/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.common;

import com.sas.dpro.common.ExternalProcessInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class ExternalProcessInfoImpl
implements ExternalProcessInfo {
    private String command;
    private List args;
    private Map envVars;
    private boolean appendEnvVars;
    private boolean useStderrInErrorMessages;

    public ExternalProcessInfoImpl(String command) {
        this.setCommand(command);
        this.setAppendEnvVars(true);
        this.setUseStderrInErrorMessages(false);
    }

    @Override
    public void addArg(String arg) {
        if (this.args == null) {
            this.args = new ArrayList();
        }
        this.args.add(arg);
    }

    @Override
    public int addArgs(List argList) {
        int added = 0;
        if (argList != null) {
            for (String arg : argList) {
                this.addArg(arg);
                ++added;
            }
        }
        return added;
    }

    @Override
    public void addEnvVar(String name, String value) {
        this.ensureEnvVarMapCreated();
        if (value == null) {
            this.envVars.remove(name);
        } else {
            this.envVars.put(name, value);
        }
    }

    @Override
    public int addEnvVars(Map envVars) {
        int added = 0;
        if (envVars != null) {
            for (Map.Entry entry : envVars.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (!(key instanceof String) || !(value instanceof String)) {
                    throw new IllegalArgumentException("Invalid map");
                }
                this.addEnvVar((String)key, (String)value);
                ++added;
            }
        }
        return added;
    }

    private void ensureEnvVarMapCreated() {
        if (this.envVars == null) {
            this.envVars = new HashMap();
        }
    }

    @Override
    public boolean getAppendEnvVars() {
        return this.appendEnvVars;
    }

    @Override
    public String getArg(int index) {
        if (this.args == null) {
            throw new IndexOutOfBoundsException();
        }
        return (String)this.args.get(index);
    }

    @Override
    public int getArgCount() {
        return this.args == null ? 0 : this.args.size();
    }

    @Override
    public Iterator getArgIterator() {
        if (this.args == null) {
            return new EmptyIterator();
        }
        return this.args.iterator();
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public Iterator getEnvVarIterator() {
        if (this.envVars == null) {
            return new EmptyIterator();
        }
        return this.envVars.entrySet().iterator();
    }

    @Override
    public boolean getUseStderrInErrorMessages() {
        return this.useStderrInErrorMessages;
    }

    @Override
    public void setAppendEnvVars(boolean append) {
        this.appendEnvVars = append;
    }

    @Override
    public void setCommand(String command) {
        this.command = command;
    }

    @Override
    public void setUseStderrInErrorMessages(boolean useStderr) {
        this.useStderrInErrorMessages = useStderr;
    }

    static class EmptyIterator
    implements Iterator {
        EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

