/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.common;

import com.sas.dpro.common.ErrorInfo;
import com.sas.dpro.common.RunActionFailedException;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.contract.messages.ContractCompletedMessage;
import com.sas.dpro.service.ServiceResults;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.rmi.RemoteException;

public class ErrorInfoImpl
implements ErrorInfo,
Serializable {
    private String errorServer;
    private String errorMessage;
    private String errorStackTrace;
    private String errorType;
    private ServiceResults serviceResults;
    private String commandExecuted;
    private ContractCompletedMessage[] ccms;
    private static final long serialVersionUID = 1L;

    public ErrorInfoImpl(String server, Throwable t) {
        ContractCompletedMessage[] ccms;
        RunActionFailedException rafe;
        if (server == null || t == null) {
            throw new NullPointerException();
        }
        this.errorServer = server;
        while (t instanceof RemoteException && t.getCause() != null) {
            t = t.getCause();
        }
        this.errorMessage = t.getMessage();
        this.errorType = t.getClass().getName();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        if (t instanceof RunActionFailedException && (rafe = (RunActionFailedException)t).getContractSubmittedCount() == 1 && (rafe.getContractErrorCount() == 1 || rafe.getContractTimeoutCount() == 1) && (ccms = rafe.getContractCompletedMessages()) != null && ccms.length == 1) {
            if (ccms[0] == null) {
                pw.println("No Error Information");
            } else if (ccms[0].isError() || ccms[0].isTimeout()) {
                ErrorInfo ei = ccms[0].getErrorInfo();
                pw.println(ei.getErrorStackTrace());
            }
        }
        this.errorStackTrace = sw.getBuffer().toString();
        pw.close();
        if (t instanceof ServiceFailedException) {
            ServiceFailedException sfe = (ServiceFailedException)t;
            this.serviceResults = sfe.getServiceResults();
            this.commandExecuted = sfe.getCommandExecuted();
        } else if (t instanceof RunActionFailedException) {
            rafe = (RunActionFailedException)t;
            ccms = rafe.getContractCompletedMessages();
            this.ccms = ccms;
        }
    }

    @Override
    public String getCommandExecuted() {
        return this.commandExecuted;
    }

    @Override
    public ContractCompletedMessage[] getContractCompletedMessages() {
        ContractCompletedMessage[] copy = null;
        if (this.ccms != null) {
            copy = new ContractCompletedMessage[this.ccms.length];
            System.arraycopy(this.ccms, 0, copy, 0, this.ccms.length);
        }
        return copy;
    }

    @Override
    public String getErrorDPROServer() {
        return this.errorServer;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getErrorStackTrace() {
        return this.errorStackTrace;
    }

    @Override
    public String getErrorType() {
        return this.errorType;
    }

    @Override
    public ServiceResults getServiceResults() {
        return this.serviceResults;
    }

    public void setServiceResults(ServiceResults results) {
        this.serviceResults = results;
    }
}

