/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.common;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.FileContents;
import com.sas.dpro.common.InvalidProviderNameException;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderFactory;
import com.sas.dpro.results.FormattedResults;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DProUtil {
    public static final String ENCODING_DEFAULT = "default";
    public static final String FALSE = "false";
    public static final String RESULTS_FILE_ENCODING = "UTF-8";
    public static final String TRUE = "true";
    public static final String EMPTY_STRING = "";
    private static final long MAX_UNCOMPRESSED_FILE_TRANSFER_SIZE = 0x100000L;
    public static byte[] BOM_UTF_8 = new byte[]{-17, -69, -65};
    public static final byte[] BOM_UTF_16BE = new byte[]{-2, -1};
    public static final byte[] BOM_UTF_16LE = new byte[]{-1, -2};
    private static final String PROPERTY_MAX_UNCOMPRESSED_FILE_TRANSFER_SIZE = "com.sas.dpro.common.MaxUncompressedFileTransferSize";

    private DProUtil() {
    }

    public static String[] cloneStringArray(String[] array) {
        String[] temp = null;
        if (array != null) {
            temp = (String[])array.clone();
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createHTMLPage(File file, String title, String text, String reportFileName, Charset cs) throws IOException {
        if (cs == null) {
            cs = Charset.defaultCharset();
        }
        try (PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), cs)));){
            text = DProUtil.getHTMLSafeVersion(text);
            out.println("<html><head>");
            out.println(DProUtil.getHTMLContentTypeMetaTag(cs));
            out.println("<title>" + title + "</title>");
            out.println("</head>");
            out.print("<body><h2>" + title + ":</h2><hr><pre>" + (text == null ? EMPTY_STRING : text) + "</pre><hr><a href=\"" + reportFileName + "\">Back to Results</a></body></html>");
        }
    }

    public static String createSafeFileName(String text) {
        char[] chars = text.toCharArray();
        StringBuilder buf = new StringBuilder(chars.length);
        int pos = 0;
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (DProUtil.isValidFilenameChar(ch)) continue;
            buf.append(chars, pos, i - pos);
            buf.append('_');
            pos = i + 1;
        }
        if (pos < chars.length) {
            buf.append(chars, pos, chars.length - pos);
        }
        return buf.toString();
    }

    public static String fixSlashes(String path) {
        char[] ch = path.toCharArray();
        int count = ch.length;
        if (DProUtil.osIsWindows()) {
            for (int i = 0; i < count; ++i) {
                if (ch[i] != '/') continue;
                ch[i] = 92;
            }
        } else {
            for (int i = 0; i < count; ++i) {
                if (ch[i] != '\\') continue;
                ch[i] = 47;
            }
        }
        return new String(ch, 0, count);
    }

    public static String formatString(ResourceBundle rb, String key, Object param) {
        return DProUtil.formatString(rb, key, new Object[]{param});
    }

    public static String formatString(ResourceBundle rb, String key, Object param1, Object param2) {
        return DProUtil.formatString(rb, key, new Object[]{param1, param2});
    }

    public static String formatString(ResourceBundle rb, String key, Object param1, Object param2, Object param3) {
        return DProUtil.formatString(rb, key, new Object[]{param1, param2, param3});
    }

    public static String formatString(ResourceBundle rb, String key, Object[] params) {
        String value = rb.getString(key);
        if (params != null) {
            value = MessageFormat.format(value, params);
        }
        return value;
    }

    public static Document getDocumentFromResults(File resultsXML) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(resultsXML));){
            Document document = DProUtil.streamToXMLDoc(in);
            return document;
        }
    }

    public static Document getDocumentFromResults(FormattedResults results) throws IOException {
        File f = results.getFile();
        return DProUtil.getDocumentFromResults(f);
    }

    public static InputStream getFileContents(ContainerContext cc, String fileName) throws IOException, InvalidProviderNameException {
        try {
            fileName = cc.getAbsoluteFilePath(fileName);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        InputStream in = null;
        String providerName = cc.getProviderName();
        if (ProviderFactory.isLocalProvider(providerName)) {
            in = new BufferedInputStream(new FileInputStream(fileName));
        } else {
            Provider p = ProviderFactory.getProvider(providerName);
            FileContents fc = p.getFile(fileName);
            if (fc.isCompressed()) {
                ZipInputStream zin = new ZipInputStream(new BufferedInputStream(new ByteArrayInputStream(fc.getContents())));
                zin.getNextEntry();
                in = zin;
            } else {
                in = new ByteArrayInputStream(fc.getContents());
            }
        }
        return in;
    }

    public static String getHTMLContentTypeMetaTag(Charset cs) {
        StringBuilder sb = new StringBuilder("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=");
        sb.append(cs.name()).append("\" />");
        return sb.toString();
    }

    public static String getHTMLSafeVersion(String str) {
        return DProUtil.getHTMLSafeVersion(str, true);
    }

    public static String getHTMLSafeVersion(String str, boolean inPreBlock) {
        if (str == null || EMPTY_STRING.equals(str)) {
            return EMPTY_STRING;
        }
        Matcher m = null;
        StringBuffer sb = new StringBuffer();
        if (inPreBlock) {
            Pattern p = Pattern.compile("([\\<\\>\\\"\\'\\\\\\&]|[\\x0c])");
            m = p.matcher(str);
            while (m.find()) {
                char ch = m.group(0).charAt(0);
                m.appendReplacement(sb, "&#" + ch + ";");
            }
        } else {
            Pattern p = Pattern.compile("([\\<\\>\\\"\\'\\\\\\&\\\n]|[\\x0c])");
            m = p.matcher(str);
            while (m.find()) {
                char ch = m.group(0).charAt(0);
                String replacement = ch == '\n' ? "<br>" : "&#" + ch + ";";
                m.appendReplacement(sb, replacement);
            }
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static List getLocalDirContents(File dir, boolean includeDirs) {
        return DProUtil.getLocalDirContents(dir, includeDirs, null);
    }

    private static List getLocalDirContents(File dir, boolean includeDirs, String prefix) {
        ArrayList<String> contents = new ArrayList<String>();
        File[] children = dir.listFiles();
        int childCount = children == null ? 0 : children.length;
        for (int i = 0; i < childCount; ++i) {
            String name;
            if (children[i].isDirectory()) {
                if (includeDirs) {
                    name = children[i].getName();
                    if (prefix != null) {
                        name = prefix + name;
                    }
                    contents.add(name);
                }
                String newPrefix = children[i].getName() + File.separatorChar;
                if (prefix != null) {
                    newPrefix = prefix + newPrefix;
                }
                contents.addAll(DProUtil.getLocalDirContents(children[i], includeDirs, newPrefix));
                continue;
            }
            name = children[i].getName();
            if (prefix != null) {
                name = prefix + name;
            }
            contents.add(name);
        }
        return contents;
    }

    public static String getLocalDPROVersion() {
        String dproVersion = null;
        try {
            Provider p = ProviderFactory.getProvider("server-local");
            dproVersion = p.getProviderDPROVersion();
        }
        catch (InvalidProviderNameException ipne) {
            ipne.printStackTrace();
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        return dproVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLocalFileContents(File file, Charset cs) throws IOException {
        if (cs == null) {
            cs = Charset.defaultCharset();
        }
        InputStream fis = new FileInputStream(file);
        fis = DProUtil.possiblyReadBOM(fis, cs);
        BufferedReader r = new BufferedReader(new InputStreamReader(fis, cs));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = r.readLine()) != null) {
                sb.append(line).append('\n');
            }
        }
        finally {
            r.close();
        }
        return sb.toString();
    }

    public static boolean getShouldCompressFileOnTransfer(String fileName, long size) {
        boolean compress = false;
        long max = 0x100000L;
        String temp = System.getProperty(PROPERTY_MAX_UNCOMPRESSED_FILE_TRANSFER_SIZE);
        if (temp != null) {
            try {
                long l = Long.parseLong(temp);
                if (l < 0L) {
                    return false;
                }
                max = l;
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
        if (size > max) {
            compress = fileName == null || !fileName.toLowerCase().endsWith(".zip");
        }
        return compress;
    }

    public static boolean isParentDir(File dir, File file) throws IOException {
        if (dir == null || file == null) {
            return false;
        }
        if (!dir.isAbsolute()) {
            throw new IOException("dir is not absolute");
        }
        if (!file.isAbsolute()) {
            throw new IOException("file is not absolute");
        }
        String canonicalDir = dir.getCanonicalPath();
        String canonicalFile = file.getCanonicalPath();
        return canonicalFile.startsWith(canonicalDir);
    }

    public static boolean isReadOnlyVariable(String varName) {
        return varName != null && varName.length() > 0 && varName.charAt(0) == '_';
    }

    public static final boolean isValidFilenameChar(char ch) {
        return ch < '\u0100' && Character.isLetterOrDigit(ch) || ch == '_' || ch == '.';
    }

    public static boolean isValidVariableName(String varName) {
        if (varName == null || varName.length() == 0) {
            return false;
        }
        boolean valid = true;
        int count = varName.length();
        for (int i = 0; i < count; ++i) {
            char ch = varName.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '.') continue;
            valid = false;
            break;
        }
        return valid;
    }

    public static boolean isValidWritableVariableName(String varName) {
        if (varName == null || varName.length() == 0) {
            return false;
        }
        char ch = varName.charAt(0);
        if (!(ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z')) {
            return false;
        }
        boolean valid = true;
        int count = varName.length();
        for (int i = 1; i < count; ++i) {
            ch = varName.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '.') continue;
            valid = false;
            break;
        }
        return valid;
    }

    public static float nanosToSeconds(long ns) {
        return Math.max((float)ns / 1.0E9f, 0.0f);
    }

    public static boolean osIsWindows() {
        String os = System.getProperty("os.name");
        return os.toLowerCase().indexOf("windows") > -1;
    }

    public static final boolean osIsZOS() {
        boolean isZOS = false;
        String os = System.getProperty("os.name");
        if (os != null && ((os = os.toLowerCase()).indexOf("z/os") > -1 || os.indexOf("os/390") > -1)) {
            isZOS = true;
        }
        return isZOS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List parseListFile(String fileName, String charset, boolean trim) throws IOException {
        ArrayList<String> lineList = new ArrayList<String>();
        try (BufferedReader r = null;){
            Charset cs = charset == null ? Charset.defaultCharset() : Charset.forName(charset);
            r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), cs));
            String line = null;
            while ((line = r.readLine()) != null) {
                if (trim) {
                    line = line.trim();
                }
                if (line.length() <= 0 || line.startsWith("#")) continue;
                lineList.add(line);
            }
        }
        return lineList;
    }

    public static InputStream possiblyReadBOM(InputStream in, Charset cs) throws IOException {
        byte[] bom = null;
        if (Charset.forName(RESULTS_FILE_ENCODING).equals(cs)) {
            bom = BOM_UTF_8;
        } else if (Charset.forName("UTF-16LE").equals(cs)) {
            bom = BOM_UTF_16LE;
        } else if (Charset.forName("UTF-16BE").equals(cs)) {
            bom = BOM_UTF_16BE;
        } else {
            return in;
        }
        PushbackInputStream pis = new PushbackInputStream(in, bom.length);
        byte[] test = new byte[bom.length];
        for (int i = 0; i < test.length; ++i) {
            test[i] = (byte)(pis.read() & 0xFF);
        }
        if (!Arrays.equals(bom, test)) {
            pis.unread(test);
        }
        return pis;
    }

    public static boolean possiblyWriteBOM(OutputStream out, Charset cs, boolean utf8BOM) throws IOException {
        if (Charset.forName(RESULTS_FILE_ENCODING).equals(cs)) {
            if (utf8BOM) {
                out.write(BOM_UTF_8);
                return true;
            }
        } else {
            if (Charset.forName("UTF-16LE").equals(cs)) {
                out.write(BOM_UTF_16LE);
                return true;
            }
            if (Charset.forName("UTF-16BE").equals(cs)) {
                out.write(BOM_UTF_16BE);
                return true;
            }
        }
        return false;
    }

    public static Document readerToXMLDoc(Reader r) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource(r);
        is.setEncoding(RESULTS_FILE_ENCODING);
        return db.parse(is);
    }

    public static Document streamToXMLDoc(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(in, RESULTS_FILE_ENCODING));
        return DProUtil.readerToXMLDoc(r);
    }

    public static Document stringToXMLDoc(String xml) throws ParserConfigurationException, SAXException, IOException {
        StringReader sr = new StringReader(xml);
        return DProUtil.readerToXMLDoc(sr);
    }
}

