/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.common;

import com.sas.dpro.common.PatternSet;
import java.io.Serializable;

abstract class AbstractPatternSet
implements PatternSet,
Cloneable,
Serializable {
    private String id;
    protected String[] includePatterns;
    protected String[] excludePatterns;

    public AbstractPatternSet(String id) {
        this.setID(id);
        this.includePatterns = new String[0];
        this.excludePatterns = new String[0];
    }

    public void addExcludePattern(String pattern) {
        if (pattern != null && pattern.length() > 0) {
            String[] temp = new String[this.excludePatterns.length + 1];
            System.arraycopy(this.excludePatterns, 0, temp, 0, this.excludePatterns.length);
            temp[temp.length - 1] = pattern;
            this.excludePatterns = temp;
        }
    }

    public void addIncludePattern(String pattern) {
        if (pattern != null && pattern.length() > 0) {
            String[] temp = new String[this.includePatterns.length + 1];
            System.arraycopy(this.includePatterns, 0, temp, 0, this.includePatterns.length);
            temp[temp.length - 1] = pattern;
            this.includePatterns = temp;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractPatternSet clone = (AbstractPatternSet)super.clone();
        clone.id = this.id;
        clone.excludePatterns = (String[])this.excludePatterns.clone();
        clone.includePatterns = (String[])this.includePatterns.clone();
        return clone;
    }

    @Override
    public final PatternSet createCopy(String idPrefix) {
        AbstractPatternSet copy = null;
        try {
            copy = (AbstractPatternSet)this.clone();
            copy.setID(this.createPrefixedID(idPrefix));
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
        }
        return copy;
    }

    private String createPrefixedID(String prefix) {
        String id = this.getID();
        if (prefix != null) {
            id = id != null ? prefix + id : prefix;
        }
        return id;
    }

    @Override
    public String getExcludePattern(int index) {
        return this.excludePatterns[index];
    }

    @Override
    public int getExcludePatternCount() {
        return this.excludePatterns.length;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getIncludePattern(int index) {
        return this.includePatterns[index];
    }

    @Override
    public int getIncludePatternCount() {
        return this.includePatterns.length;
    }

    public void removeAllPatterns() {
        this.includePatterns = new String[0];
        this.excludePatterns = new String[0];
    }

    public void setID(String id) {
        this.id = id;
    }
}

