/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.common;

import com.sas.dpro.common.FileCollection;
import java.io.Serializable;
import java.util.List;

abstract class AbstractFileCollection
implements FileCollection,
Cloneable,
Serializable {
    private String root;
    private String provider;
    private String id;
    private String[] files;

    public AbstractFileCollection(String rootDir, String provider, String id) {
        this.setRoot(rootDir);
        this.setProvider(provider);
        this.setID(id);
        this.files = new String[0];
    }

    public void add(String file) {
        String[] temp = new String[this.files.length + 1];
        System.arraycopy(this.files, 0, temp, 0, this.files.length);
        temp[temp.length - 1] = this.fixSlashes(file);
        this.files = temp;
    }

    public void add(List fileNames) {
        if (fileNames != null) {
            for (int i = 0; i < fileNames.size(); ++i) {
                this.add(this.fixSlashes((String)fileNames.get(i)));
            }
        }
    }

    public void clear() {
        this.files = new String[0];
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractFileCollection clone = (AbstractFileCollection)super.clone();
        clone.root = this.root;
        clone.provider = this.provider;
        clone.id = this.id;
        clone.files = (String[])this.files.clone();
        return clone;
    }

    @Override
    public final FileCollection createCopy(String idPrefix) {
        AbstractFileCollection copy = null;
        try {
            copy = (AbstractFileCollection)this.clone();
            copy.setID(this.createPrefixedID(idPrefix));
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
        }
        return copy;
    }

    private String createPrefixedID(String prefix) {
        String id = this.getID();
        if (prefix != null) {
            id = id != null ? prefix + id : prefix;
        }
        return id;
    }

    protected String fixSlashes(String path) {
        char[] ch = path.toCharArray();
        int count = ch.length;
        for (int i = 0; i < count; ++i) {
            if (ch[i] != '\\') continue;
            ch[i] = 47;
        }
        return new String(ch, 0, count);
    }

    @Override
    public String getAbsolute(int index) {
        return this.getRoot() + '/' + this.get(index);
    }

    @Override
    public String get(int index) {
        return this.files[index];
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public int getSize() {
        return this.files.length;
    }

    @Override
    public String getName(int index) {
        String dir = this.get(index);
        int i = Math.max(dir.lastIndexOf(47), dir.lastIndexOf(92));
        return i == -1 ? dir : dir.substring(i + 1);
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    @Override
    public String getRoot() {
        return this.root;
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public void setID(String id) {
        this.id = id;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setRoot(String root) {
        if (root == null) {
            throw new NullPointerException("File collection roots cannot be null");
        }
        this.root = root;
    }
}

