/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.client;

import com.sas.dpro.common.AlreadyInitializedException;
import com.sas.dpro.common.DProEnvironment;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.FileSetImpl;
import com.sas.dpro.common.HostInfo;
import com.sas.dpro.common.HostInfoImpl;
import com.sas.dpro.common.InputPromptInfo;
import com.sas.dpro.contract.messages.ContractCompletedMessage;
import com.sas.dpro.contract.messages.CreateReportMessage;
import com.sas.dpro.contract.messages.DPROSystemMessage;
import com.sas.dpro.contract.messages.InfoMessage;
import com.sas.dpro.contract.messages.LoadReportMessage;
import com.sas.dpro.contract.messages.MailReportMessage;
import com.sas.dpro.contract.messages.Message;
import com.sas.dpro.contract.messages.ReportMessage;
import com.sas.dpro.contract.messages.ResultsMessage;
import com.sas.dpro.contract.messages.RunActionCompletedMessage;
import com.sas.dpro.contract.messages.RunActionStartedMessage;
import com.sas.dpro.contract.messages.RunContractCompletedMessage;
import com.sas.dpro.contract.messages.RunContractMessage;
import com.sas.dpro.contract.messages.ServiceCompletedMessage;
import com.sas.dpro.contract.messages.ShowReportMessage;
import com.sas.dpro.contract.messages.WorkUnitMessage;
import com.sas.dpro.controller.ControllerImpl;
import com.sas.dpro.controller.HonorContractParms;
import com.sas.dpro.controller.HonorContractParmsImpl;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderFactory;
import com.sas.dpro.reporting.ReportInfo;
import com.sas.dpro.reporting.ReportInfoImpl;
import com.sas.dpro.reporting.ReportMaker;
import com.sas.dpro.reporting.ReportMakerFactory;
import com.sas.dpro.results.FormattedResults;
import com.sas.dpro.results.FormattedResultsSupport;
import com.sas.dpro.service.standard.Copy;
import com.sas.dpro.service.standard.Delete;
import com.sas.dpro.service.standard.Mail;
import com.sas.dpro.service.standard.Zip;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractClient {
    public static final String RESULTS_SUBDIR_NAME = "_results";
    protected ControllerImpl controller;
    protected Logger logger;
    private FileHandler logFileHandler;
    protected String hostName;
    protected String hostIPAddress;
    private FormattedResultsSupport frSupport;
    private Map reportInfoMap;
    private int createdReportCount;
    private static Schema trmSchema;
    private static String cachedClientDPROVersion;
    private final DateFormat format = new SimpleDateFormat("yyyyMMdd");
    private Object LOCK_CREATED_REPORT_COUNT = new Object();
    private Object LOCK_REPORT_INFO = new Object();
    protected static final String PARAM_GROOVY_ENABLED = "-groovyEnabled";
    protected static final String PARAM_LOGGING_LEVEL = "-loggingLevel";
    protected static final String PARAM_PARALLEL = "-parallel";
    private static ResourceBundle errorMsg;
    private static ResourceBundle loggerMsg;
    private static final String CLASS_NAME = "com.sas.dpro.client.AbstractClient";
    private static final String ERROR_MSG = "com.sas.dpro.client.AbstractClientErrors";
    private static final String LOGGER_MSG = "com.sas.dpro.client.AbstractClientLogMessages";
    private static final String VERSION_STRING_START = "1.5.00";
    private static final String SYSTEM_ID_TEST_RESULTS_1_5 = "http://www.sas.com/xml/schema/dpro/formatted-test-results-1.5.xsd";
    private static final String TEST_RESULTS_SCHEMA_1_5 = "com/sas/schema/formatted-test-results-1.5.xsd";
    private static final String TEST_SUITE_RESULTS_SCHEMA_1_5 = "com/sas/schema/formatted-test-suite-results-1.5.xsd";
    public static final String PROPERTY_DEBUG_REPORTS = "com.sas.dpro.debugReports";
    public static final String PROPERTY_DEBUG_SHUTDOWN = "com.sas.dpro.debugShutdown";

    protected AbstractClient(Logger logger, String appDataSubdir) {
        this(logger, appDataSubdir, null);
    }

    protected AbstractClient(Logger logger, String appDataSubdir, boolean logToStderr) {
        this(logger, appDataSubdir, null, logToStderr);
    }

    protected AbstractClient(Logger logger, String appDataSubdir, String dproClientInstallDir) {
        this(logger, appDataSubdir, dproClientInstallDir, false);
    }

    protected AbstractClient(Logger logger, String appDataSubdir, String dproClientInstallDir, boolean logToStderr) {
        this.logger = logger;
        if (this.logger == null) {
            this.logger = Logger.getLogger(CLASS_NAME);
        }
        this.logger.setLevel(Level.INFO);
        this.setLogToStderr(logToStderr);
        if (!DProEnvironment.isInitialized()) {
            try {
                DProEnvironment.initialize(this.logger, appDataSubdir, dproClientInstallDir, this);
            }
            catch (AlreadyInitializedException ae) {
                ae.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        this.loadHostInfo();
        this.controller = new ControllerImpl(this, logger);
        try {
            Runtime.getRuntime().addShutdownHook(new Thread("dpro-shutdown-thread"){

                @Override
                public void run() {
                    AbstractClient.this.shutdown();
                }
            });
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.frSupport = new FormattedResultsSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReportInfo addReportInfo(long sessionID, ReportInfo ri) {
        ReportInfo old = null;
        String key = AbstractClient.createReportInfoMapKey(sessionID, ri.getReportID());
        this.debugReportsMessage("addReportInfo: Adding ReportInfo: " + ri);
        this.debugReportsMessage("... key==" + key);
        Object object = this.LOCK_REPORT_INFO;
        synchronized (object) {
            if (this.reportInfoMap == null) {
                this.reportInfoMap = new HashMap();
            }
            old = this.reportInfoMap.put(key, ri);
        }
        this.debugReportsMessage("... Replacing old ReportInfo: " + old);
        return old;
    }

    public void addToFormattedResults(ResultsMessage rm) throws IOException, IllegalArgumentException {
        this.frSupport.addToFormattedResults(rm);
    }

    protected void configureLogger() {
        String logFileName;
        this.logger.entering(CLASS_NAME, "configureLogger");
        if (this.logFileHandler == null && (logFileName = this.getLoggerFileName()) != null) {
            try {
                logFileName = new File(DProEnvironment.getWorkspaceDirectory(), logFileName).getAbsolutePath();
                this.logFileHandler = new FileHandler(logFileName);
                this.logger.addHandler(this.logFileHandler);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        this.logger.exiting(CLASS_NAME, "configureLogger");
    }

    protected HonorContractParms createHonorContractParms(String contract, String[] vars) {
        HonorContractParmsImpl parms = new HonorContractParmsImpl();
        parms.setClientDPROVersion(this.getClientDPROVersion());
        parms.setContract(contract);
        parms.setLocale(Locale.getDefault().getLanguage());
        parms.setOriginalContractSessionID(-1L);
        parms.setTimeout(-1L);
        parms.setVariables(vars);
        return parms;
    }

    private static final String createReportInfoMapKey(long sessionID, String reportID) {
        return "" + sessionID + '_' + reportID;
    }

    protected File createUniqueReportDir(FormattedResults res, String reportType) throws IOException {
        String dir = DProEnvironment.getReportsDirectory();
        dir = dir + File.separatorChar + this.format.format(new Date());
        String dirName = this.createUniqueReportDirName(res, reportType);
        File reportDir = new File(dir, dirName);
        while (reportDir.exists()) {
            dirName = this.createUniqueReportDirName(res, reportType);
            reportDir = new File(dir, dirName);
        }
        if (!reportDir.mkdirs()) {
            ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
            String key = "CreatingReportDir.fmt.txt";
            String desc = DProUtil.formatString(msg, key, reportDir.getAbsolutePath(), res.getResultsID());
            throw new IOException(desc);
        }
        return reportDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createUniqueReportDirName(FormattedResults res, String reportType) {
        Object object = this.LOCK_CREATED_REPORT_COUNT;
        synchronized (object) {
            return "report_" + res.getResultsID() + '_' + ++this.createdReportCount;
        }
    }

    protected void debugReportsMessage(String msg) {
        boolean debugReports = Boolean.getBoolean(PROPERTY_DEBUG_REPORTS);
        if (debugReports) {
            msg = "[DEBUG REPORTS]: " + msg;
            System.err.println(msg);
        }
    }

    protected void debugShutdownMessage(String msg) {
        boolean debugShutdown = Boolean.getBoolean(PROPERTY_DEBUG_SHUTDOWN);
        if (debugShutdown) {
            msg = "[DEBUG SHUTDOWN]: " + msg;
            System.err.println(msg);
        }
    }

    public FormattedResults endFormattedResults(ResultsMessage rm) throws IOException, IllegalArgumentException {
        return this.frSupport.endFormattedResults(rm);
    }

    private static synchronized ResourceBundle getAbstractClientErrorBundle() {
        if (errorMsg == null) {
            errorMsg = ResourceBundle.getBundle(ERROR_MSG);
        }
        return errorMsg;
    }

    private static synchronized ResourceBundle getAbstractClientLoggerBundle() {
        if (loggerMsg == null) {
            loggerMsg = ResourceBundle.getBundle(LOGGER_MSG);
        }
        return loggerMsg;
    }

    public final String getClientDPROVersion() {
        if (cachedClientDPROVersion != null) {
            return cachedClientDPROVersion;
        }
        return "1.5.00." + this.getDPROClientTypeString();
    }

    protected static String getCommandLineOptionGroovyEnabled(String[] args, int pos) throws IllegalArgumentException {
        if (pos == args.length) {
            ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
            String desc = msg.getString("NoValueSpecified.fmt.txt");
            desc = MessageFormat.format(desc, PARAM_GROOVY_ENABLED);
            throw new IllegalArgumentException(desc);
        }
        return Boolean.parseBoolean(args[pos]) ? "true" : "false";
    }

    protected static Level getCommandLineOptionLoggingLevel(String[] args, int pos) throws IllegalArgumentException {
        if (pos == args.length) {
            ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
            String desc = msg.getString("NoValueSpecified.fmt.txt");
            desc = MessageFormat.format(desc, PARAM_LOGGING_LEVEL);
            throw new IllegalArgumentException(desc);
        }
        Level loggingLevel = null;
        try {
            loggingLevel = Level.parse(args[pos]);
        }
        catch (Exception e) {
            ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
            String desc = msg.getString("InvalidValue.fmt.txt");
            desc = MessageFormat.format(desc, PARAM_LOGGING_LEVEL, args[pos]);
            throw new IllegalArgumentException(desc);
        }
        return loggingLevel;
    }

    protected static int getCommandLineOptionParallel(String[] args, int pos) throws IllegalArgumentException {
        String OPTION = PARAM_PARALLEL;
        if (pos == args.length) {
            ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
            String desc = msg.getString("NoValueSpecified.fmt.txt");
            desc = MessageFormat.format(desc, PARAM_PARALLEL);
            throw new IllegalArgumentException(desc);
        }
        int parallel = 0;
        try {
            parallel = Integer.parseInt(args[pos]);
        }
        catch (NumberFormatException nfe) {
            ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
            String desc = msg.getString("InvalidValue.fmt.txt");
            desc = MessageFormat.format(desc, PARAM_PARALLEL, args[pos]);
            throw new IllegalArgumentException(desc);
        }
        if (parallel < 1 || parallel > 30) {
            ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
            String desc = msg.getString("InvalidValue.fmt.txt");
            desc = MessageFormat.format(desc, PARAM_PARALLEL, args[pos]);
            throw new IllegalArgumentException(desc);
        }
        return parallel;
    }

    public abstract String getDefaultReportType();

    protected abstract String getDPROClientTypeString();

    public Iterator getFormattedResultsIDIterator() {
        return this.frSupport.getFormattedResultsIDIterator();
    }

    public HostInfo getHostInfo() {
        return new HostInfoImpl(this.hostName, this.hostIPAddress);
    }

    protected abstract String getLoggerFileName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportInfo getReportInfo(long sessionID, String reportID) {
        String key = AbstractClient.createReportInfoMapKey(sessionID, reportID);
        this.debugReportsMessage("getReportInfo: Getting ReportInfo for key: " + key);
        ReportInfo ri = null;
        Object object = this.LOCK_REPORT_INFO;
        synchronized (object) {
            if (this.reportInfoMap != null) {
                ri = (ReportInfo)this.reportInfoMap.get(key);
            }
        }
        this.debugReportsMessage("... Returning: " + ri);
        return ri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportInfo[] getReportInfos() {
        ReportInfo[] infos = null;
        Object object = this.LOCK_REPORT_INFO;
        synchronized (object) {
            if (this.reportInfoMap == null) {
                infos = new ReportInfo[]{};
            } else {
                int count = this.reportInfoMap.size();
                infos = new ReportInfo[count];
                int pos = 0;
                Iterator i = this.reportInfoMap.values().iterator();
                while (i.hasNext()) {
                    infos[pos++] = (ReportInfo)i.next();
                }
            }
        }
        return infos;
    }

    protected static synchronized Validator getTestResultsValidator() throws IOException {
        if (trmSchema == null) {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            sf.setResourceResolver(new LSResourceResolver(){

                @Override
                public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                    System.err.println(">>> >>> type==" + type + ", publicId=" + publicId + ", systemId=" + systemId + ", baseURI=" + baseURI);
                    DOMInputImpl input = null;
                    if (AbstractClient.SYSTEM_ID_TEST_RESULTS_1_5.equals(systemId)) {
                        input = new DOMInputImpl();
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        InputStream stream = cl.getResourceAsStream(AbstractClient.TEST_RESULTS_SCHEMA_1_5);
                        input.setByteStream(stream);
                    }
                    return input;
                }
            });
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            URL schemaURL = cl.getResource(TEST_SUITE_RESULTS_SCHEMA_1_5);
            try {
                trmSchema = sf.newSchema(schemaURL);
            }
            catch (SAXException se) {
                throw new IOException(se.getMessage());
            }
        }
        return trmSchema.newValidator();
    }

    protected abstract void handleHandleMessageError(String var1, Exception var2);

    protected void handleMessage(Message message) {
        if (message instanceof ContractCompletedMessage) {
            this.handleMessageContractCompleted((ContractCompletedMessage)message);
        } else if (message instanceof DPROSystemMessage) {
            this.handleMessageDPROSystem((DPROSystemMessage)message);
        } else if (message instanceof InfoMessage) {
            this.handleMessageInfo((InfoMessage)message);
        } else if (message instanceof ReportMessage) {
            this.handleMessageReportRelated((ReportMessage)message);
        } else if (message instanceof ResultsMessage) {
            try {
                this.handleMessageResults((ResultsMessage)message);
            }
            catch (Exception e) {
                String text = e.getMessage();
                if (text == null) {
                    text = e.toString();
                }
                ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
                String key = "HandlingResultsMessage.fmt.txt";
                String desc = DProUtil.formatString(msg, key, text);
                this.handleHandleMessageError(desc, e);
                e.printStackTrace();
            }
        } else if (message instanceof RunActionCompletedMessage) {
            this.handleMessageRunActionCompleted((RunActionCompletedMessage)message);
        } else if (message instanceof RunActionStartedMessage) {
            this.handleMessageRunActionStarted((RunActionStartedMessage)message);
        } else if (message instanceof RunContractCompletedMessage) {
            this.handleMessageRunContractCompleted((RunContractCompletedMessage)message);
        } else if (message instanceof RunContractMessage) {
            this.handleMessageRunContractStarted((RunContractMessage)message);
        } else if (message instanceof ServiceCompletedMessage) {
            this.handleMessageServiceCompleted((ServiceCompletedMessage)message);
        } else if (message instanceof WorkUnitMessage) {
            this.handleMessageWorkUnit((WorkUnitMessage)message);
        }
    }

    protected void handleMessageContractCompleted(ContractCompletedMessage ccm) {
    }

    protected ReportInfo handleMessageCreateReport(CreateReportMessage crm) throws IOException, IllegalArgumentException {
        File dir;
        boolean success;
        ReportMakerFactory rmf;
        ReportMaker rm;
        String resultsID;
        long origSessionID = crm.getHonorContractContext().getOriginalContractSessionID();
        FormattedResults results = this.frSupport.getFormattedResultsByID(origSessionID, resultsID = crm.getResultsID());
        if (!results.getHasCompleted()) {
            ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
            String key = "MessageCR.ResultsNotDone.fmt.txt";
            String desc = DProUtil.formatString(msg, key, resultsID);
            throw new IOException(desc);
        }
        String reportID = crm.getReportID();
        String reportType = crm.getReportType();
        String requestedReportDir = crm.getReportDirectory();
        boolean clean = crm.getCleanReportDirectory();
        Charset cs = null;
        String encodingStr = crm.getReportFileEncoding();
        if (encodingStr == null || "default".equals(encodingStr)) {
            cs = Charset.defaultCharset();
        } else {
            try {
                cs = Charset.forName(encodingStr);
            }
            catch (UnsupportedCharsetException uce) {
                ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
                String key = "MessageCR.UnsupportedEncoding.fmt.txt";
                String desc = DProUtil.formatString(msg, key, encodingStr);
                throw new IOException(desc);
            }
            catch (Exception e) {
                ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
                String key = "MessageCR.InvalidEncoding.fmt.txt";
                String desc = DProUtil.formatString(msg, key, encodingStr);
                throw new IOException(desc);
            }
        }
        File reportDir = null;
        if (requestedReportDir == null) {
            reportDir = this.createUniqueReportDir(results, reportType);
        } else {
            reportDir = new File(requestedReportDir);
            if (!reportDir.isAbsolute()) {
                reportDir = new File(DProEnvironment.getReportsDirectory(), reportDir.getPath());
            }
            if (!reportDir.exists() && !reportDir.mkdir()) {
                ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
                String key = "MessageCR.CreatingReportDir.fmt.txt";
                String desc = DProUtil.formatString(msg, key, reportDir.getAbsolutePath());
                throw new IOException(desc);
            }
            if (!reportDir.isDirectory()) {
                ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
                String key = "MessageCR.ReportDirNotDir.fmt.txt";
                String desc = DProUtil.formatString(msg, key, reportDir.getAbsolutePath());
                throw new IOException(desc);
            }
            if (clean) {
                boolean success2 = Delete.deleteLocal(reportDir);
                if (!success2) {
                    ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
                    String key = "MessageCR.CannotCleanReportDir.fmt.txt";
                    String desc = DProUtil.formatString(msg, key, reportDir.getAbsolutePath());
                    throw new IOException(desc);
                }
                if (!reportDir.mkdir()) {
                    ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
                    String key = "MessageCR.CreatingReportDir.fmt.txt";
                    String desc = DProUtil.formatString(msg, key, reportDir.getAbsolutePath());
                    throw new IOException(desc);
                }
            }
        }
        File resultsXML = results.getFile();
        if (resultsXML == null) {
            ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
            String key = "MessageCR.NullResultsFile.fmt.txt";
            String desc = DProUtil.formatString(msg, key, resultsID);
            throw new IOException(desc);
        }
        if (!resultsXML.isFile()) {
            ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
            String key = "MessageCR.ResultsFileNotFile.fmt.txt";
            String desc = DProUtil.formatString(msg, key, resultsXML.getAbsolutePath(), resultsID);
            throw new IOException(desc);
        }
        File resultsCopy = new File(reportDir, ".results.xml");
        Copy.copyLocal(resultsCopy, resultsXML, false);
        if (crm.getIncludeResults()) {
            File resultsSubDir = new File(reportDir, RESULTS_SUBDIR_NAME);
            if (!resultsSubDir.mkdir()) {
                ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
                String key = "MessageCR.CreatingReportDir.fmt.txt";
                String desc = DProUtil.formatString(msg, key, resultsSubDir.getAbsolutePath());
                throw new IOException(desc);
            }
            String resultsDir = results.getDirectory().getAbsolutePath();
            FileSetImpl fs = new FileSetImpl(resultsDir, null);
            if (crm.getIncludeResultsXML()) {
                fs.addIncludePattern("**");
            } else {
                fs.addExcludePattern(resultsXML.getName());
            }
            Copy.copyLocalDir(resultsSubDir, fs, false, null);
        }
        GetTypeHandler handler = new GetTypeHandler();
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(resultsXML));){
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse((InputStream)in, (DefaultHandler)handler);
        }
        String resultsType = handler.getResultsType();
        if (reportType == null) {
            reportType = this.getDefaultReportType();
        }
        if ((rm = (rmf = ReportMakerFactory.getInstance()).getReportMaker(resultsType, reportType)) == null) {
            ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
            String key = "MessageCR.NoReportMaker.fmt.txt";
            String desc = DProUtil.formatString(msg, key, resultsID, resultsType, reportType);
            throw new IOException(desc);
        }
        rm.createReport(results, reportDir, cs);
        if (crm.getDeleteResults() && !(success = Delete.deleteLocal(dir = results.getDirectory()))) {
            ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
            String key = "MessageCR.ErrorDeletingResults.fmt.txt";
            String desc = DProUtil.formatString(msg, key, dir.getAbsolutePath(), resultsID);
            throw new IOException(desc);
        }
        ReportInfoImpl ri = new ReportInfoImpl(reportID, reportDir);
        ri.setReportFileEncoding(cs);
        ri.setReportType(reportType);
        this.addReportInfo(origSessionID, ri);
        return ri;
    }

    protected void handleMessageDPROSystem(DPROSystemMessage dsm) {
    }

    protected void handleMessageInfo(InfoMessage im) {
    }

    protected final void handleMessageLoadReport(LoadReportMessage lrm) throws IOException {
        String reportID = lrm.getReportID();
        File dir = new File(lrm.getDirectory());
        String reportType = lrm.getReportType();
        long sessionID = lrm.getHonorContractContext().getOriginalContractSessionID();
        this.loadAndAddReportInfo(sessionID, reportID, dir, reportType);
    }

    protected void handleMessageMailReport(MailReportMessage mrm) throws IllegalArgumentException, IOException {
        List attachList;
        File reportFile;
        String reportID = mrm.getReportID();
        long origSessionID = mrm.getHonorContractContext().getOriginalContractSessionID();
        ReportInfo ri = this.getReportInfo(origSessionID, reportID);
        if (ri == null) {
            ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
            String key = "MessageMR.NoSuchReport.fmt.txt";
            String desc = DProUtil.formatString(msg, key, reportID, "" + origSessionID);
            throw new IllegalArgumentException(desc);
        }
        String reportType = ri.getReportType();
        File dir = ri.getDirectory();
        Charset cs = ri.getReportFileEncoding();
        String body = null;
        String htmlBody = null;
        boolean forceAttachReport = false;
        if ("_text".equals(reportType)) {
            reportFile = new File(dir, "index.txt");
            body = DProUtil.getLocalFileContents(reportFile, cs);
        } else if ("_html".equals(reportType)) {
            reportFile = new File(dir, "index.html");
            htmlBody = DProUtil.getLocalFileContents(reportFile, cs);
        } else {
            body = "Attached to this email is the results of a DPRO report of type: " + reportType + ".";
            forceAttachReport = true;
        }
        String smtpServer = null;
        String to = mrm.getTo();
        String from = mrm.getFrom();
        String cc = mrm.getCC();
        String bcc = mrm.getBCC();
        String subject = mrm.getSubject();
        String[] attachments = null;
        boolean deleteAttachments = false;
        if ((forceAttachReport || !mrm.getSummaryOnly()) && (attachList = DProUtil.getLocalDirContents(dir, false)).size() > 0) {
            if (mrm.getZipReport()) {
                String zipName = mrm.getZipName();
                if (zipName == null) {
                    zipName = mrm.getReportID() + ".zip";
                }
                File zipFile = new File(System.getProperty("java.io.tmpdir"), zipName);
                Zip.createZip(zipFile, dir, attachList);
                attachments = new String[]{zipFile.getAbsolutePath()};
                deleteAttachments = true;
            } else {
                attachments = new String[attachList.size()];
                for (int i = 0; i < attachList.size(); ++i) {
                    String file = (String)attachList.get(i);
                    attachments[i] = new File(dir, file).getAbsolutePath();
                }
            }
        }
        try {
            Mail.send(smtpServer, to, from, cc, bcc, subject, body, htmlBody, attachments);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        if (deleteAttachments) {
            for (int i = 0; i < attachments.length; ++i) {
                new File(attachments[i]).delete();
            }
        }
    }

    protected void handleMessageReportRelated(ReportMessage rm) {
        if (rm instanceof CreateReportMessage) {
            CreateReportMessage crm = (CreateReportMessage)rm;
            try {
                this.handleMessageCreateReport(crm);
            }
            catch (Exception e) {
                String text = e.getMessage();
                if (text == null) {
                    text = e.toString();
                }
                ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
                String key = "CreatingReport.fmt.txt";
                String desc = DProUtil.formatString(msg, key, text);
                this.handleHandleMessageError(desc, e);
            }
        } else if (rm instanceof LoadReportMessage) {
            try {
                this.handleMessageLoadReport((LoadReportMessage)rm);
            }
            catch (IOException e) {
                String text = e.getMessage();
                if (text == null) {
                    text = e.toString();
                }
                ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
                String key = "LoadingReport.fmt.txt";
                String desc = DProUtil.formatString(msg, key, text);
                this.handleHandleMessageError(desc, e);
            }
        } else if (rm instanceof MailReportMessage) {
            MailReportMessage mrm = (MailReportMessage)rm;
            try {
                this.handleMessageMailReport(mrm);
            }
            catch (Exception e) {
                String text = e.getMessage();
                if (text == null) {
                    text = e.toString();
                }
                ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
                String key = "MailingReport.fmt.txt";
                String desc = DProUtil.formatString(msg, key, mrm.getReportID(), text);
                this.handleHandleMessageError(desc, e);
                e.printStackTrace();
            }
        } else if (rm instanceof ShowReportMessage) {
            ShowReportMessage srm = (ShowReportMessage)rm;
            try {
                this.handleMessageShowReport(srm);
            }
            catch (Exception e) {
                String text = e.getMessage();
                if (text == null) {
                    text = e.toString();
                }
                ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
                String key = "ShowingReport.fmt.txt";
                String desc = DProUtil.formatString(msg, key, text);
                this.handleHandleMessageError(desc, e);
            }
        }
    }

    protected final void handleMessageResults(ResultsMessage rm) throws IOException, IllegalArgumentException {
        switch (rm.getType()) {
            case 3: {
                this.endFormattedResults(rm);
                break;
            }
            case 0: {
                this.startFormattedResults(rm);
                break;
            }
            case 1: 
            case 2: {
                this.addToFormattedResults(rm);
                break;
            }
            default: {
                throw new InternalError("Unknown ResultsMessage type: " + rm.getType());
            }
        }
    }

    protected void handleMessageRunActionCompleted(RunActionCompletedMessage racm) {
    }

    protected void handleMessageRunActionStarted(RunActionStartedMessage rasm) {
    }

    protected void handleMessageRunContractCompleted(RunContractCompletedMessage rccm) {
    }

    protected void handleMessageRunContractStarted(RunContractMessage rcsm) {
    }

    protected void handleMessageServiceCompleted(ServiceCompletedMessage scm) {
    }

    protected final void handleMessageShowReport(ShowReportMessage srm) throws IOException, IllegalArgumentException, UnsupportedOperationException {
        String reportID = srm.getReportID();
        long origSessionID = srm.getHonorContractContext().getOriginalContractSessionID();
        ReportInfo ri = this.getReportInfo(origSessionID, reportID);
        if (ri == null) {
            ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
            String key = "MessageSR.NoSuchReport.fmt.txt";
            String desc = DProUtil.formatString(msg, key, reportID, "" + origSessionID);
            throw new IllegalArgumentException(desc);
        }
        try {
            this.showReport(srm, ri);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (UnsupportedOperationException uoe) {
            throw uoe;
        }
        catch (Exception e) {
            ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
            String key = "MessageSR.ErrorShowingReport.fmt.txt";
            String desc = DProUtil.formatString(msg, key, reportID, "" + origSessionID, e.getMessage());
            throw new IOException(desc);
        }
    }

    protected void handleMessageWorkUnit(WorkUnitMessage wum) {
    }

    protected static void handleUnknownCommandLineOption(String option) throws IllegalArgumentException {
        ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
        String desc = msg.getString("UnknownOption.fmt.txt");
        desc = MessageFormat.format(desc, option);
        throw new IllegalArgumentException(desc);
    }

    protected void initialize() {
        if (!(this instanceof Provider)) {
            cachedClientDPROVersion = this.getClientDPROVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportInfo loadAndAddReportInfo(long sessionID, String reportID, File dir, String reportType) throws IOException {
        this.debugReportsMessage("loadAndAddReportInfo: Entering");
        this.debugReportsMessage("... loading report");
        ReportInfoImpl ri = ReportInfoImpl.load(reportID, dir);
        if (!ri.getReportType().equals(reportType)) {
            this.debugReportsMessage("... ERROR: Report is unexpected type!");
            ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
            String key = "UnexpectedReportType.fmt.txt";
            String desc = DProUtil.formatString(msg, key, ri.getReportType(), reportType);
            throw new IOException(desc);
        }
        String key = AbstractClient.createReportInfoMapKey(sessionID, ri.getReportID());
        this.debugReportsMessage("... ReportInfo loaded: " + ri);
        this.debugReportsMessage("... Saving with key: " + key);
        Object object = this.LOCK_REPORT_INFO;
        synchronized (object) {
            if (this.reportInfoMap == null) {
                this.reportInfoMap = new HashMap();
            }
            this.reportInfoMap.put(key, ri);
        }
        this.debugReportsMessage("loadAndAddReportInfo: Exiting");
        return ri;
    }

    protected void loadHostInfo() {
        try {
            InetAddress address = InetAddress.getLocalHost();
            this.hostName = address.getCanonicalHostName();
            this.hostIPAddress = address.getHostAddress();
        }
        catch (UnknownHostException uhe) {
            ResourceBundle msg = AbstractClient.getAbstractClientErrorBundle();
            String message = msg.getString("GettingHostName.txt");
            this.logger.info(message);
        }
    }

    public abstract String promptForInput(InputPromptInfo var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReportInfo removeReportInfo(long sessionID, String reportID) {
        ReportInfo removed = null;
        String key = AbstractClient.createReportInfoMapKey(sessionID, reportID);
        Object object = this.LOCK_REPORT_INFO;
        synchronized (object) {
            if (this.reportInfoMap != null) {
                removed = (ReportInfo)this.reportInfoMap.remove(key);
            }
        }
        this.debugReportsMessage("removeReportInfo: Removing ReportInfo for key " + key);
        this.debugReportsMessage("... Removed ReportInfo: " + removed);
        return removed;
    }

    public synchronized void setLoggingLevel(Level level) {
        if (level != null) {
            ResourceBundle msg = AbstractClient.getAbstractClientLoggerBundle();
            String desc = msg.getString("LoggingLevel.fmt.txt");
            desc = MessageFormat.format(desc, level);
            this.logger.setLevel(Level.INFO);
            this.logger.info(desc);
            this.logger.setLevel(level);
        }
    }

    private void setLogToStderr(boolean stderr) {
        this.logger.entering(CLASS_NAME, "setLogToStderr");
        this.logger.setUseParentHandlers(false);
        Handler[] handlers = this.logger.getHandlers();
        if (stderr) {
            boolean found = false;
            for (int i = 0; i < handlers.length; ++i) {
                if (!(handlers[i] instanceof ConsoleHandler)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.logger.addHandler(new ConsoleHandler());
            }
        } else {
            for (int i = 0; i < handlers.length; ++i) {
                if (!(handlers[i] instanceof ConsoleHandler)) continue;
                this.logger.removeHandler(handlers[i]);
            }
        }
        this.logger.exiting(CLASS_NAME, "seLogToStderr");
    }

    public abstract void showReport(ShowReportMessage var1, ReportInfo var2) throws IOException, UnsupportedOperationException;

    public synchronized void shutdown() {
        this.logger.entering(CLASS_NAME, "shutdown");
        this.debugShutdownMessage("Entering AbstractClient.shutdown()");
        if (this.controller != null) {
            this.controller.shutdown();
            this.controller = null;
            ProviderFactory.shutdown();
        }
        this.logger.exiting(CLASS_NAME, "shutdown");
        this.debugShutdownMessage("Exiting AbstractClient.shutdown()");
    }

    public void startFormattedResults(ResultsMessage rm) throws IOException, IllegalArgumentException {
        this.frSupport.startFormattedResults(rm);
    }

    static class GetTypeHandler
    extends DefaultHandler {
        private String resultsType;

        GetTypeHandler() {
        }

        public String getResultsType() {
            return this.resultsType;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("DProResults".equals(qName)) {
                this.resultsType = attributes.getValue("type");
            }
        }
    }

    static class DOMInputImpl
    implements LSInput {
        public InputStream byteStream;

        DOMInputImpl() {
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public InputStream getByteStream() {
            return this.byteStream;
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public String getEncoding() {
            return null;
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public String getStringData() {
            return null;
        }

        @Override
        public String getSystemId() {
            return null;
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public void setByteStream(InputStream byteStream) {
            this.byteStream = byteStream;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public void setPublicId(String publicId) {
        }

        @Override
        public void setStringData(String stringData) {
        }

        @Override
        public void setSystemId(String systemId) {
        }
    }
}

