/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.baseinteg;

import com.sas.iquery.baseinteg.BaseIntegResourceBundle;
import com.sas.iquery.baseinteg.IMEMapInfo;
import com.sas.iquery.baseinteg.IMLEException;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceFactory;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BriefInformationMap;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.InformationMapFactory;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.report.config.MetadataSourceDef;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.session.SessionContextInterface;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class IMEMapList {
    public static final String SBIP = "SBIP://";
    public static final String SLASH = "/";
    public static final String FOLDER = "(Folder)";
    private List<IMEMapInfo> _maps;
    private IntelligentQueryMetadataServiceInterface _iqMetadataService = null;
    private SessionContextInterface _session;
    private MetadataSourceDef _srcDef;
    private int[] _maxDatasetsInfoLength = new int[3];
    private String[] _mapMetadata = new String[2];

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IMEMapList(String repositoryName, String folderPath, String mapName, int flags, MetadataSourceDef srcDef, SessionContextInterface session) throws MetadataException, RemoteException, ServiceException, IMLEException {
        this._session = session;
        this._srcDef = srcDef;
        if (folderPath.toUpperCase().startsWith(SBIP)) {
            int relPathIndex = folderPath.indexOf(SLASH, SBIP.length());
            folderPath = folderPath.substring(relPathIndex);
        }
        if (!folderPath.endsWith(SLASH) && !folderPath.endsWith(FOLDER)) {
            folderPath = folderPath + FOLDER;
        }
        if (repositoryName != null) {
            folderPath = repositoryName.concat(folderPath);
        }
        ServerInterface server = session.getUserContext().getAuthServer();
        PathUrl path = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)server, (String)((folderPath.indexOf(SLASH) == 0 ? "" : SLASH) + folderPath));
        if (this._iqMetadataService == null) {
            this._iqMetadataService = IntelligentQueryMetadataServiceFactory.newService();
        }
        FolderInterface folder = null;
        folder = (FolderInterface)this._iqMetadataService.getMetadataInterface(session, path);
        ArrayList<BriefInformationMap> informationMaps = null;
        this._maps = new ArrayList<IMEMapInfo>();
        try {
            if (mapName != null) {
                MetadataInterface o = folder.getItemByType(mapName, "BriefInformationMap");
                if (o == null) {
                    MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("IMLE.InvalidMap.txt", new Object[0]);
                    throw new IMLEException(errorMsg);
                }
                informationMaps = new ArrayList<BriefInformationMap>(1);
                informationMaps.add((BriefInformationMap)o);
            } else {
                informationMaps = folder.getItemsByType("BriefInformationMap");
            }
        }
        catch (NullPointerException e) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("IMLE.InvalidFolder.txt", new Object[0]);
            throw new IMLEException(errorMsg);
        }
        if (informationMaps.size() == 0) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("IMLE.NoMapsInFolder.txt", new Object[0]);
            throw new IMLEException(errorMsg);
        }
        for (int i = 0; i < informationMaps.size(); ++i) {
            InformationMap newMap;
            BriefInformationMap bim = (BriefInformationMap)informationMaps.get(i);
            if (bim.getStructure().isRelational()) {
                this._maps.add(new IMEMapInfo(bim, flags, null));
                continue;
            }
            if (bim.getStructure().isOLAP() || !(newMap = InformationMapFactory.getInstance().newInformationMap(session, this._iqMetadataService, bim)).getStructure().isRelational()) continue;
            this._maps.add(new IMEMapInfo(bim, flags, null));
        }
        if (this._maps.size() == 0) {
            MessageFormatter errorMsg = BaseIntegResourceBundle.getMessageFormatter("IMLE.NoMapsInFolder.txt", new Object[0]);
            throw new IMLEException(errorMsg);
        }
        this._mapMetadata[0] = this._maps.get(0).getMapAttribute("name");
        this._mapMetadata[1] = this._maps.get(0).getMapAttribute("desc");
    }

    public IMEMapInfo getMap(int mapIndex) {
        return this._maps.get(mapIndex);
    }

    public Object[] getAll() {
        return this._maps.toArray();
    }

    public String[] getMapMetadata() {
        return this._mapMetadata;
    }

    public String[][] getDatasetsInfo() throws RemoteException, UnsupportedEncodingException {
        return this.getDatasetsInfo(this.getCountOfMaps());
    }

    public String[][] getDatasetsInfo(int countOfMaps) throws RemoteException, UnsupportedEncodingException {
        String[][] info = new String[countOfMaps][];
        for (int index = 0; index < countOfMaps; ++index) {
            info[index] = this._maps.get(index).getDatasetsInfo();
            this.updateDatasetsMaxSize(this._maps.get(index).getDatasetsInfoLength());
        }
        return info;
    }

    private void updateDatasetsMaxSize(int[] inputarray) throws RemoteException {
        for (int i = 0; i < inputarray.length; ++i) {
            if (this._maxDatasetsInfoLength[i] >= inputarray[i]) continue;
            this._maxDatasetsInfoLength[i] = inputarray[i];
        }
    }

    public int[] getDatasetsInfoMaxLength() throws RemoteException {
        return this._maxDatasetsInfoLength;
    }

    public String[][] getAllDatasetsInfo() throws RemoteException, UnsupportedEncodingException {
        return this.getDatasetsInfo(this.getCountOfMaps());
    }

    public String[][] getContentsInfo(int mapIndex) throws MetadataException, UnsupportedEncodingException {
        String[][] contentsInfo = this._maps.get(mapIndex).getContentsInfo(this._iqMetadataService, this._session);
        return contentsInfo;
    }

    public int[] getContentsMaxLength(int mapIndex) {
        int[] maxContentsLength = this._maps.get(mapIndex).getContentsMaxLength();
        return maxContentsLength;
    }

    public String[][] getContentsInfo(int mapIndex, String keep, String[] keepDropColumns) throws MetadataException, UnsupportedEncodingException {
        String[][] contentsInfo = this._maps.get(mapIndex).getContentsInfo(this._iqMetadataService, this._session, keep, keepDropColumns);
        return contentsInfo;
    }

    public String[][] getDefaultAggregates(int mapIndex) {
        String[][] defaultAggFunctions = this._maps.get(mapIndex).getDefaultAggregates();
        return defaultAggFunctions;
    }

    public int[] getNumUnusableBI(int mapIndex) {
        int[] numUnusables = this._maps.get(mapIndex).getNumUnusableBusinessItems();
        return numUnusables;
    }

    public int getNonDetailedDI(int mapIndex) {
        int numNonDetailedDI = this._maps.get(mapIndex).getNonDetailedDI();
        return numNonDetailedDI;
    }

    public void initializeFilterInfo(int mapIndex) throws MetadataException, UnsupportedEncodingException {
        this._maps.get(mapIndex).initializeFilterInfo();
    }

    public int[] initializePromptInfo(int mapIndex) throws MetadataException, RemoteException, ServiceException {
        int[] AvailablePrompts = this._maps.get(mapIndex).initializePromptInfo();
        return AvailablePrompts;
    }

    public String[] getMapPrompts(int mapIndex) {
        String[] mapPrompts = this._maps.get(mapIndex).getMapPrompts();
        return mapPrompts;
    }

    public String[][] getAllPromptsInfo(int mapIndex) {
        String[][] allPromptsInfo = this._maps.get(mapIndex).getAllPromptsInfo();
        return allPromptsInfo;
    }

    public int getMaxPromptLength(int mapIndex) throws UnsupportedEncodingException {
        int maxPromptLength = this._maps.get(mapIndex).getMaxPromptLength();
        return maxPromptLength;
    }

    public String getPromptXML(int mapIndex, String PromptID) throws ParserConfigurationException, BackingStoreException {
        String PromptXML = this._maps.get(mapIndex).getPromptXML(PromptID);
        return PromptXML;
    }

    public String[] getFilterPrompts(int mapIndex, String filterID) {
        String[] filterPrompts = this._maps.get(mapIndex).getFilterPrompts(filterID);
        return filterPrompts;
    }

    public int getFilterCount(int mapIndex) {
        int countOfFilters = this._maps.get(mapIndex).getFilterCount();
        return countOfFilters;
    }

    public String[] getFilterName(int mapIndex) {
        String[] filterName = this._maps.get(mapIndex).getFilterName();
        return filterName;
    }

    public String[] getFilterDescription(int mapIndex) {
        String[] filterDescription = this._maps.get(mapIndex).getFilterDescription();
        return filterDescription;
    }

    public String[] getFilterID(int mapIndex) {
        String[] filterID = this._maps.get(mapIndex).getFilterID();
        return filterID;
    }

    public String[] getFilterFolder(int mapIndex) {
        String[] filterFolder = this._maps.get(mapIndex).getFilterFolder();
        return filterFolder;
    }

    public String[] getFilterExpression(int mapIndex) {
        String[] filterExpression = this._maps.get(mapIndex).getFilterExpression();
        return filterExpression;
    }

    public String[] getFilterType(int mapIndex) {
        String[] filterType = this._maps.get(mapIndex).getFilterType();
        return filterType;
    }

    public String[] getFilterIsPrompted(int mapIndex) {
        String[] promptedFilter = this._maps.get(mapIndex).getFilterIsPrompted();
        return promptedFilter;
    }

    public int getFilterBufferSize(int mapIndex) {
        int filterBufferSize = this._maps.get(mapIndex).getFilterBufferSize();
        return filterBufferSize;
    }

    public String[][] getFilterDataItems(int mapIndex) {
        String[][] filterDataItems = this._maps.get(mapIndex).getFilterDataItems();
        return filterDataItems;
    }

    public void setPromptValues(int mapIndex, String[] xml) throws SAXException, IOException, ParserConfigurationException, PromptValueNotFoundException {
        this._maps.get(mapIndex).setPromptValues(xml);
    }

    public String getDataSelectionXML(int mapIndex) {
        String dataSelectionXML = this._maps.get(mapIndex).getDataSelectionXML();
        return dataSelectionXML;
    }

    public void setFilterInfo(int mapIndex, String filterClause, String[] filterArray, String[] dataItemArray) throws MetadataException {
        this._maps.get(mapIndex).setFilterInfo(filterClause, filterArray, dataItemArray);
    }

    public boolean[] checkAuthorizations(int mapIndex) throws RemoteException, ServiceException, MetadataException {
        boolean[] authorizations = this._maps.get(mapIndex).checkAuthorizations(this._iqMetadataService, this._session);
        return authorizations;
    }

    public void executeQuery(int mapIndex, int fetchRows) throws MetadataException, IntelligentQueryException, InvalidPromptValueException, ExecutionException, SQLException {
        this._maps.get(mapIndex).executeQuery(this._iqMetadataService, this._session, fetchRows);
    }

    public void executeQuery(int mapIndex, String keep, String[] keepDropColumns, int fetchRows) throws MetadataException, IntelligentQueryException, InvalidPromptValueException, ExecutionException, SQLException {
        this._maps.get(mapIndex).executeQuery(this._iqMetadataService, this._session, keep, keepDropColumns, fetchRows);
    }

    public String[] generateQuery(int mapIndex, String keep, String[] keepDropColumns) throws MetadataException, IntelligentQueryException, InvalidPromptValueException, ExecutionException, SQLException, RemoteException {
        String[] returnArray = this._maps.get(mapIndex).generateQuery(this._iqMetadataService, this._session, keep, keepDropColumns);
        return returnArray;
    }

    public void closeResultSet(int mapIndex) throws SQLException, DataRetrievalException, ExecutionException {
        this._maps.get(mapIndex).closeResultSet();
    }

    public String getRows(int mapIndex, int start, int stop) throws SQLException {
        String rows = this._maps.get(mapIndex).getRows(start, stop);
        return rows;
    }

    public int[] getColumnType(int mapIndex) {
        int[] columnType = this._maps.get(mapIndex).getColumnType();
        return columnType;
    }

    public int getColumnCount(int mapIndex) {
        int columnCount = this._maps.get(mapIndex).getColumnCount();
        return columnCount;
    }

    public int getRowCount(int mapIndex) throws SQLException {
        int rowCount = this._maps.get(mapIndex).getRowCount();
        return rowCount;
    }

    public int getBufferCount(int mapIndex) {
        int buffCount = this._maps.get(mapIndex).getBufferCount();
        return buffCount;
    }

    public int getCountOfMaps() {
        int count = 0;
        if (this._maps != null) {
            count = this._maps.size();
        }
        return count;
    }

    public void destroySession() throws Exception {
        this._session.destroy();
    }
}

