/*
 * Decompiled with CFR 0.152.
 */
package com.sas.common.components;

import com.sas.common.components.ConfigurationComponent;
import com.sas.common.components.OmrConnectionInfoComponent;
import com.sas.common.components.ThemeComponent;
import com.sas.framework.commons.resolvers.ThemeResolverInterface;
import com.sas.framework.config.ConfigurationServiceInterface;
import com.sas.framework.themes.client.ThemeServiceInterface;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringComponentFacade
implements ServletContextListener {
    private static SpringComponentFacade _componentFacade = null;
    private static final String THEME_COMPONENT = "themeComponent";
    private static final String CONFIGURATION_COMPONENT = "configurationComponent";
    private static final String OMR_CONENCTION_INFO_COMPONENT = "omrConnectionInfoComponent";
    private ThemeServiceInterface _themeService;
    private ConfigurationServiceInterface _configurationService;
    private ThemeResolverInterface _themeResolver;
    private OmrConnectionInfoComponent _omrConnectionInfoComponent;
    private ApplicationContext _applicationContext;

    public static SpringComponentFacade getInstance() {
        if (_componentFacade == null) {
            throw new IllegalStateException();
        }
        return _componentFacade;
    }

    public ApplicationContext getApplicationContext() {
        return this._applicationContext;
    }

    public Object getComponent(String componentName) {
        return this._applicationContext.getBean(componentName);
    }

    public ThemeServiceInterface getThemeService() {
        return this._themeService;
    }

    public ThemeResolverInterface getThemeResolver() {
        return this._themeResolver;
    }

    public ConfigurationServiceInterface getConfigurationService() {
        return this._configurationService;
    }

    public OmrConnectionInfoComponent getOmrConnectionInfoComponent() {
        return this._omrConnectionInfoComponent;
    }

    public void contextDestroyed(ServletContextEvent arg0) {
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        this._applicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        this.initComponents();
        _componentFacade = this;
    }

    private void initComponents() {
        try {
            ConfigurationComponent configurationComponent = (ConfigurationComponent)this._applicationContext.getBean(CONFIGURATION_COMPONENT);
            if (configurationComponent != null) {
                this._configurationService = configurationComponent.getConfigurationService();
            }
        }
        catch (NoSuchBeanDefinitionException configurationComponent) {
            // empty catch block
        }
        try {
            this._omrConnectionInfoComponent = (OmrConnectionInfoComponent)this._applicationContext.getBean(OMR_CONENCTION_INFO_COMPONENT);
        }
        catch (NoSuchBeanDefinitionException configurationComponent) {
            // empty catch block
        }
        ThemeComponent themeComponent = (ThemeComponent)this._applicationContext.getBean(THEME_COMPONENT);
        if (themeComponent != null) {
            this._themeService = themeComponent.getThemeService();
            this._themeResolver = themeComponent.getThemeResolver();
        }
    }
}

