/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.cst.visuals;

import com.sas.metadata.promotion.visuals.PromotionLogPanel;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.tools.cst.LoggerWrapper;
import com.sas.metadata.tools.cst.visuals.AbstractSummaryTab;
import com.sas.metadata.tools.cst.visuals.CSTDataProviderInterface;
import com.sas.metadata.tools.cst.visuals.RB;
import com.sas.text.Message;
import com.sas.workspace.WAWizardDialog;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JDialog;

public class FinalReportTab
extends AbstractSummaryTab {
    private static final int _totalSteps = 4;
    private static final int _currStep = 4;

    public FinalReportTab(CSTDataProviderInterface dataProvider) {
        super(dataProvider);
        this.setHelpTopic("col_std_finish");
        this._logger.debug("Final Report Tab initialized successfully.");
    }

    @Override
    protected void initContentPanel() {
        super.initContentPanel();
        JButton viewlog = new JButton(RB.getStringResource("FinalReportTab.Log.button.caption.txt"));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.1;
        c.weighty = 0.0;
        this.add(viewlog, c);
        viewlog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FinalReportTab.this.onViewLog();
            }
        });
        viewlog.setVisible(true);
    }

    private void onViewLog() {
        StringBuffer logFileName = LoggerWrapper.getLogFileName();
        if (logFileName != null) {
            com.sas.io.File log = new com.sas.io.File(logFileName.toString());
            PromotionLogPanel panel = new PromotionLogPanel(RB.getStringResource("FinalReportTab.Log.panel.caption.txt"), (File)log, (JDialog)((WAWizardDialog)this._dataProvider));
            panel.show();
            panel.dispose();
        }
    }

    @Override
    protected String getTabHeader() {
        return RB.getStringResource("FinalReportTab.header.txt");
    }

    @Override
    protected String getTabStatus() {
        return Message.format((String)RB.getStringResource("FinalReportTab.status.fmt"), (Object)4, (Object)4);
    }

    public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
        boolean retVal = super.doDataExchange(saveToModel);
        if (retVal) {
            try {
                if (!saveToModel) {
                    this.setSummary(this._dataProvider.getFinalReportInfo());
                }
            }
            catch (Exception e) {
                retVal = false;
            }
        }
        return retVal;
    }
}

