/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.cst.visuals;

import com.sas.metadata.logical.images.DefaultIconFactory;
import com.sas.metadata.logical.images.IconFactory;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.tools.cst.Attribute;
import com.sas.metadata.tools.cst.CSTException;
import com.sas.metadata.tools.cst.ColumnInstance;
import com.sas.metadata.tools.cst.ControllerFactory;
import com.sas.metadata.tools.cst.GroupInstances;
import com.sas.metadata.tools.cst.GroupInstancesInterface;
import com.sas.metadata.tools.cst.StandardizationControllerInterface;
import com.sas.metadata.tools.cst.UserInput;
import com.sas.metadata.tools.cst.Validations;
import com.sas.metadata.tools.cst.tools.Utils;
import com.sas.metadata.tools.cst.visuals.AbstractCSTTab;
import com.sas.metadata.tools.cst.visuals.CSTDataProviderInterface;
import com.sas.metadata.tools.cst.visuals.RB;
import com.sas.swing.visuals.tableview.DefaultTableCellRenderer;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.wadmin.app.AppDesktop;
import com.sas.wadmin.visuals.ImpactAnalysisOMAView;
import com.sas.workspace.CustomDesktop;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyFrame;
import com.sas.workspace.WASplittablePropertyFrame;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceOMAView;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsOMAView;
import com.sas.workspace.WsViewFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ComparisonTab
extends AbstractCSTTab
implements ActionListener,
ItemListener,
TableModelListener {
    private JButton _btnColProps;
    private JButton _btnRollBack;
    private JButton _btnStandardize;
    private JComboBox _cmbSortBy;
    private JLabel _lblHeader;
    private JLabel _lblNote;
    private JLabel _lblSelected;
    private JLabel _lblSortBy;
    private JLabel _lblColGroups;
    private JLabel _lblStdValues;
    private JLabel _lblColumnDetails;
    private JList _lstColGroups;
    private JPanel _pnlColDetails;
    private JPanel _pnlColNames;
    private JScrollPane _scpColNames;
    private JScrollPane _scpStdRow;
    private JTable _tabStdRow;
    private JLabel _lblStdValsNote;
    private JCheckBox _chkSelectAll;
    private JScrollPane _scpColDetails;
    private JTable _tabColumns;
    private JTable _tabColumnsFixed;
    private List<GroupInstancesInterface> _groupInstancesList;
    private Hashtable<String, Attribute> _standardAttibutes;
    private HashMap<String, Integer> columnLengths;
    private ControllerFactory _controllerFactory = null;
    private StandardizationControllerInterface _standardizationController = null;
    private GroupInstancesInterface _lastSelectedGroup = null;
    private Hashtable<GroupInstancesInterface, List<Attribute>> _mpGrpStandardAttribs = new Hashtable();
    private List<ColumnInstance> lstCols;
    private static final int _totalSteps = 4;
    private static final int _currStep = 2;
    private static final String ACTION_STANDARDIZE = Util.getLabelWithoutMnemonic((String)RB.getStringResource("ComparisonTab.action.standardize.txt"));
    private static final String ACTION_ROLLBACK = Util.getLabelWithoutMnemonic((String)RB.getStringResource("ComparisonTab.action.rollback.txt"));
    private static final String ACTION_COLUMNPROPERTIES = Util.getLabelWithoutMnemonic((String)RB.getStringResource("ComparisonTab.impact.analysis.txt"));
    private static final String ACTION_SORTBY = "cmb_sortby";
    private static final String COLUMN_OBJECT = "#OBJECT#";
    private static final String COLUMN_INCLUDE = RB.getStringResource("ComparisonTab.column.include.txt");
    private static final String COLUMN_ICON = RB.getStringResource("ComparisonTab.column.icon.txt");
    private CSTDataProviderInterface dataProvider;
    private IconFactory _iconFactory = DefaultIconFactory.getInstance();

    public ComparisonTab(CSTDataProviderInterface dataProvider) {
        super(dataProvider);
        this.setHelpTopic("col_std_nonstd_cols");
        this.dataProvider = dataProvider;
        this._logger.debug("Comparisontab initialized succesfully .");
    }

    @Override
    protected String getTabHeader() {
        return RB.getStringResource("ComparisonTab.standardize.columns.txt");
    }

    @Override
    protected String getTabStatus() {
        return Message.format((String)RB.getStringResource("ComparisonTab.status.fmt"), (Object)2, (Object)4);
    }

    @Override
    protected void initContentPanel() {
        this._logger.debug("Comparisontab's initContentPanel() started.");
        WAPanel contentsPanel = this.getContentsPanel();
        int mnemonic = 0;
        this._lblHeader = new JLabel();
        this._lblSelected = new JLabel();
        this._pnlColNames = new JPanel();
        this._lblSortBy = new JLabel();
        this._lblStdValues = new JLabel();
        this._cmbSortBy = new JComboBox();
        this._scpColNames = new JScrollPane();
        this._lstColGroups = new JList();
        this._pnlColDetails = new JPanel();
        this._scpStdRow = new JScrollPane();
        this._tabStdRow = new JTable();
        this._tabColumns = new JTable();
        this._lblColGroups = new JLabel();
        this._scpColDetails = new JScrollPane(this._tabColumns);
        this._lblColumnDetails = new JLabel();
        this._tabColumns.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this._chkSelectAll = new JCheckBox(RB.getStringResource("ComparisonTab.select.all.txt"));
        this._lblStdValsNote = new JLabel();
        this._lblNote = new JLabel();
        this._btnStandardize = new JButton();
        this._btnRollBack = new JButton();
        this._btnColProps = new JButton();
        contentsPanel.setLayout((LayoutManager)new GridBagLayout());
        contentsPanel.setMinimumSize(new Dimension(580, 360));
        contentsPanel.setPreferredSize(new Dimension(580, 360));
        WAPanel panelOne = new WAPanel();
        panelOne.setLayout((LayoutManager)new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        panelOne.add((Component)this._lblSelected, (Object)c);
        c.insets = new Insets(0, 5, 5, 0);
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this._btnStandardize.setText(ACTION_STANDARDIZE);
        mnemonic = Util.getDisplayedMnemonic((String)RB.getStringResource("ComparisonTab.action.standardize.txt"));
        this._btnStandardize.setMnemonic(mnemonic);
        this._btnStandardize.addActionListener(this);
        panelOne.add((Component)this._btnStandardize, (Object)c);
        c.gridx = 3;
        this._btnRollBack.setText(ACTION_ROLLBACK);
        mnemonic = Util.getDisplayedMnemonic((String)RB.getStringResource("ComparisonTab.action.rollback.txt"));
        this._btnRollBack.setMnemonic(mnemonic);
        this._btnRollBack.addActionListener(this);
        panelOne.add((Component)this._btnRollBack, (Object)c);
        c.gridx = 4;
        this._btnColProps.setText(ACTION_COLUMNPROPERTIES);
        mnemonic = Util.getDisplayedMnemonic((String)RB.getStringResource("ComparisonTab.impact.analysis.txt"));
        this._btnColProps.setMnemonic(mnemonic);
        this._btnColProps.addActionListener(this);
        panelOne.add((Component)this._btnColProps, (Object)c);
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 4;
        c.gridheight = 2;
        c.weightx = 0.5;
        c.weighty = 0.0;
        contentsPanel.add((Component)panelOne, (Object)c);
        this._pnlColNames.setLayout(new GridBagLayout());
        this._pnlColNames.setBorder(BorderFactory.createTitledBorder(""));
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this._lblSortBy.setText(Util.getLabelWithoutMnemonic((String)RB.getStringResource("ComparisonTab.sort.by.txt")));
        mnemonic = Util.getDisplayedMnemonic((String)RB.getStringResource("ComparisonTab.sort.by.txt"));
        this._lblSortBy.setDisplayedMnemonic(mnemonic);
        this._lblSortBy.setLabelFor(this._cmbSortBy);
        this._pnlColNames.add((Component)this._lblSortBy, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.ipadx = 25;
        this._pnlColNames.add((Component)this._cmbSortBy, c);
        this._cmbSortBy.addItemListener(this);
        this._cmbSortBy.setRenderer(new ComboTooltipRenderer());
        this._cmbSortBy.setActionCommand(ACTION_SORTBY);
        this._lblColGroups.setText(Util.getLabelWithoutMnemonic((String)RB.getStringResource("ComparisonTab.column.groups.txt")));
        c.fill = 2;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 2.0;
        c.weighty = 0.0;
        mnemonic = Util.getDisplayedMnemonic((String)RB.getStringResource("ComparisonTab.column.groups.txt"));
        this._lblColGroups.setDisplayedMnemonic(mnemonic);
        this._lblColGroups.setLabelFor(this._lstColGroups);
        this._pnlColNames.add((Component)this._lblColGroups, c);
        this._lstColGroups.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ComparisonTab.this.loadDataForSelectedGroup();
            }
        });
        this._lstColGroups.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof GroupInstancesInterface) {
                    GroupInstancesInterface gii = (GroupInstancesInterface)value;
                    value = gii.getGroupIdentifier();
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        this._lstColGroups.setSelectionMode(0);
        this._scpColNames.setViewportView(this._lstColGroups);
        c.fill = 1;
        c.insets = new Insets(0, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 2.0;
        c.weighty = 1.0;
        this._pnlColNames.add((Component)this._scpColNames, c);
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 10;
        c.weightx = 0.0;
        c.weighty = 1.0;
        contentsPanel.add((Component)this._pnlColNames, (Object)c);
        this._pnlColDetails.setLayout(new GridBagLayout());
        this._pnlColDetails.setBorder(BorderFactory.createTitledBorder(""));
        this._tabStdRow.setCellSelectionEnabled(false);
        this._tabStdRow.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this._tabStdRow.setModel(new DefaultTableModel(1, 2));
        this._scpStdRow.setViewportView(this._tabStdRow);
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 5;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this._lblStdValues.setText(Util.getLabelWithoutMnemonic((String)RB.getStringResource("ComparisonTab.standard.values.txt")));
        mnemonic = Util.getDisplayedMnemonic((String)RB.getStringResource("ComparisonTab.standard.values.txt"));
        this._lblStdValues.setDisplayedMnemonic(mnemonic);
        this._lblStdValues.setLabelFor(this._tabStdRow);
        this._pnlColDetails.add((Component)this._lblStdValues, c);
        c.insets = new Insets(0, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 5;
        c.gridheight = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        if (this._tabStdRow.getTableHeader() != null) {
            int headerHeight = this._tabStdRow.getTableHeader().getPreferredSize().height;
            int rowHeight = this._tabStdRow.getRowHeight();
            c.ipady = headerHeight + rowHeight - 23;
        } else {
            c.ipady = 12;
        }
        this._pnlColDetails.add((Component)this._scpStdRow, c);
        c.fill = 1;
        c.insets = new Insets(2, 2, 0, 2);
        c.ipady = 0;
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 4;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this._lblColumnDetails.setText(Util.getLabelWithoutMnemonic((String)RB.getStringResource("ComparisonTab.column.details.txt")));
        mnemonic = Util.getDisplayedMnemonic((String)RB.getStringResource("ComparisonTab.column.details.txt"));
        this._lblColumnDetails.setDisplayedMnemonic(mnemonic);
        this._lblColumnDetails.setLabelFor(this._tabColumns);
        this._pnlColDetails.add((Component)this._lblColumnDetails, c);
        c.fill = 0;
        this._chkSelectAll.addItemListener(this);
        c.gridx = 4;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this._pnlColDetails.add((Component)this._chkSelectAll, c);
        c.fill = 1;
        c.insets = new Insets(0, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 5;
        c.gridheight = 11;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this._pnlColDetails.add((Component)this._scpColDetails, c);
        c.insets = new Insets(0, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 16;
        c.gridwidth = 5;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this._lblStdValsNote.setText(RB.getStringResource("ComparisonTab.standard.values.note.txt"));
        this._pnlColDetails.add((Component)this._lblStdValsNote, c);
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 5;
        c.gridheight = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        contentsPanel.add((Component)this._pnlColDetails, (Object)c);
        WAPanel panelLast = new WAPanel();
        panelLast.setLayout((LayoutManager)new GridBagLayout());
        this._lblNote.setText(RB.getStringResource("ComparisonTab.footer.note.txt"));
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 20;
        c.gridheight = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panelLast.add((Component)this._lblNote, (Object)c);
        c.ipady = 6;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 13;
        c.gridwidth = 4;
        c.gridheight = 4;
        c.weightx = 1.0;
        c.weighty = 0.0;
        contentsPanel.add((Component)panelLast, (Object)c);
        this._logger.debug("Comparisontab's initContentPanel() completed.");
    }

    private GroupInstancesInterface getSelectedGroup() {
        GroupInstancesInterface gii = null;
        try {
            gii = (GroupInstancesInterface)this._lstColGroups.getSelectedValue();
        }
        catch (Exception e) {
            this._logger.error(RB.getStringResource("ComparisonTab.Exception.getSelectegroup.txt"), (Throwable)e);
        }
        return gii;
    }

    private List<Attribute> saveStandardValuesForCurrentGroup() {
        List<Attribute> lstStdAttribs = this._mpGrpStandardAttribs.get(this._lastSelectedGroup);
        if (lstStdAttribs != null) {
            TableColumnModel colModl = this._tabStdRow.getColumnModel();
            for (int i = 0; i < lstStdAttribs.size(); ++i) {
                Attribute attrib;
                int col = colModl.getColumnIndex((attrib = lstStdAttribs.get(i)).getAttributeName());
                String value = (String)this._tabStdRow.getValueAt(0, col);
                attrib.setDisplayValue(value != null ? value : "");
            }
        } else {
            lstStdAttribs = new ArrayList<Attribute>();
            TableColumnModel colModl = this._tabStdRow.getColumnModel();
            for (int i = 0; i < colModl.getColumnCount(); ++i) {
                String columnHeader = (String)colModl.getColumn(i).getHeaderValue();
                String value = (String)this._tabStdRow.getValueAt(0, i);
                Attribute attrib = new Attribute(columnHeader, value != null ? value : "");
                attrib.setDisplayValue(value != null ? value : "");
                lstStdAttribs.add(attrib);
            }
            this._mpGrpStandardAttribs.put(this._lastSelectedGroup, lstStdAttribs);
        }
        return lstStdAttribs;
    }

    private void loadStardardValuesTable() {
        List<Attribute> lstStdAttribs = this._mpGrpStandardAttribs.get(this._lastSelectedGroup);
        if (lstStdAttribs != null) {
            TableColumnModel colModl = this._tabStdRow.getColumnModel();
            for (Attribute att : lstStdAttribs) {
                int iCol = colModl.getColumnIndex(att.getAttributeName());
                if (iCol <= -1) continue;
                this._tabStdRow.setValueAt(att.getDisplayValue(), 0, iCol);
            }
        } else {
            TableColumnModel colModl = this._tabStdRow.getColumnModel();
            for (int i = 0; i < colModl.getColumnCount(); ++i) {
                this._tabStdRow.setValueAt("", 0, i);
            }
        }
    }

    private void loadDataForSelectedGroup() {
        block10: {
            this._logger.debug("Comparisontab's loadDataForSelectedGroup() started.");
            try {
                if (this._lastSelectedGroup != null && !this._lastSelectedGroup.isStandardized()) {
                    this.saveStandardValuesForCurrentGroup();
                }
                this._lastSelectedGroup = this.getSelectedGroup();
                if (this._lastSelectedGroup == null) break block10;
                this.loadStardardValuesTable();
                this._btnRollBack.setEnabled(this._lastSelectedGroup.isStandardized());
                this._btnStandardize.setEnabled(!this._lastSelectedGroup.isStandardized());
                OpRequestUI opRequestUI = new OpRequestUI((Component)((Object)this), RB.getStringResource("Visuals.processing.request.message.txt"), RB.getStringResource("Visuals.progressbar.titel.txt"));
                opRequestUI.setDelayBeforeProgressCancelDialog(500);
                opRequestUI.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ComparisonTab.this.lstCols = ComparisonTab.this._lastSelectedGroup.getGroupOperator().sort();
                        }
                        catch (Exception e) {
                            ComparisonTab.this._logger.error(RB.getStringResource("ComparisonTab.failure.txt"), (Throwable)e);
                        }
                    }
                });
                this._logger.debug("The data for selected group is sorted successfully.");
                if (this.lstCols != null && !this.lstCols.isEmpty()) {
                    CSTTableModel tableModel = new CSTTableModel(this.lstCols);
                    this._tabColumns = new JTable(tableModel);
                    this._tabColumns.setSelectionMode(0);
                    TableColumnModel tcm = this._tabColumns.getColumnModel();
                    for (int i = 0; i < tcm.getColumnCount(); ++i) {
                        TableColumn tabCol = tcm.getColumn(i);
                        tabCol.setPreferredWidth(this.columnLengths.get(this._tabColumns.getColumnName(i)));
                    }
                    this._tabColumns.setAutoResizeMode(0);
                    this.freezeCols();
                    this._lblColumnDetails.setLabelFor(this._tabColumns);
                    TableColumn iconColumn = this._tabColumnsFixed.getColumn(COLUMN_ICON);
                    iconColumn.setHeaderRenderer(new TableCellRenderer(){
                        private JButton renderer = new JButton();

                        @Override
                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                            return this.renderer;
                        }
                    });
                    iconColumn.setCellRenderer((TableCellRenderer)new DefaultTableCellRenderer(){
                        private JLabel label = new JLabel();

                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                            if (value instanceof Icon) {
                                this.label.setIcon((Icon)value);
                                this.label.setHorizontalAlignment(0);
                                this.label.setOpaque(true);
                                if (isSelected) {
                                    this.label.setBackground(table.getSelectionBackground());
                                } else {
                                    this.label.setBackground(table.getBackground());
                                }
                                return this.label;
                            }
                            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        }
                    });
                    ColumnMouseListener mousseListener = new ColumnMouseListener();
                    this._tabColumns.addMouseListener(mousseListener);
                    this._tabColumnsFixed.addMouseListener(mousseListener);
                    ColumnSelectionListener selectionListener = new ColumnSelectionListener();
                    this._tabColumns.getSelectionModel().addListSelectionListener(selectionListener);
                    this._tabColumnsFixed.getSelectionModel().addListSelectionListener(selectionListener);
                    TableModel model = this._tabColumnsFixed.getModel();
                    if (model != null) {
                        int includeColumnIndex;
                        model.addTableModelListener(this);
                        int rowCount = model.getRowCount();
                        if (rowCount > 0 && (includeColumnIndex = this._tabColumnsFixed.getColumnModel().getColumnIndex(COLUMN_INCLUDE)) >= 0) {
                            TableModelEvent event = new TableModelEvent(model, 0, rowCount - 1, includeColumnIndex);
                            this.tableChanged(event);
                        }
                    }
                    this._scpColDetails.setViewportView(this._tabColumns);
                    this._scpColDetails.setViewportBorder(BorderFactory.createEmptyBorder());
                    ListSelectionModel selectionModel = this._tabColumns.getSelectionModel();
                    selectionModel.setSelectionInterval(0, 0);
                    try {
                        Object obj;
                        int iIDCol;
                        int selectedRow = this._tabColumnsFixed.getSelectedRow();
                        if (selectedRow > -1 && (iIDCol = this._tabColumnsFixed.getColumnModel().getColumnIndex(COLUMN_OBJECT)) > -1 && (obj = this._tabColumnsFixed.getValueAt(selectedRow, iIDCol)) instanceof ColumnInstance) {
                            ColumnInstance ci = (ColumnInstance)obj;
                            this.setSelectedColumnName(ci.getColumnName());
                        }
                        break block10;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(System.err);
                    }
                    break block10;
                }
                JOptionPane.showMessageDialog(null, RB.getStringResource("ComparisonTab.null.columns.txt"));
                this._logger.info(RB.getStringResource("ComparisonTab.null.columns.txt"));
            }
            catch (CSTException e1) {
                e1.printStackTrace();
                this._logger.error(RB.getStringResource("ComparisonTab.Exception.load.data.txt"), (Throwable)e1);
            }
        }
        this.lstCols = null;
        this._logger.debug("Comparisontab's loadDataForSelectedGroup() completed.");
    }

    private void freezeCols() {
        this._logger.debug("freezeCols for Comparisontab started.");
        int noOfColumnsToBeFixed = 3;
        this._tabColumnsFixed = new JTable(this._tabColumns.getModel());
        this._tabColumnsFixed.setFocusable(false);
        this._tabColumnsFixed.setSelectionModel(this._tabColumns.getSelectionModel());
        this._tabColumnsFixed.getTableHeader().setReorderingAllowed(false);
        this._tabColumnsFixed.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this._tabColumns.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        for (int i = 0; i < noOfColumnsToBeFixed; ++i) {
            TableColumnModel columnModel = this._tabColumns.getColumnModel();
            columnModel.removeColumn(columnModel.getColumn(0));
        }
        while (this._tabColumnsFixed.getColumnCount() > noOfColumnsToBeFixed) {
            TableColumnModel columnModel = this._tabColumnsFixed.getColumnModel();
            columnModel.removeColumn(columnModel.getColumn(noOfColumnsToBeFixed));
        }
        this._tabColumnsFixed.getColumn(COLUMN_OBJECT).setMaxWidth(0);
        this._tabColumnsFixed.getColumn(COLUMN_OBJECT).setMinWidth(0);
        this._tabColumnsFixed.getColumn(COLUMN_OBJECT).setPreferredWidth(0);
        this._tabColumnsFixed.getColumn(COLUMN_INCLUDE).setMaxWidth(this.columnLengths.get(COLUMN_INCLUDE));
        this._tabColumnsFixed.getColumn(COLUMN_INCLUDE).setMinWidth(this.columnLengths.get(COLUMN_INCLUDE));
        this._tabColumnsFixed.getColumn(COLUMN_INCLUDE).setPreferredWidth(this.columnLengths.get(COLUMN_INCLUDE));
        this._tabColumnsFixed.getColumn(COLUMN_ICON).setMaxWidth(20);
        this._tabColumnsFixed.getColumn(COLUMN_ICON).setMinWidth(20);
        this._tabColumnsFixed.getColumn(COLUMN_ICON).setPreferredWidth(20);
        this._tabColumnsFixed.setPreferredScrollableViewportSize(this._tabColumnsFixed.getPreferredSize());
        this._scpColDetails.setRowHeaderView(this._tabColumnsFixed);
        this._scpColDetails.setCorner("UPPER_LEFT_CORNER", this._tabColumnsFixed.getTableHeader());
        this._logger.debug("freezeCols for Comparisontab completed");
    }

    private void initLstColGroups() {
        DefaultListModel<GroupInstancesInterface> lstModel = new DefaultListModel<GroupInstancesInterface>();
        for (GroupInstancesInterface grouptInstances : this._groupInstancesList) {
            lstModel.addElement(grouptInstances);
        }
        this._lstColGroups.setModel(lstModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initVisuals() {
        this._logger.debug("Comparison Tab initVisuals() started to initialize the viuals on tab.");
        try {
            UserInput userInput = this._dataProvider.getUserInput();
            List<Attribute> attribs = userInput.getAttributes();
            this._standardizationController = this.dataProvider.getStandardizationController();
            if (!userInput.isGroupByNameCriteria()) {
                this._pnlColNames.setVisible(false);
            } else {
                this._pnlColNames.setVisible(true);
            }
            this._cmbSortBy.setModel(new DefaultComboBoxModel<StandardizationControllerInterface.GroupSortCriteria>(StandardizationControllerInterface.GroupSortCriteria.values()));
            this._cmbSortBy.setSelectedIndex(1);
            this._cmbSortBy.setSelectedIndex(0);
            this.initLstColGroups();
            this._lstColGroups.setSelectedIndex(0);
            Object[] headers = new String[attribs.size()];
            Object[][] rowData = new String[1][attribs.size()];
            this._standardAttibutes = new Hashtable();
            for (int i = 0; i < attribs.size(); ++i) {
                Attribute att = attribs.get(i);
                headers[i] = att.getAttributeName();
                rowData[0][i] = att.getDisplayValue();
                this._standardAttibutes.put((String)headers[i], att);
            }
            DefaultTableModel dtm = new DefaultTableModel(rowData, headers);
            this._tabStdRow.setModel(dtm);
            TableColumnModel tcm = this._tabStdRow.getColumnModel();
            if (tcm != null) {
                for (int i = 0; i < tcm.getColumnCount(); ++i) {
                    TableColumn col = tcm.getColumn(i);
                    try {
                        String attName = (String)col.getHeaderValue();
                        Attribute att = this._standardAttibutes.get(attName);
                        List<String> possibleValues = this._dataProvider.getPossibleValuesFor(att);
                        if (possibleValues == null || possibleValues.isEmpty()) continue;
                        col.setCellEditor(new ComboBoxEditer(possibleValues));
                        continue;
                    }
                    catch (Exception e) {
                        this._logger.error(RB.getStringResource("ComparisonTab.Exception.attribute.fetch.txt"), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this._logger.error(RB.getStringResource("ComparisonTab.Exception.initvisuals.txt"), (Throwable)e);
        }
        finally {
            this.validate();
        }
        this._logger.debug("Comparison Tab initVisuals() completed with initialization of the viuals on tab");
    }

    public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
        boolean retVal = super.doDataExchange(saveToModel);
        if (retVal) {
            try {
                if (!saveToModel) {
                    this.setUIData();
                }
            }
            catch (Exception e) {
                retVal = false;
            }
        }
        return retVal;
    }

    public boolean validateData() {
        boolean isValid = false;
        if (!this.isAnyGroupStandardized()) {
            JOptionPane.showMessageDialog((Component)((Object)this), RB.getStringResource("ComparisonTab.no.column.standardized.txt"), RB.getStringResource("ComparisonTab.warning.txt"), 2);
            this._logger.warn(RB.getStringResource("ComparisonTab.no.column.standardized.txt"));
            return false;
        }
        this._standardizationController.setPreferences();
        this._logger.debug("Comparisontab validateData() method completed sucessfully after click on Next button,passing control to intermediateSummaryTab");
        this._logger.info(RB.getStringResource("ComparisonTab.onNext.txt"));
        return true;
    }

    public void setUIData() {
        this._groupInstancesList = this._dataProvider.getAllGroupInstances();
        this.initVisuals();
    }

    private boolean isAnyGroupStandardized() {
        ListModel listModel = this._lstColGroups.getModel();
        if (listModel != null && listModel.getSize() != 0) {
            for (int i = 0; i < listModel.getSize(); ++i) {
                GroupInstancesInterface group;
                Object obj = listModel.getElementAt(i);
                if (!(obj instanceof GroupInstancesInterface) || !(group = (GroupInstancesInterface)obj).isStandardized()) continue;
                return true;
            }
        }
        return false;
    }

    private List<Attribute> getStandardValues() {
        List<Attribute> standarValues = this.saveStandardValuesForCurrentGroup();
        for (Attribute att : standarValues) {
            String value = att.getDisplayValue();
            if (value != null) continue;
            return null;
        }
        return standarValues;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean reloadGroupData;
        block39: {
            reloadGroupData = false;
            String actionCommand = e.getActionCommand();
            if (actionCommand.equals(ACTION_STANDARDIZE)) {
                this._logger.debug("Standardize button is clicked.");
                GroupInstancesInterface gii = this.getSelectedGroup();
                if (gii != null) {
                    try {
                        if (this.storeIncludeStatusToModel()) {
                            if (this.isAnyColumnIncluded()) {
                                List<Attribute> attribs = this.getStandardValues();
                                int userChoiceForBlankValueWarning = 0;
                                boolean warnigForBlankValues = false;
                                boolean errorForBlankValues = false;
                                StringBuffer emptyAttributesListFrWarning = null;
                                StringBuffer emptyAttributesListFrError = null;
                                if (attribs != null && !attribs.isEmpty()) {
                                    for (Attribute att : attribs) {
                                        if (!att.getAttributeValue().trim().equals("")) continue;
                                        if (ControllerFactory.isEmptyAllowed(att)) {
                                            warnigForBlankValues = true;
                                            if (emptyAttributesListFrWarning == null) {
                                                emptyAttributesListFrWarning = new StringBuffer(att.getAttributeName());
                                                continue;
                                            }
                                            emptyAttributesListFrWarning.append(RB.getStringResource("ComparisonTab.attribute.name.list.separator.txt"));
                                            emptyAttributesListFrWarning.append(att.getAttributeName());
                                            continue;
                                        }
                                        errorForBlankValues = true;
                                        if (emptyAttributesListFrError == null) {
                                            emptyAttributesListFrError = new StringBuffer(att.getAttributeName());
                                            continue;
                                        }
                                        emptyAttributesListFrError.append(RB.getStringResource("ComparisonTab.attribute.name.list.separator.txt"));
                                        emptyAttributesListFrError.append(att.getAttributeName());
                                    }
                                    if (errorForBlankValues) {
                                        JOptionPane.showMessageDialog((Component)((Object)this), Message.format((String)RB.getStringResource("ComparisonTab.blank.values.are.not.allowed.fmt"), emptyAttributesListFrError), RB.getStringResource("ComparisonTab.empty.selection.txt"), 0);
                                    } else if (warnigForBlankValues) {
                                        userChoiceForBlankValueWarning = JOptionPane.showConfirmDialog((Component)((Object)this), Message.format((String)RB.getStringResource("ComparisonTab.blank.values.are.not.recommanded.fmt"), emptyAttributesListFrWarning), RB.getStringResource("ComparisonTab.warning.txt"), 0);
                                    }
                                    if (userChoiceForBlankValueWarning == 0 && !errorForBlankValues) {
                                        List<Validations.ErrorWarning> errorWarnings = null;
                                        String message = null;
                                        int messageType = -1;
                                        boolean isPreProcessingRequired = false;
                                        Validations validations = gii.getGroupOperator().validate(attribs);
                                        if (validations != null) {
                                            errorWarnings = validations.getAllErrorMessages();
                                            if (errorWarnings == null || errorWarnings.isEmpty()) {
                                                errorWarnings = validations.getAllWarningMessages();
                                                if (errorWarnings != null && !errorWarnings.isEmpty()) {
                                                    messageType = 2;
                                                    message = this._dataProvider.getCombinedMessage(errorWarnings);
                                                }
                                                if (validations.getAllOperationalWarnings() != null) {
                                                    isPreProcessingRequired = true;
                                                }
                                            } else {
                                                messageType = 0;
                                                message = this._dataProvider.getCombinedMessage(errorWarnings);
                                            }
                                        }
                                        if (messageType != 0) {
                                            int userChoice;
                                            if (messageType == 2 && (userChoice = JOptionPane.showConfirmDialog((Component)((Object)this), message = message + RB.getStringResource("ComparisonTab.continue.standardization.txt"), RB.getStringResource("ComparisonTab.warning.txt"), 0)) == 0) {
                                                if (isPreProcessingRequired) {
                                                    Attribute ColLength = null;
                                                    Attribute ColType = null;
                                                    int min = 0;
                                                    int max = 0;
                                                    for (Validations.ErrorWarning ew : errorWarnings) {
                                                        gii.getGroupOperator().excludeColumns(ew.getAssociatedAttribute());
                                                        ColLength = Utils.searchAttribute(attribs, Attribute.getExternalizedAtributeName(ControllerFactory.AttributeNames.SASColumnLength.toString()));
                                                        ColType = Utils.searchAttribute(attribs, Attribute.getExternalizedAtributeName(ControllerFactory.AttributeNames.SASColumnType.toString()));
                                                        if (ColType == null) {
                                                            ColType = Utils.searchAttribute(gii.getIncluded().get(0).getAttributes(), Attribute.getExternalizedAtributeName(ControllerFactory.AttributeNames.SASColumnType.toString()));
                                                        }
                                                        if (ew.getType() == Validations.ErrorWarningType.WARNING_TRUNC_MIN) {
                                                            min = ColType.getMin();
                                                            ColLength.setAttributeValue(String.valueOf(min));
                                                        }
                                                        if (ew.getType() != Validations.ErrorWarningType.WARNING_TRUNC_MAX) continue;
                                                        max = ColType.getMax();
                                                        ColLength.setAttributeValue(String.valueOf(max));
                                                    }
                                                }
                                                messageType = -1;
                                            }
                                            if (messageType == -1) {
                                                this._logger.info(RB.getStringResource("ComparisonTab.prevalidation.completed.txt"));
                                                gii.getGroupOperator().standardize(attribs);
                                                reloadGroupData = true;
                                            }
                                        } else {
                                            JOptionPane.showMessageDialog((Component)((Object)this), message, RB.getStringResource("ComparisonTab.error.txt"), messageType);
                                            this._logger.warn(RB.getStringResource("ComparisonTab.error.txt"));
                                        }
                                    }
                                } else {
                                    JOptionPane.showMessageDialog((Component)((Object)this), RB.getStringResource("ComparisonTab.empty.values.txt"), RB.getStringResource("ComparisonTab.empty.selection.txt"), 0);
                                    this._logger.warn(RB.getStringResource("ComparisonTab.empty.values.txt"));
                                }
                            } else {
                                JOptionPane.showMessageDialog((Component)((Object)this), RB.getStringResource("ComparisonTab.include.some.column.txt"), RB.getStringResource("ComparisonTab.error.txt"), 0);
                                this._logger.warn(RB.getStringResource("ComparisonTab.include.some.column.txt"));
                            }
                            break block39;
                        }
                        JOptionPane.showMessageDialog((Component)((Object)this), RB.getStringResource("ComparisonTab.status.not.saved.txt"), RB.getStringResource("ComparisonTab.warning.txt"), 2);
                        this._logger.warn(RB.getStringResource("ComparisonTab.status.not.saved.txt"));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog((Component)((Object)this), RB.getStringResource("ComparisonTab.process.failed.with.exception.txt"), RB.getStringResource("ComparisonTab.failure.txt"), 0);
                        this._logger.error(RB.getStringResource("ComparisonTab.process.failed.with.exception.txt"), (Throwable)ex);
                    }
                } else {
                    JOptionPane.showMessageDialog((Component)((Object)this), RB.getStringResource("ComparisonTab.select.group.txt"), RB.getStringResource("ComparisonTab.empty.selection.txt"), 0);
                    this._logger.warn(RB.getStringResource("ComparisonTab.select.group.txt"));
                }
            } else if (actionCommand.equals(ACTION_ROLLBACK)) {
                this._logger.debug("Rollback button is clicked.");
                GroupInstancesInterface gii = this.getSelectedGroup();
                reloadGroupData = gii.getGroupOperator().rollBack();
                this._logger.info(RB.getStringResource("ComparisonTab.rollback.complete.txt"));
            } else if (actionCommand.equals(ACTION_COLUMNPROPERTIES)) {
                Object obj;
                int iIDCol;
                this._logger.debug("Impact analysis button is clicked.");
                int selectedRow = this._tabColumnsFixed.getSelectedRow();
                if (selectedRow > -1 && (iIDCol = this._tabColumnsFixed.getColumnModel().getColumnIndex(COLUMN_OBJECT)) > -1 && (obj = this._tabColumnsFixed.getValueAt(selectedRow, iIDCol)) instanceof ColumnInstance) {
                    ColumnInstance col = (ColumnInstance)obj;
                    try {
                        Column column1 = col.getMetadataColumn();
                        this.showColumnImpactAnalysis(true, column1);
                        this._logger.info(RB.getStringResource("ComparisonTab.impactanalysis.complete.txt"));
                    }
                    catch (CSTException e1) {
                        e1.printStackTrace();
                        this._logger.error(RB.getStringResource("ComparisonTab.Exception.getColumn.txt"), (Throwable)e1);
                    }
                }
            }
        }
        if (reloadGroupData) {
            this._logger.debug("After action the Group data is reloading.");
            this.loadDataForSelectedGroup();
            this._logger.debug("Group data is reloaded succesfully.");
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this._chkSelectAll) {
            if (e.getStateChange() == 1) {
                this.setAllIncluded(true);
            } else {
                this.setAllIncluded(false);
            }
        } else if (source == this._cmbSortBy) {
            this._logger.debug("Sorting criteria for groups is changed.");
            GroupInstances selectedGroupIndex = (GroupInstances)this._lstColGroups.getSelectedValue();
            OpRequestUI opRequestUI = new OpRequestUI((Component)((Object)this), RB.getStringResource("Visuals.processing.request.message.txt"), RB.getStringResource("Visuals.progressbar.titel.txt"));
            opRequestUI.setDelayBeforeProgressCancelDialog(500);
            opRequestUI.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ComparisonTab.this._groupInstancesList = ComparisonTab.this._dataProvider.getSortedGroupInstances((StandardizationControllerInterface.GroupSortCriteria)((Object)ComparisonTab.this._cmbSortBy.getSelectedItem()));
                    }
                    catch (Exception e) {
                        ComparisonTab.this._logger.error(RB.getStringResource("ComparisonTab.failure.txt"), (Throwable)e);
                    }
                }
            });
            this.initLstColGroups();
            this._lstColGroups.setSelectedValue(selectedGroupIndex, true);
        }
    }

    private void setAllIncluded(boolean value) {
        int col;
        TableModel model = this._tabColumnsFixed.getModel();
        if (model != null && (col = this._tabColumnsFixed.getColumnModel().getColumnIndex(COLUMN_INCLUDE)) >= 0) {
            int totalRows = model.getRowCount();
            model.removeTableModelListener(this);
            for (int row = 0; row < totalRows; ++row) {
                model.setValueAt(value, row, col);
            }
            model.addTableModelListener(this);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int col = e.getColumn();
        TableModel model = (TableModel)e.getSource();
        String columnName = model.getColumnName(col);
        if (COLUMN_INCLUDE.equals(columnName)) {
            Boolean bool;
            Object obj;
            int row;
            int firstRow = e.getFirstRow();
            int lastRow = e.getLastRow();
            for (row = firstRow; row <= lastRow; ++row) {
                obj = model.getValueAt(row, col);
                if (!(obj instanceof Boolean) || (bool = (Boolean)obj).booleanValue()) continue;
                this.setCheckBoxSelected(false);
                return;
            }
            for (row = 0; row < model.getRowCount(); ++row) {
                while (row >= firstRow && row <= lastRow) {
                    ++row;
                }
                if (row >= model.getRowCount()) break;
                obj = model.getValueAt(row, col);
                if (!(obj instanceof Boolean) || (bool = (Boolean)obj).booleanValue()) continue;
                this.setCheckBoxSelected(false);
                return;
            }
            this.setCheckBoxSelected(true);
        }
    }

    private void setCheckBoxSelected(boolean value) {
        this._chkSelectAll.removeItemListener(this);
        this._chkSelectAll.setSelected(value);
        this._chkSelectAll.addItemListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showColumnImpactAnalysis(boolean flag, Column column) {
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        try {
            ImpactAnalysisOMAView impactanalysisomaview = this.findImpactAnalysisView(column, flag);
            if (impactanalysisomaview != null) {
                WsViewFactory.showExistingView((WsOMAView)impactanalysisomaview);
            } else {
                ImpactAnalysisOMAView impactanalysisomaview1 = new ImpactAnalysisOMAView(column, flag);
                WASplittablePropertyFrame mf = new WASplittablePropertyFrame((CMetadata)column, "");
                if (mf != null) {
                    boolean isCustomdesktopSet = false;
                    JDialog jd = new JDialog();
                    jd.setLayout(new BorderLayout());
                    jd.setBounds(mf.getBounds());
                    jd.setTitle(mf.getTitle());
                    jd.setContentPane(mf.getContentPane());
                    if (Workspace.getWorkspace().getDesktopWindowHandle() == null) {
                        AppDesktop desk = new AppDesktop();
                        desk.setSize(150, 150);
                        Workspace.getWorkspace().setCustomDesktop((CustomDesktop)desk);
                        isCustomdesktopSet = true;
                    }
                    WsViewFactory.attachViewToFrame((CMetadata)column, (WorkspaceOMAView)impactanalysisomaview1, (WAPropertyFrame)mf);
                    mf.setVisible(false);
                    jd.setBounds(400, 400, 450, 350);
                    jd.setModal(true);
                    jd.setVisible(true);
                    mf.close();
                    if (isCustomdesktopSet) {
                        Workspace.getWorkspace().setCustomDesktop(null);
                    }
                }
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        finally {
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private ImpactAnalysisOMAView findImpactAnalysisView(Column column, boolean flag) throws RemoteException {
        ArrayList arraylist = column.getViewList();
        int i = arraylist.size();
        for (int j = 0; j < i; ++j) {
            ImpactAnalysisOMAView impactanalysisomaview;
            if (!arraylist.get(j).getClass().equals(ImpactAnalysisOMAView.class) || (impactanalysisomaview = (ImpactAnalysisOMAView)arraylist.get(j)).isForward() != flag) continue;
            return impactanalysisomaview;
        }
        return null;
    }

    private boolean isAnyColumnIncluded() {
        GroupInstancesInterface gii = this.getSelectedGroup();
        if (gii == null) {
            return false;
        }
        List<ColumnInstance> columns = gii.getIncluded();
        return columns != null && !columns.isEmpty();
    }

    private boolean storeIncludeStatusToModel() {
        try {
            int rowCount = this._tabColumnsFixed.getRowCount();
            for (int row = 0; row < rowCount; ++row) {
                Object idObj;
                int iColObj = this._tabColumnsFixed.getColumnModel().getColumnIndex(COLUMN_OBJECT);
                int iColInc = this._tabColumnsFixed.getColumnModel().getColumnIndex(COLUMN_INCLUDE);
                if (iColInc <= -1 || iColObj <= -1 || !((idObj = this._tabColumnsFixed.getValueAt(row, iColObj)) instanceof ColumnInstance)) continue;
                ColumnInstance colInstance = (ColumnInstance)idObj;
                Object incObj = this._tabColumnsFixed.getValueAt(row, iColInc);
                if (!(incObj instanceof Boolean)) continue;
                Boolean include = (Boolean)incObj;
                colInstance.setExcluded(include == false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this._logger.error(RB.getStringResource("ComparisonTab.excpetion.store.include.status.txt"), (Throwable)e);
            return false;
        }
        return true;
    }

    private void setSelectedColumnName(String columnName) {
        this._lblSelected.setText(Message.format((String)RB.getStringResource("ComparisonTab.selected.column.fmt"), (Object)columnName));
    }

    private int getStringWidth(FontMetrics fontMetrics, String attributeValue) {
        int maxWidth = SwingUtilities.computeStringWidth(fontMetrics, attributeValue);
        return Math.min(200, maxWidth + 10);
    }

    private class ComboTooltipRenderer
    extends DefaultListCellRenderer {
        private ComboTooltipRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JComponent comp = (JComponent)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && value.equals((Object)StandardizationControllerInterface.GroupSortCriteria.NAME)) {
                comp.setToolTipText(RB.getStringResource("ComparisonTab.sort.groups.alphabetically.txt"));
            } else if (value != null && value.equals((Object)StandardizationControllerInterface.GroupSortCriteria.NUMBER)) {
                comp.setToolTipText(RB.getStringResource("ComparisonTab.sort.groups.in.descending.order.by.number.of.member.columns.txt"));
            } else if (value != null && value.equals((Object)StandardizationControllerInterface.GroupSortCriteria.DISPARITY)) {
                comp.setToolTipText(RB.getStringResource("ComparisonTab.sort.groups.in.descending.order.by.level.of.disparity.txt"));
            } else {
                comp.setToolTipText(null);
            }
            return comp;
        }
    }

    private class CSTTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -867734598392201329L;
        private String[] columnNames = new String[0];
        private Object[][] data = new Object[0][0];

        public CSTTableModel(List<ColumnInstance> lstCols) throws CSTException {
            this.initTableData(lstCols);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            Object obj = this.getValueAt(0, c);
            if (obj != null && obj instanceof Boolean) {
                return this.getValueAt(0, c).getClass();
            }
            return super.getColumnClass(c);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            GroupInstancesInterface gii = ComparisonTab.this.getSelectedGroup();
            if (gii != null && !gii.isStandardized()) {
                return COLUMN_INCLUDE.equals(this.getColumnName(col));
            }
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }

        private void initTableData(List<ColumnInstance> lstCols) throws CSTException {
            ComparisonTab.this._logger.debug("initTableData() started");
            LinkedList<String> allColumnNames = new LinkedList<String>();
            allColumnNames.add(ComparisonTab.COLUMN_OBJECT);
            allColumnNames.add(COLUMN_INCLUDE);
            allColumnNames.add(COLUMN_ICON);
            ComparisonTab.this.columnLengths = new HashMap();
            LinkedList allRows = new LinkedList();
            FontMetrics fontMetrics = ComparisonTab.this._tabColumns.getFontMetrics(ComparisonTab.this._tabColumns.getFont());
            for (ColumnInstance colInt : lstCols) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put(ComparisonTab.COLUMN_OBJECT, colInt);
                hashMap.put(COLUMN_INCLUDE, !colInt.excluded());
                boolean isModified = colInt.isValueChanged();
                Icon icon = null;
                icon = colInt.isNumeric() ? WsColumnMetadataUtil.getColumnTypeIcon((String)WsColumnMetadataUtil.getDataNumericType()) : WsColumnMetadataUtil.getColumnTypeIcon((String)WsColumnMetadataUtil.getDataCharacterType());
                if (colInt.isValueChanged()) {
                    icon = ComparisonTab.this._iconFactory.getNewOverlayObjectIcon(icon);
                }
                hashMap.put(COLUMN_ICON, icon);
                List<Attribute> attribs = colInt.getAttributes();
                for (Attribute att : attribs) {
                    String dispVal;
                    String columnName = att.getAttributeName();
                    if (!allColumnNames.contains(columnName)) {
                        allColumnNames.add(columnName);
                    }
                    hashMap.put(columnName, (dispVal = att.getDisplayValue()) != null ? dispVal : "");
                }
                allRows.add(hashMap);
            }
            if (!allColumnNames.isEmpty()) {
                this.columnNames = new String[allColumnNames.size()];
                for (int i = 0; i < allColumnNames.size(); ++i) {
                    this.columnNames[i] = (String)allColumnNames.get(i);
                }
            } else {
                this.columnNames = new String[0];
            }
            if (!allRows.isEmpty()) {
                this.data = new Object[allRows.size()][this.columnNames.length];
                int row = 0;
                for (Map map : allRows) {
                    Set set = map.entrySet();
                    for (Map.Entry entry : set) {
                        String colName = (String)entry.getKey();
                        int size = ComparisonTab.this.getStringWidth(fontMetrics, colName);
                        int index = allColumnNames.indexOf(colName);
                        if (index < 0) continue;
                        this.data[row][index] = entry.getValue();
                        if (ComparisonTab.this.columnLengths.get(colName) != null) {
                            size = (Integer)ComparisonTab.this.columnLengths.get(colName);
                        }
                        ComparisonTab.this.columnLengths.put(colName, Math.max(size, ComparisonTab.this.getStringWidth(fontMetrics, this.data[row][index].toString())));
                    }
                    ++row;
                }
            } else {
                this.data = new Object[0][0];
            }
            ComparisonTab.this._logger.debug("initTableData() completed");
        }
    }

    private class ColumnMouseListener
    extends MouseAdapter {
        private ColumnMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int selectedRow;
            super.mouseClicked(e);
            if (e.getButton() == 1 && e.getClickCount() > 1 && (selectedRow = ComparisonTab.this._tabColumns.getSelectedRow()) > -1) {
                TableColumnModel colModel = ComparisonTab.this._tabColumns.getColumnModel();
                for (int i = 0; i < ComparisonTab.this._tabStdRow.getColumnCount(); ++i) {
                    String colName = ComparisonTab.this._tabStdRow.getColumnName(i);
                    int colIndex = colModel.getColumnIndex(colName);
                    if (colIndex == -1) continue;
                    ComparisonTab.this._tabStdRow.setValueAt(ComparisonTab.this._tabColumns.getValueAt(selectedRow, colIndex), 0, i);
                }
            }
        }
    }

    private class ColumnSelectionListener
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent e) {
            try {
                Object obj;
                int iIDCol;
                int selectedRow = ComparisonTab.this._tabColumnsFixed.getSelectedRow();
                if (selectedRow > -1 && (iIDCol = ComparisonTab.this._tabColumnsFixed.getColumnModel().getColumnIndex(ComparisonTab.COLUMN_OBJECT)) > -1 && (obj = ComparisonTab.this._tabColumnsFixed.getValueAt(selectedRow, iIDCol)) instanceof ColumnInstance) {
                    ColumnInstance ci = (ColumnInstance)obj;
                    ComparisonTab.this.setSelectedColumnName(ci.getColumnName());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    private class ComboBoxEditer
    extends DefaultCellEditor {
        public ComboBoxEditer(List<String> itemList) {
            super(new JComboBox<Object>(itemList.toArray()));
        }
    }
}

