/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.cst.visuals;

import com.sas.metadata.tools.cst.CstUtils;
import com.sas.metadata.tools.cst.visuals.AbstractCSTTab;
import com.sas.metadata.tools.cst.visuals.CSTDataProviderInterface;
import com.sas.metadata.tools.cst.visuals.RB;
import com.sas.metadata.tools.cst.visuals.RuntimeExecutor;
import com.sas.text.Message;
import com.sas.workspace.WAPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.concurrent.TimeoutException;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public abstract class AbstractSummaryTab
extends AbstractCSTTab {
    private JScrollPane _jspSummary;
    private JEditorPane _txpSummary;
    private static final String[] browserName = new String[]{"netscape", "mozilla", "firefox", "opera"};
    private static final String[] m_searchPath = new String[]{"/usr/local/Acrobat5/bin", "/usr/local/netscape7", "/usr/local/bin", "/usr/bin", "/usr/dt/bin", "/opt/firefox"};
    public static final long MAX_VALUE = Long.MAX_VALUE;

    public AbstractSummaryTab(CSTDataProviderInterface dataProvider) {
        super(dataProvider);
    }

    @Override
    protected void initContentPanel() {
        this._logger.debug("Abstract Summary Tab's initContentPanel()started.");
        WAPanel contetnsPanel = this.getContentsPanel();
        this._jspSummary = new JScrollPane();
        this._txpSummary = new JEditorPane();
        this._txpSummary.setEditable(false);
        this._txpSummary.setContentType("text/html");
        contetnsPanel.setLayout((LayoutManager)new BorderLayout());
        this._txpSummary.setText(RB.getStringResource("AbstractSummaryTab.summary.txt"));
        this._jspSummary.setViewportView(this._txpSummary);
        ActivatedHyperlinkListener hyperlinkListener = new ActivatedHyperlinkListener(this._txpSummary);
        this._txpSummary.addHyperlinkListener(hyperlinkListener);
        contetnsPanel.add((Component)this._jspSummary, (Object)"Center");
        this._logger.debug("Abstract Summary Tab's initContentPanel() completed. ");
    }

    protected void setSummary(String summaryText) {
        this._txpSummary.setText(summaryText);
    }

    private class ActivatedHyperlinkListener
    implements HyperlinkListener {
        JEditorPane editorPane;

        public ActivatedHyperlinkListener(JEditorPane editorPane) {
            this.editorPane = editorPane;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            HyperlinkEvent.EventType type = hyperlinkEvent.getEventType();
            if (type != HyperlinkEvent.EventType.ENTERED && type == HyperlinkEvent.EventType.ACTIVATED) {
                URL url = hyperlinkEvent.getURL();
                AbstractSummaryTab.this._logger.debug("User had clicked on Report Link");
                try {
                    if (CstUtils.getOS_Family().equalsIgnoreCase("Windows")) {
                        String fileName = "rundll32 url.dll,FileProtocolHandler " + url;
                        Process process = Runtime.getRuntime().exec(fileName);
                        AbstractSummaryTab.this._logger.info(RB.getStringResource("AbstractSummaryTab.Report.displyed.txt"));
                    } else if (CstUtils.getOS_Family().equalsIgnoreCase("Unix")) {
                        this.LaunchUnix(url);
                    } else if (CstUtils.getOS_Family().equalsIgnoreCase("Macintosh")) {
                        Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                        Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                        openURL.invoke(null, hyperlinkEvent.getURL().toExternalForm());
                    } else {
                        JOptionPane.showMessageDialog(null, Message.format((String)RB.getStringResource("AbstractSummaryTab.info.os.not.supported.fmt"), (Object)CstUtils.getOS_Family()), RB.getStringResource("AbstractSummaryTab.info.os.not.supported.title.txt"), 1);
                        AbstractSummaryTab.this._logger.info(Message.format((String)RB.getStringResource("AbstractSummaryTab.info.os.not.supported.fmt"), (Object)CstUtils.getOS_Family()));
                    }
                }
                catch (Exception e) {
                    AbstractSummaryTab.this._logger.error(RB.getStringResource("AbstractSummaryTab.Exception.Report.txt"), (Throwable)e);
                    JOptionPane.showInputDialog(RB.getStringResource("AbstractSummaryTab.Exception.Report.txt"));
                }
            }
        }

        private void LaunchUnix(URL webPage) throws IOException, TimeoutException {
            Object unixWebBrowser = "";
            for (int i = 0; i < browserName.length; ++i) {
                unixWebBrowser = this.unixSearch(browserName[i]);
            }
            if (unixWebBrowser == null) {
                StringBuffer allBrowserNames = new StringBuffer();
                for (int count = 0; count < browserName.length; ++count) {
                    allBrowserNames.append(" " + browserName[count]);
                }
                RuntimeExecutor r = new RuntimeExecutor(10000L);
                Object[] browserPaths = r.execute(new String[]{"/bin/sh", "-c", "paths=`echo $PATH | tr ':' ' '` ;eval \"for i in " + allBrowserNames.toString() + " ; do for j in $paths ; do if [ -x \\\"\\$j/\\$i\\\" -a ! -d \\\"\\$j/\\$i\\\" ] ; then echo \\\"\\$j/\\$i\\\"; fi; done; done\""});
                AbstractSummaryTab.this._logger.debug("Full list of web browsers returned: " + Arrays.deepToString(browserPaths));
                for (int i = 0; i < browserPaths.length; ++i) {
                    File checkBrowserPath = new File((String)browserPaths[i]);
                    if (checkBrowserPath == null || !checkBrowserPath.exists()) continue;
                    unixWebBrowser = browserPaths[i];
                    break;
                }
            }
            if (unixWebBrowser != null) {
                String command = (String)unixWebBrowser + " " + this.stringReplaceAll(webPage.toString(), " ", "%20");
                this.execute(command.trim(), "", false);
            } else {
                JOptionPane.showMessageDialog(null, Message.format((String)RB.getStringResource("AbstractSummaryTab.info.browser.not.found.fmt"), (Object)CstUtils.getOS_Family()), RB.getStringResource("AbstractSummaryTab.info.browser.not.found.title.txt"), 1);
                AbstractSummaryTab.this._logger.info(Message.format((String)RB.getStringResource("AbstractSummaryTab.info.browser.not.found.fmt"), (Object)CstUtils.getOS_Family()));
            }
        }

        private void execute(String cmdFile, String cmdArgs, boolean wait) {
            this.execute(null, cmdFile, cmdArgs, wait);
        }

        private void execute(String prodCode, String cmdFile, String cmdArgs, boolean wait) {
            String fullCmd = cmdFile;
            if (cmdArgs != null && cmdArgs.length() > 0) {
                fullCmd = fullCmd + " " + cmdArgs;
            }
            try {
                Runtime.getRuntime().exec(fullCmd);
            }
            catch (IOException e) {
                AbstractSummaryTab.this._logger.error(RB.getStringResource("AbstractSummaryTab.Exception.Report.txt"), (Throwable)e);
            }
        }

        private String unixSearch(String program) {
            File test = new File(m_searchPath[0], program);
            int i = 1;
            while (i < m_searchPath.length && test != null && !test.exists()) {
                test = new File(m_searchPath[i++], program);
            }
            if (!test.exists()) {
                return null;
            }
            return test.toString();
        }

        public String stringReplaceAll(String search, String find, String replace) {
            int searchIndex;
            if (replace == null) {
                throw new NullPointerException();
            }
            if (find.length() > 0 && (searchIndex = search.indexOf(find)) >= 0) {
                search = search.substring(0, searchIndex) + replace + this.stringReplaceAll(search.substring(searchIndex + find.length()), find, replace);
            }
            return search;
        }
    }
}

