/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.cst.tests;

import com.sas.metadata.tools.cst.Attribute;
import com.sas.metadata.tools.cst.ColumnInstance;
import com.sas.metadata.tools.cst.GroupInstances;
import com.sas.metadata.tools.cst.GroupInstancesInterface;
import com.sas.metadata.tools.cst.GroupOperationsInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;

public class ColumnInstanceTest
extends TestCase {
    GroupInstancesInterface groupInstances;

    public void setUp() {
        HashMap<String, String> column1 = new HashMap<String, String>();
        column1.put("name", "column1");
        column1.put("format", "BEST5");
        column1.put("informat", "BEST5");
        HashMap<String, String> column2 = new HashMap<String, String>();
        column2.put("name", "column2");
        column2.put("format", "BEST5");
        column2.put("informat", "BEST5");
        HashMap<String, String> column3 = new HashMap<String, String>();
        column3.put("name", "column3");
        column3.put("format", "BEST5");
        column3.put("informat", "BEST5");
        ArrayList<Map<String, String>> columns = new ArrayList<Map<String, String>>();
        columns.add(column1);
        columns.add(column2);
        columns.add(column3);
        this.groupInstances = new GroupInstances("Allcolumns", columns);
    }

    public void testName() {
        HashMap<String, String> column1 = new HashMap<String, String>();
        column1.put("name", "column1");
        column1.put("format", "BEST5");
        column1.put("informat", "BEST5");
        ColumnInstance columnInstance = ColumnInstance.createColumnInstance(column1);
        ColumnInstanceTest.assertEquals((String)columnInstance.getColumnName(), (String)"column1");
    }

    public void testAttributes() {
        HashMap<String, String> column1 = new HashMap<String, String>();
        column1.put("name", "column1");
        column1.put("format", "BEST5");
        column1.put("informat", "BEST5");
        ColumnInstance columnInstance = ColumnInstance.createColumnInstance(column1);
        ColumnInstanceTest.assertEquals((String)columnInstance.getAttributeValue("format"), (String)"BEST5");
        ColumnInstanceTest.assertEquals((String)columnInstance.getAttributeValue("metadatacreated"), null);
        List<Attribute> attributes = columnInstance.getAttributes();
        ColumnInstanceTest.assertEquals((int)attributes.size(), (int)3);
        ColumnInstanceTest.assertEquals((boolean)attributes.contains(new Attribute("name", "column1")), (boolean)true);
        ColumnInstanceTest.assertEquals((boolean)attributes.contains(new Attribute("name1", "column1")), (boolean)false);
    }

    public void testStandardized() {
        GroupOperationsInterface operator = this.groupInstances.getGroupOperator();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute("informat", "BEST6"));
        operator.standardize(attributes);
        ArrayList<ColumnInstance> all = new ArrayList<ColumnInstance>(this.groupInstances.getAll());
        ColumnInstanceTest.assertEquals((String)((ColumnInstance)all.get(0)).getAttributeValue("informat"), (String)"BEST6");
        ColumnInstanceTest.assertEquals((String)((ColumnInstance)all.get(0)).getAttributeValue("name"), (String)"column1");
        ColumnInstanceTest.assertEquals((String)((ColumnInstance)all.get(0)).getAttributeValue("format"), (String)"BEST5");
        ColumnInstanceTest.assertEquals((String)((ColumnInstance)all.get(1)).getAttributeValue("informat"), (String)"BEST6");
        ColumnInstanceTest.assertEquals((String)((ColumnInstance)all.get(2)).getAttributeValue("informat"), (String)"BEST6");
    }

    public void testUpdateCount() {
        Attribute attribute = new Attribute("format", "BEST7");
        Attribute attribute1 = new Attribute("informat", "BEST7");
        ArrayList<Attribute> standard = new ArrayList<Attribute>();
        standard.add(attribute);
        standard.add(attribute1);
        GroupOperationsInterface operaor = this.groupInstances.getGroupOperator();
        operaor.standardize(standard);
        ColumnInstanceTest.assertEquals((int)this.groupInstances.updateCount(), (int)3);
    }
}

