/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.cst;

import com.sas.metadata.tools.cst.Attribute;
import com.sas.metadata.tools.cst.ColumnInstance;
import com.sas.metadata.tools.cst.ControllerFactory;
import com.sas.metadata.tools.cst.GroupInstances;
import com.sas.metadata.tools.cst.GroupInstancesInterface;
import com.sas.metadata.tools.cst.RB;
import com.sas.metadata.tools.cst.Validations;
import com.sas.metadata.tools.cst.tools.Utils;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Validator {
    private Validations validations;
    private List<Attribute> standard;
    private GroupInstancesInterface groupInstances;
    private final ValidatorType vType;
    private final Pattern NUMRIC_FORMAT = Pattern.compile("[^\\$]*\\..*");
    private final Pattern CHAR_FORMAT = Pattern.compile("\\$.*\\..*");
    private Attribute tmpAttr;

    private Validator(List<Attribute> standrds, GroupInstancesInterface groupColumns) {
        this.validations = new Validations();
        this.standard = standrds;
        this.groupInstances = groupColumns;
        this.vType = ValidatorType.STANDARDIZATION;
    }

    private Validator(List<Attribute> standards) {
        this.validations = new Validations();
        this.standard = standards;
        this.vType = ValidatorType.USERINPUT;
    }

    public static Validator getUserInputValidator(List<Attribute> attribsSlected) {
        return new Validator(attribsSlected);
    }

    public static Validator getStandardizationValidator(List<Attribute> standard, GroupInstancesInterface columns) {
        return new Validator(standard, columns);
    }

    Validations validate() {
        String methodNamePrefix = "validate";
        Object methodName = null;
        this.validateSASInformat();
        this.validateSASFormat();
        this.validateSASColumnType();
        this.validateSASColumnLength();
        return this.validations;
    }

    private void invokeMethod(String processMethodName) {
        Method processMethod = null;
        Object result = null;
        Class<?> filterReference = null;
        try {
            filterReference = this.getClass();
            processMethod = filterReference.getDeclaredMethod(processMethodName, new Class[0]);
            processMethod.invoke((Object)this, null);
        }
        catch (NoSuchMethodException exception) {
            exception.printStackTrace();
        }
        catch (IllegalAccessException exception) {
            exception.printStackTrace();
        }
        catch (InvocationTargetException exception) {
            exception.getTargetException().printStackTrace();
        }
    }

    void validateSASFormat() {
        Attribute format = Utils.searchAttribute(this.standard, ControllerFactory.AttributeNames.SASFormat.toString());
        this.tmpAttr = null;
        if (format != null && this.vType == ValidatorType.STANDARDIZATION && !format.getAttributeValue().trim().equals("")) {
            boolean isValid = true;
            Attribute dataType = Utils.searchAttribute(this.standard, ControllerFactory.AttributeNames.SASColumnType.toString());
            if (dataType != null) {
                if (!this.isValidFormat(format.getAttributeValue(), dataType.getAttributeValue())) {
                    this.validations.addError(RB.getStringResource("Validator.invalid.format.txt"), format);
                    isValid = false;
                }
            } else if (!this.isValidFormat(format.getAttributeValue(), "c") && !this.isValidFormat(format.getAttributeValue(), "n")) {
                this.validations.addError(RB.getStringResource("Validator.invalid.format.txt"), format);
                isValid = false;
            }
            if (isValid) {
                Attribute dataT = null;
                boolean isNumericFormat = false;
                if (dataType != null) {
                    dataT = dataType;
                } else {
                    if (this.isNumericFormat(format.getAttributeValue())) {
                        dataT = new Attribute(ControllerFactory.AttributeNames.SASColumnType.toString(), "c");
                        isNumericFormat = true;
                    } else {
                        dataT = new Attribute(ControllerFactory.AttributeNames.SASColumnType.toString(), "n");
                    }
                    if (this.containsDiffDataType(this.groupInstances.getIncluded(), dataT) && this.groupInstances instanceof GroupInstances) {
                        int ncolumnCount = ((GroupInstances)this.groupInstances).getNumericIncludedColumnCount();
                        int ccolumnCount = ((GroupInstances)this.groupInstances).getCharIncludedColumnCount();
                        if (ncolumnCount > 0 && ccolumnCount > 0) {
                            this.tmpAttr = dataT;
                            String type = isNumericFormat ? RB.getStringResource("Validator.type.char.txt") : RB.getStringResource("Validator.type.numeric.txt");
                            this.validations.addWarning(Message.format((String)RB.getStringResource("Validator.group.contains.mixed.type.fmt"), (Object)type), format, dataT);
                        } else {
                            this.validations.addError(RB.getStringResource("Validator.invalid.standard.value.for.format.attribute.according.to.the.type.od.included.columns.in.group.txt"), format);
                        }
                    }
                }
                this.validateBothFormats();
            }
        }
    }

    void validateSASColumnLength() {
        int val = 0;
        int min = 0;
        int max = 0;
        int flag = 0;
        Attribute length = Utils.searchAttribute(this.standard, ControllerFactory.AttributeNames.SASColumnLength.toString());
        Attribute dataType = Utils.searchAttribute(this.standard, ControllerFactory.AttributeNames.SASColumnType.toString());
        if (length != null && this.vType == ValidatorType.STANDARDIZATION && !length.getAttributeValue().trim().equals("")) {
            String value = length.getAttributeValue();
            try {
                val = Integer.parseInt(value.trim());
            }
            catch (NumberFormatException exception) {
                this.validations.addError(RB.getStringResource("Validator.Pls.specify.numeric.value.txt"), length);
            }
            if (dataType != null) {
                flag = 1;
            } else if (this.tmpAttr != null) {
                dataType = this.tmpAttr.getAttributeValue().equals("c") ? new Attribute(ControllerFactory.AttributeNames.SASColumnType.toString(), "n") : new Attribute(ControllerFactory.AttributeNames.SASColumnType.toString(), "c");
                flag = 2;
            } else {
                String Type2 = this.groupInstances.getIncluded().get(0).getAttributeValue(Util.getLabelWithoutMnemonic((String)RB.getStringResource("Attribute.datatype.txt")));
                dataType = Type2.equalsIgnoreCase("n") ? new Attribute(ControllerFactory.AttributeNames.SASColumnType.toString(), "c") : new Attribute(ControllerFactory.AttributeNames.SASColumnType.toString(), "n");
                if (this.containsDiffDataType(this.groupInstances.getIncluded(), dataType)) {
                    dataType = new Attribute(ControllerFactory.AttributeNames.SASColumnType.toString(), "c");
                    flag = 3;
                } else {
                    dataType = Type2.equalsIgnoreCase("n") ? new Attribute(ControllerFactory.AttributeNames.SASColumnType.toString(), "n") : new Attribute(ControllerFactory.AttributeNames.SASColumnType.toString(), "c");
                    flag = 4;
                }
            }
            min = dataType.getMin();
            max = dataType.getMax();
            if (flag == 1 || flag == 4) {
                if (val < min) {
                    this.validations.addWarning(RB.getStringResource("Validator.genric.warnig.modification.of.values.to.fit.in.range.txt"), length, Validations.ErrorWarningType.WARNING_TRUNC_MIN);
                }
                if (val > max) {
                    this.validations.addWarning(RB.getStringResource("Validator.genric.warnig.modification.of.values.to.fit.in.range.txt"), length, Validations.ErrorWarningType.WARNING_TRUNC_MAX);
                }
            }
            if (flag == 2 && (val < min || val > max)) {
                this.validations.addError(RB.getStringResource("Validator.all.columns.will.be.exculded.wrong.length.formatinformat.values.txt"), length);
            }
            if (flag == 3 && (val < min || val > max)) {
                dataType = new Attribute(ControllerFactory.AttributeNames.SASColumnType.toString(), "n");
                this.validations.addWarning(RB.getStringResource("Validator.numeric.columns.will.be.excluded.txt"), length, dataType);
            }
        }
    }

    void validateSASInformat() {
        Attribute format = Utils.searchAttribute(this.standard, ControllerFactory.AttributeNames.SASInformat.toString());
        this.tmpAttr = null;
        if (format != null && this.vType == ValidatorType.STANDARDIZATION && !format.getAttributeValue().trim().equals("")) {
            boolean isValid = true;
            Attribute dataType = Utils.searchAttribute(this.standard, ControllerFactory.AttributeNames.SASColumnType.toString());
            if (dataType != null) {
                if (!this.isValidFormat(format.getAttributeValue(), dataType.getAttributeValue())) {
                    this.validations.addError(RB.getStringResource("Validator.invalid.informat.txt"), format);
                    isValid = false;
                }
            } else if (!this.isValidFormat(format.getAttributeValue(), "c") && !this.isValidFormat(format.getAttributeValue(), "n")) {
                this.validations.addError(RB.getStringResource("Validator.invalid.informat.txt"), format);
                isValid = false;
            }
            if (isValid) {
                Attribute dataT = null;
                boolean isNumericFormat = false;
                if (dataType != null) {
                    dataT = dataType;
                } else {
                    if (this.isNumericFormat(format.getAttributeValue())) {
                        dataT = new Attribute(ControllerFactory.AttributeNames.SASColumnType.toString(), "c");
                        isNumericFormat = true;
                    } else {
                        dataT = new Attribute(ControllerFactory.AttributeNames.SASColumnType.toString(), "n");
                    }
                    if (this.containsDiffDataType(this.groupInstances.getIncluded(), dataT)) {
                        int ncolumnCount = 0;
                        int ccolumnCount = 0;
                        if (this.groupInstances instanceof GroupInstances) {
                            ncolumnCount = ((GroupInstances)this.groupInstances).getNumericIncludedColumnCount();
                            ccolumnCount = ((GroupInstances)this.groupInstances).getCharIncludedColumnCount();
                            if (ncolumnCount > 0 && ccolumnCount > 0) {
                                String type;
                                this.tmpAttr = dataT;
                                String string = type = isNumericFormat ? RB.getStringResource("Validator.type.char.txt") : RB.getStringResource("Validator.type.numeric.txt");
                                if (!this.bothFormatsSlected()) {
                                    this.validations.addWarning(Message.format((String)RB.getStringResource("Validator.group.contains.mixed.type.fmt"), (Object)type), format, dataT);
                                }
                            } else {
                                this.validations.addError(RB.getStringResource("Validator.invalid.standard.value.for.Informat.attribute.according.to.the.type.od.included.columns.in.group.txt"), format);
                            }
                        }
                    }
                }
            }
        }
    }

    private void validateBothFormats() {
        if (this.bothFormatsSlected()) {
            Attribute format = Utils.searchAttribute(this.standard, ControllerFactory.AttributeNames.SASFormat.toString());
            Attribute inFormat = Utils.searchAttribute(this.standard, ControllerFactory.AttributeNames.SASInformat.toString());
            if (this.isNumericFormat(format.getAttributeValue()) && !this.isNumericFormat(inFormat.getAttributeValue()) || !this.isNumericFormat(format.getAttributeValue()) && this.isNumericFormat(inFormat.getAttributeValue())) {
                this.validations.addError(RB.getStringResource("Validator.format.informat.should.match.txt"), format);
            }
        }
    }

    private boolean bothFormatsSlected() {
        Attribute format = Utils.searchAttribute(this.standard, ControllerFactory.AttributeNames.SASFormat.toString());
        if (format != null) {
            Attribute inFormat = Utils.searchAttribute(this.standard, ControllerFactory.AttributeNames.SASInformat.toString());
            return inFormat != null;
        }
        return false;
    }

    private boolean isNumericFormat(String value) {
        Matcher m = this.NUMRIC_FORMAT.matcher(value);
        return m.matches();
    }

    private boolean containsDiffDataType(List<ColumnInstance> columns, Attribute dataType) {
        boolean contains = false;
        List<Attribute> attribs = null;
        for (ColumnInstance instance : columns) {
            Attribute attrib;
            attribs = instance.getAttributes();
            Iterator<Attribute> iterator = attribs.iterator();
            while (iterator.hasNext() && !(contains = (attrib = iterator.next()).equalsWithValue(dataType))) {
            }
            if (!contains) continue;
            break;
        }
        return contains;
    }

    private boolean isValidFormat(String value, String dataType) {
        Pattern regX = null;
        regX = dataType.equalsIgnoreCase("c") ? this.CHAR_FORMAT : this.NUMRIC_FORMAT;
        Matcher m = regX.matcher(value);
        return m.matches();
    }

    public void validateSASColumnType() {
        Attribute attribute = Utils.searchAttribute(this.standard, ControllerFactory.AttributeNames.SASColumnType.toString());
        Attribute dataD = null;
        if (attribute != null) {
            if (ValidatorType.USERINPUT == this.vType) {
                Attribute format = Utils.searchAttribute(this.standard, ControllerFactory.AttributeNames.SASFormat.toString());
                Attribute informat = Utils.searchAttribute(this.standard, ControllerFactory.AttributeNames.SASInformat.toString());
                if (format == null || informat == null) {
                    this.validations.addError(RB.getStringResource("Validator.select.format.informat.with.datatype.txt"), attribute);
                }
            } else {
                dataD = attribute.getAttributeValue().equalsIgnoreCase("c") ? new Attribute(ControllerFactory.AttributeNames.SASColumnType.toString(), "n") : new Attribute(ControllerFactory.AttributeNames.SASColumnType.toString(), "c");
                if (this.containsDiffDataType(this.groupInstances.getIncluded(), dataD)) {
                    this.validations.addWarning(RB.getStringResource("Validator.group.has.diff.datatypes.txt"), attribute);
                }
            }
        }
    }

    void validateDesc() {
    }

    void validateIsNullable() {
    }

    private static enum ValidatorType {
        USERINPUT,
        STANDARDIZATION;

    }
}

