/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.cst;

import com.sas.metadata.tools.cst.Attribute;
import com.sas.metadata.tools.cst.tools.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Validations {
    Map<Attribute, List<ErrorWarning>> validations = new HashMap<Attribute, List<ErrorWarning>>();

    void addWarning(String message, Attribute attribute) {
        List<ErrorWarning> warning = this.getList(attribute, true);
        warning.add(new ErrorWarning(message, ErrorWarningType.WARNING));
    }

    void addWarning(String message, Attribute attribute, ErrorWarningType ewt) {
        List<ErrorWarning> warning = this.getList(attribute, true);
        warning.add(new ErrorWarning(message, ewt));
    }

    void addWarning(String message, Attribute attribute, Attribute associatedAttribute) {
        List<ErrorWarning> warnings = this.getList(attribute, true);
        ErrorWarning warning = new ErrorWarning(message, ErrorWarningType.WARNING);
        warning.setAssociatedAttribute(associatedAttribute);
        warnings.add(warning);
    }

    void addError(String message, Attribute attribute) {
        List<ErrorWarning> warning = this.getList(attribute, true);
        warning.add(new ErrorWarning(message, ErrorWarningType.ERROR));
    }

    public boolean errorWarningPresent() {
        return !Utils.isEmpty(this.validations);
    }

    public boolean errorsPresent() {
        return this.getAllErrorMessages() != null;
    }

    public List<ErrorWarning> getAllWarningMessages() {
        return this.getAllMessages(false);
    }

    public List<ErrorWarning> getAllOperationalWarnings() {
        List<ErrorWarning> allWarnings = this.getAllMessages(false);
        ArrayList<ErrorWarning> warnings = null;
        if (allWarnings != null) {
            warnings = new ArrayList<ErrorWarning>(allWarnings);
            ErrorWarning warning = null;
            for (int index = 0; index < warnings.size(); ++index) {
                warning = (ErrorWarning)warnings.get(index);
                if (warning.getAssociatedAttribute() != null) continue;
                warnings.remove(index);
            }
        }
        return warnings;
    }

    public List<ErrorWarning> getAllErrorMessages() {
        return this.getAllMessages(true);
    }

    public List<ErrorWarning> getErrors(Attribute attribute) {
        return this.getMessageList(attribute, true);
    }

    public List<ErrorWarning> getWarnings(Attribute attribute) {
        return this.getMessageList(attribute, false);
    }

    private List<ErrorWarning> getAllMessages(boolean error) {
        ArrayList<ErrorWarning> allMessages = null;
        if (this.validations != null) {
            Iterator<Attribute> keys = this.validations.keySet().iterator();
            allMessages = new ArrayList<ErrorWarning>();
            while (keys.hasNext()) {
                allMessages.addAll(this.getMessageList(keys.next(), error));
            }
        }
        return !Utils.isEmpty(allMessages) ? allMessages : null;
    }

    private List<ErrorWarning> getMessageList(Attribute attribute, boolean err) {
        ArrayList<ErrorWarning> errors = null;
        List<ErrorWarning> errObject = this.getList(attribute, false);
        if (errObject != null) {
            errors = new ArrayList<ErrorWarning>();
            for (ErrorWarning errWarn : errObject) {
                if (errWarn.isError() && err) {
                    errors.add(errWarn);
                    continue;
                }
                if (errWarn.isError() || err) continue;
                errors.add(errWarn);
            }
        }
        return errors;
    }

    private List<ErrorWarning> getList(Attribute attribute, boolean add) {
        List<ErrorWarning> list = this.validations.get(attribute);
        if (list == null && add) {
            list = new ArrayList<ErrorWarning>();
            this.validations.put(attribute, list);
        }
        return list;
    }

    public class ErrorWarning {
        private String message;
        private ErrorWarningType type;
        private Attribute associatedAttribute;
        private Attribute sourceAttribute;

        private ErrorWarning(String message, ErrorWarningType type) {
            this.message = message;
            this.type = type;
        }

        private void setAssociatedAttribute(Attribute attribute) {
            this.associatedAttribute = attribute;
        }

        private void setSourceAttribute(Attribute attribute) {
            this.sourceAttribute = attribute;
        }

        public Attribute getSourceAttribute() {
            return this.sourceAttribute;
        }

        public String message() {
            return this.message;
        }

        public Attribute getAssociatedAttribute() {
            return this.associatedAttribute;
        }

        boolean isError() {
            return this.type == ErrorWarningType.ERROR;
        }

        public ErrorWarningType getType() {
            return this.type;
        }
    }

    public static enum ErrorWarningType {
        ERROR,
        WARNING,
        WARNING_TRUNC_MIN,
        WARNING_TRUNC_MAX;

    }
}

