/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.cst;

import com.sas.metadata.logical.batch.BatchDriver2;
import com.sas.metadata.tools.cst.RB;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class LoggerWrapper {
    private static Logger _logger;
    private static StringBuffer logFileName;

    public static Logger getLoggerInstance() {
        _logger = LogManager.getLogger(LoggerWrapper.class);
        String logLevel = System.getProperty("cst.log.level");
        Level level = Level.toLevel((String)logLevel, (Level)Level.INFO);
        Configurator.setLevel((Logger)_logger, (Level)level);
        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = lc.getConfiguration();
        PatternLayout layout = PatternLayout.newBuilder().withConfiguration(config).withPattern("%5p - %m%n").build();
        ConsoleAppender consoleAppender = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setName("SASConsoleAppender")).setConfiguration(config)).setLayout((Layout)layout)).build();
        consoleAppender.start();
        config.addAppender((Appender)consoleAppender);
        lc.getLogger(_logger.getName()).addAppender((Appender)consoleAppender);
        logFileName = new StringBuffer();
        String logDir = System.getProperty("cst.log.dir");
        if (logDir == null || logDir.length() <= 0) {
            logDir = BatchDriver2.getDefaultLogDirectory(null, null);
        }
        logFileName.append(logDir);
        String separator = System.getProperty("file.separator");
        if (!logDir.endsWith(separator)) {
            logFileName.append(separator);
        }
        logFileName.append("CST");
        logFileName.append("_");
        logFileName.append(System.currentTimeMillis());
        logFileName.append(".log");
        RollingFileAppender rollingFileAppender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().setConfiguration(config)).setLayout((Layout)layout)).withFileName(logFileName.toString()).setName(RB.getStringResource("LoggerWrapper.appender.name.txt"))).build();
        lc.getLogger(_logger.getName()).addAppender((Appender)rollingFileAppender);
        return _logger;
    }

    public static StringBuffer getLogFileName() {
        return logFileName;
    }
}

