/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.cst;

import com.sas.metadata.tools.cst.Attribute;
import com.sas.metadata.tools.cst.ColumnInstance;
import com.sas.metadata.tools.cst.ControllerFactory;
import com.sas.metadata.tools.cst.GroupInstances;
import com.sas.metadata.tools.cst.GroupInstancesInterface;
import com.sas.metadata.tools.cst.GroupOperationsInterface;
import com.sas.metadata.tools.cst.Validations;
import com.sas.metadata.tools.cst.Validator;
import com.sas.metadata.tools.cst.tools.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class GroupOperations
implements GroupOperationsInterface {
    private GroupInstancesInterface groupInstances;

    GroupOperations(GroupInstancesInterface groupInstances) {
        this.groupInstances = groupInstances;
    }

    @Override
    public boolean rollBack() {
        boolean done = this.groupInstances.isStandardized();
        if (done) {
            this.groupInstances.setStanderdized(false);
        }
        return done;
    }

    @Override
    public void setExcluded(ColumnInstance columnInstance, boolean excluded) {
        List<ColumnInstance> columns = this.groupInstances.getAll();
        if (columns != null) {
            ColumnInstance instance = null;
            ArrayList<ColumnInstance> columnsList = new ArrayList<ColumnInstance>(columns);
            int foundIndex = columnsList.indexOf(columnInstance);
            if (foundIndex != -1) {
                instance = (ColumnInstance)columnsList.get(foundIndex);
                instance.setExcluded(excluded);
            }
        }
    }

    @Override
    public void setExcluded(List<ColumnInstance> columns, boolean excluded) {
        if (columns != null) {
            for (ColumnInstance instance : columns) {
                this.setExcluded(instance, excluded);
            }
        }
    }

    @Override
    public void standardize(List<Attribute> standardAttribs) {
        this.groupInstances.setStandardValues(standardAttribs);
    }

    @Override
    public Validations validate(List<Attribute> standardAttribs) {
        Validator validator = Validator.getStandardizationValidator(standardAttribs, this.groupInstances);
        return validator.validate();
    }

    @Override
    public void excludeColumns(Attribute attribute) {
        List<ColumnInstance> columns = this.groupInstances.getAll();
        for (ColumnInstance column : columns) {
            if (!column.contains(attribute)) continue;
            column.setExcluded(true);
        }
    }

    @Override
    public List<ColumnInstance> sort() {
        List<ColumnInstance> columns = this.groupInstances.getAll();
        Collections.sort(columns, new Comparator<ColumnInstance>(){

            @Override
            public int compare(ColumnInstance c1, ColumnInstance c2) {
                Attribute c1type = Utils.searchAttribute(c1.getAttributes(), ControllerFactory.AttributeNames.SASColumnType.toString());
                Attribute c2type = Utils.searchAttribute(c2.getAttributes(), ControllerFactory.AttributeNames.SASColumnType.toString());
                ((GroupInstances)GroupOperations.this.groupInstances).calculateRank();
                if (c1type.equalsWithValue(c2type)) {
                    return c2.getRank() - c1.getRank();
                }
                if (((GroupInstances)GroupOperations.this.groupInstances).getNumericColumnCount() > ((GroupInstances)GroupOperations.this.groupInstances).getCharColumnCount()) {
                    return c1type.getAttributeValue().equalsIgnoreCase("N") ? -1 : 1;
                }
                return c1type.getAttributeValue().equalsIgnoreCase("C") ? -1 : 1;
            }
        });
        return columns;
    }
}

