/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.cst;

import com.sas.metadata.tools.cst.Attribute;
import com.sas.metadata.tools.cst.CSTException;
import com.sas.metadata.tools.cst.ColumnInstance;
import com.sas.metadata.tools.cst.GroupInstancesInterface;
import com.sas.metadata.tools.cst.GroupOperations;
import com.sas.metadata.tools.cst.GroupOperationsInterface;
import com.sas.metadata.tools.cst.tools.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GroupInstances
implements GroupInstancesInterface {
    private String name;
    private List<ColumnInstance> instances;
    private GroupOperationsInterface operations;
    private List<Attribute> standardValues;
    private int nColumnCount;
    private int cColumnCount;
    private boolean isRankCalculated;
    private boolean isGroupRankCalculated;
    private int groupRank;

    public GroupInstances(String groupName, List<Map<String, String>> instance) {
        if (instance == null) {
            throw new NullPointerException();
        }
        this.name = groupName;
        this.instances = new ArrayList<ColumnInstance>(instance.size());
        ColumnInstance col = null;
        for (Map<String, String> column : instance) {
            col = ColumnInstance.createColumnInstance(column, this);
            this.instances.add(col);
        }
        this.operations = new GroupOperations(this);
    }

    void calculateRank() {
        if (this.isRankCalculated) {
            return;
        }
        ColumnInstance column = null;
        ColumnInstance nextColumn = null;
        int rank = 0;
        for (int index = 0; index < this.instances.size(); ++index) {
            for (int nextIndex = index + 1; nextIndex < this.instances.size(); ++nextIndex) {
                column = this.instances.get(index);
                nextColumn = this.instances.get(nextIndex);
                rank = this.calculateRank(column.getAttributes(), nextColumn.getAttributes());
                column.setRank(rank);
                nextColumn.setRank(rank);
            }
        }
        this.isRankCalculated = true;
    }

    void calculateGroupRank() {
        if (this.isGroupRankCalculated) {
            return;
        }
        int totalRank = 0;
        try {
            for (ColumnInstance instance : this.instances) {
                if (instance.isNumeric()) {
                    ++this.nColumnCount;
                } else {
                    ++this.cColumnCount;
                }
                totalRank += instance.getRank();
            }
        }
        catch (CSTException cSTException) {
            // empty catch block
        }
        int tempCalc = this.nColumnCount > this.cColumnCount ? this.nColumnCount : this.cColumnCount;
        int size = this.instances.size();
        int weightageForOtherAttributes = 70;
        int weightageForColumnType = 30;
        if (size == 1) {
            this.groupRank = 100;
        } else {
            int otherAttributesRank = totalRank * 100 / (size * 11) * weightageForOtherAttributes / 100;
            int columnTypeRank = 100 * (size - tempCalc) / size * weightageForColumnType / 100;
            this.groupRank = otherAttributesRank + columnTypeRank;
        }
        this.isGroupRankCalculated = true;
    }

    int getNumericIncludedColumnCount() {
        int nIncludedColumnCount = 0;
        try {
            for (ColumnInstance instance : this.instances) {
                if (!instance.isNumeric() || instance.excluded()) continue;
                ++nIncludedColumnCount;
            }
        }
        catch (CSTException cSTException) {
            // empty catch block
        }
        return nIncludedColumnCount;
    }

    int getCharIncludedColumnCount() {
        int cIncludedColumnCount = 0;
        try {
            for (ColumnInstance instance : this.instances) {
                if (instance.isNumeric() || instance.excluded()) continue;
                ++cIncludedColumnCount;
            }
        }
        catch (CSTException cSTException) {
            // empty catch block
        }
        return cIncludedColumnCount;
    }

    int getNumericColumnCount() {
        return this.nColumnCount;
    }

    int getCharColumnCount() {
        return this.cColumnCount;
    }

    private int calculateRank(List<Attribute> _1ColAttribs, List<Attribute> _2ColAttribs) {
        int rank = 0;
        Attribute _2colAttrib = null;
        for (Attribute attribute : _1ColAttribs) {
            _2colAttrib = Utils.searchAttribute(_2ColAttribs, attribute);
            if (_2colAttrib == null || !attribute.equalsWithValue(_2colAttrib)) continue;
            ++rank;
        }
        return rank;
    }

    @Override
    public int count() {
        return this.instances.size();
    }

    @Override
    public int excludedCount() {
        int count = 0;
        for (ColumnInstance instance : this.instances) {
            if (!instance.excluded()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int updateCount() {
        List<ColumnInstance> included;
        int updateCount = 0;
        if (this.isStandardized() && (included = this.getIncluded()) != null) {
            List<Attribute> standard = this.getStandardValues();
            for (ColumnInstance column : included) {
                if (Utils.standardEquals(column, standard)) continue;
                ++updateCount;
            }
        }
        return updateCount;
    }

    @Override
    public List<ColumnInstance> getAll() {
        return new ArrayList<ColumnInstance>(this.instances);
    }

    @Override
    public List<ColumnInstance> getExcluded() {
        return this.getList(true);
    }

    private List<ColumnInstance> getList(boolean excluded) {
        ArrayList<ColumnInstance> colInstances = new ArrayList<ColumnInstance>();
        for (ColumnInstance instance : this.instances) {
            if (excluded && instance.excluded()) {
                colInstances.add(instance);
                continue;
            }
            if (excluded || instance.excluded()) continue;
            colInstances.add(instance);
        }
        return colInstances.size() > -1 ? colInstances : null;
    }

    @Override
    public String getGroupIdentifier() {
        return this.name;
    }

    @Override
    public GroupOperationsInterface getGroupOperator() {
        return this.operations;
    }

    @Override
    public List<ColumnInstance> getIncluded() {
        return this.getList(false);
    }

    @Override
    public List<Attribute> getStandardValues() {
        return this.standardValues;
    }

    @Override
    public int includedCount() {
        int count = 0;
        for (ColumnInstance instance : this.instances) {
            if (instance.excluded()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isStandardized() {
        return this.standardValues != null;
    }

    @Override
    public void setStandardValues(List<Attribute> attribs) {
        this.standardValues = new ArrayList<Attribute>(attribs);
    }

    @Override
    public void setStanderdized(boolean val) {
        if (!val) {
            this.standardValues = null;
        }
    }

    int getGroupRank() {
        return this.groupRank;
    }
}

