/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.cst;

import com.sas.metadata.tools.cst.ColumnInstance;
import com.sas.metadata.tools.cst.UserInput;
import com.sas.metadata.tools.cst.tools.Utils;
import com.sas.metadata.tools.cst.tools.XMLNode;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ExceptionalColumns {
    private static File loadFile;
    private UserInput userInput;
    private List<ColumnInstance> columnInstances;
    private boolean instanceToStore = false;

    private ExceptionalColumns(UserInput userInput, boolean instanceFlag) {
        this.userInput = userInput;
        this.instanceToStore = instanceFlag;
    }

    public static ExceptionalColumns getInstanceToStore(UserInput userInput) {
        return new ExceptionalColumns(userInput, true);
    }

    public static ExceptionalColumns getInstanceToView(UserInput userInput) {
        return new ExceptionalColumns(userInput, false);
    }

    public int count() {
        return this.columnInstances != null ? this.columnInstances.size() : -1;
    }

    public boolean excludedExists() throws UnsupportedOperationException {
        if (this.instanceToStore) {
            throw new UnsupportedOperationException();
        }
        return this.columnInstances != null;
    }

    public List<ColumnInstance> getExcludedColumns() {
        return this.columnInstances != null ? new ArrayList<ColumnInstance>(this.columnInstances) : null;
    }

    public void addAll(List<ColumnInstance> excludedColumns) throws UnsupportedOperationException {
        if (!this.instanceToStore) {
            throw new UnsupportedOperationException();
        }
        if (this.columnInstances != null) {
            this.columnInstances.addAll(excludedColumns);
        }
    }

    public void add(ColumnInstance column) {
        if (!this.instanceToStore) {
            throw new UnsupportedOperationException();
        }
        if (this.columnInstances != null) {
            this.columnInstances.add(column);
        }
    }

    public void store() throws UnsupportedOperationException {
        if (!this.instanceToStore) {
            throw new UnsupportedOperationException();
        }
        if (!Utils.isEmpty(this.columnInstances)) {
            XMLNode root = XMLNode.getXMLNode("ExceptionalColumns");
            XMLNode node = Utils.convertUserInputToNode(this.userInput);
            root.addChild(node);
            XMLNode columnNode = null;
            for (ColumnInstance column : this.columnInstances) {
                columnNode = Utils.convertColumnInstanceToNode(column);
                root.addChild(columnNode);
            }
            root.flush(loadFile);
        }
    }

    public void remove(ColumnInstance column) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

