/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.cst;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.tools.cst.Attribute;
import com.sas.metadata.tools.cst.CSTException;
import com.sas.metadata.tools.cst.ColumnFilter;
import com.sas.metadata.tools.cst.ColumnSearchResult;
import com.sas.metadata.tools.cst.IColumnMetadataInterface;
import com.sas.metadata.tools.cst.RB;
import com.sas.metadata.tools.cst.StandardizationController;
import com.sas.metadata.tools.cst.StandardizationControllerInterface;
import com.sas.metadata.tools.cst.UserInput;
import com.sas.metadata.tools.cst.Validations;
import com.sas.metadata.tools.cst.Validator;
import com.sas.metadata.tools.cst.tools.Utils;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ControllerFactory {
    private final List<Attribute> attributes = new ArrayList<Attribute>(7);
    private static final Map<Attribute, List<String>> possibleValues = new HashMap<Attribute, List<String>>(2);
    private static final Map<String, String> possibleDVals = new LinkedHashMap<String, String>(2);
    private static final Map<String, String> possibleNVals = new LinkedHashMap<String, String>(2);
    private final Map<Attribute, Map<String, String>> possibleNDVals = new LinkedHashMap<Attribute, Map<String, String>>(2);
    private static StandardAttributes stAttributes = null;
    private static IColumnMetadataInterface dao;

    private ControllerFactory() throws CSTException {
        this.getAttributes();
        try {
            dao = ColumnFilter.getByWorkSpace();
        }
        catch (MdException exception) {
            throw new CSTException(Message.format((String)RB.getStringResource("ControllerFactory.unable.to.init.connection.fmt"), (Object)exception.getMessage()));
        }
        catch (RemoteException exception) {
            throw new CSTException(Message.format((String)RB.getStringResource("ControllerFactory.unable.to.init.connection.fmt"), (Object)exception.getMessage()));
        }
    }

    private void getAttributes() {
        Attribute attrib = new Attribute(AttributeNames.SASColumnType.toString());
        possibleValues.put(attrib, new ArrayList<String>(possibleDVals.values()));
        this.possibleNDVals.put(attrib, possibleDVals);
        this.attributes.add(attrib);
        attrib = new Attribute(AttributeNames.SASColumnLength.toString());
        this.attributes.add(attrib);
        attrib = new Attribute(AttributeNames.SASFormat.toString());
        this.attributes.add(attrib);
        attrib = new Attribute(AttributeNames.SASInformat.toString());
        this.attributes.add(attrib);
        attrib = new Attribute(AttributeNames.Desc.toString());
        this.attributes.add(attrib);
        attrib = new Attribute(AttributeNames.IsNullable.toString());
        possibleValues.put(attrib, new ArrayList<String>(possibleNVals.values()));
        this.attributes.add(attrib);
        this.possibleNDVals.put(attrib, possibleNVals);
        stAttributes = new StandardAttributes();
    }

    private ControllerFactory(MdFactory mdfact) throws CSTException {
        this.getAttributes();
        try {
            dao = ColumnFilter.getByfactory(mdfact);
        }
        catch (MdException exception) {
            throw new CSTException(RB.getStringResource("ControllerFactory.unable.to.init.connection.fmt") + exception.getMessage());
        }
        catch (RemoteException exception) {
            throw new CSTException(RB.getStringResource("ControllerFactory.unable.to.init.connection.fmt") + exception.getMessage());
        }
    }

    static IColumnMetadataInterface getDAO() {
        return dao;
    }

    public static ControllerFactory getFactoryForUIClients() throws CSTException {
        return new ControllerFactory();
    }

    public static ControllerFactory getFactoryForBatch(MdFactory mdfact) throws CSTException {
        return new ControllerFactory(mdfact);
    }

    public StandardizationControllerInterface getController(UserInput userInput, Locale locale) throws CSTException {
        List<Map<String, String>> columns = null;
        Map<String, List<Map<String, String>>> groupedColumns = null;
        this.getLibrariesPath();
        ColumnSearchResult result = null;
        try {
            if (userInput.isGroupByNameCriteria()) {
                groupedColumns = dao.getGroupbyColumn(userInput);
                result = new ColumnSearchResult(userInput, groupedColumns);
            } else {
                columns = dao.getColumn(userInput);
                result = new ColumnSearchResult(userInput, columns);
            }
        }
        catch (RemoteException exception) {
            throw new CSTException(exception, RB.getStringResource("ControllerFactory.unable.to.fetch.columns.txt"));
        }
        catch (MdException exception) {
            throw new CSTException(exception, RB.getStringResource("ControllerFactory.unable.to.fetch.columns.txt"));
        }
        StandardizationController controller = null;
        if (!Utils.isEmpty(columns) || !Utils.isEmpty(groupedColumns)) {
            controller = locale != null ? new StandardizationController(result, locale) : new StandardizationController(result);
        } else {
            throw new IllegalArgumentException(RB.getStringResource("ControllerFactory.no.column.found.txt"));
        }
        return controller;
    }

    public StandardizationControllerInterface getController(UserInput userInput) throws CSTException {
        return this.getController(userInput, null);
    }

    public Validations validateUserInput(UserInput userInput) {
        Validator validator = Validator.getUserInputValidator(userInput.getAttributes());
        return validator.validate();
    }

    public static StandardAttributes getAttributesToStandardize() {
        return stAttributes;
    }

    public static boolean isEmptyAllowed(Attribute attribute) {
        return ControllerFactory.stAttributes.isEmptyAllowed(attribute);
    }

    public List<String> getLibrariesPath() throws CSTException {
        List<String> libraries = null;
        try {
            libraries = dao.getLibraries();
        }
        catch (RemoteException exception) {
            throw new CSTException(RB.getStringResource("ControllerFactory.unable.to.get.lib.fmt") + exception.getMessage());
        }
        catch (MdException exception) {
            throw new CSTException(RB.getStringResource("ControllerFactory.unable.to.get.lib.fmt") + exception.getMessage());
        }
        return libraries;
    }

    static {
        possibleDVals.put("c", RB.getStringResource("ControllerFactory.char.txt"));
        possibleDVals.put("n", RB.getStringResource("ControllerFactory.numeric.txt"));
        possibleNVals.put("1", RB.getStringResource("ControllerFactory.yes.txt"));
        possibleNVals.put("0", RB.getStringResource("ControllerFactory.no.txt"));
    }

    public static enum AttributeNames {
        SASTableName,
        SASColumnName,
        SASLibraryName,
        SASColumnType,
        SASColumnLength,
        ColumnId,
        SASFormat,
        SASInformat,
        Desc,
        IsNullable;

    }

    public class StandardAttributes {
        public List<Attribute> getAttributes() {
            return ControllerFactory.this.attributes;
        }

        public List<String> getPossibleValues(Attribute attribute) {
            return (List)possibleValues.get(attribute);
        }

        private boolean isEmptyAllowed(Attribute attribute) {
            ArrayList<String> emptyValueAllowingAttributes = new ArrayList<String>();
            emptyValueAllowingAttributes.add(Attribute.getExternalizedAtributeName(AttributeNames.SASFormat.toString()));
            emptyValueAllowingAttributes.add(Attribute.getExternalizedAtributeName(AttributeNames.SASInformat.toString()));
            emptyValueAllowingAttributes.add(Attribute.getExternalizedAtributeName(AttributeNames.Desc.toString()));
            for (String emptyAllowingAttribute : emptyValueAllowingAttributes) {
                if (!attribute.getAttributeName().equals(emptyAllowingAttribute)) continue;
                return true;
            }
            return false;
        }

        public boolean hasPossibleValues(Attribute attribute) {
            return possibleValues.containsKey(attribute);
        }

        String convertToDisplayableValue(Attribute attribute) {
            Map vals;
            String displayValue = null;
            String attribValue = null;
            if (ControllerFactory.this.possibleNDVals.containsKey(attribute) && !(vals = (Map)ControllerFactory.this.possibleNDVals.get(attribute)).containsValue(attribute.getAttributeValue())) {
                attribValue = attribute.getAttributeValue();
                String string = attribValue = attribValue != null ? attribValue.toLowerCase() : null;
                if (vals.containsKey(attribValue)) {
                    displayValue = (String)vals.get(attribValue);
                }
            }
            return displayValue != null ? displayValue : attribute.getAttributeValue();
        }

        void convertToMetadataValue(Attribute attribute) {
            Map vals;
            if (ControllerFactory.this.possibleNDVals.containsKey(attribute) && (vals = (Map)ControllerFactory.this.possibleNDVals.get(attribute)).containsValue(attribute.getAttributeValue())) {
                Set set = vals.entrySet();
                for (Map.Entry entry : set) {
                    if (!((String)entry.getValue()).equalsIgnoreCase(attribute.getAttributeValue())) continue;
                    attribute.setAttributeValue((String)entry.getKey());
                }
            }
        }
    }
}

