/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.cst;

import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.tools.cst.Attribute;
import com.sas.metadata.tools.cst.CSTException;
import com.sas.metadata.tools.cst.ControllerFactory;
import com.sas.metadata.tools.cst.GroupInstancesInterface;
import com.sas.metadata.tools.cst.IColumnMetadataInterface;
import com.sas.metadata.tools.cst.RB;
import com.sas.metadata.tools.cst.tools.Utils;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ColumnInstance {
    private static final String TYPE_NUMERIC = "N";
    private String name;
    private String id;
    private String type;
    private GroupInstancesInterface group;
    private List<Attribute> attributes;
    private boolean excluded;
    private int rank;

    private ColumnInstance(Map<String, String> attribs, GroupInstancesInterface group) {
        this.group = group;
        if (group != null) {
            group.isStandardized();
        }
        this.init(attribs);
    }

    private boolean standardized() {
        return this.group != null && this.group.isStandardized();
    }

    public boolean contains(Attribute attribute) {
        for (Attribute attrib : this.attributes) {
            if (!attrib.equalsWithValue(attribute)) continue;
            return true;
        }
        return false;
    }

    void setRank(int rank) {
        this.rank = rank;
    }

    int getRank() {
        return this.rank;
    }

    public String getAttributeValue(String attributeName) {
        String value = null;
        if (this.standardized()) {
            value = this.getStandardValue(attributeName);
        }
        if (value == null) {
            for (Attribute attrib : this.attributes) {
                if (!attrib.getAttributeName().equals(attributeName)) continue;
                value = attrib.getAttributeValue();
                break;
            }
        }
        return value;
    }

    private String getStandardValue(String attributeName) {
        List<Attribute> attribs;
        int foundIndex;
        String sValue = null;
        if (this.standardized() && (foundIndex = (attribs = this.group.getStandardValues()).indexOf(new Attribute(attributeName, null))) != -1) {
            Attribute attrib = attribs.get(foundIndex);
            sValue = attrib.getAttributeValue();
        }
        return sValue;
    }

    public static ColumnInstance createColumnInstance(Map<String, String> attributes, GroupInstancesInterface group) {
        return new ColumnInstance(attributes, group);
    }

    private void init(Map<String, String> attribs) {
        this.name = attribs.get(ControllerFactory.AttributeNames.SASColumnName.toString());
        this.id = attribs.get(ControllerFactory.AttributeNames.ColumnId.toString());
        this.type = attribs.get(ControllerFactory.AttributeNames.SASColumnType.toString());
        Set<Map.Entry<String, String>> entries = attribs.entrySet();
        this.attributes = new ArrayList<Attribute>(entries.size());
        for (Map.Entry<String, String> entry : entries) {
            this.attributes.add(new Attribute(entry.getKey(), entry.getValue()));
        }
    }

    public static ColumnInstance createColumnInstance(Map<String, String> attributes) {
        return ColumnInstance.createColumnInstance(attributes, null);
    }

    private ColumnInstance() {
    }

    public void addAttribute(Attribute attribute) {
    }

    public List<Attribute> getAttributes() {
        ArrayList<Attribute> attribs = new ArrayList<Attribute>(this.attributes);
        if (!this.excluded && this.standardized()) {
            List<Attribute> standard = this.group.getStandardValues();
            for (Attribute attrib : standard) {
                int foundIndex = attribs.indexOf(attrib);
                if (foundIndex == -1) continue;
                attribs.remove(foundIndex);
                attribs.add(foundIndex, attrib);
            }
        }
        return this.changeOrder(attribs);
    }

    private List<Attribute> changeOrder(List<Attribute> attributes) {
        ArrayList<Attribute> ordered = new ArrayList<Attribute>(attributes.size());
        Attribute attrib = null;
        for (ControllerFactory.AttributeNames attribName : ControllerFactory.AttributeNames.values()) {
            attrib = Utils.searchAttribute(attributes, attribName.toString());
            if (attrib == null) continue;
            ordered.add(attrib);
            attributes.remove(attrib);
        }
        ordered.addAll(attributes);
        return ordered;
    }

    public List<Attribute> getOriginalAttributes() {
        return new ArrayList<Attribute>(this.attributes);
    }

    public boolean excluded() {
        return this.excluded;
    }

    public void setExcluded(boolean exclude) {
        this.excluded = exclude;
    }

    public boolean isNumeric() throws CSTException {
        return TYPE_NUMERIC.equalsIgnoreCase(this.type);
    }

    public boolean isValueChanged() {
        if (!this.excluded()) {
            List<Attribute> standard = this.group.getStandardValues();
            return !Utils.standardEquals(this, standard);
        }
        return false;
    }

    public String getColumnName() {
        return this.name;
    }

    public boolean equals(Object another) {
        if (another == null) {
            return false;
        }
        return another instanceof ColumnInstance && this.id.equals(((ColumnInstance)another).getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String getTableName() {
        return Utils.search(this.attributes, "SASTableName");
    }

    public String getLibararyName() {
        return Utils.search(this.attributes, "SASLibraryName");
    }

    public String getId() {
        return this.id;
    }

    public Column getMetadataColumn() throws CSTException {
        Column column = null;
        try {
            IColumnMetadataInterface dao = ControllerFactory.getDAO();
            column = dao.getMetadataColumn(this.id);
        }
        catch (RemoteException exception) {
            throw new CSTException(Message.format((String)RB.getStringResource("ColumnInstance.unable.to.fetch.column.fmt"), (Object)exception.getMessage()));
        }
        catch (MdException exception) {
            throw new CSTException(Message.format((String)RB.getStringResource("ColumnInstance.unable.to.fetch.column.fmt"), (Object)exception.getMessage()));
        }
        return column;
    }
}

