/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.cst;

import com.sas.metadata.tools.cst.ControllerFactory;
import com.sas.metadata.tools.cst.RB;
import com.sas.metadata.tools.cst.tools.Utils;
import com.sas.swing.visuals.util.Util;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Attribute {
    private static final int CHAR_MAX = Short.MAX_VALUE;
    private static final int CHAR_MIN = 1;
    private static final int NUMERIC_MAX = 8;
    private static final int NUMERIC_MIN = 2;
    private static Map<String, String> mappings = new HashMap<String, String>(10);
    private static Map<String, String> mappingsWithMnemonic = new HashMap<String, String>(10);
    private String attributeName;
    private String attributeValue;
    private List<String> possibleValues;

    public Attribute(String name) {
        this.attributeName = mappings.containsValue(Util.getLabelWithoutMnemonic((String)name)) ? this.reverseSearch(name) : name;
    }

    public Attribute(String name, String value) {
        this(name);
        this.attributeValue = value;
    }

    public Attribute(String name, String value, List<String> possibleValues) {
        this.attributeName = name;
        this.attributeValue = value;
        this.possibleValues = possibleValues;
    }

    public String getAttributeName() {
        String attrib = this.attributeName;
        if (mappings.containsKey(this.attributeName)) {
            attrib = mappings.get(this.attributeName);
        }
        return attrib;
    }

    public static String getExternalizedAtributeName(String attName) {
        String attrib = attName;
        if (mappings.containsKey(attName)) {
            attrib = mappings.get(attName);
        }
        return attrib;
    }

    public int getMnemonic() {
        String attrib = this.attributeName;
        if (mappingsWithMnemonic.containsKey(this.attributeName)) {
            attrib = mappingsWithMnemonic.get(this.attributeName);
        }
        return Util.getDisplayedMnemonic((String)attrib);
    }

    public int getMnemonicIndex() {
        String attrib = this.attributeName;
        if (mappingsWithMnemonic.containsKey(this.attributeName)) {
            attrib = mappingsWithMnemonic.get(this.attributeName);
        }
        return Util.getDisplayedMnemonicIndex((String)attrib);
    }

    public String getLabelWithMnemonic() {
        String attrib = this.attributeName;
        if (mappingsWithMnemonic.containsKey(this.attributeName)) {
            attrib = Util.getLabelWithoutMnemonic((String)mappingsWithMnemonic.get(this.attributeName));
        }
        return attrib;
    }

    public String getMetadataAttributeName() {
        return this.attributeName;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public int getMin() {
        if (this.attributeValue.equalsIgnoreCase("c")) {
            return 1;
        }
        if (this.attributeValue.equalsIgnoreCase("n")) {
            return 2;
        }
        return 0;
    }

    public int getMax() {
        if (this.attributeValue.equalsIgnoreCase("c")) {
            return Short.MAX_VALUE;
        }
        if (this.attributeValue.equalsIgnoreCase("n")) {
            return 8;
        }
        return 0;
    }

    public void setDisplayValue(String value) {
        this.attributeValue = value;
        ControllerFactory.StandardAttributes atts = ControllerFactory.getAttributesToStandardize();
        atts.convertToMetadataValue(this);
    }

    public String getDisplayValue() {
        ControllerFactory.StandardAttributes atts = ControllerFactory.getAttributesToStandardize();
        return atts.convertToDisplayableValue(this);
    }

    public void setAttributeValue(String attributeValue) {
        this.attributeValue = attributeValue;
    }

    public String toString() {
        return this.getAttributeName();
    }

    public int hashCode() {
        return this.attributeName.hashCode();
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (another instanceof Attribute) {
            return this.attributeName.equals(((Attribute)another).getMetadataAttributeName());
        }
        return false;
    }

    public boolean equalsWithValue(Attribute another) {
        boolean equals = false;
        if (another != null) {
            equals = this.attributeName != null && this.attributeName.equals(another.getMetadataAttributeName()) && this.attributeValue != null && this.attributeValue.equalsIgnoreCase(another.getAttributeValue());
        }
        return equals;
    }

    public boolean hasPossibleValues() {
        return Utils.isEmpty(this.possibleValues);
    }

    public List<String> getPossibleValues() {
        return this.possibleValues;
    }

    public boolean isPossibleValueEditable() {
        return true;
    }

    private String reverseSearch(String value) {
        String key = null;
        Iterator<Map.Entry<String, String>> entrySet = mappings.entrySet().iterator();
        Map.Entry<String, String> entry = null;
        while (entrySet.hasNext()) {
            entry = entrySet.next();
            if (!entry.getValue().equals(value)) continue;
            key = entry.getKey();
            break;
        }
        return key;
    }

    static {
        mappingsWithMnemonic.put("SASColumnType", RB.getStringResource("Attribute.datatype.txt"));
        mappingsWithMnemonic.put("SASColumnLength", RB.getStringResource("Attribute.length.txt"));
        mappingsWithMnemonic.put("SASFormat", RB.getStringResource("Attribute.format.txt"));
        mappingsWithMnemonic.put("SASTableName", RB.getStringResource("Attribute.table.name.txt"));
        mappingsWithMnemonic.put("SASInformat", RB.getStringResource("Attribute.informat.txt"));
        mappingsWithMnemonic.put("SASColumnName", RB.getStringResource("Attribute.column.name.txt"));
        mappingsWithMnemonic.put("Desc", RB.getStringResource("Attribute.description.txt"));
        mappingsWithMnemonic.put("SASLibraryName", RB.getStringResource("Attribute.library.name.txt"));
        mappingsWithMnemonic.put("PhysicalTableName", RB.getStringResource("Attribute.table.name.txt"));
        mappingsWithMnemonic.put("IsNullable", RB.getStringResource("Attribute.isnullable.txt"));
        mappingsWithMnemonic.put("ColumnId", RB.getStringResource("Attribute.columnid.txt"));
        mappingsWithMnemonic.put("SummaryRole", RB.getStringResource("Attribute.summaryrole.txt"));
        mappingsWithMnemonic.put("SortOrder", RB.getStringResource("Attribute.sortorder.txt"));
        mappingsWithMnemonic.put("MetadataObjectType", RB.getStringResource("Attribute.metadataobjecttype.txt"));
        mappingsWithMnemonic.put("ExternalTableName", RB.getStringResource("Attribute.etname.txt"));
        mappingsWithMnemonic.put("SchemaName", RB.getStringResource("Attribute.DatabaseSchemaName.txt"));
        mappings.put("SASColumnType", Util.getDisplayLabel((String)RB.getStringResource("Attribute.datatype.txt")));
        mappings.put("SASColumnLength", Util.getDisplayLabel((String)RB.getStringResource("Attribute.length.txt")));
        mappings.put("SASFormat", Util.getDisplayLabel((String)RB.getStringResource("Attribute.format.txt")));
        mappings.put("SASTableName", Util.getDisplayLabel((String)RB.getStringResource("Attribute.table.name.txt")));
        mappings.put("SASInformat", Util.getDisplayLabel((String)RB.getStringResource("Attribute.informat.txt")));
        mappings.put("SASColumnName", Util.getDisplayLabel((String)RB.getStringResource("Attribute.column.name.txt")));
        mappings.put("Desc", Util.getDisplayLabel((String)RB.getStringResource("Attribute.description.txt")));
        mappings.put("SASLibraryName", Util.getDisplayLabel((String)RB.getStringResource("Attribute.library.name.txt")));
        mappings.put("PhysicalTableName", RB.getStringResource("Attribute.table.name.txt"));
        mappings.put("IsNullable", Util.getDisplayLabel((String)RB.getStringResource("Attribute.isnullable.txt")));
        mappings.put("ColumnId", Util.getDisplayLabel((String)RB.getStringResource("Attribute.columnid.txt")));
        mappings.put("SummaryRole", Util.getDisplayLabel((String)RB.getStringResource("Attribute.summaryrole.txt")));
        mappings.put("SortOrder", Util.getDisplayLabel((String)RB.getStringResource("Attribute.sortorder.txt")));
        mappings.put("MetadataObjectType", Util.getDisplayLabel((String)RB.getStringResource("Attribute.metadataobjecttype.txt")));
        mappings.put("SchemaName", RB.getStringResource("Attribute.DatabaseSchemaName.txt"));
        mappings.put("ExternalTableName", RB.getStringResource("Attribute.etname.txt"));
    }
}

