/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.alerts.client;

import java.io.Serializable;
import java.util.BitSet;

public class AlertCondition
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int LT = 1;
    public static final int GT = 2;
    public static final int EQ = 4;
    public static final int NOT = 8;
    public static final int STRING_TYPE = 12;
    public static final int DOUBLE_TYPE = 8;
    private long alertId;
    private String attribute;
    private int operator;
    private String value;
    private int type = 0;
    boolean multipleValues = false;
    boolean notOperator = false;
    private static BitSet bits = new BitSet();

    public AlertCondition() {
        this.setOperator(4);
    }

    public AlertCondition(String attr, Object val) {
        this.setAttribute(attr);
        this.setValue(val);
        this.setOperator(4);
    }

    public AlertCondition(String attr, Object val, int typ) {
        this.setAttribute(attr);
        this.setValue(val);
        this.setType(typ);
        this.setOperator(4);
    }

    public AlertCondition(String attr, int oper, Object val) {
        this.setAttribute(attr);
        this.setOperator(oper);
        this.setValue(val);
    }

    public String getAttribute() {
        return this.attribute;
    }

    public Object getValue() {
        if (0 == this.type || this.type == 12) {
            return this.value;
        }
        if (this.type == 8) {
            try {
                return Double.valueOf(this.value);
            }
            catch (NumberFormatException nfe) {
                return this.value;
            }
        }
        return this.value;
    }

    public final void setAttribute(String attr) {
        this.attribute = attr;
    }

    public final void setValue(Object val) {
        try {
            Double temp = Double.valueOf(String.valueOf(val));
            this.value = String.valueOf(temp);
            this.setType(8);
        }
        catch (NumberFormatException nfe) {
            this.value = String.valueOf(val);
            this.setType(12);
        }
    }

    public String getObjectValue() {
        return this.value;
    }

    public void setObjectValue(Object val) {
        this.setValue(val);
    }

    public int getType() {
        return this.type;
    }

    public final void setType(int typeInt) {
        this.type = typeInt;
    }

    public boolean isComplete() {
        if (null == this.attribute) {
            return false;
        }
        return null != this.value;
    }

    public boolean hasNotOperator() {
        return this.notOperator;
    }

    public int getOperator() {
        return this.operator;
    }

    public final void setOperator(int bitWiseOperator) {
        int i = bitWiseOperator;
        if (i > 0 && i <= bits.size() && bits.get(i)) {
            if (i == 8) {
                i = 12;
            }
            this.operator = i;
            if ((this.operator & 8) > 0) {
                this.notOperator = true;
            }
            return;
        }
        throw new IllegalStateException("Operator value is invalid, '" + i + "'.");
    }

    public long getAlertId() {
        return this.alertId;
    }

    public void setAlertId(long aId) {
        this.alertId = aId;
    }

    public String toString() {
        int stringLength = 256;
        StringBuilder sb = new StringBuilder(256).append("alertId: ").append(this.alertId).append('\n').append("attribute: ").append(this.attribute).append('\n').append("operator: ").append(this.operator).append('\n').append("value: ").append(this.value).append('\n').append("type: ").append(Integer.toString(this.type)).append('\n').append("not: ").append(this.notOperator).append('\n');
        return sb.toString();
    }

    static {
        bits.set(1);
        bits.set(2);
        bits.set(4);
        bits.set(8);
        bits.set(5);
        bits.set(6);
        bits.set(9);
        bits.set(10);
        bits.set(12);
        bits.set(13);
        bits.set(14);
    }
}

