/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkgridmon.client;

import com.sas.tkgridmon.client.CustomCommandUI;
import com.sas.tkgridmon.client.Graph;
import com.sas.tkgridmon.client.LocalMon;
import com.sas.tkgridmon.client.NodeRank;
import com.sas.tkgridmon.client.TKGridMonNode;
import com.sas.tkgridmon.client.TKGridMonProcess;
import com.sas.tkgridmon.client.TKGridMonUser;
import com.sas.tkgridmon.client.UserDataList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;

public class nodeDisplay
extends JComponent {
    private static final long serialVersionUID = 212519296943112131L;
    int[] values;
    int[] meanCPUValues;
    int in = 0;
    int out = 0;
    int freeMem = 0;
    int totalMem = 1;
    int[] cpuHistory;
    int[] inHistory;
    int[] outHistory;
    int[] memHistory;
    int[][] multiCpuHistory;
    Graph cpuGraph;
    JFrame graphWindow;
    JFrame usersWindow;
    JFrame nodeRankWindow;
    JPopupMenu popup;
    JMenuItem menuItem;
    JMenuItem XTermMenuItem;
    HashMap<String, TKGridMonUser> userData = new HashMap();
    UserDataList usersGraph;
    JPanel usersPanel;
    JPanel nodeRankPanel;
    JScrollPane scrollRank;
    private TKGridMonNode data = new TKGridMonNode("", 0, 1);
    int updateNumber = 0;
    private final Object dataLock;
    JComboBox sortArg;
    JScrollPane scroll;
    ArrayList<TKGridMonProcess> ranks;
    boolean fullScale;

    public nodeDisplay(Object dataLock) {
        this.dataLock = dataLock;
        this.graphWindow = new JFrame();
        this.graphWindow.setSize(225, 145);
        this.usersWindow = new JFrame();
        this.fullScale = true;
        this.usersWindow.setMinimumSize(new Dimension(300, 400));
        this.usersGraph = new UserDataList();
        this.usersPanel = new JPanel();
        this.usersPanel.setLayout(new BoxLayout(this.usersPanel, 1));
        this.usersPanel.setBackground(Color.white);
        this.sortArg = new JComboBox<String>(new String[]{"Sort by CPU", "Sort by Username", "Sort by Memory"});
        this.sortArg.setMaximumSize(new Dimension(150, 50));
        this.usersPanel.add(this.usersGraph.getPanel());
        this.usersWindow.add(this.usersPanel);
        this.cpuGraph = new Graph();
        this.graphWindow.setLayout(new BorderLayout(0, 10));
        this.graphWindow.add((Component)this.cpuGraph, "Center");
        this.popup = new JPopupMenu();
        this.menuItem = new JMenuItem("Show History Graph");
        this.menuItem.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!nodeDisplay.this.graphWindow.isVisible()) {
                    nodeDisplay.this.graphWindow.setLocation(100, 100);
                }
                nodeDisplay.this.graphWindow.setVisible(true);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!nodeDisplay.this.graphWindow.isVisible()) {
                    nodeDisplay.this.graphWindow.setLocation(100, 100);
                }
                nodeDisplay.this.graphWindow.setVisible(true);
            }
        });
        this.popup.add(this.menuItem);
        this.menuItem = new JMenuItem("Show User Summary ");
        this.menuItem.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!nodeDisplay.this.graphWindow.isVisible()) {
                    nodeDisplay.this.usersWindow.setLocation(100, 100);
                }
                nodeDisplay.this.usersWindow.setVisible(true);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!nodeDisplay.this.graphWindow.isVisible()) {
                    nodeDisplay.this.usersWindow.setLocation(100, 100);
                }
                nodeDisplay.this.usersWindow.setVisible(true);
            }
        });
        this.XTermMenuItem = new JMenuItem("XTerm", 88);
        this.XTermMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String hostname = "";
                try {
                    InetAddress addr = InetAddress.getLocalHost();
                    hostname = addr.getCanonicalHostName();
                }
                catch (UnknownHostException addr) {
                    // empty catch block
                }
                ArrayList<String> cmds = new ArrayList<String>();
                if (!LocalMon.TKsshPath.equals("")) {
                    if (LocalMon.TKsshPath.contains("sdssas")) {
                        for (int x1 = 0; x1 < LocalMon.TKsshPath.split(" ").length; ++x1) {
                            if (LocalMon.TKsshPath.split(" ")[x1].trim() == "") continue;
                            cmds.add(LocalMon.TKsshPath.split(" ")[x1].trim());
                        }
                    } else {
                        cmds.add(LocalMon.TKsshPath);
                    }
                    cmds.add(LocalMon.gridHost);
                }
                if (File.separatorChar == '/') {
                    cmds.add(LocalMon.gridSSHPath);
                    hostname = System.getenv("DISPLAY");
                } else {
                    cmds.add(LocalMon.gridSSHPath);
                    hostname = hostname + ":0";
                }
                cmds.add(nodeDisplay.this.data.getName());
                cmds.add("xterm -display " + hostname);
                System.out.println(cmds);
                ProcessBuilder pb = new ProcessBuilder(cmds.toArray(new String[cmds.size()]));
                try {
                    pb.start();
                }
                catch (IOException e1) {
                    System.out.println("failed to open xterm");
                    e1.printStackTrace();
                }
            }
        });
        this.popup.add(this.XTermMenuItem);
        this.menuItem = new JMenuItem("Show Ranks on Node ");
        this.menuItem.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!nodeDisplay.this.nodeRankWindow.isVisible()) {
                    nodeDisplay.this.nodeRankWindow.setLocation(100, 100);
                }
                nodeDisplay.this.nodeRankWindow.setVisible(true);
                JFrame dummy = new JFrame();
                dummy.setLocation(-100, 0);
                dummy.setVisible(true);
                dummy.setVisible(false);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }
        });
        this.popup.add(this.menuItem);
        this.menuItem = new JMenuItem("Execute Commands ");
        this.menuItem.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                CustomCommandUI UI = new CustomCommandUI(nodeDisplay.this.getName(), 0, "");
                JFrame commandFrame = new JFrame();
                commandFrame.setTitle("Commands on " + nodeDisplay.this.getName());
                commandFrame.add(UI);
                UI.setframe(commandFrame);
                commandFrame.setMinimumSize(new Dimension(330, 350));
                commandFrame.setLocation(100, 100);
                commandFrame.setVisible(true);
                JFrame dummy = new JFrame();
                dummy.setLocation(-100, 0);
                dummy.setVisible(true);
                dummy.setVisible(false);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }
        });
        this.popup.add(this.menuItem);
        this.setToolTipText("meh");
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
        this.cpuHistory = new int[60];
        this.inHistory = new int[60];
        this.outHistory = new int[60];
        this.memHistory = new int[60];
        this.multiCpuHistory = new int[50][60];
        this.nodeRankWindow = new JFrame();
        this.nodeRankWindow.setSize(400, 200);
        this.nodeRankWindow.setLocation(100, 100);
        JMenu menu = new JMenu("Menu");
        JMenuBar menuBar = new JMenuBar();
        JMenuItem GraphMenuItem = new JMenuItem("Copy to Clipboard", 71);
        GraphMenuItem.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                String data = "Username" + nodeDisplay.this.spaces(20 - "Username".length()) + "Job Name" + nodeDisplay.this.spaces(20 - "Job Name".length()) + "ID" + nodeDisplay.this.spaces(20 - "ID".length()) + "Run Time" + nodeDisplay.this.spaces(20 - "Run Time".length()) + "% CPU" + nodeDisplay.this.spaces(15 - "% CPU".length()) + "% Memory" + nodeDisplay.this.spaces(20 - "% Memory".length()) + "LASR Port" + nodeDisplay.this.spaces(15 - "LASR Port".length()) + "Active" + nodeDisplay.this.spaces(10 - "Active".length()) + "Pending\n\n";
                for (int i = 0; i < nodeDisplay.this.ranks.size(); ++i) {
                    data = data + nodeDisplay.this.ranks.get(i).getUserID().split(":")[0] + nodeDisplay.this.spaces(20 - nodeDisplay.this.ranks.get(i).getUserID().split(":")[0].length()) + nodeDisplay.this.ranks.get(i).getUserID().split(":")[1] + nodeDisplay.this.spaces(20 - nodeDisplay.this.ranks.get(i).getUserID().split(":")[1].length()) + nodeDisplay.this.ranks.get(i).getPid() + nodeDisplay.this.spaces(20 - (nodeDisplay.this.ranks.get(i).getPid() + "").length()) + nodeDisplay.this.ranks.get(i).getRunningTime() + nodeDisplay.this.spaces(20 - nodeDisplay.this.ranks.get(i).getRunningTime().length()) + nodeDisplay.this.ranks.get(i).getCpuUsage() / (double)nodeDisplay.this.ranks.get(i).getCpus() + nodeDisplay.this.spaces(15 - (nodeDisplay.this.ranks.get(i).getCpuUsage() / (double)nodeDisplay.this.ranks.get(i).getCpus() + "").length()) + nodeDisplay.this.ranks.get(i).getMemUsed() / nodeDisplay.this.ranks.get(i).getMemTotal() + nodeDisplay.this.spaces(20 - (nodeDisplay.this.ranks.get(i).getMemUsed() / nodeDisplay.this.ranks.get(i).getMemTotal() + "").length()) + nodeDisplay.this.ranks.get(i).getSnapServerPort() + nodeDisplay.this.spaces(15 - (nodeDisplay.this.ranks.get(i).getSnapServerPort() + "").length()) + nodeDisplay.this.ranks.get((int)i).activeConnections + nodeDisplay.this.spaces(10 - (nodeDisplay.this.ranks.get((int)i).activeConnections + "").length()) + nodeDisplay.this.ranks.get((int)i).pendingConnections + "\n";
                }
                StringSelection selection = new StringSelection(data);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(selection, selection);
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        menu.add(GraphMenuItem);
        JMenu scaling = new JMenu("Scaling");
        final JMenuItem option1 = new JMenuItem("One CPU");
        final JMenuItem option2 = new JMenuItem("Full Node");
        option1.setOpaque(true);
        option2.setOpaque(true);
        option2.setBackground(Color.GRAY);
        option1.setBackground(Color.WHITE);
        option1.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                option1.setBackground(Color.GRAY);
                option2.setBackground(Color.WHITE);
                nodeDisplay.this.fullScale = false;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        scaling.add(option1);
        option2.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                option2.setBackground(Color.GRAY);
                option1.setBackground(Color.WHITE);
                nodeDisplay.this.fullScale = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        scaling.add(option2);
        menu.add(scaling);
        menuBar.add(menu);
        this.nodeRankWindow.setJMenuBar(menuBar);
        this.nodeRankPanel = new JPanel();
        this.nodeRankPanel.setBackground(Color.white);
        this.nodeRankPanel.setSize(500, 800);
        this.scrollRank = new JScrollPane(this.nodeRankPanel);
        this.scrollRank.getVerticalScrollBar().setUnitIncrement(16);
        this.scrollRank.setHorizontalScrollBarPolicy(31);
        this.nodeRankPanel.setAlignmentX(0.0f);
        this.nodeRankPanel.setLayout(new FlowLayout(0));
        this.scrollRank.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent arg0) {
                int a = (nodeDisplay.this.nodeRankPanel.getComponentCount() / ((nodeDisplay.this.nodeRankPanel.getWidth() + 1) / 80) + 1) * 40 + 5;
                if (nodeDisplay.this.nodeRankPanel.getComponentCount() % ((nodeDisplay.this.nodeRankPanel.getWidth() + 1) / 80) == 0) {
                    a -= 46;
                }
                nodeDisplay.this.nodeRankPanel.setPreferredSize(new Dimension(nodeDisplay.this.nodeRankWindow.getWidth() - 25, a));
                nodeDisplay.this.nodeRankPanel.setSize(new Dimension(nodeDisplay.this.nodeRankWindow.getWidth() - 25, a));
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        this.nodeRankWindow.add(this.scrollRank);
        this.nodeRankWindow.setTitle("name");
        this.nodeRankPanel.setName("name");
        int a = (this.nodeRankPanel.getComponentCount() / ((this.nodeRankPanel.getWidth() + 1) / 80) + 1) * 40 + 5;
        if (this.nodeRankPanel.getComponentCount() % ((this.nodeRankPanel.getWidth() + 1) / 80) == 0) {
            a -= 46;
        }
        this.nodeRankPanel.setPreferredSize(new Dimension(this.nodeRankWindow.getWidth() - 25, a));
        this.nodeRankPanel.setSize(new Dimension(this.nodeRankWindow.getWidth() - 25, a));
    }

    public void updateRanks(ArrayList<TKGridMonProcess> ranks) {
        this.nodeRankWindow.setTitle("Ranks on " + this.getName());
        int x = -1;
        Collections.sort(ranks);
        this.ranks = ranks;
        if (ranks != null) {
            for (x = 0; x < ranks.size(); ++x) {
                if (this.nodeRankPanel.getComponentCount() <= x) {
                    this.nodeRankPanel.add(new NodeRank("", 0, "", this));
                }
                String clip = ranks.get(x).getUserID().split(":")[0] + this.spaces(20 - ranks.get(x).getUserID().split(":")[0].length()) + ranks.get(x).getUserID().split(":")[1] + this.spaces(20 - ranks.get(x).getUserID().split(":")[1].length()) + ranks.get(x).getPid() + this.spaces(20 - (ranks.get(x).getPid() + "").length()) + ranks.get(x).getRunningTime() + this.spaces(20 - ranks.get(x).getRunningTime().length()) + ranks.get(x).getCpuUsage() / (double)ranks.get(x).getCpus() + this.spaces(15 - (ranks.get(x).getCpuUsage() / (double)ranks.get(x).getCpus() + "").length()) + ranks.get(x).getMemUsed() / ranks.get(x).getMemTotal() + this.spaces(20 - (ranks.get(x).getMemUsed() / ranks.get(x).getMemTotal() + "").length()) + ranks.get(x).getSnapServerPort() + this.spaces(15 - (ranks.get(x).getSnapServerPort() + "").length()) + ranks.get((int)x).activeConnections + this.spaces(10 - (ranks.get((int)x).activeConnections + "").length()) + ranks.get((int)x).pendingConnections + "\n";
                ((NodeRank)this.nodeRankPanel.getComponent(x)).setNumbers(ranks.get(x).getCpuUsage() / ((double)ranks.get(x).getCpus() * 100.0), ranks.get((int)x).timeLeft, ranks.get((int)x).maxTime, ranks.get(x).getUserID(), ranks.get(x).getRank(), ranks.get(x).getPid(), ranks.get(x).getParentpid(), (double)ranks.get(x).getMemUsed() / (double)ranks.get(x).getMemTotal(), ranks.get(x).getNice(), (double)ranks.get(x).getMemUsed() / 1048576.0, ranks.get(x).getUserID().split(":")[1], clip, ranks.get(x).getJobID(), ranks.get(x).getCpus(), this.fullScale);
            }
        }
        if (x > -1 && this.nodeRankPanel.getComponentCount() > x) {
            this.nodeRankPanel.remove(this.nodeRankPanel.getComponentCount() - 1);
        }
        this.nodeRankPanel.validate();
        this.nodeRankPanel.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNumbers(int[] cpu, int[] meanCPU, int in, int out, int total, int free, TKGridMonNode data) {
        TKGridMonNode tKGridMonNode = this.data;
        synchronized (tKGridMonNode) {
            this.data = data;
            this.values = cpu;
            this.meanCPUValues = meanCPU;
            this.in = in;
            this.out = out;
            this.freeMem = free;
            this.totalMem = total;
            this.graphWindow.setTitle(this.getName() + " CPU History");
            this.usersWindow.setTitle("Users on " + this.getName());
            for (int x = 59; x > 0; --x) {
                this.cpuHistory[x] = this.cpuHistory[x - 1];
                this.inHistory[x] = this.inHistory[x - 1];
                this.outHistory[x] = this.outHistory[x - 1];
                this.memHistory[x] = this.memHistory[x - 1];
                for (int y = 0; y < data.getCpuCount(); ++y) {
                    this.multiCpuHistory[y][x] = this.multiCpuHistory[y][x - 1];
                }
            }
            DecimalFormat xFormat = new DecimalFormat("0.00");
            String toolTip = "<html><font face=\"sansserif\" color=\"black\">";
            int x = 0;
            for (int element : cpu) {
                toolTip = toolTip + "CPU[" + x + "]: " + cpu[x] + "% <br>";
                ++x;
            }
            int dataIn = in * (data.getnetMax() / 100) / 0x100000;
            int dataOut = out * (data.getnetMax() / 100) / 0x100000;
            if (total != 0) {
                toolTip = toolTip + "Net Read (Dark Blue): " + dataIn + "MB/s <br>Net Write (Red): " + dataOut + "MB/s <br>Memory (Light Blue): " + xFormat.format((double)(total - free) / 1048576.0) + " Gb</font></html>";
            }
            this.setToolTipText(toolTip);
            ToolTipManager.sharedInstance().setDismissDelay(1000000);
            this.cpuHistory[0] = 0;
            this.inHistory[0] = 0;
            this.outHistory[0] = 0;
            this.memHistory[0] = 0;
            for (int element : cpu) {
                this.cpuHistory[0] = this.cpuHistory[0] + element;
            }
            this.cpuHistory[0] = this.cpuHistory[0] / cpu.length;
            this.inHistory[0] = in;
            this.outHistory[0] = out;
            this.memHistory[0] = (int)((double)(this.totalMem - this.freeMem) / (double)this.totalMem * 100.0);
            int[] levels = data.getCpuLevels();
            for (int y = 0; y < data.getCpuCount(); ++y) {
                this.multiCpuHistory[y][0] = levels[y];
            }
            this.cpuGraph.setData(this.cpuHistory, this.inHistory, this.outHistory, this.memHistory, this.multiCpuHistory, data.getCpuCount());
            int positionOfBiggest = 0;
            double[] percents = new double[500];
            double[] percentMems = new double[500];
            long[] actualMems = new long[500];
            String[] names = new String[500];
            if (data.getUserInfo() != null) {
                TKGridMonUser[] a = (TKGridMonUser[])data.getUserInfo().clone();
                for (int x1 = 0; x1 < a.length; ++x1) {
                    positionOfBiggest = -1;
                    double bigValue = 0.0;
                    for (int y = 0; y < a.length; ++y) {
                        if (a[y] == null || a[y].getProcesses() == -1) continue;
                        double newValue = 0.0;
                        if (this.sortArg.getSelectedIndex() == 0) {
                            newValue = a[y].getCpuUsage();
                        }
                        if (this.sortArg.getSelectedIndex() == 1) {
                            newValue = this.StringToDouble(a[y].getUserID());
                        }
                        if (this.sortArg.getSelectedIndex() == 2) {
                            newValue = a[y].getMemUsed();
                        }
                        if (positionOfBiggest != -1 && !(newValue > bigValue)) continue;
                        positionOfBiggest = y;
                        bigValue = newValue;
                    }
                    if (positionOfBiggest > -1) {
                        percents[x1] = (double)a[positionOfBiggest].getCpuUsage() / (double)data.getCpuCount();
                        percentMems[x1] = (double)a[positionOfBiggest].getMemUsed() / (double)data.getMemTotal() * 100.0;
                        names[x1] = a[positionOfBiggest].getUserID();
                        actualMems[x1] = a[positionOfBiggest].getMemUsed();
                        a[positionOfBiggest] = null;
                        continue;
                    }
                    percents[x1] = 0.0;
                    percentMems[x1] = 0.0;
                    names[x1] = "";
                    actualMems[x1] = 0L;
                }
            }
        }
    }

    @Override
    public void paint(Graphics G) {
        int top;
        int length;
        int x;
        Graphics2D g = (Graphics2D)G;
        int spacing = 2;
        if (this.values == null) {
            int[] nArray = new int[]{100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100};
        }
        if (this.values.length > 10) {
            spacing = 1;
        }
        spacing = 0;
        double percentMem = (double)(this.totalMem - this.freeMem) / (double)this.totalMem * 100.0;
        int bars = this.values.length + 3;
        int PXperBar = LocalMon.nodeSizeSelection * 2;
        for (x = 0; x < bars - 3; ++x) {
            g.setColor(new Color(0, 255, 0));
            length = (int)((double)this.values[x] / 100.0 * (double)(this.getHeight() - 20));
            top = this.getHeight() - length - 20;
            g.fillRect(spacing + (spacing + PXperBar) * x, top, PXperBar, length);
            g.setColor(new Color(0, 195, 0));
            length = (int)((double)this.meanCPUValues[x] / 100.0 * (double)(this.getHeight() - 20));
            top = this.getHeight() - length - 20;
            g.fillRect(spacing + (spacing + PXperBar) * x, top, PXperBar, length);
        }
        g.setColor(Color.blue);
        length = (int)((double)this.in / 100.0 * (double)(this.getHeight() - 20));
        top = this.getHeight() - length - 20;
        g.fillRect(spacing + (spacing + PXperBar) * x, top, PXperBar, length);
        g.setColor(Color.red);
        length = (int)((double)this.out / 100.0 * (double)(this.getHeight() - 20));
        top = this.getHeight() - length - 20;
        g.fillRect(spacing + (spacing + PXperBar) * ++x, top, PXperBar, length);
        g.setColor(Color.CYAN);
        length = (int)(percentMem / 100.0 * (double)(this.getHeight() - 20));
        top = this.getHeight() - length - 20;
        g.fillRect(spacing + (spacing + PXperBar) * ++x, top, PXperBar, length);
        g.setColor(Color.black);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 20);
        g.setFont(LocalMon.f);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawString(this.getName(), 0, 45);
        this.usersGraph.repaint();
    }

    double StringToDouble(String name) {
        double value = 0.0;
        for (int x = 0; x < name.length(); ++x) {
            value += (double)(name.charAt(x) - 96) / 2.7 * 10.0 / 10.0 * Math.pow(10.0, -2 * x);
        }
        return 1.0 / value;
    }

    String spaces(int n) {
        String x = "";
        for (int y = 0; y < n; ++y) {
            x = x + " ";
        }
        return x;
    }

    class PopupListener
    implements MouseListener {
        PopupListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            nodeDisplay.this.popup.show(e.getComponent(), e.getX(), e.getY());
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

