/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkgridmon.client;

import java.io.Serializable;
import java.text.DecimalFormat;

public class TKGridMonProcess
implements Serializable,
Comparable {
    private static final long serialVersionUID = 2337448321530313136L;
    private final String userID;
    private int rank;
    private int port;
    private double cpuUsage;
    private int pid;
    private int memUsed;
    private int memTotal;
    private String hostName;
    private int cpus;
    int timeLeft;
    int maxTime;
    int parentpid;
    int activeConnections;
    int pendingConnections;
    private int nice;
    private int snapServerPort;
    private int snapStartTime;
    private int snapLastUseTime;
    private int jobID;

    public int getParentpid() {
        return this.parentpid;
    }

    public void setParentpid(int parentpid) {
        this.parentpid = parentpid;
    }

    public int getTimeLeft() {
        return this.timeLeft;
    }

    public void setTimeLeft(int timeLeft) {
        this.timeLeft = timeLeft;
    }

    public int getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(int maxTime) {
        this.maxTime = maxTime;
    }

    public int getCpus() {
        return this.cpus;
    }

    public void setCpus(int cpus) {
        this.cpus = cpus;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public TKGridMonProcess(String userID) {
        this.userID = userID;
    }

    public String getUserID() {
        return this.userID;
    }

    public int getMemUsed() {
        return this.memUsed;
    }

    public int getActiveConnections() {
        return this.activeConnections;
    }

    public void setActiveConnections(int activeConnections) {
        this.activeConnections = activeConnections;
    }

    public int getPendingConnections() {
        return this.pendingConnections;
    }

    public void setPendingConnections(int pendingConnections) {
        this.pendingConnections = pendingConnections;
    }

    protected void setMemUsed(int memUsed) {
        this.memUsed = memUsed;
    }

    public int getMemTotal() {
        return this.memTotal;
    }

    protected void setMemTotal(int memTotal) {
        this.memTotal = memTotal;
    }

    public double getCpuUsage() {
        return this.cpuUsage;
    }

    protected void setCpuUsage(double d) {
        this.cpuUsage = d;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public String toString() {
        return "TKGridMonProcess [cpuUsage=" + this.cpuUsage + ", memTotal=" + this.memTotal + ", memUsed=" + this.memUsed + ", pid=" + this.pid + ", port=" + this.port + ", rank=" + this.rank + ", userID=" + this.userID + "]";
    }

    public int getNice() {
        return this.nice;
    }

    public void setNice(int nice) {
        this.nice = nice;
    }

    public void setSnapServerPort(int snapserverport) {
        this.snapServerPort = snapserverport;
    }

    public void setSnapStartTime(int snapstarttime) {
        this.snapStartTime = snapstarttime;
    }

    public void setSnapLastUseTime(int snaplastusetime) {
        this.snapLastUseTime = snaplastusetime;
    }

    public int getSnapServerPort() {
        return this.snapServerPort;
    }

    public int getSnapStartTime() {
        return this.snapStartTime;
    }

    public int getSnapLastUseTime() {
        return this.snapLastUseTime;
    }

    public void setActiveC(int snapnumactiveconnections) {
        this.activeConnections = snapnumactiveconnections;
    }

    public void setPendingC(int snapnumpendingconnections) {
        this.pendingConnections = snapnumpendingconnections;
    }

    public int compareTo(Object arg0) {
        TKGridMonProcess that = (TKGridMonProcess)arg0;
        if (this.userID.compareTo(that.userID) == 0) {
            if (this.rank > that.rank) {
                return 1;
            }
            if (this.rank == that.rank) {
                return 0;
            }
            return -1;
        }
        if (this.userID.compareTo(that.userID) > 0) {
            return 1;
        }
        return -1;
    }

    public String getRunningTime() {
        DecimalFormat minFormat = new DecimalFormat("00");
        int upsec = this.maxTime - this.timeLeft;
        int min = upsec / 60;
        int sec = upsec % 60;
        int hour = 0;
        int day = 0;
        if (min >= 60) {
            hour = min / 60;
            min %= 60;
        }
        if (hour > 23) {
            day = hour / 24;
            hour %= 24;
        }
        String time = day > 0 ? day + " days, " + hour + ":" + minFormat.format(min) : hour + ":" + minFormat.format(min);
        return time;
    }

    public int getJobID() {
        return this.jobID;
    }

    public void setJobID(int jid) {
        this.jobID = jid;
    }
}

