/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkgridmon.client;

import com.sas.tkgridmon.client.CustomCommandUI;
import com.sas.tkgridmon.client.LocalMon;
import com.sas.tkgridmon.client.nodeDisplay;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class NodeRank
extends JComponent {
    private static final long serialVersionUID = -2231942284994428789L;
    String userName;
    double cpu;
    int timeLeft;
    int totalTime;
    JPopupMenu popup;
    private String hostName;
    private int pid;
    private nodeDisplay Parent;
    int parentPid;
    private double percentMem;
    String popupHost;
    private double usedMem;
    int target;
    String ClipString;
    boolean fullScale;
    String Job;
    private Object jobID;
    private int numCPU;

    public NodeRank(final String username, int p, String job, final nodeDisplay Parent) {
        this.setBackground(Color.white);
        this.userName = username;
        this.Parent = Parent;
        this.pid = p;
        this.Job = job;
        this.setPreferredSize(new Dimension(75, 35));
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
        this.popup = new JPopupMenu();
        this.fullScale = true;
        JMenuItem XTermMenuItem = new JMenuItem("XTerm", 88);
        XTermMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String compAddress = "";
                try {
                    InetAddress addr = InetAddress.getLocalHost();
                    compAddress = addr.getCanonicalHostName();
                }
                catch (UnknownHostException addr) {
                    // empty catch block
                }
                ArrayList<String> cmds = new ArrayList<String>();
                if (!LocalMon.TKsshPath.equals("")) {
                    if (LocalMon.TKsshPath.contains("sdssas")) {
                        for (int x1 = 0; x1 < LocalMon.TKsshPath.split(" ").length; ++x1) {
                            if (LocalMon.TKsshPath.split(" ")[x1].trim() == "") continue;
                            cmds.add(LocalMon.TKsshPath.split(" ")[x1].trim());
                        }
                    } else {
                        cmds.add(LocalMon.TKsshPath);
                    }
                    cmds.add(LocalMon.gridHost);
                }
                if (File.separatorChar == '/') {
                    cmds.add(LocalMon.gridSSHPath);
                    compAddress = System.getenv("DISPLAY");
                } else {
                    cmds.add(LocalMon.gridSSHPath);
                    compAddress = compAddress + ":0";
                }
                cmds.add(Parent.getName());
                cmds.add("export DISPLAY=" + compAddress + "\\; xterm");
                System.out.println(cmds);
                ProcessBuilder pb = new ProcessBuilder(cmds);
                try {
                    pb.start();
                }
                catch (IOException e1) {
                    System.out.println("failed to open xterm");
                    e1.printStackTrace();
                }
            }
        });
        this.popup.add(XTermMenuItem);
        JMenuItem menuItem = new JMenuItem("Kill Rank");
        menuItem.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                int sudo = !NodeRank.this.isRootOrSame(username) ? JOptionPane.showConfirmDialog(null, "Run kill as sudo?", "sudo kill?", 0) : 1;
                ArrayList<String> cmds = new ArrayList<String>();
                if (!LocalMon.TKsshPath.equals("")) {
                    if (LocalMon.TKsshPath.contains("sdssas")) {
                        for (int x1 = 0; x1 < LocalMon.TKsshPath.split(" ").length; ++x1) {
                            if (LocalMon.TKsshPath.split(" ")[x1].trim() == "") continue;
                            cmds.add(LocalMon.TKsshPath.split(" ")[x1].trim());
                        }
                    } else {
                        cmds.add(LocalMon.TKsshPath);
                    }
                    cmds.add(LocalMon.gridHost);
                }
                if (File.separatorChar == '/') {
                    cmds.add(LocalMon.gridSSHPath);
                } else {
                    cmds.add(LocalMon.gridSSHPath);
                }
                cmds.add(LocalMon.gridHost);
                String data = "";
                if (System.getenv().get("GRIDRSHCOMMAND") != "") {
                    data = "\"export GRIDRSHCOMMAND=" + System.getenv().get("GRIDRSHCOMMAND") + "; ";
                }
                if (sudo == 0) {
                    data = data + LocalMon.gridInstall + "/bin/sudokillpid.sh ";
                }
                if (sudo == 1) {
                    data = data + LocalMon.gridInstall + "/bin/killpid.sh ";
                }
                if (!data.contains("killpid")) {
                    return;
                }
                data = data + Parent.getName() + " " + NodeRank.this.pid;
                data = data + "\"";
                cmds.add(data);
                ProcessBuilder pb = new ProcessBuilder(cmds.toArray(new String[cmds.size()]));
                try {
                    pb.start();
                }
                catch (IOException e1) {
                    System.out.println("failed to kill");
                    e1.printStackTrace();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }
        });
        this.popup.add(menuItem);
        menuItem = new JMenuItem("Show in Job View");
        menuItem.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                if (!LocalMon.newJobFrame.isVisible()) {
                    LocalMon.newJobFrame.setVisible(true);
                }
                LocalMon.jobWindow.select(NodeRank.this.target);
            }
        });
        this.popup.add(menuItem);
        menuItem = new JMenuItem("Copy to Clipboard");
        menuItem.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                String data = "Username" + NodeRank.this.spaces(20 - "Username".length()) + "Job Name" + NodeRank.this.spaces(20 - "Job Name".length()) + "ID" + NodeRank.this.spaces(20 - "ID".length()) + "Run Time" + NodeRank.this.spaces(20 - "Run Time".length()) + "% CPU" + NodeRank.this.spaces(15 - "% CPU".length()) + "% Memory" + NodeRank.this.spaces(20 - "% Memory".length()) + "LASR Port" + NodeRank.this.spaces(15 - "LASR Port".length()) + "Active" + NodeRank.this.spaces(10 - "Active".length()) + "Pending\n\n";
                data = data + NodeRank.this.ClipString;
                StringSelection selection = new StringSelection(data);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(selection, selection);
            }
        });
        this.popup.add(menuItem);
        menuItem = new JMenuItem("Execute Commands");
        menuItem.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                CustomCommandUI UI = new CustomCommandUI(NodeRank.this.popupHost, NodeRank.this.pid, username);
                JFrame commandFrame = new JFrame();
                commandFrame.setTitle("Commands on " + NodeRank.this.popupHost + ", pid: " + NodeRank.this.pid);
                commandFrame.add(UI);
                commandFrame.setMinimumSize(new Dimension(330, 300));
                commandFrame.setLocation(100, 100);
                commandFrame.setVisible(true);
                JFrame dummy = new JFrame();
                dummy.setLocation(-100, 0);
                dummy.setVisible(true);
                dummy.setVisible(false);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }
        });
        this.popup.add(menuItem);
    }

    public void setScale(boolean s) {
        this.fullScale = s;
    }

    public void setNumbers(double cpu, int remaining, int total, String userName, int rank, int pid, int parentPid, double percentMem, int nice, double usedMem, String job, String clip, int jID, int cpus, boolean scale) {
        this.cpu = cpu;
        this.fullScale = scale;
        this.ClipString = clip;
        this.numCPU = cpus;
        this.userName = userName.split(":")[0];
        this.Job = job.trim();
        this.pid = pid;
        this.jobID = jID;
        this.timeLeft = remaining;
        this.totalTime = total;
        this.parentPid = parentPid;
        this.percentMem = percentMem;
        this.usedMem = usedMem;
        int min = remaining / 60;
        int sec = remaining % 60;
        int hour = 0;
        int day = 0;
        if (min > 60) {
            hour = min / 60;
            min %= 60;
        }
        if (hour > 23) {
            day = hour / 24;
            hour %= 24;
        }
        String toolTip = "<html><font face=\"sansserif\" color=\"black\">";
        toolTip = toolTip + this.Parent.getName() + "<br>";
        toolTip = toolTip + "CPU (Green): " + (int)(cpu * 100.0) + "%<br>";
        toolTip = toolTip + "Memory (Blue): " + (double)((int)(usedMem * 100.0)) / 100.0 + " Gb<br>";
        toolTip = toolTip + "ID: " + this.jobID + "<br>";
        toolTip = toolTip + "PID: " + pid + "<br>";
        toolTip = toolTip + "Nice: " + nice + "<br>";
        toolTip = day > 0 ? toolTip + "Remaining Time: " + day + " days, " + hour + " hours, " + min + " min, " + sec + " sec</font></html>" : (hour > 0 ? toolTip + "Remaining Time: " + hour + " hours, " + min + " min, " + sec + " sec</font></html>" : toolTip + "Remaining Time: " + min + " min, " + sec + " sec</font></html>");
        this.setToolTipText(toolTip);
        this.repaint();
    }

    @Override
    public void paint(Graphics G) {
        Graphics2D g = (Graphics2D)G;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(LocalMon.f);
        g.setColor(Color.black);
        g.drawRect(0, 0, this.getWidth() - 3, this.getHeight() - 3);
        int width = !this.fullScale ? (int)(this.cpu * (double)this.numCPU * (double)(this.getWidth() - 5)) : (int)(this.cpu * (double)(this.getWidth() - 5));
        g.setColor(Color.green);
        g.fillRect(1, 1, width, (this.getHeight() - 4) / 2);
        g.setColor(Color.cyan);
        width = (int)(this.percentMem * (double)(this.getWidth() - 5));
        g.fillRect(1, (this.getHeight() - 4) / 2, width, (this.getHeight() - 4) / 2);
        g.setColor(Color.orange);
        width = (int)((double)this.timeLeft / (double)this.totalTime * (double)(this.getWidth() - 5));
        g.setColor(Color.black);
        g.drawString(" " + this.userName, 0, (int)((double)this.getHeight() * 0.5));
        String h = this.Job.length() > 10 ? this.Job.substring(0, 8) + ".." : this.Job;
        g.drawString(" " + h, 0, (int)((double)this.getHeight() * 0.8));
    }

    protected boolean isRootOrSame(String targetUserName) {
        targetUserName = targetUserName.trim();
        String userName = System.getenv().get("TKSSH_USER") != null ? System.getenv().get("TKSSH_USER") : (File.separatorChar == '/' ? System.getenv().get("USER") : System.getenv().get("USERNAME"));
        return userName.equals("root") || userName.equals(targetUserName);
    }

    String spaces(int n) {
        String x = "";
        for (int y = 0; y < n; ++y) {
            x = x + " ";
        }
        return x;
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                NodeRank.this.popupHost = ((NodeRank)e.getComponent()).Parent.getName();
                NodeRank.this.popup.show(e.getComponent(), e.getX(), e.getY());
                NodeRank.this.target = ((NodeRank)e.getComponent()).pid;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

