/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.recovery.fs;

import com.atomikos.recovery.PendingTransactionRecord;
import com.atomikos.recovery.TxState;
import com.atomikos.recovery.fs.Repository;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InMemoryRepository
implements Repository {
    private Map<String, PendingTransactionRecord> storage = new ConcurrentHashMap<String, PendingTransactionRecord>();
    private boolean closed = true;

    @Override
    public void init() {
        this.closed = false;
    }

    @Override
    public synchronized void put(String id, PendingTransactionRecord coordinatorLogEntry) throws IllegalArgumentException {
        PendingTransactionRecord existing = this.storage.get(id);
        if (existing != null && existing == coordinatorLogEntry) {
            throw new IllegalArgumentException("cannot put the same coordinatorLogEntry twice");
        }
        if (coordinatorLogEntry.state.isFinalState()) {
            this.storage.remove(id);
        } else {
            this.storage.put(id, coordinatorLogEntry);
        }
    }

    @Override
    public synchronized PendingTransactionRecord get(String coordinatorId) {
        return this.storage.get(coordinatorId);
    }

    @Override
    public synchronized Collection<PendingTransactionRecord> findAllCommittingCoordinatorLogEntries() {
        HashSet<PendingTransactionRecord> res = new HashSet<PendingTransactionRecord>();
        Collection<PendingTransactionRecord> allCoordinatorLogEntry = this.storage.values();
        for (PendingTransactionRecord coordinatorLogEntry : allCoordinatorLogEntry) {
            TxState state = coordinatorLogEntry.state;
            if (state == TxState.COMMITTING) {
                res.add(coordinatorLogEntry);
                continue;
            }
            if (state != TxState.IN_DOUBT || !this.hasCommittingSuperiorCoordnator(coordinatorLogEntry)) continue;
            res.add(coordinatorLogEntry);
        }
        return res;
    }

    private boolean hasCommittingSuperiorCoordnator(PendingTransactionRecord coordinatorLogEntry) {
        if (coordinatorLogEntry.superiorId == null) {
            return false;
        }
        PendingTransactionRecord superiorCoordinator = this.storage.get(coordinatorLogEntry.superiorId);
        if (superiorCoordinator == null) {
            return false;
        }
        if (superiorCoordinator.state == TxState.COMMITTING) {
            return true;
        }
        return this.hasCommittingSuperiorCoordnator(superiorCoordinator);
    }

    @Override
    public void close() {
        this.storage.clear();
        this.closed = true;
    }

    @Override
    public Collection<PendingTransactionRecord> getAllCoordinatorLogEntries() {
        return this.storage.values();
    }

    @Override
    public void writeCheckpoint(Collection<PendingTransactionRecord> checkpointContent) {
        this.storage.clear();
        for (PendingTransactionRecord coordinatorLogEntry : checkpointContent) {
            this.storage.put(coordinatorLogEntry.id, coordinatorLogEntry);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }
}

