/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RecoveryCoordinator;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TimeoutException;
import com.atomikos.icatch.imp.CompositeTransactionImp;
import com.atomikos.icatch.imp.TransactionStateHandler;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.recovery.TxState;

class TxRollbackOnlyStateHandler
extends TransactionStateHandler {
    private static final Logger LOGGER = LoggerFactory.createLogger(TxRollbackOnlyStateHandler.class);

    protected TxRollbackOnlyStateHandler(CompositeTransactionImp ct, TransactionStateHandler handler) {
        super(ct, handler);
    }

    @Override
    protected RecoveryCoordinator addParticipant(Participant participant) throws SysException, IllegalStateException {
        try {
            participant.rollback();
        }
        catch (Exception ignore) {
            LOGGER.logTrace("Ignoring exception on participant rollback", (Throwable)ignore);
        }
        return this.getCT().getCoordinatorImp();
    }

    @Override
    protected CompositeTransaction createSubTransaction() throws SysException, IllegalStateException {
        throw new IllegalStateException("Transaction is marked for rollback");
    }

    @Override
    protected void commit() throws SysException, IllegalStateException, RollbackException {
        this.rollbackWithStateCheck();
        if (this.getCT().getCoordinatorImp().hasTimedOut()) {
            throw new TimeoutException("Rollback after timeout");
        }
        throw new RollbackException("Transaction set to rollback only");
    }

    @Override
    protected TxState getState() {
        return TxState.MARKED_ABORT;
    }
}

