/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.event.Event;
import com.atomikos.icatch.event.recovery.RecoveryEndedEvent;
import com.atomikos.icatch.event.recovery.RecoveryFailedEvent;
import com.atomikos.icatch.event.recovery.RecoveryStartedEvent;
import com.atomikos.icatch.event.transaction.TransactionHeuristicEvent;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.publish.EventPublisher;
import com.atomikos.recovery.PendingTransactionRecord;
import com.atomikos.recovery.RecoveryLog;
import com.atomikos.recovery.TxState;
import com.atomikos.thread.TaskManager;
import com.atomikos.timing.AlarmTimer;
import com.atomikos.timing.AlarmTimerListener;
import com.atomikos.timing.PooledAlarmTimer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class RecoveryDomainService {
    private static final Logger LOGGER = LoggerFactory.createLogger(RecoveryDomainService.class);
    private RecoveryLog recoveryLog;
    private boolean stopped;
    private long maxTimeout;
    private PooledAlarmTimer recoveryTimer;
    private String recoveryDomainName;

    public RecoveryDomainService(RecoveryLog recoveryLog) {
        this.recoveryLog = recoveryLog;
    }

    public void init() {
        long recoveryDelay = Configuration.getConfigProperties().getRecoveryDelay();
        this.setMaxTimeout(Configuration.getConfigProperties().getMaxTimeout());
        this.recoveryDomainName = Configuration.getConfigProperties().getTmUniqueName();
        this.recoveryTimer = new PooledAlarmTimer(recoveryDelay);
        this.recoveryTimer.addAlarmTimerListener(new AlarmTimerListener(){

            public void alarm(AlarmTimer timer) {
                RecoveryDomainService.this.performRecovery();
            }
        });
        TaskManager.SINGLETON.executeTask((Runnable)this.recoveryTimer);
    }

    public void setMaxTimeout(long maxTimeout) {
        this.maxTimeout = maxTimeout;
    }

    protected synchronized boolean performRecovery() {
        boolean perform;
        boolean bl = perform = !this.stopped && this.recoveryLog.isActive();
        if (perform) {
            try {
                boolean allOk = true;
                long startOfRecovery = System.currentTimeMillis();
                Set<RecoverableResource> resourcesToRecover = this.getResourcesForRecovery();
                Collection indoubtCoordinators = this.recoveryLog.getIndoubtTransactionRecords();
                Collection<PendingTransactionRecord> foreignIndoubtCoordinators = this.extractForeignRecords(indoubtCoordinators);
                Collection<PendingTransactionRecord> foreignCoordinatorsForHeuristicAbort = this.extractForeignIndoubtCoordinatorsForHeuristicAbort(foreignIndoubtCoordinators, startOfRecovery);
                Collection expiredCommittingCoordinators = this.recoveryLog.getExpiredPendingCommittingTransactionRecordsAt(startOfRecovery);
                EventPublisher.INSTANCE.publish((Event)new RecoveryStartedEvent(startOfRecovery));
                for (RecoverableResource recoverableResource : resourcesToRecover) {
                    try {
                        boolean resourceOk = recoverableResource.recover(startOfRecovery, expiredCommittingCoordinators, foreignIndoubtCoordinators);
                        if (!resourceOk) {
                            EventPublisher.INSTANCE.publish((Event)new RecoveryFailedEvent(recoverableResource.getName()));
                        }
                        allOk = allOk && resourceOk;
                    }
                    catch (Throwable e) {
                        allOk = false;
                        LOGGER.logError(e.getMessage(), e);
                    }
                }
                HashSet<PendingTransactionRecord> recordsToDelete = new HashSet<PendingTransactionRecord>();
                if (allOk) {
                    recordsToDelete.addAll(expiredCommittingCoordinators);
                    Collection<PendingTransactionRecord> expiredNativeIndoubtCoordinators = this.extractNativeIndoubtCoordinatorsExpiredSince(startOfRecovery - this.maxTimeout, indoubtCoordinators);
                    recordsToDelete.addAll(expiredNativeIndoubtCoordinators);
                }
                recordsToDelete.addAll(foreignCoordinatorsForHeuristicAbort);
                this.recoveryLog.forgetTransactionRecords(recordsToDelete);
                EventPublisher.INSTANCE.publish((Event)new RecoveryEndedEvent(allOk, startOfRecovery));
            }
            catch (Throwable e) {
                LOGGER.logError(e.getMessage(), e);
            }
        }
        return perform;
    }

    private Collection<PendingTransactionRecord> extractNativeIndoubtCoordinatorsExpiredSince(long momentInThePast, Collection<PendingTransactionRecord> collection) {
        return PendingTransactionRecord.collectLineages(r -> r.isLocalRoot(this.recoveryDomainName) && !r.isForeignInDomain(this.recoveryDomainName) && r.expires < momentInThePast && r.state == TxState.IN_DOUBT, collection);
    }

    private Collection<PendingTransactionRecord> extractForeignRecords(Collection<PendingTransactionRecord> collection) {
        return PendingTransactionRecord.collectLineages(r -> r.isForeignInDomain(this.recoveryDomainName), collection);
    }

    private Collection<PendingTransactionRecord> extractForeignIndoubtCoordinatorsForHeuristicAbort(Collection<PendingTransactionRecord> foreignIndoubtCoordinators, long startOfRecovery) {
        HashSet<PendingTransactionRecord> ret = new HashSet<PendingTransactionRecord>();
        for (PendingTransactionRecord record : foreignIndoubtCoordinators) {
            if (record.expires + this.maxTimeout < startOfRecovery) {
                if (record.allowsHeuristicTermination(this.recoveryDomainName)) {
                    ret.add(record);
                } else {
                    TransactionHeuristicEvent event = new TransactionHeuristicEvent(record.id, record.superiorId, TxState.IN_DOUBT);
                    EventPublisher.INSTANCE.publish((Event)event);
                }
            }
            for (PendingTransactionRecord entry : ret) {
                foreignIndoubtCoordinators.remove(entry);
                PendingTransactionRecord.removeAllDescendants((PendingTransactionRecord)entry, foreignIndoubtCoordinators);
                TransactionHeuristicEvent event = new TransactionHeuristicEvent(record.id, record.superiorId, TxState.HEUR_ABORTED);
                EventPublisher.INSTANCE.publish((Event)event);
            }
        }
        return ret;
    }

    private Set<RecoverableResource> getResourcesForRecovery() {
        Collection resources = null;
        resources = Configuration.getResources();
        return this.filterDuplicates(resources);
    }

    private Set<RecoverableResource> filterDuplicates(Collection<RecoverableResource> resources) {
        return new HashSet<RecoverableResource>(resources);
    }

    public synchronized void stop() {
        if (this.recoveryTimer != null) {
            this.recoveryTimer.stopTimer();
            this.recoveryTimer = null;
        }
        this.stopped = true;
    }

    public synchronized boolean hasPendingParticipantsFromLastRecoveryScan() {
        if (!this.recoveryLog.isActive()) {
            return false;
        }
        for (RecoverableResource res : this.getResourcesForRecovery()) {
            if (!res.hasPendingParticipantsFromLastRecoveryScan()) continue;
            return true;
        }
        return false;
    }
}

