/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.RecoveryService;
import com.atomikos.icatch.event.Event;
import com.atomikos.icatch.event.EventListener;
import com.atomikos.icatch.event.recovery.RecoveryFailedEvent;
import com.atomikos.icatch.event.transaction.ParticipantHeuristicEvent;
import com.atomikos.icatch.event.transaction.TransactionAbandonedEvent;
import com.atomikos.icatch.event.transaction.TransactionHeuristicEvent;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.publish.EventPublisher;
import com.atomikos.recovery.RecoveryLog;

class EventBasedRecoveryService
implements RecoveryService,
EventListener {
    private static final Logger LOGGER = LoggerFactory.createLogger(EventBasedRecoveryService.class);
    private RecoveryService delegate;
    private boolean recoveryNeeded;

    EventBasedRecoveryService(RecoveryService delegate) {
        this.delegate = delegate;
        EventPublisher.INSTANCE.registerEventListener((EventListener)this);
    }

    public String getName() {
        return this.delegate.getName();
    }

    public RecoveryLog getRecoveryLog() {
        return this.delegate.getRecoveryLog();
    }

    public boolean performRecovery() {
        return this.delegate.performRecovery();
    }

    public boolean performRecovery(boolean lax) {
        boolean ret = false;
        if (!lax || this.getAndClearRecoveryFlag()) {
            ret = this.performRecovery();
        }
        return ret;
    }

    private synchronized void setRecoveryFlag() {
        this.recoveryNeeded = true;
    }

    synchronized boolean getAndClearRecoveryFlag() {
        boolean ret = this.recoveryNeeded;
        this.recoveryNeeded = false;
        return ret;
    }

    private void triggerRecovery(Event e) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(e + " - triggering recovery...");
        }
        this.setRecoveryFlag();
    }

    public void eventOccurred(Event event) {
        if (event instanceof TransactionAbandonedEvent || event instanceof TransactionHeuristicEvent || event instanceof ParticipantHeuristicEvent || event instanceof RecoveryFailedEvent) {
            this.triggerRecovery(event);
        }
    }
}

