/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.scheduling.client.proxy;

import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.model.DirectoryInfo;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FlowHistory;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.JobRendererInfo;
import com.sas.scheduler.model.PreferenceInfo;
import com.sas.scheduler.model.RunHistory;
import com.sas.scheduler.model.SASFolder;
import com.sas.scheduler.model.ScheduledFlowInfo;
import com.sas.scheduler.model.SchedulerResultSet;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.model.TriggerEventInfo;
import com.sas.scheduler.model.lsf.JFJob;
import com.sas.svcs.commons.webservice.client.ProxyHelperException;
import com.sas.svcs.commons.webservice.client.ProxyHelperHttpInvokerHolder;
import com.sas.svcs.commons.webservice.client.ProxyHelperNew;
import com.sas.svcs.commons.webservice.client.SecurityTokenServiceClient;
import com.sas.svcs.commons.webservice.client.ServiceRegistryClient;
import com.sas.svcs.scheduling.client.SchedulingExceptionHolder;
import com.sas.svcs.scheduling.client.SchedulingServiceInterface;
import com.sas.svcs.scheduling.client.types.ConnectToSchedulingServer2Parameters;
import com.sas.svcs.scheduling.client.types.ConnectToSchedulingServer2Response;
import com.sas.svcs.scheduling.client.types.ConnectToSchedulingServerParameters;
import com.sas.svcs.scheduling.client.types.ConnectToSchedulingServerResponse;
import com.sas.svcs.scheduling.client.types.CreateDataStepDeployedJobParameters;
import com.sas.svcs.scheduling.client.types.CreateDataStepDeployedJobResponse;
import com.sas.svcs.scheduling.client.types.CreateDeployedJob2Parameters;
import com.sas.svcs.scheduling.client.types.CreateDeployedJob2Response;
import com.sas.svcs.scheduling.client.types.CreateDeployedJobParameters;
import com.sas.svcs.scheduling.client.types.CreateDeployedJobResponse;
import com.sas.svcs.scheduling.client.types.CreateFlowParameters;
import com.sas.svcs.scheduling.client.types.CreateFlowParameters2;
import com.sas.svcs.scheduling.client.types.CreateFlowResponse;
import com.sas.svcs.scheduling.client.types.DeleteDeployedJobParameters;
import com.sas.svcs.scheduling.client.types.DeleteFlowParameters;
import com.sas.svcs.scheduling.client.types.DisconnectFromSchedulingServerParameters;
import com.sas.svcs.scheduling.client.types.GetAllDeployedJobsAndFlowsParameters;
import com.sas.svcs.scheduling.client.types.GetAllDeployedJobsAndFlowsResponse;
import com.sas.svcs.scheduling.client.types.GetBatchServersParameters;
import com.sas.svcs.scheduling.client.types.GetBatchServersResponse;
import com.sas.svcs.scheduling.client.types.GetDeployedJobsForFlowParameters;
import com.sas.svcs.scheduling.client.types.GetDeployedJobsForFlowResponse;
import com.sas.svcs.scheduling.client.types.GetDeployedJobsInFlowParameters;
import com.sas.svcs.scheduling.client.types.GetDeployedJobsInFlowResponse;
import com.sas.svcs.scheduling.client.types.GetDeployedJobsNotInFlowParameters;
import com.sas.svcs.scheduling.client.types.GetDeployedJobsNotInFlowResponse;
import com.sas.svcs.scheduling.client.types.GetDeployedJobsParameters;
import com.sas.svcs.scheduling.client.types.GetDeployedJobsResponse;
import com.sas.svcs.scheduling.client.types.GetFlowByNameParameters;
import com.sas.svcs.scheduling.client.types.GetFlowByNameResponse;
import com.sas.svcs.scheduling.client.types.GetFlowDataParameters;
import com.sas.svcs.scheduling.client.types.GetFlowDataResponse;
import com.sas.svcs.scheduling.client.types.GetFlowDefinitionBySchedulerParameters;
import com.sas.svcs.scheduling.client.types.GetFlowDefinitionBySchedulerResponse;
import com.sas.svcs.scheduling.client.types.GetFlowEventDisplayNameParameters;
import com.sas.svcs.scheduling.client.types.GetFlowEventDisplayNameResponse;
import com.sas.svcs.scheduling.client.types.GetFlowHistoryBySchedulerParameters;
import com.sas.svcs.scheduling.client.types.GetFlowHistoryParameters;
import com.sas.svcs.scheduling.client.types.GetFlowHistoryResponse;
import com.sas.svcs.scheduling.client.types.GetFlowInfoParameters;
import com.sas.svcs.scheduling.client.types.GetFlowInfoResponse;
import com.sas.svcs.scheduling.client.types.GetFlowsByPartyParameters;
import com.sas.svcs.scheduling.client.types.GetFlowsByPartyResponse;
import com.sas.svcs.scheduling.client.types.GetFlowsParameters;
import com.sas.svcs.scheduling.client.types.GetFlowsResponse;
import com.sas.svcs.scheduling.client.types.GetHolidaysParameters;
import com.sas.svcs.scheduling.client.types.GetHolidaysResponse;
import com.sas.svcs.scheduling.client.types.GetJCLTemplateParameters;
import com.sas.svcs.scheduling.client.types.GetJCLTemplateResponse;
import com.sas.svcs.scheduling.client.types.GetJobInfoParameters;
import com.sas.svcs.scheduling.client.types.GetJobInfoResponse;
import com.sas.svcs.scheduling.client.types.GetJobRenderersParameters;
import com.sas.svcs.scheduling.client.types.GetJobRenderersResponse;
import com.sas.svcs.scheduling.client.types.GetLSFJobFromPlatformPMParameters;
import com.sas.svcs.scheduling.client.types.GetLSFJobFromPlatformPMResponse;
import com.sas.svcs.scheduling.client.types.GetMessageQueuesParameters;
import com.sas.svcs.scheduling.client.types.GetMessageQueuesResponse;
import com.sas.svcs.scheduling.client.types.GetMessagesParameters;
import com.sas.svcs.scheduling.client.types.GetMessagesResponse;
import com.sas.svcs.scheduling.client.types.GetNextScheduledDatesParameters;
import com.sas.svcs.scheduling.client.types.GetNextScheduledDatesResponse;
import com.sas.svcs.scheduling.client.types.GetOutagesParameters;
import com.sas.svcs.scheduling.client.types.GetOutagesResponse;
import com.sas.svcs.scheduling.client.types.GetPreferenceParameters;
import com.sas.svcs.scheduling.client.types.GetPreferenceResponse;
import com.sas.svcs.scheduling.client.types.GetRunningJobsBySchedulerParameters;
import com.sas.svcs.scheduling.client.types.GetRunningJobsResponse;
import com.sas.svcs.scheduling.client.types.GetScheduledFlowsBySchedulerParameters;
import com.sas.svcs.scheduling.client.types.GetScheduledFlowsBySchedulerResponse;
import com.sas.svcs.scheduling.client.types.GetScheduledFlowsParameters;
import com.sas.svcs.scheduling.client.types.GetScheduledFlowsResponse;
import com.sas.svcs.scheduling.client.types.GetSchedulingServersParameters;
import com.sas.svcs.scheduling.client.types.GetSchedulingServersResponse;
import com.sas.svcs.scheduling.client.types.GetStandardErrorParameters;
import com.sas.svcs.scheduling.client.types.GetStandardErrorResponse;
import com.sas.svcs.scheduling.client.types.GetStandardOutputParameters;
import com.sas.svcs.scheduling.client.types.GetStandardOutputResponse;
import com.sas.svcs.scheduling.client.types.HoldFlowParameters;
import com.sas.svcs.scheduling.client.types.HoldFlowResponse;
import com.sas.svcs.scheduling.client.types.IsValidBatchServerParameters;
import com.sas.svcs.scheduling.client.types.IsValidBatchServerResponse;
import com.sas.svcs.scheduling.client.types.IsValidSchedulerParameters;
import com.sas.svcs.scheduling.client.types.IsValidSchedulerResponse;
import com.sas.svcs.scheduling.client.types.KillFlowInstanceParameters;
import com.sas.svcs.scheduling.client.types.KillFlowInstanceResponse;
import com.sas.svcs.scheduling.client.types.KillItemInstanceParameters;
import com.sas.svcs.scheduling.client.types.KillItemInstanceResponse;
import com.sas.svcs.scheduling.client.types.MapType;
import com.sas.svcs.scheduling.client.types.ObjectFactory;
import com.sas.svcs.scheduling.client.types.PauseFlowInstanceParameters;
import com.sas.svcs.scheduling.client.types.PauseFlowInstanceResponse;
import com.sas.svcs.scheduling.client.types.ReleaseFlowParameters;
import com.sas.svcs.scheduling.client.types.ReleaseFlowResponse;
import com.sas.svcs.scheduling.client.types.RescheduleFlowParameters;
import com.sas.svcs.scheduling.client.types.RescheduleFlowResponse;
import com.sas.svcs.scheduling.client.types.ResumeFlowInstanceParameters;
import com.sas.svcs.scheduling.client.types.ResumeFlowInstanceResponse;
import com.sas.svcs.scheduling.client.types.RowData;
import com.sas.svcs.scheduling.client.types.ScheduleFlowParameters;
import com.sas.svcs.scheduling.client.types.ScheduleFlowResponse;
import com.sas.svcs.scheduling.client.types.ScheduleServiceEventParameters;
import com.sas.svcs.scheduling.client.types.ScheduleServiceEventResponse;
import com.sas.svcs.scheduling.client.types.SchedulingException;
import com.sas.svcs.scheduling.client.types.TriggerFlowParameters;
import com.sas.svcs.scheduling.client.types.TriggerFlowResponse;
import com.sas.svcs.scheduling.client.types.UnscheduleFlowParameters;
import com.sas.svcs.scheduling.client.types.UnscheduleFlowResponse;
import com.sas.svcs.scheduling.client.types.UpdateDeployedJobParameters;
import com.sas.svcs.scheduling.client.types.UpdateFlowParameters;
import com.sas.svcs.scheduling.client.types.UpdatePreferenceParameters;
import jakarta.xml.bind.JAXBElement;
import java.io.Serializable;
import java.util.Calendar;
import java.util.List;

public class SchedulingServiceInterfaceProxy
implements Serializable,
SchedulingServiceInterface {
    private static final long serialVersionUID = 1L;
    private String url;
    private boolean useHttpInvokerRemoting;
    private SchedulingServiceInterface bean;
    private ProxyHelperNew helper;
    private SecurityTokenServiceClient stsClient;

    public SchedulingServiceInterfaceProxy(String serviceRegistryURL) {
        if (serviceRegistryURL != null && serviceRegistryURL.contains("SASWIPSoapServices")) {
            ServiceRegistryClient srClient = new ServiceRegistryClient(serviceRegistryURL);
            srClient.obtainServices();
            this.url = srClient.getServiceURL("SchedulingService");
            this.helper = new ProxyHelperNew();
            this.helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        } else {
            this.useHttpInvokerRemoting = true;
            this.bean = (SchedulingServiceInterface)ProxyHelperHttpInvokerHolder.getInstance((String)"wip", (String)serviceRegistryURL, null).getBean("schedulingService");
        }
    }

    public SchedulingServiceInterfaceProxy() {
        this.useHttpInvokerRemoting = true;
    }

    public SchedulingServiceInterface getBean() {
        return this.bean;
    }

    public void setBean(SchedulingServiceInterface bean) {
        this.bean = bean;
    }

    public void setStsClient(SecurityTokenServiceClient stsClient) {
        this.helper.setSecurityTokenServiceClient(stsClient);
        this.stsClient = stsClient;
    }

    @Override
    public List<SchedulerServerInfo> getSchedulingServers(int type) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            List<SchedulerServerInfo> retArg = this.getBean().getSchedulingServers(type);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getSchedulingServers";
        GetSchedulingServersParameters arg = new ObjectFactory().createGetSchedulingServersParameters();
        arg.setType(type);
        JAXBElement<GetSchedulingServersParameters> argDoc = new ObjectFactory().createGetSchedulingServers(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetSchedulingServersResponse retType = (GetSchedulingServersResponse)retDocType.getValue();
            List<SchedulerServerInfo> retArg = retType.getSchedulerServer();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public SchedulerServerInfo connectToSchedulingServer(SchedulerServerInfo schedulerServer, String user, String password, String timezone, String stdout, String stderr, String flowDefDir, Integer maxHistory, Integer maxHistoryPerFlow) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            SchedulerServerInfo retArg = this.getBean().connectToSchedulingServer(schedulerServer, user, password, timezone, stdout, stderr, flowDefDir, maxHistory, maxHistoryPerFlow);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/connectToSchedulingServer";
        ConnectToSchedulingServerParameters arg = new ObjectFactory().createConnectToSchedulingServerParameters();
        arg.setSchedulerServer(schedulerServer);
        arg.setUser(user);
        arg.setPassword(password);
        arg.setTimezone(timezone);
        arg.setStdout(stdout);
        arg.setStderr(stderr);
        arg.setFlowDefDir(flowDefDir);
        arg.setMaxHistory(maxHistory);
        arg.setMaxHistoryPerFlow(maxHistoryPerFlow);
        JAXBElement<ConnectToSchedulingServerParameters> argDoc = new ObjectFactory().createConnectToSchedulingServer(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            ConnectToSchedulingServerResponse retType = (ConnectToSchedulingServerResponse)retDocType.getValue();
            SchedulerServerInfo retArg = retType.getSchedulerServer();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public SchedulerServerInfo connectToSchedulingServer2(SchedulerServerInfo schedulerServer, String user, String password, String timezone, String stdout, String stderr, boolean scoping, String flowDefDir, Integer maxHistory, Integer maxHistoryPerFlow) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            SchedulerServerInfo retArg = this.getBean().connectToSchedulingServer2(schedulerServer, user, password, timezone, stdout, stderr, scoping, flowDefDir, maxHistory, maxHistoryPerFlow);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/connectToSchedulingServer2";
        ConnectToSchedulingServer2Parameters arg = new ObjectFactory().createConnectToSchedulingServer2Parameters();
        arg.setSchedulerServer(schedulerServer);
        arg.setUser(user);
        arg.setPassword(password);
        arg.setTimezone(timezone);
        arg.setStdout(stdout);
        arg.setStderr(stderr);
        arg.setScoping(scoping);
        arg.setFlowDefDir(flowDefDir);
        arg.setMaxHistory(maxHistory);
        arg.setMaxHistoryPerFlow(maxHistoryPerFlow);
        JAXBElement<ConnectToSchedulingServer2Parameters> argDoc = new ObjectFactory().createConnectToSchedulingServer2(arg);
        try {
            SchedulerServerInfo retArg;
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            ConnectToSchedulingServer2Response retType = (ConnectToSchedulingServer2Response)retDocType.getValue();
            SchedulerServerInfo schedulerServerInfo = retArg = retType.getSchedulerServer();
            return schedulerServerInfo;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
        finally {
            arg.clearPassword();
        }
    }

    @Override
    public void disconnectFromSchedulingServer(SchedulerServerInfo schedulerServer) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            this.getBean().disconnectFromSchedulingServer(schedulerServer);
            return;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/disconnectFromSchedulingServer";
        DisconnectFromSchedulingServerParameters arg = new ObjectFactory().createDisconnectFromSchedulingServerParameters();
        arg.setSchedulerServer(schedulerServer);
        JAXBElement<DisconnectFromSchedulingServerParameters> argDoc = new ObjectFactory().createDisconnectFromSchedulingServer(arg);
        try {
            this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public boolean isValidScheduler(SchedulerServerInfo schedulerServer) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            boolean retArg = this.getBean().isValidScheduler(schedulerServer);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/isValidScheduler";
        IsValidSchedulerParameters arg = new ObjectFactory().createIsValidSchedulerParameters();
        arg.setSchedulerServer(schedulerServer);
        JAXBElement<IsValidSchedulerParameters> argDoc = new ObjectFactory().createIsValidScheduler(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            IsValidSchedulerResponse retType = (IsValidSchedulerResponse)retDocType.getValue();
            boolean retArg = retType.isValid();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<BatchServerInfo> getBatchServers(int type, int subType) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            List<BatchServerInfo> retArg = this.getBean().getBatchServers(type, subType);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getBatchServers";
        GetBatchServersParameters arg = new ObjectFactory().createGetBatchServersParameters();
        arg.setType(type);
        arg.setSubType(subType);
        JAXBElement<GetBatchServersParameters> argDoc = new ObjectFactory().createGetBatchServers(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetBatchServersResponse retType = (GetBatchServersResponse)retDocType.getValue();
            List<BatchServerInfo> retArg = retType.getBatchServer();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public boolean isValidBatchServer(BatchServerInfo batchServer) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            boolean retArg = this.getBean().isValidBatchServer(batchServer);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/isValidBatchServer";
        IsValidBatchServerParameters arg = new ObjectFactory().createIsValidBatchServerParameters();
        arg.setBatchServer(batchServer);
        JAXBElement<IsValidBatchServerParameters> argDoc = new ObjectFactory().createIsValidBatchServer(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            IsValidBatchServerResponse retType = (IsValidBatchServerResponse)retDocType.getValue();
            boolean retArg = retType.isValid();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public String getJCLTemplate(BatchServerInfo batchServer) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            String retArg = this.getBean().getJCLTemplate(batchServer);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getJCLTemplate";
        GetJCLTemplateParameters arg = new ObjectFactory().createGetJCLTemplateParameters();
        arg.setBatchServer(batchServer);
        JAXBElement<GetJCLTemplateParameters> argDoc = new ObjectFactory().createGetJCLTemplate(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetJCLTemplateResponse retType = (GetJCLTemplateResponse)retDocType.getValue();
            String retArg = retType.getTemplate();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<JobInfo> getDeployedJobs() throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            List<JobInfo> retArg = this.getBean().getDeployedJobs();
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getDeployedJobs";
        GetDeployedJobsParameters arg = new ObjectFactory().createGetDeployedJobsParameters();
        JAXBElement<GetDeployedJobsParameters> argDoc = new ObjectFactory().createGetDeployedJobs(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetDeployedJobsResponse retType = (GetDeployedJobsResponse)retDocType.getValue();
            List<JobInfo> retArg = retType.getJob();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<JobInfo> getDeployedJobsInFlow() throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            List<JobInfo> retArg = this.getBean().getDeployedJobsInFlow();
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getDeployedJobsInFlow";
        GetDeployedJobsInFlowParameters arg = new ObjectFactory().createGetDeployedJobsInFlowParameters();
        JAXBElement<GetDeployedJobsInFlowParameters> argDoc = new ObjectFactory().createGetDeployedJobsInFlow(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetDeployedJobsInFlowResponse retType = (GetDeployedJobsInFlowResponse)retDocType.getValue();
            List<JobInfo> retArg = retType.getJob();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<JobInfo> getDeployedJobsNotInFlow() throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            List<JobInfo> retArg = this.getBean().getDeployedJobsNotInFlow();
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getDeployedJobsNotInFlow";
        GetDeployedJobsNotInFlowParameters arg = new ObjectFactory().createGetDeployedJobsNotInFlowParameters();
        JAXBElement<GetDeployedJobsNotInFlowParameters> argDoc = new ObjectFactory().createGetDeployedJobsNotInFlow(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetDeployedJobsNotInFlowResponse retType = (GetDeployedJobsNotInFlowResponse)retDocType.getValue();
            List<JobInfo> retArg = retType.getJob();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<JobInfo> getDeployedJobsForFlow(FlowInfo flow) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            List<JobInfo> retArg = this.getBean().getDeployedJobsForFlow(flow);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getDeployedJobsForFlow";
        GetDeployedJobsForFlowParameters arg = new ObjectFactory().createGetDeployedJobsForFlowParameters();
        arg.setFlow(flow);
        JAXBElement<GetDeployedJobsForFlowParameters> argDoc = new ObjectFactory().createGetDeployedJobsForFlow(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetDeployedJobsForFlowResponse retType = (GetDeployedJobsForFlowResponse)retDocType.getValue();
            List<JobInfo> retArg = retType.getJob();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    @Deprecated
    public JFJob getLSFJobFromPlatformPM(JobInfo job, FlowInfo flow) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            JFJob retArg = this.getBean().getLSFJobFromPlatformPM(job, flow);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getLSFJobFromPlatformPM";
        GetLSFJobFromPlatformPMParameters arg = new ObjectFactory().createGetLSFJobFromPlatformPMParameters();
        arg.setJob(job);
        arg.setFlow(flow);
        JAXBElement<GetLSFJobFromPlatformPMParameters> argDoc = new ObjectFactory().createGetLSFJobFromPlatformPM(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetLSFJobFromPlatformPMResponse retType = (GetLSFJobFromPlatformPMResponse)retDocType.getValue();
            JFJob retArg = retType.getPMLSFJob();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public RowData getFlowData(String flowId) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            RowData retArg = this.getBean().getFlowData(flowId);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getFlowData";
        GetFlowDataParameters arg = new ObjectFactory().createGetFlowDataParameters();
        arg.setFlowId(flowId);
        JAXBElement<GetFlowDataParameters> argDoc = new ObjectFactory().createGetFlowData(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetFlowDataResponse retType = (GetFlowDataResponse)retDocType.getValue();
            RowData retArg = retType.getRowData();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public String getFlowEventDisplayName(DisplayInfo flowEvent, String language, String region) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            String retArg = this.getBean().getFlowEventDisplayName(flowEvent, language, region);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getFlowEventDisplayName";
        GetFlowEventDisplayNameParameters arg = new ObjectFactory().createGetFlowEventDisplayNameParameters();
        arg.setFlowEvent(flowEvent);
        arg.setLanguage(language);
        arg.setRegion(region);
        JAXBElement<GetFlowEventDisplayNameParameters> argDoc = new ObjectFactory().createGetFlowEventDisplayName(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetFlowEventDisplayNameResponse retType = (GetFlowEventDisplayNameResponse)retDocType.getValue();
            String retArg = retType.getDisplayString();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public String getFlowDefinitionByScheduler(String schId, String flowDefId) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            String retArg = this.getBean().getFlowDefinitionByScheduler(schId, flowDefId);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getFlowDefinitionByScheduler";
        GetFlowDefinitionBySchedulerParameters arg = new ObjectFactory().createGetFlowDefinitionBySchedulerParameters();
        arg.setSchId(schId);
        arg.setFlowDefinitionId(flowDefId);
        JAXBElement<GetFlowDefinitionBySchedulerParameters> argDoc = new ObjectFactory().createGetFlowDefinitionByScheduler(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetFlowDefinitionBySchedulerResponse retType = (GetFlowDefinitionBySchedulerResponse)retDocType.getValue();
            String retArg = retType.getFlowDef();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<FlowHistory> getFlowHistory(FlowInfo flow) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            List<FlowHistory> retArg = this.getBean().getFlowHistory(flow);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getFlowHistory";
        GetFlowHistoryParameters arg = new ObjectFactory().createGetFlowHistoryParameters();
        arg.setFlow(flow);
        JAXBElement<GetFlowHistoryParameters> argDoc = new ObjectFactory().createGetFlowHistory(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetFlowHistoryResponse retType = (GetFlowHistoryResponse)retDocType.getValue();
            List<FlowHistory> retArg = retType.getFlowHistory();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<FlowHistory> getFlowHistoryByScheduler(String schId, String user, int count) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            List<FlowHistory> retArg = this.getBean().getFlowHistoryByScheduler(schId, user, count);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getFlowHistoryByScheduler";
        GetFlowHistoryBySchedulerParameters arg = new ObjectFactory().createGetFlowHistoryBySchedulerParameters();
        arg.setSchId(schId);
        arg.setUser(user);
        arg.setCount(count);
        JAXBElement<GetFlowHistoryBySchedulerParameters> argDoc = new ObjectFactory().createGetFlowHistoryByScheduler(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetFlowHistoryResponse retType = (GetFlowHistoryResponse)retDocType.getValue();
            List<FlowHistory> retArg = retType.getFlowHistory();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public boolean holdFlow(String schId, String flowDefinition) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            boolean retArg = this.getBean().holdFlow(schId, flowDefinition);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/holdFlow";
        HoldFlowParameters arg = new ObjectFactory().createHoldFlowParameters();
        arg.setSchId(schId);
        arg.setFlowDefinition(flowDefinition);
        JAXBElement<HoldFlowParameters> argDoc = new ObjectFactory().createHoldFlow(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            HoldFlowResponse retType = (HoldFlowResponse)retDocType.getValue();
            boolean retArg = retType.getValue();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public boolean releaseFlow(String schId, String flowDefinition) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            boolean retArg = this.getBean().releaseFlow(schId, flowDefinition);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/releaseFlow";
        ReleaseFlowParameters arg = new ObjectFactory().createReleaseFlowParameters();
        arg.setSchId(schId);
        arg.setFlowDefinition(flowDefinition);
        JAXBElement<ReleaseFlowParameters> argDoc = new ObjectFactory().createReleaseFlow(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            ReleaseFlowResponse retType = (ReleaseFlowResponse)retDocType.getValue();
            boolean retArg = retType.getValue();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public boolean triggerFlow(String schId, String flowDefinition) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            boolean retArg = this.getBean().triggerFlow(schId, flowDefinition);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/triggerFlow";
        TriggerFlowParameters arg = new ObjectFactory().createTriggerFlowParameters();
        arg.setSchId(schId);
        arg.setFlowDefinition(flowDefinition);
        JAXBElement<TriggerFlowParameters> argDoc = new ObjectFactory().createTriggerFlow(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            TriggerFlowResponse retType = (TriggerFlowResponse)retDocType.getValue();
            boolean retArg = retType.getValue();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public boolean killFlowInstance(String schId, String flowInstance) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            boolean retArg = this.getBean().killFlowInstance(schId, flowInstance);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/killFlowInstance";
        KillFlowInstanceParameters arg = new ObjectFactory().createKillFlowInstanceParameters();
        arg.setSchId(schId);
        arg.setFlowInstance(flowInstance);
        JAXBElement<KillFlowInstanceParameters> argDoc = new ObjectFactory().createKillFlowInstance(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            KillFlowInstanceResponse retType = (KillFlowInstanceResponse)retDocType.getValue();
            boolean retArg = retType.getValue();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public boolean killItemInstance(String schId, String flowInstance, String itemInstance) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            boolean retArg = this.getBean().killItemInstance(schId, flowInstance, itemInstance);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/killItemInstance";
        KillItemInstanceParameters arg = new ObjectFactory().createKillItemInstanceParameters();
        arg.setSchId(schId);
        arg.setFlowInstance(flowInstance);
        arg.setItemInstance(itemInstance);
        JAXBElement<KillItemInstanceParameters> argDoc = new ObjectFactory().createKillItemInstance(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            KillItemInstanceResponse retType = (KillItemInstanceResponse)retDocType.getValue();
            boolean retArg = retType.getValue();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public boolean pauseFlowInstance(String schId, String flowInstance) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            boolean retArg = this.getBean().pauseFlowInstance(schId, flowInstance);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/pauseFlowInstance";
        PauseFlowInstanceParameters arg = new ObjectFactory().createPauseFlowInstanceParameters();
        arg.setSchId(schId);
        arg.setFlowInstance(flowInstance);
        JAXBElement<PauseFlowInstanceParameters> argDoc = new ObjectFactory().createPauseFlowInstance(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            PauseFlowInstanceResponse retType = (PauseFlowInstanceResponse)retDocType.getValue();
            boolean retArg = retType.getValue();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public boolean resumeFlowInstance(String schId, String flowInstance) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            boolean retArg = this.getBean().resumeFlowInstance(schId, flowInstance);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/resumeFlowInstance";
        ResumeFlowInstanceParameters arg = new ObjectFactory().createResumeFlowInstanceParameters();
        arg.setSchId(schId);
        arg.setFlowInstance(flowInstance);
        JAXBElement<ResumeFlowInstanceParameters> argDoc = new ObjectFactory().createResumeFlowInstance(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            ResumeFlowInstanceResponse retType = (ResumeFlowInstanceResponse)retDocType.getValue();
            boolean retArg = retType.getValue();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public StringBuffer getStandardOutput(String schId, String flowInstance, String jobInstance) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            StringBuffer retArg = this.getBean().getStandardOutput(schId, flowInstance, jobInstance);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getStandardOutput";
        GetStandardOutputParameters arg = new ObjectFactory().createGetStandardOutputParameters();
        arg.setSchId(schId);
        arg.setFlowInstance(flowInstance);
        arg.setJobInstance(jobInstance);
        JAXBElement<GetStandardOutputParameters> argDoc = new ObjectFactory().createGetStandardOutput(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetStandardOutputResponse retType = (GetStandardOutputResponse)retDocType.getValue();
            StringBuffer retArg = retType.getStandardOutput();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public StringBuffer getStandardError(String schId, String flowInstance, String jobInstance) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            StringBuffer retArg = this.getBean().getStandardError(schId, flowInstance, jobInstance);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getStandardError";
        GetStandardErrorParameters arg = new ObjectFactory().createGetStandardErrorParameters();
        arg.setSchId(schId);
        arg.setFlowInstance(flowInstance);
        arg.setJobInstance(jobInstance);
        JAXBElement<GetStandardErrorParameters> argDoc = new ObjectFactory().createGetStandardError(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetStandardErrorResponse retType = (GetStandardErrorResponse)retDocType.getValue();
            StringBuffer retArg = retType.getStandardError();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<JobRendererInfo> getJobRenderers(String schId) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            List<JobRendererInfo> retArg = this.getBean().getJobRenderers(schId);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getJobRenderers";
        GetJobRenderersParameters arg = new ObjectFactory().createGetJobRenderersParameters();
        arg.setSchId(schId);
        JAXBElement<GetJobRenderersParameters> argDoc = new ObjectFactory().createGetJobRenderers(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetJobRenderersResponse retType = (GetJobRenderersResponse)retDocType.getValue();
            List<JobRendererInfo> retArg = retType.getJobRenderers();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<String> getMessageQueues(String schId) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            List<String> retArg = this.getBean().getMessageQueues(schId);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getMessageQueues";
        GetMessageQueuesParameters arg = new ObjectFactory().createGetMessageQueuesParameters();
        arg.setSchId(schId);
        JAXBElement<GetMessageQueuesParameters> argDoc = new ObjectFactory().createGetMessageQueues(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetMessageQueuesResponse retType = (GetMessageQueuesResponse)retDocType.getValue();
            List<String> retArg = retType.getMessageQueues();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<Object> getMessages(String schId, String qname) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            List<Object> retArg = this.getBean().getMessages(schId, qname);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getMessages";
        GetMessagesParameters arg = new ObjectFactory().createGetMessagesParameters();
        arg.setSchId(schId);
        arg.setQname(qname);
        JAXBElement<GetMessagesParameters> argDoc = new ObjectFactory().createGetMessages(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetMessagesResponse retType = (GetMessagesResponse)retDocType.getValue();
            List<Object> retArg = retType.getMessages();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public PreferenceInfo getPreference() throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            PreferenceInfo retArg = this.getBean().getPreference();
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getPreference";
        GetPreferenceParameters arg = new ObjectFactory().createGetPreferenceParameters();
        JAXBElement<GetPreferenceParameters> argDoc = new ObjectFactory().createGetPreference(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetPreferenceResponse retType = (GetPreferenceResponse)retDocType.getValue();
            PreferenceInfo retArg = retType.getPreference();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void updatePreference(PreferenceInfo preference) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            this.getBean().updatePreference(preference);
            return;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/updatePreference";
        UpdatePreferenceParameters arg = new ObjectFactory().createUpdatePreferenceParameters();
        arg.setPreference(preference);
        JAXBElement<UpdatePreferenceParameters> argDoc = new ObjectFactory().createUpdatePreference(arg);
        try {
            this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<Calendar> getHolidays(Calendar startCalendar, Calendar endCalendar) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            List<Calendar> retArg = this.getBean().getHolidays(startCalendar, endCalendar);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getHolidays";
        GetHolidaysParameters arg = new ObjectFactory().createGetHolidaysParameters();
        arg.setStartCalendar(startCalendar);
        arg.setEndCalendar(endCalendar);
        JAXBElement<GetHolidaysParameters> argDoc = new ObjectFactory().createGetHolidays(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetHolidaysResponse retType = (GetHolidaysResponse)retDocType.getValue();
            List<Calendar> retArg = retType.getCalendar();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<Calendar> getOutages(Calendar startCalendar, Calendar endCalendar) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            List<Calendar> retArg = this.getBean().getOutages(startCalendar, endCalendar);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getOutages";
        GetOutagesParameters arg = new ObjectFactory().createGetOutagesParameters();
        arg.setStartCalendar(startCalendar);
        arg.setEndCalendar(endCalendar);
        JAXBElement<GetOutagesParameters> argDoc = new ObjectFactory().createGetOutages(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetOutagesResponse retType = (GetOutagesResponse)retDocType.getValue();
            List<Calendar> retArg = retType.getCalendar();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<Calendar> getNextScheduledDates(FlowInfo flow, Calendar startCalendar, Calendar endCalendar, int count) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            List<Calendar> retArg = this.getBean().getNextScheduledDates(flow, startCalendar, endCalendar, count);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getNextScheduledDates";
        GetNextScheduledDatesParameters arg = new ObjectFactory().createGetNextScheduledDatesParameters();
        arg.setFlow(flow);
        arg.setStartCalendar(startCalendar);
        arg.setEndCalendar(endCalendar);
        arg.setCount(count);
        JAXBElement<GetNextScheduledDatesParameters> argDoc = new ObjectFactory().createGetNextScheduledDates(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetNextScheduledDatesResponse retType = (GetNextScheduledDatesResponse)retDocType.getValue();
            List<Calendar> retArg = retType.getNextDate();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public FlowInfo getFlowInfo(String flowId) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            FlowInfo retArg = this.getBean().getFlowInfo(flowId);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getFlowInfo";
        GetFlowInfoParameters arg = new ObjectFactory().createGetFlowInfoParameters();
        arg.setFlowId(flowId);
        JAXBElement<GetFlowInfoParameters> argDoc = new ObjectFactory().createGetFlowInfo(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetFlowInfoResponse retType = (GetFlowInfoResponse)retDocType.getValue();
            FlowInfo retArg = retType.getFlow();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<FlowInfo> getFlows() throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            List<FlowInfo> retArg = this.getBean().getFlows();
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getFlows";
        GetFlowsParameters arg = new ObjectFactory().createGetFlowsParameters();
        JAXBElement<GetFlowsParameters> argDoc = new ObjectFactory().createGetFlows(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetFlowsResponse retType = (GetFlowsResponse)retDocType.getValue();
            List<FlowInfo> retArg = retType.getFlow();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public FlowInfo getFlowByName(String flowName) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            FlowInfo retArg = this.getBean().getFlowByName(flowName);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getFlowByName";
        GetFlowByNameParameters arg = new ObjectFactory().createGetFlowByNameParameters();
        arg.setFlowName(flowName);
        JAXBElement<GetFlowByNameParameters> argDoc = new ObjectFactory().createGetFlowByName(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetFlowByNameResponse retType = (GetFlowByNameResponse)retDocType.getValue();
            FlowInfo retArg = retType.getFlow();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<FlowInfo> getFlowsByParty(String party) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            List<FlowInfo> retArg = this.getBean().getFlowsByParty(party);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getFlowsByParty";
        GetFlowsByPartyParameters arg = new ObjectFactory().createGetFlowsByPartyParameters();
        arg.setParty(party);
        JAXBElement<GetFlowsByPartyParameters> argDoc = new ObjectFactory().createGetFlowsByParty(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetFlowsByPartyResponse retType = (GetFlowsByPartyResponse)retDocType.getValue();
            List<FlowInfo> retArg = retType.getFlow();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<FlowInfo> getScheduledFlows() throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            List<FlowInfo> retArg = this.getBean().getScheduledFlows();
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getScheduledFlows";
        GetScheduledFlowsParameters arg = new ObjectFactory().createGetScheduledFlowsParameters();
        JAXBElement<GetScheduledFlowsParameters> argDoc = new ObjectFactory().createGetScheduledFlows(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetScheduledFlowsResponse retType = (GetScheduledFlowsResponse)retDocType.getValue();
            List<FlowInfo> retArg = retType.getFlow();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<RunHistory> getRunningJobsByScheduler(String schId, String user) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            List<RunHistory> retArg = this.getBean().getRunningJobsByScheduler(schId, user);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getRunningJobsByScheduler";
        GetRunningJobsBySchedulerParameters arg = new ObjectFactory().createGetRunningJobsBySchedulerParameters();
        JAXBElement<GetRunningJobsBySchedulerParameters> argDoc = new ObjectFactory().createGetRunningJobsByScheduler(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetRunningJobsResponse retType = (GetRunningJobsResponse)retDocType.getValue();
            List<RunHistory> retArg = retType.getRunHistory();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<ScheduledFlowInfo> getScheduledFlowsByScheduler(String schId, String user) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            List<ScheduledFlowInfo> retArg = this.getBean().getScheduledFlowsByScheduler(schId, user);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getScheduledFlowsByScheduler";
        GetScheduledFlowsBySchedulerParameters arg = new ObjectFactory().createGetScheduledFlowsBySchedulerParameters();
        JAXBElement<GetScheduledFlowsBySchedulerParameters> argDoc = new ObjectFactory().createGetScheduledFlowsByScheduler(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetScheduledFlowsBySchedulerResponse retType = (GetScheduledFlowsBySchedulerResponse)retDocType.getValue();
            List<ScheduledFlowInfo> retArg = retType.getFlow();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public JobInfo getJobInfo(String jobId) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            JobInfo retArg = this.getBean().getJobInfo(jobId);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getJobInfo";
        GetJobInfoParameters arg = new ObjectFactory().createGetJobInfoParameters();
        arg.setJobId(jobId);
        JAXBElement<GetJobInfoParameters> argDoc = new ObjectFactory().createGetJobInfo(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetJobInfoResponse retType = (GetJobInfoResponse)retDocType.getValue();
            JobInfo retArg = retType.getJob();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<JobInfo> getAllDeployedJobsAndFlows() throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            List<JobInfo> retArg = this.getBean().getAllDeployedJobsAndFlows();
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/getAllDeployedJobsAndFlows";
        GetAllDeployedJobsAndFlowsParameters arg = new ObjectFactory().createGetAllDeployedJobsAndFlowsParameters();
        JAXBElement<GetAllDeployedJobsAndFlowsParameters> argDoc = new ObjectFactory().createGetAllDeployedJobsAndFlows(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetAllDeployedJobsAndFlowsResponse retType = (GetAllDeployedJobsAndFlowsResponse)retDocType.getValue();
            List<JobInfo> retArg = retType.getJob();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public JobInfo createDeployedJob(String jobName, boolean modifyNameForUniqueness, BatchServerInfo batchServer, SASFolder sASFolder, DisplayInfo associatedJob, String jobArgs) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            JobInfo retArg = this.getBean().createDeployedJob(jobName, modifyNameForUniqueness, batchServer, sASFolder, associatedJob, jobArgs);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/createDeployedJob";
        CreateDeployedJobParameters arg = new ObjectFactory().createCreateDeployedJobParameters();
        arg.setJobName(jobName);
        arg.setModifyNameForUniqueness(modifyNameForUniqueness);
        arg.setBatchServer(batchServer);
        arg.setSASFolder(sASFolder);
        arg.setAssociatedJob(associatedJob);
        arg.setJobArgs(jobArgs);
        JAXBElement<CreateDeployedJobParameters> argDoc = new ObjectFactory().createCreateDeployedJob(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            CreateDeployedJobResponse retType = (CreateDeployedJobResponse)retDocType.getValue();
            JobInfo retArg = retType.getJob();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public JobInfo createDeployedJob2(JobInfo job, boolean modifyNameForUniqueness) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            JobInfo retArg = this.getBean().createDeployedJob2(job, modifyNameForUniqueness);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/createDeployedJob2";
        CreateDeployedJob2Parameters arg = new ObjectFactory().createCreateDeployedJob2Parameters();
        arg.setJob(job);
        arg.setModifyNameForUniqueness(modifyNameForUniqueness);
        JAXBElement<CreateDeployedJob2Parameters> argDoc = new ObjectFactory().createCreateDeployedJob2(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            CreateDeployedJob2Response retType = (CreateDeployedJob2Response)retDocType.getValue();
            JobInfo retArg = retType.getJob();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public JobInfo createDataStepDeployedJob(String jobName, boolean modifyNameForUniqueness, BatchServerInfo batchServer, SASFolder sASFolder, String sourceFileName, DirectoryInfo deploymentDirectory) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            JobInfo retArg = this.getBean().createDataStepDeployedJob(jobName, modifyNameForUniqueness, batchServer, sASFolder, sourceFileName, deploymentDirectory);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/createDataStepDeployedJob";
        CreateDataStepDeployedJobParameters arg = new ObjectFactory().createCreateDataStepDeployedJobParameters();
        arg.setJobName(jobName);
        arg.setModifyNameForUniqueness(modifyNameForUniqueness);
        arg.setBatchServer(batchServer);
        arg.setSASFolder(sASFolder);
        arg.setSourceFileName(sourceFileName);
        arg.setDeploymentDirectory(deploymentDirectory);
        JAXBElement<CreateDataStepDeployedJobParameters> argDoc = new ObjectFactory().createCreateDataStepDeployedJob(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            CreateDataStepDeployedJobResponse retType = (CreateDataStepDeployedJobResponse)retDocType.getValue();
            JobInfo retArg = retType.getJob();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public boolean scheduleServiceEvent(String serviceName, String serviceMethod, MapType argMap) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            boolean retArg = this.getBean().scheduleServiceEvent(serviceName, serviceMethod, argMap);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/scheduleServiceEvent";
        ScheduleServiceEventParameters arg = new ObjectFactory().createScheduleServiceEventParameters();
        arg.setServiceName(serviceName);
        arg.setServiceMethod(serviceMethod);
        arg.setArgMap(argMap);
        JAXBElement<ScheduleServiceEventParameters> argDoc = new ObjectFactory().createScheduleServiceEvent(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            ScheduleServiceEventResponse retType = (ScheduleServiceEventResponse)retDocType.getValue();
            boolean retArg = retType.isEventResponse();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void updateDeployedJob(JobInfo job) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            this.getBean().updateDeployedJob(job);
            return;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/updateDeployedJob";
        UpdateDeployedJobParameters arg = new ObjectFactory().createUpdateDeployedJobParameters();
        arg.setJob(job);
        JAXBElement<UpdateDeployedJobParameters> argDoc = new ObjectFactory().createUpdateDeployedJob(arg);
        try {
            this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void deleteDeployedJob(JobInfo job) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            this.getBean().deleteDeployedJob(job);
            return;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/deleteDeployedJob";
        DeleteDeployedJobParameters arg = new ObjectFactory().createDeleteDeployedJobParameters();
        arg.setJob(job);
        JAXBElement<DeleteDeployedJobParameters> argDoc = new ObjectFactory().createDeleteDeployedJob(arg);
        try {
            this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public FlowInfo createFlow(String flowName, boolean modifyNameForUniqueness, SchedulerServerInfo schedulerServer, SASFolder sASFolder, List<JobInfo> job, TriggerEventInfo triggerEvent) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            FlowInfo retArg = this.getBean().createFlow(flowName, modifyNameForUniqueness, schedulerServer, sASFolder, job, triggerEvent);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/createFlow";
        CreateFlowParameters arg = new ObjectFactory().createCreateFlowParameters();
        arg.setFlowName(flowName);
        arg.setModifyNameForUniqueness(modifyNameForUniqueness);
        arg.setSchedulerServer(schedulerServer);
        arg.setSASFolder(sASFolder);
        arg.setJobs(job);
        arg.setTriggerEvent(triggerEvent);
        JAXBElement<CreateFlowParameters> argDoc = new ObjectFactory().createCreateFlow(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            CreateFlowResponse retType = (CreateFlowResponse)retDocType.getValue();
            FlowInfo retArg = retType.getFlow();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public FlowInfo createFlow2(FlowInfo flowInformation, boolean modifyNameForUniqueness) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            FlowInfo retArg = this.getBean().createFlow2(flowInformation, modifyNameForUniqueness);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/createFlow2";
        CreateFlowParameters2 arg = new ObjectFactory().createCreateFlowParameters2();
        arg.setFlowInformation(flowInformation);
        arg.setModifyNameForUniqueness(modifyNameForUniqueness);
        JAXBElement<CreateFlowParameters2> argDoc = new ObjectFactory().createCreateFlow2(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            CreateFlowResponse retType = (CreateFlowResponse)retDocType.getValue();
            FlowInfo retArg = retType.getFlow();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void updateFlow(FlowInfo flow) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            this.getBean().updateFlow(flow);
            return;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/updateFlow";
        UpdateFlowParameters arg = new ObjectFactory().createUpdateFlowParameters();
        arg.setFlow(flow);
        JAXBElement<UpdateFlowParameters> argDoc = new ObjectFactory().createUpdateFlow(arg);
        try {
            this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void deleteFlow(FlowInfo flow, boolean removeFromScheduler) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            this.getBean().deleteFlow(flow, removeFromScheduler);
            return;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/deleteFlow";
        DeleteFlowParameters arg = new ObjectFactory().createDeleteFlowParameters();
        arg.setFlow(flow);
        arg.setRemoveFromScheduler(removeFromScheduler);
        JAXBElement<DeleteFlowParameters> argDoc = new ObjectFactory().createDeleteFlow(arg);
        try {
            this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public SchedulerResultSet scheduleFlow(FlowInfo flow) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            SchedulerResultSet retArg = this.getBean().scheduleFlow(flow);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/scheduleFlow";
        ScheduleFlowParameters arg = new ObjectFactory().createScheduleFlowParameters();
        arg.setFlow(flow);
        JAXBElement<ScheduleFlowParameters> argDoc = new ObjectFactory().createScheduleFlow(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            ScheduleFlowResponse retType = (ScheduleFlowResponse)retDocType.getValue();
            SchedulerResultSet retArg = retType.getSchedulerResultSet();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public SchedulerResultSet rescheduleFlow(FlowInfo flow, boolean errorOnDeleteFailureFromScheduler) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            SchedulerResultSet retArg = this.getBean().rescheduleFlow(flow, errorOnDeleteFailureFromScheduler);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/rescheduleFlow";
        RescheduleFlowParameters arg = new ObjectFactory().createRescheduleFlowParameters();
        arg.setFlow(flow);
        arg.setErrorOnDeleteFailureFromScheduler(errorOnDeleteFailureFromScheduler);
        JAXBElement<RescheduleFlowParameters> argDoc = new ObjectFactory().createRescheduleFlow(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            RescheduleFlowResponse retType = (RescheduleFlowResponse)retDocType.getValue();
            SchedulerResultSet retArg = retType.getSchedulerResultSet();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public FlowInfo unscheduleFlow(FlowInfo flow) throws SchedulingExceptionHolder {
        if (this.useHttpInvokerRemoting) {
            FlowInfo retArg = this.getBean().unscheduleFlow(flow);
            return retArg;
        }
        String action = "http://www.sas.com/xml/schema/sas-svcs/schedulingservice-9.3/wsdl/SchedulingServiceInterface/unscheduleFlow";
        UnscheduleFlowParameters arg = new ObjectFactory().createUnscheduleFlowParameters();
        arg.setFlow(flow);
        JAXBElement<UnscheduleFlowParameters> argDoc = new ObjectFactory().createUnscheduleFlow(arg);
        try {
            Object retDoc = this.helper.call(this.url, action, argDoc, "jaxbMarshaller", "com.sas.scheduler.model.lsf:com.sas.scheduler.model:com.sas.svcs.scheduling.client.types");
            JAXBElement retDocType = (JAXBElement)retDoc;
            UnscheduleFlowResponse retType = (UnscheduleFlowResponse)retDocType.getValue();
            FlowInfo retArg = retType.getFlow();
            return retArg;
        }
        catch (ProxyHelperException phe) {
            if (phe.getFault() instanceof SchedulingException) {
                SchedulingException exDoc;
                SchedulingException ex = exDoc = (SchedulingException)phe.getFault();
                SchedulingExceptionHolder e = new SchedulingExceptionHolder();
                e.setSchedulingException(ex);
                throw e;
            }
            throw new RuntimeException("Unknown Exception thrown: " + phe.getFault());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

