/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.util;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JaxbMarshallerHelper<T> {
    private static Map<Class<?>, JAXBContext> contextStore = new ConcurrentHashMap();
    private static final Logger logger = LogManager.getLogger(JaxbMarshallerHelper.class);

    protected static JAXBContext getContextInstance(Class<?> objectClass) throws JAXBException {
        logger.debug("Inside JaxbMarshallerHelper getContextInstance");
        JAXBContext context = contextStore.get(objectClass);
        if (context == null) {
            context = JAXBContext.newInstance((Class[])new Class[]{objectClass});
            contextStore.put(objectClass, context);
        }
        return context;
    }

    public void marshallObjectToXML(T object, File file) {
        try {
            JAXBContext jaxbContext = JaxbMarshallerHelper.getContextInstance(object.getClass());
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal(object, file);
        }
        catch (JAXBException e2) {
            e2.printStackTrace();
        }
    }

    public T unMarshallXMLToObject(T object, File file) {
        Object readObject = null;
        try {
            JAXBContext jaxbContext = JaxbMarshallerHelper.getContextInstance(object.getClass());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            readObject = unmarshaller.unmarshal(file);
        }
        catch (JAXBException e2) {
            e2.printStackTrace();
        }
        return (T)readObject;
    }
}

