/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.spi;

import com.sas.svcs.backup.analyze.ConfigurationMergeManager;
import com.sas.svcs.backup.client.BackupConfiguration;
import com.sas.svcs.backup.client.BackupServiceSession;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.BackupSourceNode;
import com.sas.svcs.backup.client.ConfigurableServerProxy;
import com.sas.svcs.backup.client.ConfigurationFilter;
import com.sas.svcs.backup.client.SASTierProxy;
import com.sas.svcs.backup.client.SASTiers;
import com.sas.svcs.backup.client.UserBackupConfiguration;
import com.sas.svcs.backup.client.UserConfigurationServiceInterface;
import com.sas.svcs.backup.client.UserSourceConfiguration;
import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import com.sas.svcs.backup.dao.ConfigBeanConverter;
import com.sas.svcs.backup.dao.DeploymentAgentClient;
import com.sas.svcs.backup.dao.DeploymentBackupConfiguration;
import com.sas.svcs.backup.dao.XMLOperationDAO;
import com.sas.svcs.backup.spi.BackupConfigurationService;
import com.sas.svcs.backup.spi.BackupServiceHelper;
import com.sas.svcs.backup.spi.SessionManager;
import com.sas.svcs.deployment.DeploymentDiscoveryService;
import com.sas.svcs.deployment.dao.DeploymentDiscoveryDAO;
import com.sas.svcs.deployment.dao.WorkflowStateHolder;
import com.sas.svcs.deployment.data.ConfigurableServer;
import com.sas.svcs.deployment.data.SASEnvironment;
import com.sas.svcs.deployment.data.SASTier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class UserConfigurationService
implements UserConfigurationServiceInterface {
    private static final Logger logger = LogManager.getLogger(UserConfigurationService.class);
    @Autowired
    private XMLOperationDAO xmlOperationDAO;
    @Autowired
    private BackupConfigurationService backupConfigurationService;
    @Autowired
    private ConfigBeanConverter configBeanConverter;
    @Autowired
    private DeploymentDiscoveryService deploymentDiscoveryService;
    @Autowired
    private ConfigurationMergeManager configurationMergeManager;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private DeploymentBackupConfiguration deploymentBackupConfiguration;
    @Autowired
    private BackupServiceHelper backupServiceHelper;
    private Lock updateLock;

    public void setUpdateLock(Lock updateLock) {
        this.updateLock = updateLock;
    }

    private List<SASTier> getUnreachableTiers(List<SASTier> sasTiers) {
        ArrayList<SASTier> unreachableTiers = new ArrayList<SASTier>();
        try {
            for (SASTier sasTier : sasTiers) {
                String hostName = sasTier.getHostName();
                if (DeploymentAgentClient.isAgentRunning(hostName)) continue;
                unreachableTiers.add(sasTier);
            }
        }
        catch (BackupException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new BackupException("Fatal error encountered while trying check deployment agent communications.", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_DEPLOYMENT_AGENT_COMMUNICATION_FAILURE.getErrorCode());
        }
        return unreachableTiers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyConfigFilesFromPrimaryTier(SASTier primaryMetadataTier) {
        BackupServiceSession session = new BackupServiceSession(SessionManager.createSessionId(), "CopyConfigFiles");
        boolean immutableSessionAlreadyRunning = this.sessionManager.isImmutableSessionStarted();
        try {
            if (!immutableSessionAlreadyRunning) {
                this.sessionManager.startImmutableSessionOn(primaryMetadataTier, session, "CopyConfigFiles");
            }
        }
        finally {
            if (!immutableSessionAlreadyRunning) {
                this.sessionManager.resetImmutableSession();
                this.backupServiceHelper.deleteTempDirectory();
            }
        }
    }

    private SASTier getPrimaryMDTier() {
        SASTier primaryMDTier = this.deploymentBackupConfiguration.getUserSpecifiedPrimaryMetadataTier();
        SASEnvironment sasEnvironment = this.deploymentDiscoveryService.discover();
        List allAvailableSASTiers = sasEnvironment.getSasTiers();
        List<SASTier> unreachableTiers = this.getUnreachableTiers(allAvailableSASTiers);
        ArrayList<String> unreachableHost = new ArrayList<String>();
        if (!unreachableTiers.isEmpty()) {
            for (SASTier sASTier : unreachableTiers) {
                unreachableHost.add(sASTier.getHostName());
            }
        }
        logger.debug("Get List of unavailable tiers::" + unreachableHost);
        logger.debug("#Get List of actual reachable tiers#");
        ArrayList<SASTier> actualReachableTiers = new ArrayList<SASTier>();
        for (SASTier tier : allAvailableSASTiers) {
            if (unreachableHost.contains(tier.getHostName())) continue;
            actualReachableTiers.add(tier);
            logger.debug("Reachable HostName::" + tier.getHostName());
        }
        if (primaryMDTier != null) {
            primaryMDTier = BackupServiceUtils.retrieveObject(actualReachableTiers, primaryMDTier);
            logger.debug("IF UserSpecifiedPrimaryTIer is not null PrimaryMetadataTier hostName::" + primaryMDTier.getHostName());
        } else {
            logger.debug("#If userspecifiedPrimaryTier is null#");
            List list = this.deploymentDiscoveryService.getConfigurableServers(DeploymentDiscoveryDAO.ComponentType.METADATA_SERVER);
            ArrayList<String> metadataTierList = new ArrayList<String>();
            for (ConfigurableServer metadataServer : list) {
                metadataTierList.add(metadataServer.getSasTier().getHostName());
            }
            logger.debug("metadataTierList::" + metadataTierList);
            if (!metadataTierList.isEmpty() && !actualReachableTiers.isEmpty()) {
                for (SASTier metadataTier : actualReachableTiers) {
                    if (!metadataTierList.contains(metadataTier.getHostName())) continue;
                    primaryMDTier = metadataTier;
                    break;
                }
            }
        }
        if (primaryMDTier != null) {
            primaryMDTier.setPrimaryMetadataServer(true);
            logger.debug("Primary Metadata Tier: " + primaryMDTier);
        }
        return primaryMDTier;
    }

    public UserBackupConfiguration getConfiguration() throws BackupException {
        logger.debug("NotFoundInCache! Entering getConfiguration()");
        return this.getConfigurationActual();
    }

    private UserBackupConfiguration getConfigurationActual() throws BackupException {
        BackupSourceConfig.BackupSource[] sourceValues;
        UserBackupConfiguration configuration = null;
        BackupConfiguration baseconfiguration = this.backupConfigurationService.getBaseConfiguration();
        configuration = this.configBeanConverter.BackupConfigTouserConfig(baseconfiguration);
        ArrayList<UserSourceConfiguration> lstSrcConfiguration = null;
        UserSourceConfiguration sourceConfiguration = null;
        for (BackupSourceConfig.BackupSource source : sourceValues = BackupSourceConfig.BackupSource.values()) {
            sourceConfiguration = this.getMergedConfigurationActual(source);
            if (sourceConfiguration == null) continue;
            sourceConfiguration.setSourceType(source.getDisplayName());
            if (lstSrcConfiguration == null) {
                lstSrcConfiguration = new ArrayList<UserSourceConfiguration>();
            }
            lstSrcConfiguration.add(sourceConfiguration);
        }
        if (lstSrcConfiguration != null && lstSrcConfiguration.size() > 0) {
            configuration.setSources((List)lstSrcConfiguration);
        }
        return configuration;
    }

    public UserSourceConfiguration getSourceConfig(BackupSourceConfig.BackupSource sourceType) throws BackupException {
        logger.debug("NotFoundInCache! Entering getSourceConfig(" + sourceType + ")");
        return this.getSourceConfigActual(sourceType);
    }

    private UserSourceConfiguration getSourceConfigActual(BackupSourceConfig.BackupSource sourceType) throws BackupException {
        return this.xmlOperationDAO.getBackupSourceConfiguration(sourceType);
    }

    public void setSourceConfigurationLocal(UserSourceConfiguration sourceConfig, BackupSourceConfig.BackupSource sourceType) throws BackupException {
        logger.debug("setSourceConfigurationLocal");
        try {
            this.xmlOperationDAO.setBackupSourceConfiguration(sourceConfig, sourceType);
        }
        catch (Exception e) {
            logger.warn("Unable to write CONFIGDIR file locally for offline recovery", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceConfiguration(UserSourceConfiguration sourceConfig, BackupSourceConfig.BackupSource sourceType) throws BackupException {
        logger.debug("Geode Cache need to be refreshed. Reason : setSourceConfiguration(" + sourceConfig + ", " + sourceType + ")");
        try {
            if (this.updateLock != null) {
                this.updateLock.lock();
            }
            BackupServiceSession session = null;
            try {
                SASTier primaryTier = this.getPrimaryMDTier();
                if (primaryTier != null) {
                    BackupSourceNode primaryNode = this.configBeanConverter.sasTierToBackupSourceNode(primaryTier);
                    session = this.backupServiceHelper.ensureSessionStartedOn(primaryNode, "setUserSourceConfiguration", true);
                    this.xmlOperationDAO.setBackupSourceConfiguration(sourceConfig, sourceType);
                } else {
                    logger.warn("Ignoring update request for SASTiers as primary tier not found");
                }
            }
            finally {
                try {
                    if (session != null) {
                        this.sessionManager.endSession(session, "setUserSourceConfiguration", false);
                        this.backupServiceHelper.deleteTempDirectory();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            if (this.updateLock != null) {
                this.updateLock.unlock();
            }
        }
    }

    public SASTiers getSASTiers() throws BackupException {
        logger.debug("NotFoundInCache! Entering getSASTiers()");
        return this.getSASTiersActual();
    }

    private SASTiers getSASTiersActual() throws BackupException {
        SASEnvironment env;
        List lstTiers;
        List<SASTierProxy> lstTierProxy;
        SASTiers tiers = null;
        tiers = this.xmlOperationDAO.getSASTiers();
        if (tiers == null && (lstTierProxy = this.configBeanConverter.sasTierListToProxyList(lstTiers = (env = this.deploymentDiscoveryService.discover()).getSasTiers())) != null && lstTierProxy.size() > 0) {
            tiers = new SASTiers();
            tiers.setSasTiers(lstTierProxy);
            Object offlineWorkflowPhaseEnabled = WorkflowStateHolder.getProperty((String)WorkflowStateHolder.IS_OFFLINE_RECOVERY_INITIAL_PHASE_ENABLED);
            if (offlineWorkflowPhaseEnabled != null && ((Boolean)offlineWorkflowPhaseEnabled).booleanValue()) {
                this.setSASTiersLocal(tiers);
            } else {
                this.setSASTiers(tiers);
            }
            UserSourceConfiguration configDirConfiguration = new UserSourceConfiguration();
            ArrayList<ConfigurableServerProxy> serverProxies = new ArrayList<ConfigurableServerProxy>();
            for (SASTierProxy sasTierProxy : lstTierProxy) {
                ConfigurableServerProxy proxy = this.configBeanConverter.sasTierProxyToUserConfigDir(sasTierProxy);
                List<String> includes = this.getIncludes(sasTierProxy);
                if (includes == null || includes.isEmpty()) continue;
                ConfigurationFilter filter = new ConfigurationFilter();
                filter.setIncludes(includes);
                proxy.setFilter(filter);
                serverProxies.add(proxy);
            }
            configDirConfiguration.setConfigurableServers(serverProxies);
            if (offlineWorkflowPhaseEnabled != null && ((Boolean)offlineWorkflowPhaseEnabled).booleanValue()) {
                this.setSourceConfigurationLocal(configDirConfiguration, BackupSourceConfig.BackupSource.CONFIGDIR);
            } else {
                this.setSourceConfiguration(configDirConfiguration, BackupSourceConfig.BackupSource.CONFIGDIR);
            }
        }
        if (tiers == null) {
            tiers = new SASTiers();
            tiers.setSasTiers(new ArrayList());
        }
        return tiers;
    }

    private List<String> getIncludes(SASTierProxy sasTierProxy) {
        ArrayList<String> includes = new ArrayList<String>();
        SASTier sasTier = this.configBeanConverter.proxyToSASTier(sasTierProxy);
        List sasAppServers = this.deploymentDiscoveryService.getConfigurableServers(DeploymentDiscoveryDAO.ComponentType.SAS_APP_SERVER, sasTier);
        for (ConfigurableServer configurableServer : sasAppServers) {
            String sasAppServerPath = configurableServer.getConfigurablePath();
            if (sasAppServerPath == null) continue;
            includes.add(sasAppServerPath + "/Data");
            includes.add(sasAppServerPath + "/SASEnvironment");
        }
        return includes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSASTiers(SASTiers sasTiers) throws BackupException {
        logger.debug("Geode Cache need to be refreshed. Reason: setSASTiers(" + sasTiers + ")");
        try {
            if (this.updateLock != null) {
                this.updateLock.lock();
            }
            BackupServiceSession session = null;
            try {
                SASTier primaryTier = this.getPrimaryMDTier();
                if (primaryTier != null) {
                    BackupSourceNode primaryNode = this.configBeanConverter.sasTierToBackupSourceNode(primaryTier);
                    session = this.backupServiceHelper.ensureSessionStartedOn(primaryNode, "setSASTiers", true);
                    this.xmlOperationDAO.setSASTiers(sasTiers);
                } else {
                    logger.warn("Ignoring update request for SASTiers as primary tier not found");
                }
            }
            finally {
                try {
                    if (session != null) {
                        this.sessionManager.endSession(session, "setSASTiers", false);
                        this.backupServiceHelper.deleteTempDirectory();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            if (this.updateLock != null) {
                this.updateLock.unlock();
            }
        }
    }

    public void setSASTiersLocal(SASTiers sasTiers) {
        logger.debug("Inside setSASTiersLocal()");
        try {
            this.xmlOperationDAO.setSASTiers(sasTiers);
        }
        catch (Exception e) {
            logger.warn("Unable to write SASTiers file locally for offline recovery", (Throwable)e);
        }
    }

    public ConfigurationFilter getConfigurationFilter(ConfigurableServer server, BackupSourceConfig.BackupSource source) {
        if (server != null) {
            logger.debug("NotFoundInCache! Entering getConfigurationFilter(" + server + ", " + source + ")");
            return this.getConfigurationFilterActual(server, source);
        }
        return null;
    }

    private ConfigurationFilter getConfigurationFilterActual(ConfigurableServer server, BackupSourceConfig.BackupSource source) {
        ConfigurableServerProxy proxy = this.getUserConfigurationActual(server, source);
        if (proxy != null) {
            return proxy.getFilter();
        }
        return null;
    }

    public ConfigurableServerProxy getUserConfiguration(ConfigurableServer server, BackupSourceConfig.BackupSource source) {
        logger.debug("NotFoundInCache! Entering getUserConfiguration(" + server + ", " + source + ")");
        return this.getUserConfigurationActual(server, source);
    }

    private ConfigurableServerProxy getUserConfigurationActual(ConfigurableServer server, BackupSourceConfig.BackupSource source) {
        if (server != null) {
            int index;
            List userConfigs;
            ConfigurableServerProxy proxy = this.configBeanConverter.serverToProxy(server);
            UserSourceConfiguration configuration = this.getSourceConfigActual(source);
            if (configuration != null && (userConfigs = configuration.getConfigurableServers()) != null && (index = userConfigs.indexOf(proxy)) != -1) {
                return (ConfigurableServerProxy)userConfigs.get(index);
            }
        }
        return null;
    }

    public List<SASTier> getExcludedSASTiersActual() {
        SASTiers sasTiers = this.getSASTiersActual();
        ArrayList<SASTier> excludedProxies = null;
        List proxyTier = sasTiers.getSasTiers();
        if (proxyTier != null && proxyTier.size() > 0) {
            excludedProxies = new ArrayList<SASTier>(proxyTier.size());
            for (SASTierProxy servicetier : proxyTier) {
                if (servicetier.isIncluded() == null || servicetier.isIncluded().booleanValue()) continue;
                SASTier tierdata = this.configBeanConverter.proxyToSASTier(servicetier);
                excludedProxies.add(tierdata);
            }
        }
        if (excludedProxies != null && excludedProxies.size() > 0) {
            logger.debug("getExcludedSASTiersActual() Excluded Tiers size: " + excludedProxies.size());
            for (SASTier sasTier : excludedProxies) {
                logger.debug("getExcludedSASTiersActual() Excluded Tier = " + sasTier.getTierName() + "  , " + sasTier.getHostName() + " , " + sasTier.getTierHost().getHostName());
            }
        }
        return excludedProxies.size() <= 0 ? Collections.EMPTY_LIST : excludedProxies;
    }

    public UserSourceConfiguration getMergedConfiguration(BackupSourceConfig.BackupSource sourceType) {
        logger.debug("NotFoundInCache! Entering getMergedConfiguration(" + sourceType + ")");
        return this.getMergedConfigurationActual(sourceType);
    }

    private UserSourceConfiguration getMergedConfigurationActual(BackupSourceConfig.BackupSource sourceType) {
        UserSourceConfiguration configuration = null;
        List<Object> lstProxyServer = new ArrayList();
        if (sourceType.equals((Object)BackupSourceConfig.BackupSource.CONFIGDIR)) {
            SASTiers SASTier2 = this.getSASTiersActual();
            if (SASTier2 != null) {
                lstProxyServer = this.configurationMergeManager.mergeConfigDirectories(SASTier2.getSasTiers());
            }
        } else {
            lstProxyServer = this.configurationMergeManager.mergeServers(sourceType);
        }
        if (lstProxyServer != null && lstProxyServer.size() > 0) {
            configuration = new UserSourceConfiguration();
            configuration.setConfigurableServers(lstProxyServer);
            configuration.setSourceType(sourceType.getDisplayName());
        }
        return configuration;
    }

    private String getSASTierIdActual(SASTier sasTier) {
        List sastierProxies;
        SASTiers sastiers = this.getSASTiersActual();
        if (sastiers != null && (sastierProxies = sastiers.getSasTiers()) != null) {
            for (SASTierProxy proxy : sastierProxies) {
                if (!proxy.getTierHost().getHostName().equals(sasTier.getHostName()) || !proxy.getSasConfig().equals(sasTier.getSasConfig())) continue;
                return proxy.getTierName();
            }
        }
        return null;
    }

    private SASTierProxy getSASTierByIdActual(String tierId) {
        List sastierProxies;
        SASTiers sastiers = this.getSASTiersActual();
        if (sastiers != null && (sastierProxies = sastiers.getSasTiers()) != null) {
            for (SASTierProxy proxy : sastierProxies) {
                if (!proxy.getTierName().equals(tierId)) continue;
                return proxy;
            }
        }
        return null;
    }

    public boolean isCanonicalExclude(ConfigurableServer server, BackupSourceConfig.BackupSource source) {
        logger.debug("NotFoundInCache! Entering isCanonicalExclude(" + server + ", " + source + ")");
        return this.isCanonicalExcludeActual(server, source);
    }

    private boolean isCanonicalExcludeActual(ConfigurableServer server, BackupSourceConfig.BackupSource source) {
        SASTier sasTier = server.getSasTier();
        if (this.getExcludedSASTiersActual().contains(sasTier)) {
            return true;
        }
        return this.isExcludedActual(server, source);
    }

    public SASTier getUserConfigSASTier(ConfigurableServer server, BackupSourceConfig.BackupSource source) {
        logger.debug("NotFoundInCache! Entering getUserConfigSASTier(" + server + ", " + source + ")");
        return this.getUserConfigSASTierActual(server, source);
    }

    private SASTier getUserConfigSASTierActual(ConfigurableServer server, BackupSourceConfig.BackupSource source) {
        ConfigurableServerProxy userConfig = this.getUserConfigurationActual(server, source);
        SASTier sasTier = null;
        if (userConfig != null) {
            String tierId = userConfig.getSasTierId();
            SASTierProxy tierProxy = this.getSASTierByIdActual(tierId);
            sasTier = this.deploymentDiscoveryService.getSASTier(tierProxy.getTierHost().getHostName(), tierProxy.getSasConfig());
        }
        return sasTier;
    }

    public boolean isExcluded(ConfigurableServer server, BackupSourceConfig.BackupSource source) {
        logger.debug("NotFoundInCache! Entering isExcluded(" + server + ", " + source + ")");
        return this.isExcludedActual(server, source);
    }

    private boolean isExcludedActual(ConfigurableServer server, BackupSourceConfig.BackupSource source) {
        List userConfigServers;
        UserSourceConfiguration config = this.getSourceConfigActual(source);
        if (config != null && (userConfigServers = config.getConfigurableServers()) != null) {
            for (ConfigurableServerProxy userver : userConfigServers) {
                ConfigurableServerProxy serverTobeChecked = this.configBeanConverter.serverToProxy(server);
                if (!serverTobeChecked.equals((Object)userver) || userver.isIncluded().booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public List<ConfigurableServer> getConfigurableServers(BackupSourceConfig.BackupSource sourceType) {
        logger.debug("NotFoundInCache! Entering getConfigurableServers(" + sourceType + ")");
        return this.getConfigurableServersActual(sourceType);
    }

    private List<ConfigurableServer> getConfigurableServersActual(BackupSourceConfig.BackupSource sourceType) {
        List<ConfigurableServer> dbServers = this.getConfigurableServersfor(sourceType);
        for (ConfigurableServer server : dbServers) {
            SASTier sasTier = this.getUserConfigSASTierActual(server, sourceType);
            if (sasTier != null) {
                if (server.getSasTier() != null) {
                    logger.warn("Discovered sas tier " + server.getSasTier() + " is overridden by user specified sas tier " + sasTier);
                    server.setSasTier(sasTier);
                    continue;
                }
                server.setSasTier(sasTier);
                continue;
            }
            SASTier tier = server.getSasTier();
            if (tier == null) continue;
            tier.setTierName(this.getSASTierIdActual(tier));
            logger.info("Setting sas tier name : " + tier.getTierName());
        }
        return dbServers;
    }

    public List<ConfigurableServer> getConfigurableServers(BackupSourceConfig.BackupSource sourceType, SASTier tier) {
        if (tier != null) {
            logger.debug("NotFoundInCache! Entering getConfigurableServers(" + sourceType + "," + tier + ")");
            return this.getConfigurableServersActual(sourceType, tier);
        }
        return null;
    }

    private List<ConfigurableServer> getConfigurableServersActual(BackupSourceConfig.BackupSource sourceType, SASTier tier) {
        ArrayList<ConfigurableServer> filtered = null;
        List<ConfigurableServer> dbServers = this.getConfigurableServersActual(sourceType);
        filtered = new ArrayList<ConfigurableServer>();
        for (ConfigurableServer server : dbServers) {
            SASTier sasTier = server.getSasTier();
            if (!tier.equals((Object)sasTier)) continue;
            filtered.add(server);
        }
        return filtered;
    }

    public List<ConfigurableServerProxy> getConfigurableServerForTier(BackupSourceConfig.BackupSource sourceType, SASTier tier) {
        if (tier != null) {
            logger.debug("NotFoundInCache! Entering getConfigurableServerForTier(" + sourceType + ", " + tier + ")");
            return this.getConfigurableServerForTierActual(sourceType, tier);
        }
        return null;
    }

    private List<ConfigurableServerProxy> getConfigurableServerForTierActual(BackupSourceConfig.BackupSource sourceType, SASTier tier) {
        List lstProxy;
        ArrayList<ConfigurableServerProxy> ConfigurableServer2 = null;
        UserSourceConfiguration configuration = this.getSourceConfigActual(sourceType);
        if (configuration != null && (lstProxy = configuration.getConfigurableServers()) != null & lstProxy.size() > 0) {
            ConfigurableServer2 = new ArrayList<ConfigurableServerProxy>(lstProxy.size());
            for (ConfigurableServerProxy proxy : lstProxy) {
                if (!proxy.getSasTierId().equalsIgnoreCase(tier.getTierName())) continue;
                ConfigurableServer2.add(proxy);
            }
        }
        return ConfigurableServer2;
    }

    private List<ConfigurableServer> getConfigurableServersfor(BackupSourceConfig.BackupSource sourceType) {
        DeploymentDiscoveryDAO.ComponentType[] types = sourceType.getComponentTypes();
        ArrayList servers = null;
        List tservers = null;
        if (types != null) {
            servers = new ArrayList();
            for (DeploymentDiscoveryDAO.ComponentType type : types) {
                tservers = this.deploymentDiscoveryService.getConfigurableServers(type);
                if (tservers == null) continue;
                servers.addAll(tservers);
            }
        }
        return servers;
    }
}

