/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.spi;

import com.sas.solstice.platform.core.access.IResults;
import com.sas.svcs.backup.client.BackupServiceSession;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.BackupSourceNode;
import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.BackupServerContext;
import com.sas.svcs.backup.dao.BackupServerHelperDAO;
import com.sas.svcs.backup.dao.ConfigBeanConverter;
import com.sas.svcs.backup.dao.DeploymentAgentClient;
import com.sas.svcs.backup.dao.DeploymentBackupConfiguration;
import com.sas.svcs.backup.dao.OMRDeploymentBackupConfiguration;
import com.sas.svcs.deployment.data.SASTier;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class SessionManager {
    @Autowired
    private BackupServerHelperDAO helperDAO;
    private Logger logger = LogManager.getLogger(SessionManager.class);
    @Autowired
    @Qualifier(value="DeploymentBackupConfiguration")
    private DeploymentBackupConfiguration configuration;
    @Autowired
    ConfigBeanConverter configBeanConverter;
    private static final String SAS_TIERS_XML = "SASTiers.xml";
    private static final List<String> FILES_TO_BE_SYNCHRONIZED = new ArrayList<String>();
    private boolean immutableSessionStarted = false;
    BackupServiceSession session = null;

    public BackupServiceSession<?> getSession() {
        return this.session;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean startImmutableSession(Set<BackupSourceNode> backupServerNodes, String operation) throws BackupException {
        if (!this.isImmutableSessionStarted()) {
            String sessionId = SessionManager.createSessionId();
            BackupServiceSession session = new BackupServiceSession(sessionId, operation);
            this.logger.info("startImmutableSession() for operation : " + operation + " with immutable session. sessionId = " + session.getSessionId());
            try {
                if (backupServerNodes == null || backupServerNodes == null) return this.isImmutableSessionStarted();
                for (BackupSourceNode node : backupServerNodes) {
                    this.immutableSessionStarted = this.startImmutableSessionOn(node, session, operation);
                }
                return this.isImmutableSessionStarted();
            }
            catch (BackupException e) {
                this.logger.error("Error while starting the immutable service session ");
                this.resetImmutableSession();
                throw e;
            }
            catch (Exception exception) {
                this.logger.error("Error while starting the immutable service session ");
                this.resetImmutableSession();
                throw new BackupException("Failed to start immutable session.", (Throwable)exception, BackupErrorConstants.ErrorCodes.ERROR_CODE_SESSION_START_FAILED.getErrorCode());
            }
        } else if (this.immutableSessionStarted) {
            this.logger.info("An immutable session already started.");
            return this.isImmutableSessionStarted();
        } else {
            this.logger.info("startImmutableSession() Session already running with id: " + this.session.getSessionId());
        }
        return this.isImmutableSessionStarted();
    }

    public boolean startImmutableSessionOn(BackupSourceNode node, BackupServiceSession<?> session, String operation) {
        boolean sessionStarted = true;
        if (this.isImmutableSessionStarted()) {
            this.logger.debug("startImmutableSessionOn() Immutable session is already running");
            return true;
        }
        if (this.configuration.isBackupServerAlreadyConfigured(node)) {
            this.logger.debug("Backupserver found configured. Sending session start event to backup server node : " + node.getHostName());
            this.helperDAO.initSessionStart(node, operation, session, true);
            if (node.isPrimary()) {
                this.logger.debug("Starting immutable session as node is primary");
                this.immutableSessionStarted = sessionStarted = this.syncBackupServerForStartSession(node, session, operation);
            } else {
                this.logger.debug("Immutable session not started as node isn't primary");
            }
        } else {
            this.logger.debug("Immutable session not started as backup server is not configured on this node");
        }
        return sessionStarted;
    }

    public boolean startImmutableSessionOn(SASTier tier, BackupServiceSession<?> session, String operation) {
        BackupSourceNode node = this.configBeanConverter.sasTierToBackupSourceNode(tier);
        return this.startImmutableSessionOn(node, session, operation);
    }

    public void resetSession() {
        this.resetImmutableSession();
        this.logger.info("resetting the session");
        this.session = null;
    }

    public void resetImmutableSession() {
        this.logger.info("resetting the immutable session ");
        this.immutableSessionStarted = false;
    }

    public <T> BackupServiceSession<T> startSession(Set<BackupSourceNode> backupServerNodes, String operation) throws BackupException {
        return this.startSession(backupServerNodes, operation, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> BackupServiceSession<T> startSession(Set<BackupSourceNode> backupServerNodes, String operation, boolean pullConfigFiles) throws BackupException {
        String sessionId;
        String string = sessionId = this.session == null ? null : this.session.getSessionId();
        if (!this.isSessionAlreadyRunning()) {
            sessionId = SessionManager.createSessionId();
            this.session = new BackupServiceSession(sessionId, operation);
            boolean sessionStarted = true;
            this.session.setActiveNodes(backupServerNodes);
            this.logger.info("Starting a session for operation : " + operation + " with session id " + sessionId);
            try {
                if (backupServerNodes == null) return this.session;
                if (backupServerNodes != null) {
                    for (BackupSourceNode node : backupServerNodes) {
                        if (!this.configuration.isBackupServerAlreadyConfigured(node)) continue;
                        this.logger.info("Sending session start event to backup server node : " + node.getHostName());
                        this.helperDAO.initSessionStart(node, operation, this.session);
                        if (!node.isPrimary() || !pullConfigFiles) continue;
                        sessionStarted = this.syncBackupServerForStartSession(node, this.session, operation) && sessionStarted;
                    }
                }
                if (!sessionStarted) return this.session;
                this.session.setState(BackupServiceSession.State.RUNNING);
                return this.session;
            }
            catch (BackupException e) {
                this.session.setState(BackupServiceSession.State.FAILED_TO_START);
                this.logger.error("Error while starting the session : " + sessionId);
                this.resetSession();
                throw e;
            }
            catch (Exception exception) {
                this.session.setState(BackupServiceSession.State.FAILED_TO_START);
                this.logger.error("Error while starting the session : " + sessionId);
                this.resetSession();
                throw new BackupException((Throwable)exception, BackupErrorConstants.ErrorCodes.ERROR_CODE_SESSION_START_FAILED.getErrorCode());
            }
        } else {
            this.logger.info("startSession() Session already running with id: " + sessionId);
            return null;
        }
    }

    public <T> BackupServiceSession<T> startSessionOn(BackupSourceNode node, String operation, boolean pullConfigFiles) {
        String sessionId;
        boolean sessionStarted = true;
        String string = sessionId = this.session == null ? null : this.session.getSessionId();
        if (!this.isSessionAlreadyRunning()) {
            sessionId = SessionManager.createSessionId();
            this.session = new BackupServiceSession(sessionId, operation);
            this.logger.debug("startSessionOn() sessionId = " + sessionId + "  , pullConfigFiles = " + pullConfigFiles);
            HashSet<BackupSourceNode> activeNode = new HashSet<BackupSourceNode>();
            activeNode.add(node);
            this.session.setActiveNodes(activeNode);
            if (this.configuration.isBackupServerAlreadyConfigured(node)) {
                this.logger.info("Sending session start event to backup server node : " + node.getHostName());
                this.helperDAO.initSessionStart(node, operation, this.session);
                if (node.isPrimary() && pullConfigFiles) {
                    sessionStarted = this.syncBackupServerForStartSession(node, this.session, operation) && sessionStarted;
                }
            }
        } else {
            this.logger.info("startSessionOn() Session already running with id: " + sessionId);
            return null;
        }
        return this.session;
    }

    public static String createSessionId() {
        Date currentDate = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH_mm_ss");
        return formatter.format(currentDate);
    }

    public boolean isSessionAlreadyRunning() {
        boolean sessionAlreadyRunnig;
        boolean bl = sessionAlreadyRunnig = this.session != null;
        if (sessionAlreadyRunnig) {
            this.logger.debug("isSessionAlreadyRunning() = true. For sessionId =  " + this.session.getSessionId());
        }
        return sessionAlreadyRunnig;
    }

    private boolean syncBackupServerForStartSession(BackupSourceNode node, BackupServiceSession<?> session, String operationName) throws BackupException {
        boolean syncBackSurverSuccessful = true;
        String dropZoneConfigSubdir = null;
        BackupServerContext context = null;
        String hostName = null;
        hostName = node.getHostName();
        context = BackupServerContext.getInstance((OMRDeploymentBackupConfiguration)this.configuration, node);
        dropZoneConfigSubdir = context.getBackupDropZone() + "/" + "config";
        this.logger.info("Pulling files from : " + node.getHostName() + " : " + dropZoneConfigSubdir);
        syncBackSurverSuccessful = this.callDAtoMoveFile(dropZoneConfigSubdir, this.configuration.getAppHomePath(), hostName, "pullFolder");
        return syncBackSurverSuccessful;
    }

    private boolean syncBackupServerForEndSession(BackupSourceNode node, BackupServiceSession<?> session, String operationName) throws BackupException {
        boolean syncBackSurverSuccessful = true;
        String dropZoneFile = null;
        BackupServerContext context = null;
        String hostName = null;
        hostName = node.getHostName();
        context = BackupServerContext.getInstance((OMRDeploymentBackupConfiguration)this.configuration, node);
        String appHome = this.configuration.getAppHomePath();
        for (String fileTobeMoved : FILES_TO_BE_SYNCHRONIZED) {
            String appHomeFile = appHome + "/" + fileTobeMoved;
            if (!new File(appHomeFile).exists()) continue;
            dropZoneFile = context.getBackupDropZone() + "/" + "config" + "/" + fileTobeMoved;
            syncBackSurverSuccessful = this.callDAtoMoveFile(appHomeFile, dropZoneFile, hostName, "copyFile") && syncBackSurverSuccessful;
        }
        return syncBackSurverSuccessful;
    }

    public boolean callDAtoMoveFile(String source, String dest, String host, String operation) {
        boolean syncBackSurverSuccessful;
        String[] paramsGetResult = new String[]{operation, host, source, dest};
        this.logger.debug("Trying to copy " + source + " at location " + dest);
        IResults copyResult = DeploymentAgentClient.handleArgLine(paramsGetResult, paramsGetResult);
        boolean bl = syncBackSurverSuccessful = copyResult.getStatus() == 0;
        if (!syncBackSurverSuccessful) {
            this.logger.error("An error occurred while copying the  " + source);
        } else {
            this.logger.debug(source + " copied at " + dest);
        }
        return syncBackSurverSuccessful;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean endSession(BackupServiceSession<?> session, String operationName, boolean onlySync) throws BackupException {
        if (session == null) return true;
        String operation = session.getOperationName();
        if (operationName != null && operationName.equalsIgnoreCase(operation)) {
            if (onlySync) {
                this.logger.info("Synchronizing session which was started by operation " + operation);
            } else {
                this.logger.info("Ending session which was started by operation " + operation);
            }
            try {
                Set sourceNodes = session.getActiveNodes();
                this.logger.debug("SourceNodes during endsession:" + sourceNodes);
                if (sourceNodes == null || sourceNodes == null) return true;
                for (BackupSourceNode node : sourceNodes) {
                    if (!this.configuration.isBackupServerAlreadyConfigured(node)) continue;
                    if (node.isPrimary()) {
                        this.syncBackupServerForEndSession(node, session, operationName);
                    }
                    this.helperDAO.initSessionEnd(node, operation, session, onlySync);
                }
                return true;
            }
            catch (BackupException e) {
                session.setState(BackupServiceSession.State.FAILED_TO_END);
                throw e;
            }
            catch (Exception exception) {
                session.setState(BackupServiceSession.State.FAILED_TO_END);
                throw new BackupException((Throwable)exception, BackupErrorConstants.ErrorCodes.ERROR_CODE_SESSION_END_FAILED.getErrorCode());
            }
            finally {
                if (!onlySync) {
                    session.setState(BackupServiceSession.State.ENDED);
                    this.resetSession();
                }
            }
        } else {
            this.logger.warn("Unable to end session " + session + " because it was started by another operation which is " + operation + " and session end requested by " + operationName);
        }
        return true;
    }

    public boolean isImmutableSessionStarted() {
        return this.immutableSessionStarted || this.isSessionAlreadyRunning();
    }

    public <T> BackupServiceSession<T> getMockSession(String operationName) {
        String sessionId = SessionManager.createSessionId();
        this.logger.info("Creating a mock session for operation : " + operationName + " with session id " + sessionId);
        BackupServiceSession session = new BackupServiceSession(sessionId, operationName);
        return session;
    }

    static {
        FILES_TO_BE_SYNCHRONIZED.add("BackupHistory.xml");
        FILES_TO_BE_SYNCHRONIZED.add("BackupConfiguration.xml");
        for (BackupSourceConfig.BackupSource backupSource : BackupSourceConfig.BackupSource.values()) {
            FILES_TO_BE_SYNCHRONIZED.add(backupSource.toString() + ".xml");
        }
        FILES_TO_BE_SYNCHRONIZED.add(SAS_TIERS_XML);
    }
}

