/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.spi;

import com.sas.svcs.backup.analyze.BackupTask;
import com.sas.svcs.backup.analyze.model.RuntimeSASEnvironment;
import com.sas.svcs.backup.client.BackupOptions;
import com.sas.svcs.backup.client.BackupServiceSession;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.BackupSourceDetails;
import com.sas.svcs.backup.client.BackupSourceEntryDetails;
import com.sas.svcs.backup.client.BackupSourceInstanceDetails;
import com.sas.svcs.backup.client.OperationDetails;
import com.sas.svcs.backup.client.RecoveryOptions;
import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.BackupServerHelperDAO;
import com.sas.svcs.backup.dao.OMRDeploymentBackupConfiguration;
import com.sas.svcs.backup.dao.OSUtils;
import com.sas.svcs.backup.spi.AbstractBackupSupportService;
import com.sas.svcs.backup.spi.RB;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="DATABASE")
public class PostgresBackupSupportService
extends AbstractBackupSupportService {
    private static final Logger logger = LogManager.getLogger(PostgresBackupSupportService.class);
    public static final String INSTANCES_DBNAME_SPERATOR = "@";
    @Autowired
    @Qualifier(value="BackupServerHelperDAO")
    BackupServerHelperDAO helperDAO;
    @Autowired
    @Qualifier(value="DeploymentBackupConfiguration")
    private OMRDeploymentBackupConfiguration backupConfigComponent;

    @Override
    public BackupSourceDetails doSourceBackup(RuntimeSASEnvironment runtimeSASEnvironment, BackupTask backupTask, BackupOptions backupOptions, BackupServiceSession<?> session) throws BackupException {
        BackupSourceDetails srcBackupDetails = null;
        try {
            logger.info(RB.getStringResource("PostgresBackupSupportService.starting.postgres.backup.txt"));
            LinkedHashMap<String, String> optionalProps = new LinkedHashMap<String, String>();
            String osType = backupTask.getPerformOn().getTierHost().getHostType();
            Properties properties = backupTask.getProperties();
            optionalProps.put("-host", properties.getProperty("host"));
            optionalProps.put("-dbconnecturl", this.getQuotedString(properties.getProperty("connecturl"), osType));
            srcBackupDetails = this.helperDAO.backup(runtimeSASEnvironment, backupTask, session, optionalProps, BackupErrorConstants.ErrorCodes.ERROR_CODE_DB_BACKUP_FAILED);
            logger.info(RB.getStringResource("PostgresBackupSupportService.pg.backup.completed.txt"));
        }
        catch (BackupException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BackupException((Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_DB_BACKUP_FAILED.getErrorCode());
        }
        return srcBackupDetails;
    }

    @Override
    public BackupSourceDetails doSourceRecovery(String backupId, RecoveryOptions recoveryOptions, BackupSourceDetails sourceBackup, BackupServiceSession session) throws BackupException {
        BackupSourceDetails sourceRecovery = null;
        try {
            logger.info(RB.getStringResource("PostgresBackupSupportService.pg.recovery.starting.txt"));
            LinkedHashMap<String, String> optionalProps = new LinkedHashMap<String, String>();
            String osType = sourceBackup.getSourceConfig().getBackupSourceNode().getOsType();
            StringBuilder dbNamesList = new StringBuilder("");
            Map instanceDetails = sourceBackup.getSourceInstances();
            Set keys = instanceDetails.keySet();
            for (String key : keys) {
                BackupSourceInstanceDetails instanceDetail = (BackupSourceInstanceDetails)instanceDetails.get(key);
                List sourceEntries = instanceDetail.getSourceEntries();
                for (BackupSourceEntryDetails sourceEntry : sourceEntries) {
                    if (OperationDetails.OperationStatus.SUCCESS.equals((Object)sourceEntry.getStatus()) && !dbNamesList.toString().isEmpty()) {
                        dbNamesList.append(",");
                    }
                    dbNamesList.append(instanceDetail.getInstanceName() + INSTANCES_DBNAME_SPERATOR + sourceEntry.getName());
                }
            }
            optionalProps.put("-dbconnecturl", this.getQuotedString(sourceBackup.getSourceConfig().getProperties().getProperty("connecturl"), osType));
            optionalProps.put("-backupid", backupId);
            optionalProps.put("-host", sourceBackup.getSourceConfig().getProperties().getProperty("host"));
            optionalProps.put("-pgdatabaselist", this.getQuotedString(dbNamesList.toString(), osType));
            sourceRecovery = this.helperDAO.recover(sourceBackup, session, optionalProps, BackupErrorConstants.ErrorCodes.ERROR_CODE_DB_RECOVERY_FAILED);
            logger.info(RB.getStringResource("PostgresBackupSupportService.pg.recovery.completed.txt"));
        }
        catch (BackupException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BackupException((Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_DB_RECOVERY_FAILED.getErrorCode());
        }
        return sourceRecovery;
    }

    @Override
    public Map<String, List<String>> getContentDetails(BackupSourceConfig sourceConfig, String operationName, BackupServiceSession session) throws BackupException {
        Map<String, List<String>> contentDetails = null;
        try {
            contentDetails = super.getContentDetails(sourceConfig, operationName, session);
            this.getPGContentsDetails(contentDetails, this.sourceDetailsLoc);
        }
        catch (BackupException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BackupException("Error encountered while trying to fetch database backup content details. ", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONTENT_DETAILS_FAILED.getErrorCode());
        }
        return contentDetails;
    }

    private void getPGContentsDetails(Map<String, List<String>> contentDetails, String sourceDetailsLoc) throws BackupException {
        File PGLogFile = new File(sourceDetailsLoc);
        BufferedReader SCSLogBR = null;
        try {
            if (PGLogFile.exists()) {
                SCSLogBR = new BufferedReader(new FileReader(PGLogFile));
                int lineNo = 0;
                String dirName = "";
                RB.getStringResource("PostgresBackupSupportService.backupcontentslist.title.database.contents.txt");
                ArrayList<String> filesList = null;
                String line = null;
                while ((line = SCSLogBR.readLine()) != null) {
                    String[] tempArray;
                    if (line.contains("Database Name")) {
                        if (!dirName.equals("")) {
                            contentDetails.put(dirName, filesList);
                            filesList = null;
                        }
                        if ((tempArray = line.split("Database Name :")).length == 2) {
                            dirName = tempArray[1];
                        }
                    }
                    if (line.contains("dumping contents") && (tempArray = line.split("of")).length == 2) {
                        String PGContentDetail = tempArray[1];
                        if (filesList == null) {
                            filesList = new ArrayList<String>();
                        }
                        filesList.add(PGContentDetail);
                    }
                    ++lineNo;
                }
                contentDetails.put(dirName, filesList);
            }
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage());
            throw new BackupException("Error encountered while trying to fetch database backup contents.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONTENT_DETAILS_FAILED.getErrorCode());
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw new BackupException("Error encountered while trying to fetch database backup contents.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONTENT_DETAILS_FAILED.getErrorCode());
        }
        finally {
            if (SCSLogBR != null) {
                try {
                    SCSLogBR.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private String getQuotedString(String str, String osType) throws BackupException {
        String osFamily = OSUtils.getOSFamily(osType);
        if (str != null && str.contains(" ") && osFamily.equalsIgnoreCase("Windows")) {
            str = "\"" + str + "\"";
        }
        return str;
    }

    @Override
    public String getContentFilePath() {
        String contentFilePath = "backup/Database/Database.log";
        return contentFilePath;
    }
}

