/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.spi;

import com.sas.metadata.remote.MdException;
import com.sas.svcs.backup.analyze.BackupJob;
import com.sas.svcs.backup.analyze.BackupTask;
import com.sas.svcs.backup.analyze.model.AnalysisResult;
import com.sas.svcs.backup.analyze.model.RuntimeSASEnvironment;
import com.sas.svcs.backup.client.BackupConfiguration;
import com.sas.svcs.backup.client.BackupDetails;
import com.sas.svcs.backup.client.BackupOptions;
import com.sas.svcs.backup.client.BackupServiceSession;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.BackupSourceDetails;
import com.sas.svcs.backup.client.BackupSourceNode;
import com.sas.svcs.backup.client.OperationDetails;
import com.sas.svcs.backup.client.RecoveryDetails;
import com.sas.svcs.backup.client.RecoveryOptions;
import com.sas.svcs.backup.client.ServerSideBackupArchiveResult;
import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.BackupNodeHelper;
import com.sas.svcs.backup.dao.BackupServerHelperDAO;
import com.sas.svcs.backup.dao.ConfigBeanConverter;
import com.sas.svcs.backup.dao.XMLOperationDAO;
import com.sas.svcs.backup.spi.BackupServiceHelper;
import com.sas.svcs.backup.spi.BackupSupportService;
import com.sas.svcs.backup.spi.BackupSupportServiceProxy;
import com.sas.svcs.backup.spi.ContentServerBackupSupportService;
import com.sas.svcs.backup.spi.RB;
import com.sas.svcs.backup.spi.SessionManager;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Service;

@Service(value="BackupSupportServiceProxy")
public class BackupSupportServiceProxyImpl
implements BackupSupportServiceProxy {
    Logger logger = LogManager.getLogger(BackupSupportServiceProxyImpl.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="XMLOperationDAO")
    private XMLOperationDAO xmlOperationDAO;
    @Autowired
    @Qualifier(value="BackupServerHelperDAO")
    BackupServerHelperDAO backupServerHelperDAO;
    @Autowired
    ConfigBeanConverter configBeanConverter;
    @Autowired
    BackupServiceHelper helper;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private BackupNodeHelper nodeHelper;
    @Autowired
    private ContentServerBackupSupportService contentServerBackupSupportService;

    private BackupSupportService getService(BackupSourceConfig.BackupSource sourceType) {
        String type = sourceType.name();
        if (null == type) {
            throw new RuntimeException(Message.format((String)RB.getStringResource("BackupSupportServiceProxyImpl.sourcetype.not.found.fmt"), (Object)sourceType));
        }
        BackupSupportService service = null;
        try {
            service = (BackupSupportService)this.applicationContext.getBean(type, BackupSupportService.class);
        }
        catch (BeansException beansException) {
            // empty catch block
        }
        if (service == null) {
            service = (BackupSupportService)this.applicationContext.getBean("DefaultBackup", BackupSupportService.class);
        }
        return service;
    }

    public Map<String, List<String>> getContentDetails(BackupSourceConfig sourceConfig, String operationName, BackupServiceSession session) throws BackupException {
        Map<String, List<String>> contentDetails = null;
        try {
            if (sourceConfig != null) {
                BackupSourceConfig.BackupSource bkupSourceType = sourceConfig.getSourceType();
                BackupSupportService supportService = this.getService(bkupSourceType);
                contentDetails = supportService.getContentDetails(sourceConfig, operationName, session);
            }
        }
        catch (BackupException e) {
            this.processContentDetailsException(e, session);
        }
        catch (Throwable t) {
            BackupException e = new BackupException("Error encountered while trying to fetch backup contents for " + sourceConfig.getSourceType(), t, BackupErrorConstants.ErrorCodes.ERROR_CODE_UNKNOWN.getErrorCode());
            this.processContentDetailsException(e, session);
        }
        return contentDetails;
    }

    private void processContentDetailsException(BackupException e, BackupServiceSession<?> session) {
        this.helper.addOperationType(e, "gethistory");
        this.helper.addToSession(session, e);
        throw e;
    }

    @Override
    @Async
    public Future<BackupDetails> beginSourceBackups(BackupJob backupJob, BackupDetails details, BackupOptions backupOptions, BackupServiceSession<BackupDetails> session) throws BackupException {
        this.logger.debug("Starting support services asynchronously");
        if (backupJob != null) {
            AnalysisResult analysisResult = backupJob.getBackupJobEnvironment().getBackupAnalysis();
            if (analysisResult.hasRealErrors()) {
                details.setStatus(OperationDetails.OperationStatus.ANALYSIS_WARN);
            }
            this.doSourceBackup(backupJob, details, backupOptions, session);
            this.postSupportServices((OperationDetails)details, session);
            if (backupOptions.isAsynchronous()) {
                this.sessionManager.endSession(session, "Backup", false);
            }
        } else {
            this.logger.error(RB.getStringResource("BackupSupportServiceProxyImpl.source.cofnig.null.txt"));
        }
        return new AsyncResult((Object)details);
    }

    private void doSourceBackup(BackupJob backupJob, BackupDetails details, BackupOptions backupOptions, BackupServiceSession<BackupDetails> session) {
        RuntimeSASEnvironment runtimeSASEnvironment = backupJob.getBackupJobEnvironment();
        AnalysisResult analysisResult = null;
        if (runtimeSASEnvironment != null) {
            analysisResult = runtimeSASEnvironment.getBackupAnalysis();
        }
        for (BackupSourceConfig.BackupSource backupSource : BackupSourceConfig.BackupSource.values()) {
            if (analysisResult != null) {
                List list = analysisResult.getAnalyzeErrors(backupSource);
            }
            BackupSourceDetails backupSourceDetails = null;
            List<BackupTask> backupTasksForSource = backupJob.getTasks(backupSource);
            BackupSupportService supportService = this.getService(backupSource);
            if (backupTasksForSource == null || backupTasksForSource.isEmpty()) continue;
            for (BackupTask backupTask : backupTasksForSource) {
                try {
                    backupSourceDetails = supportService.doSourceBackup(backupJob.getBackupJobEnvironment(), backupTask, backupOptions, session);
                    if (backupSourceDetails != null) {
                        this.updateBackupDetails(details, backupSourceDetails);
                        this.xmlOperationDAO.addOperationToHistory((OperationDetails)details);
                    } else {
                        this.logger.warn(Message.format((String)RB.getStringResource("BackupSupportServiceProxyImpl.error.for.backup.fmt"), (Object)backupSource));
                    }
                    this.logger.debug("Backup of " + backupSource + " completed with status " + backupSourceDetails.getStatus());
                }
                catch (BackupException e) {
                    this.processException(runtimeSASEnvironment, details, backupTask, backupSourceDetails, e, session);
                }
                catch (Throwable t) {
                    BackupException e = new BackupException(Message.format((String)RB.getStringResource("BackupSupportServiceProxyImpl.error.for.backup.fmt"), (Object)backupSource), t, BackupErrorConstants.ErrorCodes.ERROR_CODE_UNKNOWN.getErrorCode());
                    this.processException(runtimeSASEnvironment, details, backupTask, backupSourceDetails, e, session);
                }
            }
        }
    }

    private void processException(RuntimeSASEnvironment runtimeSASEnvironment, BackupDetails details, BackupTask backupTask, BackupSourceDetails backupSourceDetails, BackupException e, BackupServiceSession<?> session) {
        if (backupSourceDetails == null) {
            BackupSourceConfig sourceConfig = this.configBeanConverter.backupTaskToSourceConfig(backupTask, runtimeSASEnvironment.getPrimaryMetdataTier());
            backupSourceDetails = new BackupSourceDetails(sourceConfig);
        }
        backupSourceDetails.setStatus(OperationDetails.OperationStatus.FAIL);
        details.getSourceDetails().add(backupSourceDetails);
        this.xmlOperationDAO.addOperationToHistory((OperationDetails)details);
        if (e.getErrorInfo("operationType") == null) {
            e.setErrorInfo("operationType", "backup");
        }
        session.getResult().addException(e);
    }

    private void postSupportServices(OperationDetails details, BackupServiceSession session) throws BackupException {
        if (details != null && !details.getSourceDetails().isEmpty()) {
            String centralVault = details.getConfig().getVaultLocation();
            String metaStaging = null;
            for (BackupSourceDetails srcDetails : details.getSourceDetails()) {
                BackupSourceConfig.BackupSource sourceType;
                OperationDetails.OperationStatus currentStatus = details.getStatus();
                OperationDetails.OperationStatus srcStatus = srcDetails.getStatus();
                if (srcStatus == null) {
                    srcStatus = OperationDetails.OperationStatus.FAIL;
                    srcDetails.setStatus(OperationDetails.OperationStatus.FAIL);
                }
                if (srcStatus.ordinal() > currentStatus.ordinal()) {
                    details.setStatus(srcStatus);
                }
                if (!(details instanceof BackupDetails) || !BackupSourceConfig.BackupSource.METADATASERVER.equals((Object)(sourceType = srcDetails.getSourceConfig().getSourceType()))) continue;
                metaStaging = srcDetails.getBackupLocation();
            }
            if (details instanceof BackupDetails) {
                this.logger.debug("Sending archive command");
                try {
                    boolean archiveResult = this.archive(details, metaStaging, true, session, false);
                    if (!archiveResult) {
                        details.setErrorMessage("Could not archive backup.");
                        if (OperationDetails.OperationStatus.WARN.ordinal() > details.getStatus().ordinal()) {
                            details.setStatus(OperationDetails.OperationStatus.WARN);
                        }
                        this.logger.warn(RB.getStringResource("BackupSupportServiceProxyImpl.could.not.archive.central.backup.txt"));
                    }
                }
                catch (BackupException e) {
                    details.setErrorMessage("Could not archive backup.");
                    if (OperationDetails.OperationStatus.WARN.ordinal() > details.getStatus().ordinal()) {
                        details.setStatus(OperationDetails.OperationStatus.WARN);
                    }
                    this.logger.warn(RB.getStringResource("BackupSupportServiceProxyImpl.could.not.archive.central.backup.txt"));
                    session.getResult().addException(e);
                }
            } else if (details instanceof RecoveryDetails) {
                boolean postRecover = true;
                try {
                    BackupDetails backupDetails = ((RecoveryDetails)details).getBackupDetails();
                    String backupid = backupDetails.getName();
                    postRecover = this.doPostRecover(details, session, backupid);
                    if (!postRecover) {
                        details.setErrorMessage("Post Recovery steps not compleated.");
                        if (OperationDetails.OperationStatus.WARN.ordinal() > details.getStatus().ordinal()) {
                            details.setStatus(OperationDetails.OperationStatus.WARN);
                        }
                        this.logger.warn(RB.getStringResource("BackupSupportServiceProxyImpl.postrecovery.fail.txt"));
                    }
                }
                catch (RemoteException e) {
                    throw new BackupException((Throwable)e, BackupErrorConstants.ErrorCodes.COMMAND_INTERNAL_WARN_POSTRECOVER.getErrorCode());
                }
                catch (MdException e) {
                    throw new BackupException((Throwable)e, BackupErrorConstants.ErrorCodes.COMMAND_INTERNAL_WARN_POSTRECOVER.getErrorCode());
                }
                catch (BackupException e) {
                    details.setErrorMessage("Post Recovery steps not compleated.");
                    if (OperationDetails.OperationStatus.WARN.ordinal() > details.getStatus().ordinal()) {
                        details.setStatus(OperationDetails.OperationStatus.WARN);
                    }
                    this.logger.warn(RB.getStringResource("BackupSupportServiceProxyImpl.postrecovery.fail.txt"));
                    session.getResult().addException(e);
                }
            }
            this.xmlOperationDAO.addOperationToHistory(details);
        }
    }

    private void updateBackupDetails(BackupDetails details, BackupSourceDetails srcDetails) {
        if (details != null) {
            details.getSourceDetails().add(srcDetails);
            long srcBackupSize = srcDetails.getSize();
            long backupSize = details.getSize();
            details.setSize(backupSize + srcBackupSize);
        }
    }

    private boolean doPostRecover(OperationDetails operation, BackupServiceSession session, String backupid) throws RemoteException, BackupException, MdException {
        boolean postRecoveryResult = true;
        boolean isSCSPresent = false;
        boolean isSuccessful = false;
        if (OperationDetails.OperationStatus.SUCCESS.equals((Object)operation.getStatus()) || OperationDetails.OperationStatus.WARN.equals((Object)operation.getStatus())) {
            isSuccessful = true;
        }
        BackupConfiguration config = operation.getConfig();
        Set sourceNodes = session.getActiveNodes();
        LinkedHashMap<String, String> optionalProps = new LinkedHashMap();
        BackupException ex = null;
        BackupSourceNode sourceNodeWithSCS = null;
        for (BackupSourceDetails srcDetails : operation.getSourceDetails()) {
            BackupSourceConfig srcConfig = srcDetails.getSourceConfig();
            BackupSourceConfig.BackupSource sourceType = srcConfig.getSourceType();
            if (!sourceType.equals((Object)BackupSourceConfig.BackupSource.CONTENTSERVER)) continue;
            sourceNodeWithSCS = srcConfig.getBackupSourceNode();
        }
        for (BackupSourceNode sourceNode : sourceNodes) {
            try {
                optionalProps = this.contentServerBackupSupportService.getOptionalProps(backupid);
                isSCSPresent = sourceNode.equals((Object)sourceNodeWithSCS);
                postRecoveryResult = this.backupServerHelperDAO.postRecover(sourceNode, optionalProps, session, isSCSPresent, isSuccessful) && postRecoveryResult;
            }
            catch (BackupException e) {
                if (ex != null) continue;
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
        return postRecoveryResult;
    }

    private boolean archive(OperationDetails operation, String metadataBackupPath, boolean isSessionEnd, BackupServiceSession session, boolean force) throws BackupException {
        boolean archiveResult = true;
        String way = "up";
        String backupid = operation.getName();
        Set<Object> sourceNodes = new HashSet();
        BackupConfiguration config = operation.getConfig();
        if ("Recovery".equals(operation.getType())) {
            way = "down";
            backupid = ((RecoveryDetails)operation).getBackupDetails().getName();
            sourceNodes = session.getActiveNodes();
        } else {
            sourceNodes = this.nodeHelper.getUniqueSourceNodes(config);
        }
        String centralVault = config.getVaultLocation();
        BackupException ex = null;
        for (BackupSourceNode backupSourceNode : sourceNodes) {
            try {
                ServerSideBackupArchiveResult serverResult = this.backupServerHelperDAO.archiveAndSessionEnd(backupSourceNode, session, centralVault, backupid, way, metadataBackupPath, isSessionEnd, force);
                if ("up".equals(way)) {
                    this.updateSourceLocation(operation, backupSourceNode, serverResult);
                }
                archiveResult = archiveResult && serverResult.success();
            }
            catch (BackupException e) {
                if (ex != null) continue;
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
        return archiveResult;
    }

    private void updateSourceLocation(OperationDetails operation, BackupSourceNode node, ServerSideBackupArchiveResult result) {
        for (BackupSourceConfig.BackupSource source : BackupSourceConfig.BackupSource.values()) {
            String backupLocation;
            BackupSourceDetails details = operation.getBackupSourceDetails(node, source);
            if (details == null || (backupLocation = result.getBackupLocation(source)) == null) continue;
            details.setBackupLocation(backupLocation);
        }
    }

    public Future<RecoveryDetails> beginSourceRecovery(RecoveryDetails details, RecoveryOptions recoveryOptions, BackupServiceSession session) throws BackupException {
        this.logger.debug("Starting support services asynchronously");
        BackupDetails backupDetails = details.getBackupDetails();
        List sourceBackups = backupDetails.getSourceDetails();
        String metaStaging = null;
        for (BackupSourceDetails sourceBackup : sourceBackups) {
            BackupSourceConfig.BackupSource sourceType;
            OperationDetails.OperationStatus srcStatus = sourceBackup.getStatus();
            if (srcStatus == null) {
                srcStatus = OperationDetails.OperationStatus.FAIL;
            }
            if (!BackupSourceConfig.BackupSource.METADATASERVER.equals((Object)(sourceType = sourceBackup.getSourceConfig().getSourceType()))) continue;
            metaStaging = sourceBackup.getBackupLocation();
        }
        this.logger.debug("Sending archive command for recovery");
        try {
            boolean archiveResult = this.archive((OperationDetails)details, metaStaging, false, session, recoveryOptions.isForced());
            if (!archiveResult) {
                this.logger.warn(RB.getStringResource("BackupSupportServiceProxyImpl.could.not.archive.central.backup.txt"));
            }
        }
        catch (BackupException e) {
            this.logger.error(RB.getStringResource("BackupSupportServiceProxyImpl.could.not.archive.central.backup.txt"));
            throw e;
        }
        String name = details.getName();
        if (sourceBackups != null) {
            BackupSourceDetails sourceRecovery = null;
            int numberOfSources = sourceBackups.size();
            Float percentComplete = Float.valueOf(0.0f);
            int i = 0;
            for (BackupSourceDetails sourceBackup : sourceBackups) {
                BackupSourceConfig.BackupSource sourceType = sourceBackup.getSourceConfig().getSourceType();
                try {
                    OperationDetails.OperationStatus backupStatus = sourceBackup.getStatus();
                    if (backupStatus.canBeRecovered()) {
                        BackupSupportService supportService = this.getService(sourceType);
                        sourceRecovery = supportService.doSourceRecovery(backupDetails.getName(), recoveryOptions, sourceBackup, session);
                    } else {
                        this.logger.info("Skipping recovery of " + sourceType + " on host " + sourceBackup.getSourceConfig().getBackupSourceNode() + " because the backup was failed");
                        sourceRecovery = new BackupSourceDetails(sourceBackup);
                        sourceRecovery.setStatus(OperationDetails.OperationStatus.FAIL);
                    }
                    if (sourceRecovery != null) {
                        this.updateRecoveryDetails(details, sourceRecovery);
                        this.xmlOperationDAO.addOperationToHistory((OperationDetails)details);
                        this.logger.debug("Recovery of " + sourceRecovery.getSourceConfig().getSourceType() + " completed with status " + sourceRecovery.getStatus());
                    }
                }
                catch (BackupException e) {
                    this.logger.error(Message.format((String)RB.getStringResource("BackupSupportServiceProxyImpl.source.support.service.failed.fmt"), (Object)sourceType), (Throwable)e);
                    if (sourceRecovery == null) {
                        sourceRecovery = new BackupSourceDetails(sourceBackup);
                    }
                    sourceRecovery.setStatus(OperationDetails.OperationStatus.FAIL);
                    details.getSourceDetails().add(sourceRecovery);
                    this.xmlOperationDAO.addOperationToHistory((OperationDetails)details);
                    if (e.getErrorInfo("operationType") == null) {
                        e.setErrorInfo("operationType", "recover");
                    }
                    session.getResult().addException(e);
                }
                catch (Throwable t) {
                    this.logger.error(Message.format((String)RB.getStringResource("BackupSupportServiceProxyImpl.source.support.service.failed.fmt"), (Object)sourceType), t);
                    if (sourceRecovery == null) {
                        sourceRecovery = new BackupSourceDetails(sourceBackup);
                    }
                    sourceRecovery.setStatus(OperationDetails.OperationStatus.FATAL);
                    details.getSourceDetails().add(sourceRecovery);
                    this.xmlOperationDAO.addOperationToHistory((OperationDetails)details);
                    BackupException e = new BackupException(Message.format((String)RB.getStringResource("BackupSupportServiceProxyImpl.source.support.service.failed.fmt"), (Object)sourceType), t, BackupErrorConstants.ErrorCodes.ERROR_CODE_UNKNOWN.getErrorCode());
                    if (e.getErrorInfo("operationType") == null) {
                        e.setErrorInfo("operationType", "recover");
                    }
                    session.getResult().addException(e);
                }
                percentComplete = Float.valueOf(100.0f * (float)(++i) / (float)numberOfSources);
                details.setPercentComplete(percentComplete.floatValue());
                this.logger.info("Percentage of completion: " + percentComplete + "%");
            }
            this.postSupportServices((OperationDetails)details, session);
        } else {
            this.logger.error(RB.getStringResource("BackupSupportServiceProxyImpl.recovery.error.nullbackup.txt"));
        }
        return new AsyncResult((Object)details);
    }

    private void updateRecoveryDetails(RecoveryDetails recoveryDetails, BackupSourceDetails srcDetails) {
        recoveryDetails.getSourceDetails().add(srcDetails);
    }
}

