/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.spi;

import com.sas.svcs.authentication.helper.FoundationServicesUserSessionFactory;
import com.sas.svcs.backup.analyze.BackupJob;
import com.sas.svcs.backup.analyze.BackupRequestContext;
import com.sas.svcs.backup.analyze.model.AnalysisResult;
import com.sas.svcs.backup.analyze.model.RuntimeSASEnvironment;
import com.sas.svcs.backup.client.BackupConfiguration;
import com.sas.svcs.backup.client.BackupDetails;
import com.sas.svcs.backup.client.BackupOptions;
import com.sas.svcs.backup.client.BackupSchedule;
import com.sas.svcs.backup.client.BackupService;
import com.sas.svcs.backup.client.BackupServiceResult;
import com.sas.svcs.backup.client.BackupServiceSession;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.BackupSourceNode;
import com.sas.svcs.backup.client.DirectoryDetails;
import com.sas.svcs.backup.client.Notifiable;
import com.sas.svcs.backup.client.OperationDetails;
import com.sas.svcs.backup.client.RecoveryDetails;
import com.sas.svcs.backup.client.RecoveryOptions;
import com.sas.svcs.backup.client.SASTierProxy;
import com.sas.svcs.backup.client.SASTiers;
import com.sas.svcs.backup.client.UserBackupConfiguration;
import com.sas.svcs.backup.client.UserConfigurationServiceInterface;
import com.sas.svcs.backup.client.UserSourceConfiguration;
import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.BackupNodeHelper;
import com.sas.svcs.backup.dao.BackupServerHelperDAO;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import com.sas.svcs.backup.dao.ConfigBeanConverter;
import com.sas.svcs.backup.dao.DeploymentBackupConfiguration;
import com.sas.svcs.backup.dao.OMRDeploymentBackupConfiguration;
import com.sas.svcs.backup.dao.XMLOperationDAO;
import com.sas.svcs.backup.spi.BackupConfigurationService;
import com.sas.svcs.backup.spi.BackupSchedulingServiceImpl;
import com.sas.svcs.backup.spi.BackupServiceHelper;
import com.sas.svcs.backup.spi.BackupSupportServiceProxy;
import com.sas.svcs.backup.spi.RB;
import com.sas.svcs.backup.spi.SessionManager;
import com.sas.svcs.deployment.DeploymentDiscoveryService;
import com.sas.svcs.deployment.dao.DeploymentDiscoveryDAO;
import com.sas.svcs.deployment.dao.WorkflowStateHolder;
import com.sas.svcs.deployment.data.ConfigurableServer;
import com.sas.svcs.deployment.data.SASEnvironment;
import com.sas.svcs.deployment.data.SASTier;
import com.sas.text.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="BackupService")
public class BackupServiceImpl
implements BackupService {
    @Autowired
    private ApplicationContext applicationContext;
    private final Logger logger = LogManager.getLogger(BackupServiceImpl.class);
    private XMLOperationDAO xmlOperationDAO;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private OMRDeploymentBackupConfiguration omrDeploymentConf;
    @Autowired
    @Qualifier(value="UserConfigurationService")
    private UserConfigurationServiceInterface userConfService;
    @Autowired
    private BackupConfigurationService configurationService;
    @Autowired
    @Qualifier(value="BackupServerHelperDAO")
    private BackupServerHelperDAO backupServerHelperDAO;
    @Autowired
    @Qualifier(value="BackupSupportServiceProxy")
    private BackupSupportServiceProxy supportServiceProxy;
    @Autowired
    private FoundationServicesUserSessionFactory userSessionFactory;
    @Autowired
    private DeploymentDiscoveryService deploymentDiscovery;
    @Autowired
    @Qualifier(value="BackupSchedulingService")
    private BackupSchedulingServiceImpl backupSchedulingService;
    @Autowired
    private ConfigBeanConverter configBeanConverter;
    @Autowired
    private BackupServiceHelper helper;
    @Autowired
    private BackupNodeHelper nodeHelper;
    @Autowired
    @Qualifier(value="DeploymentBackupConfiguration")
    private DeploymentBackupConfiguration backupConfiguration;
    @Autowired
    @Qualifier(value="DeploymentBackupConfiguration")
    private OMRDeploymentBackupConfiguration backupConfigComponent;

    @Autowired
    public void setDao(@Qualifier(value="XMLOperationDAO") XMLOperationDAO xmlDAO) {
        this.xmlOperationDAO = xmlDAO;
    }

    public BackupServiceResult<AnalysisResult> analyze() throws BackupException {
        BackupServiceResult backupServiceResult = new BackupServiceResult();
        BackupRequestContext backupRequestContext = (BackupRequestContext)this.applicationContext.getBean("backupRequestContext");
        RuntimeSASEnvironment runtimeSASEnvironment = backupRequestContext.initialize();
        AnalysisResult analysisResult = backupRequestContext.analyze(runtimeSASEnvironment);
        backupServiceResult.setActualResult((Object)analysisResult);
        return backupServiceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Notifiable
    public BackupServiceResult<BackupDetails> startBackup(BackupOptions backupOptions) throws BackupException {
        block24: {
            block25: {
                this.logger.info(RB.getStringResource("BackupServiceImpl.starting.deployment.backup.txt"));
                backupDetails = null;
                session = null;
                anotherSessionRunning = false;
                config = null;
                analysisResult = null;
                runtimeSASEnvironment = null;
                backupRequestContext = (BackupRequestContext)this.applicationContext.getBean("backupRequestContext");
                runtimeSASEnvironment = backupRequestContext.initialize();
                analysisResult = backupRequestContext.analyze(runtimeSASEnvironment);
                backupJob = null;
                backupJob = backupRequestContext.createBackupJob(backupOptions, runtimeSASEnvironment);
                if (backupJob == null) ** GOTO lbl49
                this.helper.ensureAllTiersAreReachable(runtimeSASEnvironment);
                session = this.helper.configureBackupServerAndStartSession(session, runtimeSASEnvironment);
                config = this.configBeanConverter.backupJobToConfig((BackupJob)backupJob);
                this.helper.ensureOverlappingBackupsNotProcessed(session);
                backupDetails = new BackupDetails(config);
                this.helper.initBackupDetails(session, backupDetails, backupOptions);
                if (!backupOptions.isScheduled()) break block24;
                backupDetails.setScheduled(true);
                if (config.isScheduledBackupsAllowed()) break block24;
                var10_14 = this.helper.getScheduledBackupNotAllowedResult(backupDetails);
                this.helper.postBackup(backupOptions, backupDetails, session, anotherSessionRunning);
                if (backupDetails == null) break block25;
                backupDetails.setRuntimeEnvironment(runtimeSASEnvironment);
            }
            return var10_14;
        }
        try {
            block28: {
                this.helper.syncXMLFiles(backupDetails, session);
                future = this.supportServiceProxy.beginSourceBackups((BackupJob)backupJob, backupDetails, backupOptions, session);
                if (!backupOptions.isAsynchronous()) {
                    backupDetails = this.helper.waitForBackupCompletion(future);
                    if (backupJob.getBackupOptions().isExternalDBPresent()) {
                        backupDetails.setErrorMessage("Backup of SAS Content Server and Shared Services Database will not be taken as it is configured on external database.");
                        if (OperationDetails.OperationStatus.ANALYSIS_WARN.ordinal() > backupDetails.getStatus().ordinal()) {
                            backupDetails.setStatus(OperationDetails.OperationStatus.WARN);
                        }
                        this.logger.warn(RB.getStringResource("BackupServiceImpl.external.database.txt"));
                        session.getResult().addException(new BackupException(RB.getStringResource("BackupServiceImpl.external.database.txt"), BackupErrorConstants.ErrorCodes.COMMAND_INTERNAL_WARN_EXTERNAL_DATABASE.getErrorCode()));
                        this.xmlOperationDAO.addOperationToHistory((OperationDetails)backupDetails);
                    }
                    v0 = errorsEncountered = BackupServiceUtils.isEmpty(session.getResult().getExceptions()) == false;
                    if (backupDetails != null && backupDetails.getStatus() == OperationDetails.OperationStatus.SUCCESS && errorsEncountered) {
                        backupDetails.setStatus(OperationDetails.OperationStatus.WARN);
                        this.xmlOperationDAO.addOperationToHistory((OperationDetails)backupDetails);
                    }
                }
                break block28;
lbl49:
                // 1 sources

                this.logger.error(RB.getStringResource("BackupServiceImpl.could.not.load.configuration.txt"));
                throw new BackupException(RB.getStringResource("BackupServiceImpl.could.not.load.configuration.txt"), BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONFIG_ERROR.getErrorCode());
            }
            this.helper.logBackupStatusMessage(backupDetails);
            this.helper.postBackup(backupOptions, backupDetails, session, anotherSessionRunning);
            ** if (backupDetails == null) goto lbl-1000
        }
        catch (BackupException e) {
            block26: {
                block27: {
                    this.logger.error(RB.getStringResource("BackupServiceImpl.backup.failed.txt"), (Throwable)e);
                    if (backupDetails == null) {
                        backupDetails = new BackupDetails();
                    }
                    if (!e.isLogInNewSession()) break block26;
                    anotherSessionRunning = true;
                    backupJob = this.helper.getExceptionResultInNewSession(e, backupDetails);
                    this.helper.postBackup(backupOptions, backupDetails, session, anotherSessionRunning);
                    if (backupDetails == null) break block27;
                    backupDetails.setRuntimeEnvironment(runtimeSASEnvironment);
                }
                return backupJob;
            }
            session = this.helper.processBackupException(e, session, (OperationDetails)backupDetails, config);
            {
                catch (Exception e1) {
                    this.logger.debug("Exception encountered in startBackup() flow", (Throwable)e);
                }
            }
            this.helper.postBackup(backupOptions, backupDetails, session, anotherSessionRunning);
            ** if (backupDetails == null) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                backupDetails.setRuntimeEnvironment(runtimeSASEnvironment);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        catch (Throwable t) {
            this.logger.error(RB.getStringResource("BackupServiceImpl.backup.failed.txt"), t);
            try {
                e = new BackupException(RB.getStringResource("BackupServiceImpl.backup.failed.txt"), t, BackupErrorConstants.ErrorCodes.ERROR_CODE_UNKNOWN.getErrorCode());
                if (backupDetails == null) {
                    backupDetails = new BackupDetails();
                }
                session = this.helper.processBackupException(e, session, (OperationDetails)backupDetails, config);
            }
            catch (Exception var9_13) {
                // empty catch block
            }
            this.helper.postBackup(backupOptions, backupDetails, session, anotherSessionRunning);
            ** if (backupDetails == null) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                backupDetails.setRuntimeEnvironment(runtimeSASEnvironment);
            }
lbl-1000:
            // 2 sources

            {
            }
            {
                catch (Throwable var12_17) {
                    this.helper.postBackup(backupOptions, backupDetails, session, anotherSessionRunning);
                    if (backupDetails != null) {
                        backupDetails.setRuntimeEnvironment(runtimeSASEnvironment);
                    }
                    throw var12_17;
                }
            }
        }
lbl-1000:
        // 1 sources

        {
            backupDetails.setRuntimeEnvironment(runtimeSASEnvironment);
        }
lbl-1000:
        // 2 sources

        {
        }
        if (analysisResult != null && !analysisResult.isOK()) {
            session.getResult().setAnalysisResult(analysisResult);
        }
        session.getResult().setActualResult((Object)backupDetails);
        return session == null || session.getResult() == null ? null : session.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupServiceResult<Map<String, List<String>>> getContentDetails(String operationName, String operationType, String hostName, String sourceType) throws BackupException {
        BackupServiceSession session;
        Map<String, List<String>> srcContentDetails;
        block13: {
            srcContentDetails = null;
            session = null;
            Set<BackupSourceNode> uniqBackupSourceNodes = null;
            boolean anotherSessionRunning = false;
            try {
                session = this.sessionManager.startSession(uniqBackupSourceNodes, "GetContentDetails");
                RuntimeSASEnvironment runtimeSASEnvironment = this.helper.getRuntimeSASEnvironment();
                this.helper.ensurePrimaryTierIsReachable(runtimeSASEnvironment);
                if (session == null) {
                    anotherSessionRunning = true;
                    session = this.sessionManager.getMockSession("GetContentDetails");
                }
                OperationDetails details = this.helper.getDetails(operationName, operationType, "Name", session);
                BackupConfiguration config = details.getConfig();
                List sourceConfigs = config.getSources();
                uniqBackupSourceNodes = this.nodeHelper.getUniqueSourceNodes(config);
                if (sourceConfigs == null) break block13;
                for (BackupSourceConfig sourceConfig : sourceConfigs) {
                    BackupSourceConfig.BackupSource bkupSourceType = sourceConfig.getSourceType();
                    BackupSourceNode sourceNode = sourceConfig.getBackupSourceNode();
                    String sourceHostName = sourceNode.getHostName();
                    if (!bkupSourceType.name().equals(sourceType)) continue;
                    if (hostName == null) {
                        srcContentDetails = this.supportServiceProxy.getContentDetails(sourceConfig, operationName, session);
                        break;
                    }
                    if (!BackupServiceUtils.isHostsEqual(sourceHostName, hostName)) continue;
                    srcContentDetails = this.supportServiceProxy.getContentDetails(sourceConfig, operationName, session);
                }
            }
            catch (BackupException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                if (session != null) {
                    session.getResult().addException(e);
                }
            }
            catch (Throwable t) {
                this.logger.error(t.getMessage(), t);
                BackupException be = new BackupException("Fatal error encountered while trying to get content details for operation " + operationName, t, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONTENT_DETAILS_FAILED.getErrorCode());
                if (session != null) {
                    session.getResult().addException(be);
                }
            }
            finally {
                if (!anotherSessionRunning) {
                    this.sessionManager.endSession(session, "GetContentDetails", false);
                    this.helper.deleteTempDirectory();
                }
            }
        }
        session.getResult().setActualResult(srcContentDetails);
        return session == null ? null : session.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupServiceResult<List<OperationDetails>> getAllHistory() throws BackupException {
        List<OperationDetails> history = null;
        BackupServiceSession session = null;
        boolean immutableSessionAlreadyRunning = this.sessionManager.isImmutableSessionStarted();
        try {
            session = this.sessionManager.getMockSession("getAllHistory");
            RuntimeSASEnvironment runtimeSASEnvironment = this.helper.getRuntimeSASEnvironment();
            this.helper.ensurePrimaryTierIsReachable(runtimeSASEnvironment);
            BackupSourceNode primaryNode = this.configBeanConverter.sasTierToBackupSourceNode(runtimeSASEnvironment.getPrimaryMetdataTier());
            if (this.sessionManager.startImmutableSessionOn(primaryNode, session, "getAllHistory")) {
                history = this.helper.getAllHistory(session);
            }
        }
        catch (BackupException e) {
            this.helper.addOperationtypeAndLog(e, session, "gethistory");
        }
        catch (Throwable t) {
            BackupException be = new BackupException("Fatal error encountered while trying to get history information.", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_HISTORY_ERROR.getErrorCode());
            this.helper.addOperationtypeAndLog(be, session, "gethistory");
        }
        finally {
            if (!immutableSessionAlreadyRunning) {
                this.sessionManager.resetImmutableSession();
                this.helper.deleteTempDirectory();
            }
        }
        this.helper.setSessionResult(session, history);
        return session == null ? null : session.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupServiceResult<List<OperationDetails>> getRecentHistory(int count) throws BackupException {
        List<OperationDetails> history = null;
        BackupServiceSession session = null;
        session = this.sessionManager.getMockSession("getRecentHistory");
        boolean immutableSessionAlreadyRunning = this.sessionManager.isImmutableSessionStarted();
        try {
            RuntimeSASEnvironment runtimeSASEnvironment = this.helper.getRuntimeSASEnvironment();
            this.helper.ensurePrimaryTierIsReachable(runtimeSASEnvironment);
            BackupSourceNode primaryNode = this.configBeanConverter.sasTierToBackupSourceNode(runtimeSASEnvironment.getPrimaryMetdataTier());
            if (this.sessionManager.startImmutableSessionOn(primaryNode, session, "getRecentHistory")) {
                history = this.xmlOperationDAO.getHistory();
            }
        }
        catch (BackupException e) {
            this.helper.addOperationtypeAndLog(e, session, "gethistory");
        }
        catch (Throwable t) {
            BackupException be = new BackupException("Fatal error encountered while trying to get  recent history information.", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_HISTORY_ERROR.getErrorCode());
            this.helper.addOperationtypeAndLog(be, session, "gethistory");
        }
        finally {
            if (!immutableSessionAlreadyRunning) {
                this.sessionManager.resetImmutableSession();
                this.helper.deleteTempDirectory();
            }
        }
        session.getResult().setActualResult(history);
        return session == null ? null : session.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupServiceResult<OperationDetails> getDetails(String name, String type, String identifier) throws BackupException {
        OperationDetails details = null;
        BackupServiceSession session = null;
        session = this.sessionManager.getMockSession("getDetails");
        boolean immutableSessionAlreadyRunning = this.sessionManager.isImmutableSessionStarted();
        try {
            RuntimeSASEnvironment runtimeSASEnvironment = this.helper.getRuntimeSASEnvironment();
            this.helper.ensurePrimaryTierIsReachable(runtimeSASEnvironment);
            BackupSourceNode primaryNode = this.configBeanConverter.sasTierToBackupSourceNode(runtimeSASEnvironment.getPrimaryMetdataTier());
            if (this.sessionManager.startImmutableSessionOn(primaryNode, session, "getDetails")) {
                details = this.helper.getDetails(name, type, identifier, session);
            }
        }
        catch (BackupException e) {
            this.helper.addOperationtypeAndLog(e, session, "gethistory");
        }
        catch (Throwable t) {
            BackupException be = new BackupException("Fatal error encountered while trying to retrieve details of: " + name + " " + type, t, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_HISTORY_ERROR.getErrorCode());
            this.helper.addOperationtypeAndLog(be, session, "gethistory");
        }
        finally {
            if (!immutableSessionAlreadyRunning) {
                this.sessionManager.resetImmutableSession();
                this.helper.deleteTempDirectory();
            }
        }
        session.getResult().setActualResult(details);
        return session == null ? null : session.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupServiceResult<OperationDetails.OperationStatus> getStatus(String name, String type, String identifier) throws BackupException {
        OperationDetails details = null;
        OperationDetails.OperationStatus status = null;
        BackupServiceSession session = null;
        session = this.sessionManager.getMockSession("getStatus");
        boolean immutableSessionAlreadyRunning = this.sessionManager.isImmutableSessionStarted();
        try {
            RuntimeSASEnvironment runtimeSASEnvironment = this.helper.getRuntimeSASEnvironment();
            this.helper.ensurePrimaryTierIsReachable(runtimeSASEnvironment);
            BackupSourceNode primaryNode = this.configBeanConverter.sasTierToBackupSourceNode(runtimeSASEnvironment.getPrimaryMetdataTier());
            if (this.sessionManager.startImmutableSessionOn(primaryNode, session, "getStatus") && (details = this.xmlOperationDAO.getDetails(name, type, identifier)) != null) {
                status = details != null ? details.getStatus() : null;
            }
        }
        catch (BackupException e) {
            this.helper.addOperationtypeAndLog(e, session, "gethistory");
        }
        catch (Throwable t) {
            BackupException be = new BackupException("Fatal error encountered while trying to retrieve status of " + name + " " + type, t, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_HISTORY_ERROR.getErrorCode());
            this.helper.addOperationtypeAndLog(be, session, "gethistory");
        }
        finally {
            if (!immutableSessionAlreadyRunning) {
                this.sessionManager.resetImmutableSession();
                this.helper.deleteTempDirectory();
            }
        }
        session.getResult().setActualResult(status);
        return session == null ? null : session.getResult();
    }

    private void fillUpUserConfiguration(BackupConfiguration config) throws BackupException {
        SASEnvironment env = this.deploymentDiscovery.discover();
        List dbServers1 = this.deploymentDiscovery.getConfigurableServers(DeploymentDiscoveryDAO.ComponentType.SAS_SOL_DATA_SERVER);
        ArrayList<SASTierProxy> sasTiers = new ArrayList<SASTierProxy>();
        SASTier tier = ((ConfigurableServer)dbServers1.get(0)).getSasTier();
        SASTierProxy proxyTier = new SASTierProxy();
        proxyTier.setTierHost(tier.getTierHost());
        proxyTier.setTierName(tier.getTierName());
        proxyTier.setSasConfig(tier.getSasConfig());
        proxyTier.setSasHome(tier.getSasHome());
        sasTiers.add(proxyTier);
        UserBackupConfiguration userConf = new UserBackupConfiguration();
        SASTiers tiers = new SASTiers();
        tiers.setSasTiers(sasTiers);
        this.userConfService.setSASTiers(tiers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupServiceResult<BackupConfiguration> getBackupConfiguration() throws BackupException {
        BackupConfiguration config = null;
        BackupServiceSession session = null;
        session = this.sessionManager.getMockSession("getBackupConfiguration");
        try {
            RuntimeSASEnvironment runtimeSASEnvironment = this.helper.getRuntimeSASEnvironment();
            this.helper.ensurePrimaryTierIsReachable(runtimeSASEnvironment);
            config = this.getBackupConfiguration(session, runtimeSASEnvironment);
        }
        catch (BackupException e) {
            this.helper.addOperationtypeAndLog(e, session, "getconfig");
        }
        catch (Throwable t) {
            BackupException be = new BackupException("Fatal error encountered while trying to retrieve configuration information.", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONFIG_ERROR.getErrorCode());
            this.helper.addOperationtypeAndLog(be, session, "getconfig");
        }
        finally {
            this.helper.deleteTempDirectory();
        }
        session.getResult().setActualResult((Object)config);
        return session == null ? null : session.getResult();
    }

    public BackupConfiguration getBackupConfiguration(BackupServiceSession<?> session, RuntimeSASEnvironment runtimeSASEnvironment) throws BackupException {
        return this.configurationService.getConfiguration(session, runtimeSASEnvironment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupServiceResult<BackupConfiguration> setBackupConfiguration(BackupConfiguration backupConfiguration) throws BackupException {
        this.logger.debug("Geode Cache need to be refreshed. Reason: setBackupConfiguration(" + backupConfiguration + ")");
        BackupServiceSession session = null;
        session = this.sessionManager.getMockSession("setBackupConfiguration");
        try {
            RuntimeSASEnvironment runtimeSASEnvironment = this.helper.getRuntimeSASEnvironment();
            this.helper.ensurePrimaryTierIsReachable(runtimeSASEnvironment);
            List<BackupSourceNode> backupSourceNodes = this.configBeanConverter.sasTierToBackupSourceNodeList(runtimeSASEnvironment.getAvailableTiers(), runtimeSASEnvironment.getPrimaryMetdataTier());
            Set<BackupSourceNode> uniqueSourceNodes = this.nodeHelper.getUniqueElements(backupSourceNodes);
            if (backupConfiguration != null) {
                String sharedVaultLocation = backupConfiguration.getVaultLocation();
                Map<String, String> backupServerProperties = this.omrDeploymentConf.getConfigurationProperties();
                HashMap<String, String> updatedBackupServerProperties = new HashMap<String, String>();
                if (sharedVaultLocation != null) {
                    updatedBackupServerProperties.put("svrbakupevm.shared.vault.dir", sharedVaultLocation);
                } else {
                    this.configurationService.setConfiguration(backupConfiguration);
                }
                if (!BackupServiceUtils.isEmpty(updatedBackupServerProperties.size())) {
                    boolean isBackupServerReConfigured = true;
                    if (!BackupServiceUtils.isEmpty(uniqueSourceNodes)) {
                        for (BackupSourceNode sourceNode : uniqueSourceNodes) {
                            if (this.omrDeploymentConf.isBackupServerAlreadyConfigured(sourceNode)) {
                                String backupWorkspace = backupServerProperties.get("svrbakupevm.backup.workspace.legal.dir.name");
                                if (backupWorkspace != null) {
                                    updatedBackupServerProperties.put("svrbakupevm.backup.workspace.legal.dir.name", backupWorkspace);
                                }
                                this.logger.info("Re-configuring backup server on " + sourceNode);
                                isBackupServerReConfigured = this.configurationService.reConfigureBackupServer(sourceNode, session, updatedBackupServerProperties);
                            } else {
                                this.logger.debug("Backup Server can not be reconfigured on " + sourceNode + " because its never been configured there.");
                            }
                            if (!isBackupServerReConfigured) {
                                this.logger.error("Failed to re-configure backup server on host: " + sourceNode);
                                BackupException e = new BackupException("Failed to re-configure backup server on host: " + sourceNode, BackupErrorConstants.ErrorCodes.ERROR_CODE_BACKUP_SERVER_RECONFIGURATION_FAILURE.getErrorCode());
                                throw e;
                            }
                            this.logger.info("Backup server re-configured on " + sourceNode);
                        }
                        if (isBackupServerReConfigured) {
                            this.configurationService.setConfiguration(backupConfiguration);
                        }
                    }
                }
            }
            session.getResult().setActualResult((Object)this.getBackupConfiguration(session, runtimeSASEnvironment));
        }
        catch (BackupException e) {
            this.helper.addOperationtypeAndLog(e, session, "setconfig");
        }
        catch (Throwable t) {
            BackupException be = new BackupException("Fatal error encountered while trying to set configuration information.", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_SET_CONFIG_ERROR.getErrorCode());
            this.helper.addOperationtypeAndLog(be, session, "setconfig");
        }
        finally {
            this.helper.deleteTempDirectory();
        }
        return session == null ? null : session.getResult();
    }

    public BackupServiceResult<BackupDetails> getMostRecentBackup() throws BackupException {
        this.logger.info("Fetching most recent backup");
        BackupServiceSession session = null;
        BackupDetails details = null;
        boolean immutableSessionAlreadyRunning = this.sessionManager.isImmutableSessionStarted();
        session = this.sessionManager.getMockSession("getMostRecentRecovery");
        try {
            RuntimeSASEnvironment runtimeSASEnvironment = this.helper.getRuntimeSASEnvironment();
            this.helper.ensurePrimaryTierIsReachable(runtimeSASEnvironment);
            BackupSourceNode primaryNode = this.configBeanConverter.sasTierToBackupSourceNode(runtimeSASEnvironment.getPrimaryMetdataTier());
            if (this.sessionManager.startImmutableSessionOn(primaryNode, session, "getMostRecentRecovery")) {
                details = this.helper.getMostRecentBackup(session);
            }
        }
        catch (BackupException e) {
            this.helper.addOperationtypeAndLog(e, session, "gethistory");
            throw e;
        }
        catch (Throwable t) {
            BackupException be = new BackupException("Fatal error encountered while trying to retrieve most recent backup.", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_HISTORY_ERROR.getErrorCode());
            this.helper.addOperationtypeAndLog(be, session, "gethistory");
            throw be;
        }
        finally {
            if (!immutableSessionAlreadyRunning) {
                this.sessionManager.resetImmutableSession();
                this.helper.deleteTempDirectory();
            }
        }
        session.getResult().setActualResult((Object)details);
        this.logger.info("Finished with fetching most recent backup");
        return session == null ? null : session.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupServiceResult<BackupDetails> getBackupBySlugName(String slug) throws BackupException {
        BackupDetails details = null;
        boolean immutableSessionAlreadyRunning = this.sessionManager.isImmutableSessionStarted();
        BackupServiceSession session = this.sessionManager.getMockSession("getBackupBySlugName");
        try {
            RuntimeSASEnvironment runtimeSASEnvironment = this.helper.getRuntimeSASEnvironment();
            this.helper.ensurePrimaryTierIsReachable(runtimeSASEnvironment);
            BackupSourceNode primaryNode = this.configBeanConverter.sasTierToBackupSourceNode(runtimeSASEnvironment.getPrimaryMetdataTier());
            if (this.sessionManager.startImmutableSessionOn(primaryNode, session, "getBackupSlugByName")) {
                details = this.xmlOperationDAO.getBackupBySlugName(slug);
            }
        }
        catch (BackupException e) {
            this.helper.addOperationtypeAndLog(e, session, "gethistory");
        }
        catch (Throwable t) {
            BackupException e = new BackupException("Fatal error encountered while trying to retrieve backup details for given name: " + slug, t, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_HISTORY_ERROR.getErrorCode());
            this.helper.addOperationtypeAndLog(e, session, "gethistory");
        }
        finally {
            if (!immutableSessionAlreadyRunning) {
                this.sessionManager.resetImmutableSession();
                this.helper.deleteTempDirectory();
            }
        }
        session.getResult().setActualResult(details);
        return session == null ? null : session.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupServiceResult<BackupDetails> getBackupByName(String name) throws BackupException {
        this.logger.debug("Inside getBackupByName() name = " + name);
        RuntimeSASEnvironment runtimeSASEnvironment = this.helper.getRuntimeSASEnvironment();
        try {
            List availableSASTiers = runtimeSASEnvironment.getAvailableTiers();
            this.helper.removeExcludedTiersFromSASTierList(availableSASTiers);
            List<BackupSourceNode> backupSourceNodes = this.configBeanConverter.sasTierToBackupSourceNodeList(availableSASTiers, runtimeSASEnvironment.getPrimaryMetdataTier());
            HashSet<BackupSourceNode> uniqueSourceNodes = new HashSet<BackupSourceNode>();
            uniqueSourceNodes.addAll(backupSourceNodes);
            this.helper.ensureRequiredTiersAreReachable(uniqueSourceNodes);
            BackupServiceSession session = this.sessionManager.startSession(uniqueSourceNodes, "SynchronizeConfigurationFiles");
            this.sessionManager.endSession(session, "SynchronizeConfigurationFiles", false);
        }
        catch (Exception e) {
            this.logger.error("Could not synchronize Configuration files", (Throwable)e);
        }
        BackupDetails details = null;
        BackupServiceSession session = null;
        boolean immutableSessionAlreadyRunning = this.sessionManager.isImmutableSessionStarted();
        session = this.sessionManager.getMockSession("getBackupByName");
        try {
            this.helper.ensurePrimaryTierIsReachable(runtimeSASEnvironment);
            BackupSourceNode primaryNode = this.configBeanConverter.sasTierToBackupSourceNode(runtimeSASEnvironment.getPrimaryMetdataTier());
            if (this.sessionManager.startImmutableSessionOn(primaryNode, session, "getBackupByName")) {
                details = this.xmlOperationDAO.getBackupByName(name);
            }
        }
        catch (BackupException e) {
            this.helper.addOperationtypeAndLog(e, session, "gethistory");
        }
        catch (Throwable t) {
            BackupException e = new BackupException("Fatal error encountered while trying to retrieve backup details for given name: " + name, t, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_HISTORY_ERROR.getErrorCode());
            this.helper.addOperationtypeAndLog(e, session, "gethistory");
        }
        finally {
            if (!immutableSessionAlreadyRunning) {
                this.sessionManager.resetImmutableSession();
                this.helper.deleteTempDirectory();
            }
        }
        session.getResult().setActualResult(details);
        Object offlineWorkflowPhaseEnabled = WorkflowStateHolder.getProperty((String)WorkflowStateHolder.IS_OFFLINE_RECOVERY_INITIAL_PHASE_ENABLED);
        if (offlineWorkflowPhaseEnabled != null && ((Boolean)offlineWorkflowPhaseEnabled).booleanValue()) {
            WorkflowStateHolder.clearContext();
            this.logger.debug("Clearing context of WorkflowStateHolder as getBackupByName is completed");
        }
        return session == null ? null : session.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupServiceResult<BackupDetails> refreshBackup(BackupDetails backup) throws BackupException {
        BackupDetails details = null;
        BackupServiceSession session = null;
        boolean immutableSessionAlreadyRunning = this.sessionManager.isImmutableSessionStarted();
        session = this.sessionManager.getMockSession("refreshBackup");
        try {
            RuntimeSASEnvironment runtimeSASEnvironment = this.helper.getRuntimeSASEnvironment();
            this.helper.ensurePrimaryTierIsReachable(runtimeSASEnvironment);
            BackupSourceNode primaryNode = this.configBeanConverter.sasTierToBackupSourceNode(runtimeSASEnvironment.getPrimaryMetdataTier());
            if (this.sessionManager.startImmutableSessionOn(primaryNode, session, "refreshBackup")) {
                details = this.refreshBackup(backup, session);
            }
        }
        catch (BackupException e) {
            this.helper.addOperationtypeAndLog(e, session, "gethistory");
        }
        catch (Throwable t) {
            BackupException e = new BackupException("Fatal error encountered while trying to refresh backup details.", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_HISTORY_ERROR.getErrorCode());
            this.helper.addOperationtypeAndLog(e, session, "gethistory");
        }
        finally {
            if (!immutableSessionAlreadyRunning) {
                this.sessionManager.resetImmutableSession();
                this.helper.deleteTempDirectory();
            }
        }
        session.getResult().setActualResult(details);
        return session == null ? null : session.getResult();
    }

    private BackupDetails refreshBackup(BackupDetails backup, BackupServiceSession<?> session) throws BackupException {
        BackupDetails details = null;
        try {
            details = this.xmlOperationDAO.getBackupByName(backup.getName());
        }
        catch (BackupException e) {
            this.helper.addOperationType(e, "gethistory");
            throw e;
        }
        catch (Throwable t) {
            BackupException e = new BackupException("Fatal error encountered while trying to refresh backup details.", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_HISTORY_ERROR.getErrorCode());
            this.helper.addOperationType(e, "gethistory");
            throw e;
        }
        return details;
    }

    public List<BackupDetails> getAvailableBackups(BackupServiceSession<?> session) throws BackupException {
        this.logger.debug("Inside getAvailableBackups()");
        LinkedList<BackupDetails> backups = new LinkedList<BackupDetails>();
        boolean immutableSessionAlreadyRunning = this.sessionManager.isImmutableSessionStarted();
        try {
            RuntimeSASEnvironment runtimeSASEnvironment = this.helper.getRuntimeSASEnvironment();
            this.helper.ensurePrimaryTierIsReachable(runtimeSASEnvironment);
            BackupSourceNode primaryNode = this.configBeanConverter.sasTierToBackupSourceNode(runtimeSASEnvironment.getPrimaryMetdataTier());
            if (this.sessionManager.startImmutableSessionOn(primaryNode, session, "getAvailableBackups")) {
                for (OperationDetails result : this.helper.getAllHistory(session)) {
                    BackupDetails backup;
                    if (!(result instanceof BackupDetails) || (backup = (BackupDetails)result).isOffline()) continue;
                    backups.add(backup);
                }
            }
        }
        catch (BackupException e) {
            this.helper.addOperationType(e, "gethistory");
            this.logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Throwable t) {
            this.logger.error(t.getMessage(), t);
            BackupException be = new BackupException("Fatal error encountered while trying to retrieve available backups.", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_HISTORY_ERROR.getErrorCode());
            this.helper.addOperationType(be, "gethistory");
            throw be;
        }
        finally {
            if (!immutableSessionAlreadyRunning) {
                this.sessionManager.resetImmutableSession();
            }
        }
        return backups;
    }

    public void addToHistory(BackupDetails backup) throws BackupException {
        try {
            this.xmlOperationDAO.addOperationToHistory((OperationDetails)backup);
        }
        catch (BackupException e) {
            this.helper.addOperationType(e, "sethistory");
            this.logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Throwable t) {
            this.logger.error(t.getMessage(), t);
            BackupException e = new BackupException("Fatal error encountered while trying to add backup details to hisory file.", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_UPDATE_HISTORY_ERROR.getErrorCode());
            this.helper.addOperationType(e, "sethistory");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Notifiable
    public BackupServiceResult<RecoveryDetails> recover(BackupDetails backup, RecoveryOptions recoveryOptions) throws BackupException {
        RecoveryDetails recovery = null;
        this.logger.info("Starting recover operation...");
        BackupServiceSession<RecoveryDetails> session = null;
        boolean anotherSessionRunning = false;
        RuntimeSASEnvironment runtimeSASEnvironment = null;
        try {
            runtimeSASEnvironment = this.helper.getRuntimeSASEnvironment();
            session = this.startSessionOnRequiredTiers(backup, runtimeSASEnvironment);
            this.helper.validateSession(session);
            this.helper.validateBackup(backup);
            this.logger.info("Done with Validation");
            if (backup.getName() != null && backup.getName() != "" && (backup = this.refreshBackup(backup, session)).isOffline()) {
                BackupServiceResult<RecoveryDetails> backupServiceResult = this.getBackupPurgedResult(backup, session);
                return backupServiceResult;
            }
            this.helper.validateBackupWasSuccessful(backup);
            RecoveryDetails previousRecovery = this.helper.getMostRecentRecovery(session);
            if (previousRecovery != null) {
                previousRecovery = this.helper.waitForNewRecovery(previousRecovery, session);
            }
            if (recoveryOptions != null) {
                this.helper.filterRecoverySources(recoveryOptions, backup);
            }
            this.logger.debug(Message.format((String)RB.getStringResource("BackupServiceImpl.recovery.started.fmt"), (Object)backup.getName()));
            recovery = new RecoveryDetails(backup);
            this.helper.fillRecoveryDetails(recoveryOptions, recovery);
            recovery.setName(session.getSessionId());
            this.helper.initRecoveryDetails(recovery);
            this.sessionManager.endSession(session, "Recover", true);
            this.helper.reloadConfiguration(recoveryOptions, recovery);
            if (BackupServiceUtils.isEmpty(backup.getSourceDetails())) {
                BackupServiceResult<RecoveryDetails> backupServiceResult = this.helper.returnNoSourceSelectedResult(recovery, session);
                return backupServiceResult;
            }
            Future<RecoveryDetails> futureRecovery = this.supportServiceProxy.beginSourceRecovery(recovery, recoveryOptions, session);
            if (!recoveryOptions.isAsynchronous()) {
                recovery = this.helper.waitForRecoveryCompletion(futureRecovery);
            }
            this.helper.logRecoveryStatusMessage(recovery);
            this.xmlOperationDAO.addOperationToHistory((OperationDetails)recovery);
        }
        catch (BackupException e) {
            block24: {
                this.logger.error(RB.getStringResource("BackupServiceImpl.recovery.failed.txt"), (Throwable)e);
                if (recovery == null) {
                    recovery = new RecoveryDetails(backup);
                }
                if (!e.isLogInNewSession()) break block24;
                anotherSessionRunning = true;
                BackupServiceResult<RecoveryDetails> futureRecovery = this.helper.getRecoveryExceptionInNewSession(e, recovery);
                return futureRecovery;
            }
            try {
                session = this.helper.processRecoveryException(e, session, recovery);
            }
            catch (Exception futureRecovery) {
                // empty catch block
            }
        }
        catch (Throwable t) {
            this.logger.error(RB.getStringResource("BackupServiceImpl.recovery.failed.txt"), t);
            try {
                BackupException e = new BackupException(RB.getStringResource("BackupServiceImpl.recovery.failed.txt"), t, BackupErrorConstants.ErrorCodes.ERROR_CODE_UNKNOWN.getErrorCode());
                if (recovery == null) {
                    recovery = new RecoveryDetails(backup);
                }
                session = this.helper.processRecoveryException(e, session, recovery);
            }
            catch (Exception e) {
                this.logger.debug("Exception while processing Throwable ", (Throwable)e);
            }
        }
        finally {
            this.helper.postRecovery(session, anotherSessionRunning);
            if (recovery != null) {
                recovery.setRuntimeEnvironment(runtimeSASEnvironment);
            }
        }
        session.getResult().setActualResult((Object)recovery);
        return session.getResult();
    }

    private BackupServiceSession<RecoveryDetails> startSessionOnRequiredTiers(BackupDetails backup, RuntimeSASEnvironment runtimeSASEnvironment) {
        if (backup != null) {
            this.logger.debug("startSessionOnRequiredTiers() Entered backup.getName() =" + backup.getName());
        } else {
            this.logger.debug("startSessionOnRequiredTiers() Entered backup = null");
        }
        Set<BackupSourceNode> sourceNodesTemp = this.nodeHelper.getUniqueSourceNodes(backup.getConfig());
        HashSet<BackupSourceNode> sourceNodes = new HashSet<BackupSourceNode>();
        for (BackupSourceNode sourceNode : sourceNodesTemp) {
            if (sourceNode.isMetadataTier() && !runtimeSASEnvironment.getPrimaryMetdataTier().getHostName().equals(sourceNode.getHostName())) {
                sourceNode.setHostName(runtimeSASEnvironment.getPrimaryMetdataTier().getHostName());
                sourceNodes.add(sourceNode);
                this.logger.debug("Replacing metadata host wid primary metadata host,sourcenode after replacing metadata:" + sourceNodes);
                continue;
            }
            sourceNodes.add(sourceNode);
        }
        this.helper.ensureRequiredTiersAreReachable(sourceNodes);
        List availableSASTiers = runtimeSASEnvironment.getAvailableTiers();
        this.helper.removeExcludedTiersFromSASTierList(availableSASTiers);
        List<BackupSourceNode> backupSourceNodes = this.configBeanConverter.sasTierToBackupSourceNodeList(availableSASTiers, runtimeSASEnvironment.getPrimaryMetdataTier());
        Set<BackupSourceNode> uniqueSourceNodes = this.nodeHelper.getUniqueElements(backupSourceNodes);
        uniqueSourceNodes.retainAll(sourceNodes);
        this.logger.debug("startSessionOnRequiredTiers() Unique source node during recovery:" + uniqueSourceNodes);
        BackupServiceSession session = this.sessionManager.startSession(uniqueSourceNodes, "Recover");
        return session;
    }

    private BackupServiceResult<RecoveryDetails> getBackupPurgedResult(BackupDetails backup, BackupServiceSession<RecoveryDetails> session) {
        this.logger.error(RB.getStringResource("BackupService.UnableToRecoverOfflineBackup.log"));
        RecoveryDetails recovery = new RecoveryDetails(backup);
        recovery.setErrorMessage(RB.getStringResource("BackupService.UnableToRecoverOfflineBackup.log"));
        BackupServiceResult result = new BackupServiceResult();
        result.setActualResult((Object)recovery);
        session.setResult(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupServiceResult<RecoveryDetails> getMostRecentRecovery() throws BackupException {
        RecoveryDetails details = null;
        BackupServiceSession session = null;
        boolean immutableSessionAlreadyRunning = this.sessionManager.isImmutableSessionStarted();
        session = this.sessionManager.getMockSession("getMostRecentRecovery");
        try {
            RuntimeSASEnvironment runtimeSASEnvironment = this.helper.getRuntimeSASEnvironment();
            this.helper.ensurePrimaryTierIsReachable(runtimeSASEnvironment);
            BackupSourceNode primaryNode = this.configBeanConverter.sasTierToBackupSourceNode(runtimeSASEnvironment.getPrimaryMetdataTier());
            if (this.sessionManager.startImmutableSessionOn(primaryNode, session, "getMostRecentRecovery")) {
                details = this.helper.getMostRecentRecovery(session);
            }
        }
        catch (BackupException e) {
            this.helper.addOperationtypeAndLog(e, session, "gethistory");
        }
        catch (Throwable t) {
            BackupException e = new BackupException("Fatal error encountered while trying to retrieve most recent recovery.", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_HISTORY_ERROR.getErrorCode());
            this.helper.addOperationtypeAndLog(e, session, "gethistory");
        }
        finally {
            if (!immutableSessionAlreadyRunning) {
                this.sessionManager.resetImmutableSession();
                this.helper.deleteTempDirectory();
            }
        }
        session.getResult().setActualResult(details);
        return session == null ? null : session.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupServiceResult<RecoveryDetails> getRecoveryBySlugName(String slug) throws BackupException {
        RecoveryDetails details = null;
        boolean immutableSessionAlreadyRunning = this.sessionManager.isImmutableSessionStarted();
        BackupServiceSession session = this.sessionManager.getMockSession("getRecoveryBySlugName");
        try {
            RuntimeSASEnvironment runtimeSASEnvironment = this.helper.getRuntimeSASEnvironment();
            this.helper.ensurePrimaryTierIsReachable(runtimeSASEnvironment);
            BackupSourceNode primaryNode = this.configBeanConverter.sasTierToBackupSourceNode(runtimeSASEnvironment.getPrimaryMetdataTier());
            if (this.sessionManager.startImmutableSessionOn(primaryNode, session, "getRecoveryBySlugName")) {
                details = this.xmlOperationDAO.getRecoveryBySlugName(slug);
            }
        }
        catch (BackupException e) {
            this.helper.addOperationtypeAndLog(e, session, "gethistory");
        }
        catch (Throwable t) {
            BackupException e = new BackupException("Fatal error encountered while trying to retrieve recovery details for given slug name " + slug, t, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_HISTORY_ERROR.getErrorCode());
            this.helper.addOperationtypeAndLog(e, session, "gethistory");
        }
        finally {
            if (!immutableSessionAlreadyRunning) {
                this.sessionManager.resetImmutableSession();
                this.helper.deleteTempDirectory();
            }
        }
        session.getResult().setActualResult(details);
        return session == null ? null : session.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupServiceResult<RecoveryDetails> getRecoveryByName(String name) throws BackupException {
        RecoveryDetails details = null;
        BackupServiceSession session = null;
        boolean immutableSessionAlreadyRunning = this.sessionManager.isImmutableSessionStarted();
        session = this.sessionManager.getMockSession("getRecoveryByName");
        try {
            RuntimeSASEnvironment runtimeSASEnvironment = this.helper.getRuntimeSASEnvironment();
            this.helper.ensurePrimaryTierIsReachable(runtimeSASEnvironment);
            BackupSourceNode primaryNode = this.configBeanConverter.sasTierToBackupSourceNode(runtimeSASEnvironment.getPrimaryMetdataTier());
            if (this.sessionManager.startImmutableSessionOn(primaryNode, session, "getRecoveryByName")) {
                details = this.xmlOperationDAO.getRecoveryByName(name);
            }
        }
        catch (BackupException e) {
            this.helper.addOperationtypeAndLog(e, session, "gethistory");
        }
        catch (Throwable t) {
            BackupException e = new BackupException("Fatal error encountered while trying to retrieve recovery details for given name " + name, t, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_HISTORY_ERROR.getErrorCode());
            this.helper.addOperationtypeAndLog(e, session, "gethistory");
        }
        finally {
            if (!immutableSessionAlreadyRunning) {
                this.sessionManager.resetImmutableSession();
                this.helper.deleteTempDirectory();
            }
        }
        session.getResult().setActualResult(details);
        return session == null ? null : session.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupServiceResult<RecoveryDetails> refreshRecovery(RecoveryDetails recovery) throws BackupException {
        RecoveryDetails details = null;
        BackupServiceSession session = null;
        boolean immutableSessionAlreadyRunning = this.sessionManager.isImmutableSessionStarted();
        session = this.sessionManager.getMockSession("refreshRecovery");
        try {
            RuntimeSASEnvironment runtimeSASEnvironment = this.helper.getRuntimeSASEnvironment();
            this.helper.ensurePrimaryTierIsReachable(runtimeSASEnvironment);
            BackupSourceNode primaryNode = this.configBeanConverter.sasTierToBackupSourceNode(runtimeSASEnvironment.getPrimaryMetdataTier());
            if (this.sessionManager.startImmutableSessionOn(primaryNode, session, "refreshRecovery")) {
                details = this.xmlOperationDAO.getRecoveryByName(recovery.getName());
            }
        }
        catch (BackupException e) {
            this.helper.addOperationtypeAndLog(e, session, "gethistory");
        }
        catch (Throwable t) {
            BackupException e = new BackupException("Fatal error encountered while trying to refresh recovery details.", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_HISTORY_ERROR.getErrorCode());
            this.helper.addOperationtypeAndLog(e, session, "gethistory");
        }
        finally {
            if (!immutableSessionAlreadyRunning) {
                this.sessionManager.resetImmutableSession();
                this.helper.deleteTempDirectory();
            }
        }
        session.getResult().setActualResult(details);
        return session == null ? null : session.getResult();
    }

    public BackupServiceResult<Boolean> isMostRecentRecovery(RecoveryDetails recovery) throws BackupException {
        boolean result = false;
        BackupServiceSession session = null;
        boolean immutableSessionAlreadyRunning = this.sessionManager.isImmutableSessionStarted();
        session = this.sessionManager.getMockSession("isMostRecentRecovery");
        try {
            RecoveryDetails latestRecovery;
            RuntimeSASEnvironment runtimeSASEnvironment = this.helper.getRuntimeSASEnvironment();
            this.helper.ensurePrimaryTierIsReachable(runtimeSASEnvironment);
            BackupSourceNode primaryNode = this.configBeanConverter.sasTierToBackupSourceNode(runtimeSASEnvironment.getPrimaryMetdataTier());
            if (this.sessionManager.startImmutableSessionOn(primaryNode, session, "isMostRecentRecovery") && recovery != null && (latestRecovery = this.helper.getMostRecentRecovery(session)) != null && recovery.getName().equals(latestRecovery.getName())) {
                result = true;
            }
        }
        catch (BackupException e) {
            this.helper.addOperationtypeAndLog(e, session, "gethistory");
            throw e;
        }
        catch (Throwable t) {
            BackupException e = new BackupException("Fatal error encountered while trying to retrieve most recent recovery.", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_HISTORY_ERROR.getErrorCode());
            this.helper.addOperationtypeAndLog(e, session, "gethistory");
            throw e;
        }
        finally {
            if (!immutableSessionAlreadyRunning) {
                this.sessionManager.resetImmutableSession();
            }
        }
        session.getResult().setActualResult((Object)result);
        return session == null ? null : session.getResult();
    }

    public BackupServiceResult<Map<String, List<DirectoryDetails>>> getCustomDirs() throws BackupException {
        Map<String, List<DirectoryDetails>> customdirs = null;
        BackupServiceSession session = null;
        session = this.sessionManager.getMockSession("getCustomDirs");
        try {
            RuntimeSASEnvironment runtimeSASEnvironment = this.helper.getRuntimeSASEnvironment();
            this.helper.ensurePrimaryTierIsReachable(runtimeSASEnvironment);
            customdirs = this.configurationService.getCustomDirs();
        }
        catch (BackupException e) {
            this.helper.addOperationtypeAndLog(e, session, "getconfig");
        }
        catch (Throwable t) {
            BackupException be = new BackupException("Fatal error encountered while trying to retrieve information for customer specified directory(ies).", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONFIG_ERROR.getErrorCode());
            this.helper.addOperationtypeAndLog(be, session, "getconfig");
        }
        session.getResult().setActualResult(customdirs);
        return session == null ? null : session.getResult();
    }

    public BackupServiceResult<List<BackupSchedule>> getBackupSchedule() throws BackupException {
        List<BackupSchedule> schedules = null;
        BackupServiceSession session = this.sessionManager.getMockSession("getBackupSchedule");
        try {
            schedules = this.configurationService.getBackupSchedules();
        }
        catch (BackupException e) {
            this.helper.addOperationtypeAndLog(e, session, "getconfig");
        }
        catch (Throwable e) {
            BackupException be = new BackupException("Fatal error encountered while trying  to retrieve information for backup schedule.", e, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONFIG_ERROR.getErrorCode());
            this.helper.addOperationtypeAndLog(be, session, "getconfig");
        }
        session.getResult().setActualResult(schedules);
        return session == null ? null : session.getResult();
    }

    public BackupServiceResult<Boolean> setBackupSchedule(List<BackupSchedule> schedule) throws BackupException {
        BackupServiceSession session = this.sessionManager.getMockSession("setBackupSchedule");
        boolean result = false;
        try {
            result = this.backupSchedulingService.updateBackupSchedule(schedule);
            if (result) {
                this.configurationService.setBackupSchedules(schedule);
            }
        }
        catch (BackupException e) {
            this.helper.addOperationtypeAndLog(e, session, "setconfig");
        }
        catch (Throwable t) {
            BackupException be = new BackupException("Fatal error encountered while trying  to set backup schedule.", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_SET_CONFIG_ERROR.getErrorCode());
            this.helper.addOperationtypeAndLog(be, session, "setconfig");
        }
        session.getResult().setActualResult((Object)result);
        return session == null ? null : session.getResult();
    }

    @Deprecated
    public BackupServiceResult<Boolean> setCustomDirs(Map<String, List<DirectoryDetails>> customDirsWithHostNames) throws BackupException {
        boolean addedCustomDirs = false;
        BackupServiceSession session = null;
        session = this.sessionManager.getMockSession("setCustomDirs");
        try {
            RuntimeSASEnvironment runtimeSASEnvironment = this.helper.getRuntimeSASEnvironment();
            this.helper.ensurePrimaryTierIsReachable(runtimeSASEnvironment);
            addedCustomDirs = this.configurationService.setCustomDirs(customDirsWithHostNames);
        }
        catch (BackupException e) {
            this.helper.addOperationtypeAndLog(e, session, "setconfig");
        }
        catch (Throwable t) {
            BackupException be = new BackupException("Fatal error encountered while trying  to set customer directories.", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_SET_CONFIG_ERROR.getErrorCode());
            this.helper.addOperationtypeAndLog(be, session, "setconfig");
        }
        session.getResult().setActualResult((Object)addedCustomDirs);
        return session == null ? null : session.getResult();
    }

    public BackupServiceResult<Boolean> addCustomDirs(Map<String, List<DirectoryDetails>> customDirsWithHostNames) throws BackupException {
        boolean addedCustomDirs = false;
        BackupServiceSession session = null;
        session = this.sessionManager.getMockSession("addCustomDirs");
        try {
            RuntimeSASEnvironment runtimeSASEnvironment = this.helper.getRuntimeSASEnvironment();
            this.helper.ensurePrimaryTierIsReachable(runtimeSASEnvironment);
            addedCustomDirs = this.configurationService.addCustomDirs(customDirsWithHostNames);
        }
        catch (BackupException e) {
            this.helper.addOperationtypeAndLog(e, session, "setconfig");
        }
        catch (Throwable t) {
            BackupException be = new BackupException("Fatal error encountered while trying  to add customer directories.", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_SET_CONFIG_ERROR.getErrorCode());
            this.helper.addOperationtypeAndLog(be, session, "setconfig");
        }
        session.getResult().setActualResult((Object)addedCustomDirs);
        return session == null ? null : session.getResult();
    }

    public List<String> getUnreachableHosts() throws BackupException {
        RuntimeSASEnvironment runtimeSASEnvironment = this.helper.getRuntimeSASEnvironment();
        List unreachableTiers = runtimeSASEnvironment.getUnreachableTiers();
        ArrayList<String> tierHosts = new ArrayList<String>();
        if (!BackupServiceUtils.isEmpty(unreachableTiers)) {
            for (SASTier unreachableTier : unreachableTiers) {
                tierHosts.add(unreachableTier.getHostName());
            }
        }
        return tierHosts;
    }

    public BackupServiceResult<UserBackupConfiguration> getUserConfiguration() throws BackupException {
        BackupServiceSession session = null;
        UserBackupConfiguration userConfiguration = null;
        try {
            session = this.sessionManager.getMockSession("getUserConfiguration");
            RuntimeSASEnvironment runtimeSASEnvironment = this.helper.getRuntimeSASEnvironment();
            this.helper.ensurePrimaryTierIsReachable(runtimeSASEnvironment);
            this.logger.debug("Calling UserConfigurationService.getConfiguration()");
            userConfiguration = this.userConfService.getConfiguration();
        }
        catch (BackupException e) {
            this.helper.addOperationtypeAndLog(e, session, "getconfig");
        }
        catch (Throwable t) {
            BackupException be = new BackupException("Fatal error encountered while trying to get source configuration information.", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONFIG_ERROR.getErrorCode());
            this.helper.addOperationtypeAndLog(be, session, "getconfig");
        }
        this.helper.setSessionResult(session, userConfiguration);
        return session == null ? null : session.getResult();
    }

    @Deprecated
    public BackupServiceResult<SASTierProxy> getSASTier(String tierid) throws BackupException {
        BackupServiceSession session = this.sessionManager.getMockSession("getSASTier");
        SASTierProxy searchTier = null;
        try {
            this.logger.debug("Calling UserConfigurationService.getSASTiers()");
            SASTiers tiers = this.userConfService.getSASTiers();
            List tiersList = tiers.getSasTiers();
            for (SASTierProxy tier : tiersList) {
                if (!tier.getTierName().equals(tierid)) continue;
                searchTier = tier;
                break;
            }
        }
        catch (BackupException e) {
            this.helper.addOperationtypeAndLog(e, session, "getconfig");
        }
        catch (Throwable t) {
            BackupException be = new BackupException("Fatal error encountered while trying to get source configuration information.", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONFIG_ERROR.getErrorCode());
            this.helper.addOperationtypeAndLog(be, session, "getconfig");
        }
        this.helper.setSessionResult(session, searchTier);
        return session == null ? null : session.getResult();
    }

    @Deprecated
    public BackupServiceResult<Boolean> setSASTiers(SASTiers tiers) throws BackupException {
        BackupServiceSession session = this.sessionManager.getMockSession("setSASTiers");
        try {
            this.userConfService.setSASTiers(tiers);
            session.getResult().setActualResult((Object)true);
        }
        catch (BackupException e) {
            this.helper.addOperationtypeAndLog(e, session, "setconfig");
        }
        catch (Throwable t) {
            BackupException e = new BackupException("Fatal error encountered while trying to set user configuration information.", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_SET_CONFIG_ERROR.getErrorCode());
            this.helper.addOperationtypeAndLog(e, session, "setconfig");
        }
        return session == null ? null : session.getResult();
    }

    @Deprecated
    public BackupServiceResult<SASTiers> getSASTiers() throws BackupException {
        BackupServiceSession session = this.sessionManager.getMockSession("getSASTiers");
        SASTiers sasTiers = null;
        try {
            this.logger.debug("Calling UserConfigurationService.getSASTiers()");
            sasTiers = this.userConfService.getSASTiers();
        }
        catch (BackupException e) {
            this.helper.addOperationtypeAndLog(e, session, "getconfig");
        }
        catch (Throwable t) {
            BackupException be = new BackupException("Fatal error encountered while trying to get source configuration information.", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONFIG_ERROR.getErrorCode());
            this.helper.addOperationtypeAndLog(be, session, "getconfig");
        }
        this.helper.setSessionResult(session, sasTiers);
        return session == null ? null : session.getResult();
    }

    @Deprecated
    public BackupServiceResult<UserSourceConfiguration> displaySoureceConfiguration(BackupSourceConfig.BackupSource sourceType) throws BackupException {
        BackupServiceSession session = this.sessionManager.getMockSession("displaySourceConfiguration");
        UserSourceConfiguration userConfiguration = null;
        try {
            this.logger.debug("Calling UserConfigurationService.getMergedConfiguration(" + sourceType + ")");
            userConfiguration = this.userConfService.getMergedConfiguration(sourceType);
        }
        catch (BackupException e) {
            this.helper.addOperationtypeAndLog(e, session, "getconfig");
        }
        catch (Throwable t) {
            BackupException be = new BackupException("Fatal error encountered while trying to get source configuration information.", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONFIG_ERROR.getErrorCode());
            this.helper.addOperationtypeAndLog(be, session, "getconfig");
        }
        this.helper.setSessionResult(session, userConfiguration);
        return session == null ? null : session.getResult();
    }

    @Deprecated
    public BackupServiceResult<UserSourceConfiguration> getUserSoureceConfiguration(BackupSourceConfig.BackupSource sourceType) throws BackupException {
        BackupServiceSession session = this.sessionManager.getMockSession("getUserSourceConfiguration");
        UserSourceConfiguration userConfiguration = null;
        try {
            this.logger.debug("Calling UserConfigurationService.getSourceConfig(" + sourceType + ")");
            userConfiguration = this.userConfService.getSourceConfig(sourceType);
        }
        catch (BackupException e) {
            this.helper.addOperationtypeAndLog(e, session, "getconfig");
        }
        catch (Throwable t) {
            BackupException be = new BackupException("Fatal error encountered while trying to get source configuration information.", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONFIG_ERROR.getErrorCode());
            this.helper.addOperationtypeAndLog(be, session, "getconfig");
        }
        this.helper.setSessionResult(session, userConfiguration);
        return session == null ? null : session.getResult();
    }

    @Deprecated
    public BackupServiceResult<Boolean> setUserSourceConfiguration(UserSourceConfiguration sourceConfig, BackupSourceConfig.BackupSource sourceType) throws BackupException {
        BackupServiceSession session = this.sessionManager.getMockSession("setUserSourceConfiguration");
        try {
            this.userConfService.setSourceConfiguration(sourceConfig, sourceType);
            session.getResult().setActualResult((Object)true);
        }
        catch (BackupException e) {
            this.helper.addOperationtypeAndLog(e, session, "setconfig");
        }
        catch (Throwable t) {
            BackupException e = new BackupException("Fatal error encountered while trying to set user  source configuration information.", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_SET_CONFIG_ERROR.getErrorCode());
            this.helper.addOperationtypeAndLog(e, session, "setconfig");
        }
        return session == null ? null : session.getResult();
    }
}

