/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.spi;

import com.sas.codepolicy.SASScope;
import com.sas.services.session.SessionServiceInterface;
import com.sas.services.user.UserServiceInterface;
import com.sas.svcs.backup.client.BackupConfiguration;
import com.sas.svcs.backup.client.BackupOptions;
import com.sas.svcs.backup.client.BackupSchedule;
import com.sas.svcs.backup.client.BackupService;
import com.sas.svcs.backup.spi.BackupConfigurationService;
import com.sas.svcs.backup.spi.RB;
import com.sas.text.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.locks.Lock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;

public class BackupSchedulingServiceImpl {
    private static final Logger logger = LogManager.getLogger(BackupSchedulingServiceImpl.class);
    @Autowired
    @Qualifier(value="BackupService")
    BackupService backupService;
    Lock lock;
    @Autowired
    BackupConfigurationService configurationService;
    @Autowired
    ThreadPoolTaskScheduler scheduler;
    UserServiceInterface userService;
    SessionServiceInterface sessionService;
    String username;
    String password;
    private static final List<ScheduledFuture> scheduledTasks = new ArrayList<ScheduledFuture>();
    private static final String ZERO = "0";
    private static final String SPACE = " ";
    private static final String STAR = "*";
    private static final String QUESTIONMARK = "?";
    private static final String COMMA = ",";
    private static boolean schedulerRunning;
    private Map<String, List<BackupSchedule>> eventMap = new HashMap<String, List<BackupSchedule>>();
    private List<String> cronExpressions = new ArrayList<String>();
    final String expression = "";

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public UserServiceInterface getUserService() {
        return this.userService;
    }

    public void setUserService(UserServiceInterface userService) {
        this.userService = userService;
    }

    public SessionServiceInterface getSessionService() {
        return this.sessionService;
    }

    public void setSessionService(SessionServiceInterface sessionService) {
        this.sessionService = sessionService;
    }

    public Lock getLock() {
        return this.lock;
    }

    public void setLock(Lock lock) {
        this.lock = lock;
    }

    public static boolean isSchedulerRunning() {
        return schedulerRunning;
    }

    @SASScope
    public static void setSchedulerRunning(boolean schedulerRunning) {
        BackupSchedulingServiceImpl.schedulerRunning = schedulerRunning;
    }

    boolean updateBackupSchedule(List<BackupSchedule> schedule) {
        this.eventMap.clear();
        this.cronExpressions.clear();
        boolean result = false;
        for (BackupSchedule event : schedule) {
            int hour = event.getHour();
            int minute = event.getMinute();
            String strHour = Integer.toString(hour);
            StringBuffer key = new StringBuffer(4);
            if (hour < 10) {
                key.append(ZERO);
            }
            key.append(strHour);
            String strMinute = Integer.toString(minute);
            if (minute < 10) {
                key.append(ZERO);
            }
            key.append(strMinute);
            List<BackupSchedule> eventSchedule = this.eventMap.get(key.toString());
            if (eventSchedule == null) {
                eventSchedule = new ArrayList<BackupSchedule>();
                this.eventMap.put(key.toString(), eventSchedule);
            }
            eventSchedule.add(event);
        }
        for (String eventKey : this.eventMap.keySet()) {
            this.cronExpressions.add(this.getCRONExpression(eventKey));
        }
        result = this.reschedule();
        return result;
    }

    private boolean reschedule() {
        if (this.cancelPreviousSchedules()) {
            scheduledTasks.clear();
            for (String cronExpression : this.cronExpressions) {
                logger.debug("Scheduling backup with CRON Expression: " + cronExpression);
                this.addSchedule(cronExpression);
            }
        } else {
            logger.error(RB.getStringResource("BackupSchedulingServiceImpl.new.schedules.cannot.be.applied.txt"));
            return false;
        }
        return true;
    }

    private String getCRONExpression(String eventKey) {
        logger.debug("Key:" + eventKey);
        StringBuffer cronExpression = new StringBuffer();
        cronExpression.append("0 ");
        cronExpression.append(eventKey.substring(2, 4) + SPACE);
        cronExpression.append(eventKey.substring(0, 2) + SPACE);
        cronExpression.append("? * ");
        cronExpression.append(this.createDayofWeekExpression(this.eventMap.get(eventKey)));
        return cronExpression.toString();
    }

    private String createDayofWeekExpression(List<BackupSchedule> schedule) {
        StringBuffer dayofWeek = new StringBuffer();
        HashSet<Integer> daysSet = new HashSet<Integer>();
        for (BackupSchedule event : schedule) {
            int ord = event.getDayOfweek().ordinal();
            int dayIndex = 7;
            if (ord != 0) {
                dayIndex = ord;
            }
            daysSet.add(new Integer(dayIndex));
        }
        ArrayList daysList = new ArrayList(daysSet);
        Collections.sort(daysList);
        for (Integer integer : daysList) {
            if (dayofWeek.length() != 0) {
                dayofWeek.append(COMMA);
            }
            dayofWeek.append(integer.toString());
        }
        return dayofWeek.toString();
    }

    public void addSchedule(String cronExpression) {
        Runnable task = this.getBackupServiceTask(cronExpression);
        logger.debug("Adding new " + task.toString());
        ScheduledFuture scheduleFuture = this.scheduler.schedule(task, (Trigger)new CronTrigger(cronExpression));
        scheduledTasks.add(scheduleFuture);
    }

    private Runnable getBackupServiceTask(final String cronExpression) {
        return new Runnable(){
            String expression;
            {
                this.expression = cronExpression;
            }

            @Override
            public void run() {
                logger.info("Trying to aquire geode lock.");
                if (BackupSchedulingServiceImpl.this.lock == null || BackupSchedulingServiceImpl.this.lock.tryLock()) {
                    logger.info("Aquired geode lock.");
                    try {
                        SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)new User(BackupSchedulingServiceImpl.this.username, BackupSchedulingServiceImpl.this.password, true, true, true, true, Arrays.asList(new GrantedAuthority[0])), (Object)"aBigSecret"));
                        BackupConfiguration config = BackupSchedulingServiceImpl.this.configurationService.getBaseConfiguration();
                        if (config.isScheduledBackupsAllowed()) {
                            BackupOptions options = BackupOptions.getInstance((String)RB.getStringResource("BackupSchedulingServiceImpl.scheduled.backup.comment.txt"));
                            options.setScheduled(true);
                            BackupSchedulingServiceImpl.this.backupService.startBackup(options);
                        }
                        logger.warn("Schedule has been set for backups however scheduled backups are not allowed. Exiting.");
                    }
                    catch (Exception e) {
                        logger.error("Unable to perform scheduled backup. Invalid authentication");
                        e.printStackTrace();
                    }
                    finally {
                        if (BackupSchedulingServiceImpl.this.lock != null) {
                            logger.info("Releasing geode lock.");
                            BackupSchedulingServiceImpl.this.lock.unlock();
                        }
                    }
                } else {
                    logger.info("Unable to aquire geode lock. Exiting.");
                }
            }

            public String toString() {
                return Message.format((String)RB.getStringResource("BackupSchedulingServiceImpl.schedules.task.with.cron.exp.fmt"), (Object)this.expression);
            }
        };
    }

    private boolean cancelPreviousSchedules() {
        boolean result = true;
        Iterator<ScheduledFuture> itr = scheduledTasks.iterator();
        while (itr.hasNext()) {
            ScheduledFuture task = itr.next();
            boolean localresult = task.cancel(false);
            if (localresult) {
                logger.info(Message.format((String)RB.getStringResource("BackupSchedulingServiceImpl.task.cancelled.fmt"), (Object)task.toString()));
                itr.remove();
            } else {
                logger.warn(Message.format((String)RB.getStringResource("BackupSchedulingServiceImpl.unable.to.cancel.task.fmt"), (Object)task.toString()));
            }
            result = result || localresult;
        }
        return result;
    }
}

