/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.spi;

import com.sas.svcs.backup.analyze.model.RuntimeSASEnvironment;
import com.sas.svcs.backup.client.BackupConfiguration;
import com.sas.svcs.backup.client.BackupSchedule;
import com.sas.svcs.backup.client.BackupServiceSession;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.BackupSourceNode;
import com.sas.svcs.backup.client.DirectoryDetails;
import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.BackupNodeHelper;
import com.sas.svcs.backup.dao.BackupServerHelperDAO;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import com.sas.svcs.backup.dao.ConfigBeanConverter;
import com.sas.svcs.backup.dao.OMRBackupSourceSupportService;
import com.sas.svcs.backup.dao.OMRDeploymentBackupConfiguration;
import com.sas.svcs.backup.dao.XMLOperationDAO;
import com.sas.svcs.backup.spi.RB;
import com.sas.svcs.backup.spi.SessionManager;
import com.sas.text.Message;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class BackupConfigurationService {
    private static final Logger logger = LogManager.getLogger(BackupConfigurationService.class);
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="XMLOperationDAO")
    private XMLOperationDAO XMLOperationDAO;
    @Autowired
    @Qualifier(value="DeploymentBackupConfiguration")
    private OMRDeploymentBackupConfiguration backupConfigComponent;
    @Autowired
    private BackupServerHelperDAO backupServer;
    @Autowired
    private BackupNodeHelper nodeHelper;
    @Autowired
    SessionManager sessionManager;
    @Autowired
    ConfigBeanConverter configBeanConverter;

    public BackupConfiguration getConfiguration(BackupServiceSession<?> session, RuntimeSASEnvironment runtimeSASEnvironment) throws BackupException {
        logger.info(RB.getStringResource("BackupConfigurationService.reading.backupconfig.txt"));
        BackupConfiguration backupConfig = null;
        try {
            BackupSourceNode[] lstBackupSourceNodes;
            backupConfig = this.getBaseConfiguration();
            List<BackupSourceConfig> sourceConfigs = this.getSourceConfigurations(session, runtimeSASEnvironment);
            backupConfig.setSources(sourceConfigs);
            if (backupConfig != null && !BackupServiceUtils.isEmpty(lstBackupSourceNodes = this.nodeHelper.getUniqueSourceNodes(backupConfig).toArray(new BackupSourceNode[0]))) {
                boolean isBackupServerConfigured = true;
                for (BackupSourceNode sourceNode : lstBackupSourceNodes) {
                    if (this.backupConfigComponent.isBackupServerAlreadyConfigured(sourceNode)) continue;
                    isBackupServerConfigured = false;
                    break;
                }
                if (isBackupServerConfigured) {
                    this.XMLOperationDAO.setConfig(backupConfig);
                } else {
                    logger.debug("Backup Server is not yet configured on all tiers. Hence not storing configuration information in BackupConfiguration.xml");
                }
            }
            logger.info(RB.getStringResource("BackupConfigurationService.read.backupconfig.txt"));
        }
        catch (BackupException e) {
            if (e.getErrorInfo("operationType") == null) {
                e.setErrorInfo("operationType", "getconfig");
            }
            throw e;
        }
        catch (Throwable t) {
            BackupException e = new BackupException(t, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONFIG_ERROR.getErrorCode());
            e.setErrorInfo("operationType", "getconfig");
            throw e;
        }
        return backupConfig;
    }

    public void reloadConfiguration(BackupConfiguration config) throws BackupException {
        logger.info("Reloading configuration");
        try {
            this.reloadSharedConfiguration(config);
            this.reloadSourceConfiguration(config);
        }
        catch (BackupException e) {
            if (e.getErrorInfo("operationType") == null) {
                e.setErrorInfo("operationType", "getconfig");
            }
            throw e;
        }
    }

    private void reloadSourceConfiguration(BackupConfiguration config) throws BackupException {
        List sourceConfigs = config.getSources();
        List<BackupSourceNode> uniqueSourceNodes = this.nodeHelper.getAllSourceNodes(config);
        for (BackupSourceConfig sourceConfig : sourceConfigs) {
            for (BackupSourceConfig.BackupSource sourceType : BackupSourceConfig.BackupSource.values()) {
                this.reloadSourceConfigurationProperties(sourceType, sourceConfig);
            }
        }
    }

    private void reloadSourceConfigurationProperties(BackupSourceConfig.BackupSource sourceType, BackupSourceConfig sourceConfig) throws BackupException {
        OMRBackupSourceSupportService omrSupportService = this.getOMRSupportService(sourceType);
        if (omrSupportService != null) {
            omrSupportService.reloadSourceConfig(sourceConfig);
        }
    }

    private void reloadSharedConfiguration(BackupConfiguration config) throws BackupException {
        logger.debug("Reloading shared properties (sharedValut, Retention  period etc.) from backup server component");
        config.setId("Default");
        config.setDaysToRetainBackups(this.backupConfigComponent.getRetentionPeriod());
        config.setScheduledBackupsAllowed(this.backupConfigComponent.isScheduledBackupsAllowed());
        config.setVaultLocation(this.backupConfigComponent.getSharedVaultLocation());
        logger.debug("Retention  Period:" + config.getDaysToRetainBackups() + ". Are scheduled backup allowed " + config.isScheduledBackupsAllowed() + ". Shared vault location: " + config.getVaultLocation());
    }

    public void setConfiguration(BackupConfiguration config) throws BackupException {
        try {
            if (config != null) {
                String[] userEmail;
                int retentionPeriod = config.getDaysToRetainBackups();
                this.backupConfigComponent.setRetentionPeriod(retentionPeriod);
                String sharedVaultLocation = config.getVaultLocation();
                if (sharedVaultLocation != null) {
                    this.backupConfigComponent.setSharedVaultLocation(sharedVaultLocation);
                    logger.warn(Message.format((String)RB.getStringResource("BackupConfigurationService.sharedvault.updated.no.validation.fmt"), (Object)config.getVaultLocation()));
                }
                if ((userEmail = config.getEmailToList()) != null) {
                    this.backupConfigComponent.setEmailToList(config.getEmailToList());
                }
                boolean scheduledAllowed = config.isScheduledBackupsAllowed();
                this.backupConfigComponent.setScheduledBackupsAllowed(scheduledAllowed);
            }
        }
        catch (BackupException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BackupException(BackupErrorConstants.ErrorCodes.ERROR_CODE_SET_CONFIG_ERROR.getErrorCode());
        }
    }

    public void setBackupSchedules(List<BackupSchedule> schedules) throws BackupException {
        if (schedules != null) {
            this.backupConfigComponent.setSchedules(schedules);
            this.XMLOperationDAO.setSchedule(schedules);
        }
    }

    public boolean addCustomDirs(Map<String, List<DirectoryDetails>> customDirsWithHostNames) throws BackupException {
        if (customDirsWithHostNames != null && !customDirsWithHostNames.isEmpty()) {
            return this.backupConfigComponent.addCustomDirs(customDirsWithHostNames);
        }
        return false;
    }

    public boolean setCustomDirs(Map<String, List<DirectoryDetails>> customDirsWithHostNames) throws BackupException {
        if (customDirsWithHostNames != null) {
            return this.backupConfigComponent.setCustomDirs(customDirsWithHostNames);
        }
        return false;
    }

    public List<BackupSchedule> getBackupSchedules() throws BackupException {
        logger.debug("Retrieving scheduling information...");
        return this.backupConfigComponent.getSchedules();
    }

    public Map<String, List<DirectoryDetails>> getCustomDirs() throws BackupException {
        return this.backupConfigComponent.getCustomDirs();
    }

    private List<BackupSourceConfig> getSourceConfigurations(BackupServiceSession<?> session, RuntimeSASEnvironment runtimeSASEnvironment) throws BackupException {
        ArrayList<BackupSourceConfig> sourceConfigs = new ArrayList<BackupSourceConfig>();
        List<BackupSourceNode> lstBackupSourceNodes = this.configBeanConverter.sasTierToBackupSourceNodeList(runtimeSASEnvironment.getAvailableTiers(), runtimeSASEnvironment.getPrimaryMetdataTier());
        ArrayList<String> dbCalledHosts = new ArrayList<String>();
        if (BackupServiceUtils.isEmpty(session)) {
            session = this.sessionManager.getMockSession("getSourceConfigurations");
        }
        for (BackupSourceNode sourceNode : lstBackupSourceNodes) {
            for (BackupSourceConfig.BackupSource sourceType : BackupSourceConfig.BackupSource.values()) {
                Map<String, String> properties = this.getConfigurationProperties(sourceType, sourceNode, (BackupServiceSession)session);
                if (BackupServiceUtils.isEmpty(properties)) continue;
                boolean runDB = false;
                if (BackupSourceConfig.BackupSource.DATABASE.equals((Object)sourceType)) {
                    if (!dbCalledHosts.contains(sourceNode.getHostName()) && !this.isHostDBEqual(dbCalledHosts, sourceNode.getHostName())) {
                        dbCalledHosts.add(sourceNode.getHostName());
                        logger.debug("Adding to the list " + sourceNode.getHostName());
                        runDB = true;
                    }
                    logger.debug("if DataBase to run" + runDB);
                }
                if (BackupSourceConfig.BackupSource.DATABASE.equals((Object)sourceType) && !runDB) continue;
                BackupSourceConfig sourceConfig = new BackupSourceConfig();
                sourceConfig.setBackupSourceNode(sourceNode);
                sourceConfig.setSourceType(sourceType);
                Properties sourceProps = new Properties();
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (key == null || value == null) {
                        logger.warn(Message.format((String)RB.getStringResource("BackupConfigurationService.invalid.Key.Or.Value.fmt"), (Object)key, (Object)value, (Object)sourceType));
                        continue;
                    }
                    sourceProps.put(key, value);
                }
                sourceConfig.setProperties(sourceProps);
                sourceConfigs.add(sourceConfig);
            }
        }
        return sourceConfigs;
    }

    private boolean isHostDBEqual(List<String> dbCalledHosts, String hostName) {
        boolean hostAreEqual = false;
        if (dbCalledHosts != null) {
            Iterator<String> iterDBHost = dbCalledHosts.iterator();
            while (iterDBHost.hasNext()) {
                String dbHost = iterDBHost.next().toString();
                if (!BackupServiceUtils.isHostsEqual(dbHost, hostName)) continue;
                logger.debug("hostAreEqual" + hostAreEqual + "dbHost " + dbHost + "hostname" + hostName);
                return true;
            }
        }
        return hostAreEqual;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, String> getConfigurationProperties(BackupSourceConfig.BackupSource sourceType, BackupSourceNode sourceNode, BackupServiceSession session) throws BackupException {
        Map<String, String> configurationProperties = null;
        try {
            OMRBackupSourceSupportService omrSupportService = this.getOMRSupportService(sourceType);
            if (omrSupportService == null) return configurationProperties;
        }
        catch (BackupException e) {
            if (e.getErrorInfo("operationType") != null) throw e;
            e.setErrorInfo("operationType", "getconfig");
            throw e;
        }
        return configurationProperties;
    }

    public OMRBackupSourceSupportService getOMRSupportService(BackupSourceConfig.BackupSource sourceType) {
        if (null == sourceType) {
            throw new RuntimeException(Message.format((String)RB.getStringResource("BackupConfigurationService.sourcetype.not.found.fmt"), (Object)sourceType));
        }
        String type = "OMR" + sourceType.name();
        OMRBackupSourceSupportService service = null;
        try {
            service = (OMRBackupSourceSupportService)this.applicationContext.getBean(type, OMRBackupSourceSupportService.class);
        }
        catch (BeansException e) {
            logger.info(Message.format((String)RB.getStringResource("BackupConfigurationService.OMR.supportservice.notfound.fmt"), (Object)type));
        }
        if (service == null) {
            service = (OMRBackupSourceSupportService)this.applicationContext.getBean("OMRDefault", OMRBackupSourceSupportService.class);
        }
        return service;
    }

    public boolean reConfigureBackupServer(BackupSourceNode sourceNode, BackupServiceSession session, Map<String, String> updatedBackupServerProperties) throws BackupException {
        boolean isReConfigured = false;
        if (this.backupConfigComponent.isBackupServerAlreadyConfigured(sourceNode)) {
            isReConfigured = this.backupServer.reConfigure(sourceNode, updatedBackupServerProperties, session);
        }
        return isReConfigured;
    }

    public boolean configureBackupServer(BackupSourceNode sourceNode, BackupServiceSession session) throws BackupException {
        boolean isConfigured = false;
        Map<String, String> backupServerProperties = this.backupConfigComponent.getConfigurationProperties();
        String lstConfiguredHosts = backupServerProperties.get("svrbakupevm.configured.hosts");
        String hostNConfigDir = sourceNode.getHostName() + "|" + sourceNode.getConfigDirPath();
        if (!this.backupConfigComponent.isBackupServerAlreadyConfigured(sourceNode)) {
            isConfigured = this.backupServer.configure(sourceNode, backupServerProperties, session);
        }
        if (isConfigured) {
            lstConfiguredHosts = BackupServiceUtils.isEmpty(lstConfiguredHosts) ? hostNConfigDir : lstConfiguredHosts + "," + hostNConfigDir;
            isConfigured = this.backupConfigComponent.updateConfigurationProperties("svrbakupevm.configured.hosts", lstConfiguredHosts);
        }
        return isConfigured;
    }

    public BackupConfiguration getBaseConfiguration() throws BackupException {
        logger.debug("Retrieving shared properties (sharedValut, Retention  period etc.) from backup server component");
        BackupConfiguration sharedConfig = new BackupConfiguration();
        sharedConfig.setId("Default");
        sharedConfig.setDaysToRetainBackups(this.backupConfigComponent.getRetentionPeriod());
        sharedConfig.setScheduledBackupsAllowed(this.backupConfigComponent.isScheduledBackupsAllowed());
        sharedConfig.setVaultLocation(this.backupConfigComponent.getSharedVaultLocation());
        sharedConfig.setEmailToList(this.backupConfigComponent.getEmailToList());
        logger.debug("Retention  Period:" + sharedConfig.getDaysToRetainBackups() + ". Are scheduled backup allowed " + sharedConfig.isScheduledBackupsAllowed() + ". Shared vault location: " + sharedConfig.getVaultLocation());
        return sharedConfig;
    }
}

