/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.dao;

import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.metadata.ServerComponentInterface;
import com.sas.services.information.metadata.SoftwareComponentInterface;
import com.sas.services.information.metadata.servers.DataServerInterface;
import com.sas.services.information.metadata.servers.SASInfrastructureDataServerUtil;
import com.sas.svcs.authentication.helper.FoundationServicesUserSessionFactory;
import com.sas.svcs.backup.analyze.BackupTask;
import com.sas.svcs.backup.analyze.model.AnalysisResult;
import com.sas.svcs.backup.analyze.model.RuntimeSASEnvironment;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.UserConfigurationServiceInterface;
import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.BackupServerHelperDAO;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import com.sas.svcs.backup.dao.ContentServerUserNameAndPassword;
import com.sas.svcs.backup.dao.OMRBackupSourceSupportService;
import com.sas.svcs.backup.dao.OMRDeploymentBackupConfiguration;
import com.sas.svcs.backup.dao.RB;
import com.sas.svcs.backup.spi.ExternalDataBaseException;
import com.sas.svcs.deployment.DeploymentDiscoveryService;
import com.sas.svcs.deployment.dao.DeploymentDiscoveryDAO;
import com.sas.svcs.deployment.data.ConfigurableServer;
import com.sas.svcs.deployment.data.SASTier;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository(value="OMRCONTENTSERVER")
public class OMRContentServerSupportService
extends OMRBackupSourceSupportService {
    private static final Logger logger = LogManager.getLogger(OMRContentServerSupportService.class);
    private static final String SASINFRA_SERVERCOMPONENT_CLASSIDENTIFIER = "SASInfrastructureData";
    public static final String WEBAPPSERV_SOFTWARECOMPONENTCLASSIDENTIFIER = "webappsrv";
    private static final String SCS_WEBAPPSERV_DB_PORT = "webappsrv.dbms.port";
    @Autowired
    private OMRDeploymentBackupConfiguration omrDeploymentConf;
    @Autowired
    private DeploymentDiscoveryService discoverer;
    @Autowired
    private FoundationServicesUserSessionFactory userSessionFactory;
    @Autowired
    @Qualifier(value="ContentServerUserNameAndPassword")
    ContentServerUserNameAndPassword SCSUserPassWord;
    @Autowired
    @Qualifier(value="BackupServerHelperDAO")
    BackupServerHelperDAO backupServer;
    @Autowired
    @Qualifier(value="UserConfigurationService")
    UserConfigurationServiceInterface userConfigurationService;

    @Override
    public List<AnalysisResult.AnalysisProblem> analyze(RuntimeSASEnvironment sasEnvironment) throws BackupException {
        ArrayList<AnalysisResult.AnalysisProblem> analysisProblems = new ArrayList<AnalysisResult.AnalysisProblem>();
        try {
            ConfigurableServer server;
            boolean found = false;
            List contentServers = this.userConfigurationService.getConfigurableServers(BackupSourceConfig.BackupSource.CONTENTSERVER);
            if (contentServers != null && !contentServers.isEmpty() && (server = (ConfigurableServer)BackupServiceUtils.extractAsObject(contentServers)) != null) {
                if (!this.userConfigurationService.isCanonicalExclude(server, BackupSourceConfig.BackupSource.CONTENTSERVER)) {
                    if (server.getSasTier() != null) {
                        ServerComponentInterface contentServer = this.discoverer.getServerComponent(server.getEntityId());
                        if (contentServer != null) {
                            this.analyzeContentServer(analysisProblems, server);
                        } else {
                            analysisProblems.add(AnalysisResult.createErrorForSource((ConfigurableServer)server, (int)BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_DISCOVERY_FAILED.getErrorCode(), (String)Message.format((String)RB.getStringResource("OMRBackupSupportService.analyze.error.server.component.notfound.fmt"), (Object)server.getObjectName())));
                        }
                    } else {
                        analysisProblems.add(AnalysisResult.createErrorForSource((ConfigurableServer)server, (int)BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_DISCOVERY_FAILED.getErrorCode(), (String)Message.format((String)RB.getStringResource("OMRBackupSourceSupportService.analyze.error.sastier.notfound.fmt"), (Object)server.getObjectName())));
                    }
                }
                found = true;
            }
            if (!found) {
                analysisProblems.add(AnalysisResult.createError((int)BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_DISCOVERY_FAILED.getErrorCode(), (String)RB.getStringResource("OMRContentServerSupportService.analyze.error.content.server.notfound.txt")));
            }
            this.analyzeWIPDatabase(analysisProblems);
        }
        catch (RemoteException e) {
            String message = Message.format((String)RB.getStringResource("OMRBackupSourceSupportService.analyze.failed.with.unknown.error.fmt"), (Object)BackupSourceConfig.BackupSource.CONTENTSERVER);
            logger.error(message, (Throwable)e);
            analysisProblems.add(AnalysisResult.createProblem((int)BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_DISCOVERY_FAILED.getErrorCode(), (String)message));
        }
        catch (ServiceException e) {
            String message = Message.format((String)RB.getStringResource("OMRBackupSourceSupportService.analyze.failed.with.unknown.error.fmt"), (Object)BackupSourceConfig.BackupSource.CONTENTSERVER);
            logger.error(message, (Throwable)e);
            analysisProblems.add(AnalysisResult.createProblem((int)BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_DISCOVERY_FAILED.getErrorCode(), (String)message));
        }
        return analysisProblems;
    }

    private void analyzeWIPDatabase(List<AnalysisResult.AnalysisProblem> analysisProblems) {
        List wipDataServers = this.discoverer.getConfigurableServers(DeploymentDiscoveryDAO.ComponentType.SAS_WIP_DATA_SERVER);
        if (BackupServiceUtils.isEmpty(wipDataServers)) {
            analysisProblems.add(AnalysisResult.createProblem((int)BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_DISCOVERY_FAILED.getErrorCode(), (String)RB.getStringResource("OMRContentServerSupportService.analyze.error.wip.dataserver.notfound.txt")));
        }
    }

    private List<AnalysisResult.AnalysisProblem> analyzeContentServer(List<AnalysisResult.AnalysisProblem> analysisProblems, ConfigurableServer server) throws ServiceException, RemoteException {
        ServerComponentInterface contentServer = this.discoverer.getServerComponent(server.getEntityId());
        if (contentServer.getHost() == null) {
            analysisProblems.add(AnalysisResult.createErrorForSource((ConfigurableServer)server, (int)BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_DISCOVERY_FAILED.getErrorCode(), (String)Message.format((String)RB.getStringResource("OMRBackupSourceSupportService.analyze.error.host.notfound.fmt"), (Object)server.getObjectName())));
        }
        if (contentServer.getApplicationProtocol() == null) {
            analysisProblems.add(AnalysisResult.createProblem((int)BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_DISCOVERY_FAILED.getErrorCode(), (String)Message.format((String)RB.getStringResource("OMRBackupSourceSupportService.analyze.error.application.protocol.notfound.fmt"), (Object)server.getObjectName())));
        }
        if (contentServer.getTcpPort() <= 0) {
            analysisProblems.add(AnalysisResult.createProblem((int)BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_DISCOVERY_FAILED.getErrorCode(), (String)Message.format((String)RB.getStringResource("OMRBackupSourceSupportService.analyze.error.port.notfound.fmt"), (Object)server.getObjectName())));
        }
        return analysisProblems;
    }

    @Override
    public List<BackupTask> getBackupTasks(RuntimeSASEnvironment runtimeSASEnvironment) {
        logger.debug("Get task for SCS");
        BackupTask contentServerTask = null;
        for (SASTier sasTier : runtimeSASEnvironment.getAvailableTiers()) {
            ConfigurableServer contentServer;
            List contentServers = this.userConfigurationService.getConfigurableServers(BackupSourceConfig.BackupSource.CONTENTSERVER, sasTier);
            if (contentServers == null || contentServers.isEmpty() || (contentServer = (ConfigurableServer)BackupServiceUtils.extractAsObject(contentServers)) == null) continue;
            if (runtimeSASEnvironment.hasErrors(BackupSourceConfig.BackupSource.CONTENTSERVER, contentServer) || this.userConfigurationService.isExcluded(contentServer, BackupSourceConfig.BackupSource.CONTENTSERVER)) break;
            logger.info("Content server included , check for database");
            if (this.isContentServerOnInternalDatabase()) {
                SASTier configuredOn = contentServer.getSasTier();
                if (configuredOn == null) break;
                BackupTask.BackupTaskBuilder taskBuilder = BackupTask.getBackupNodeTaskBuilder(BackupSourceConfig.BackupSource.CONTENTSERVER, configuredOn);
                ServerComponentInterface content = this.discoverer.getServerComponent(contentServer.getEntityId());
                String userid = this.SCSUserPassWord.getServerUserid();
                String password = this.SCSUserPassWord.getServerPassword();
                try {
                    contentServerTask = taskBuilder.addParam("host", content.getHost()).addParam("httpprotocol", content.getApplicationProtocol()).addParam("port", String.valueOf(content.getTcpPort())).addParam("user", userid).addParam("pw", password).build();
                    break;
                }
                catch (RemoteException e) {
                    throw BackupException.getBuilder((int)BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_DISCOVERY_FAILED.getErrorCode()).setCause((Throwable)e).build();
                }
                catch (ServiceException e) {
                    throw BackupException.getBuilder((int)BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_DISCOVERY_FAILED.getErrorCode()).setCause((Throwable)e).build();
                }
            }
            logger.warn("Backup of SAS Content Server will not be taken as it's on external database");
            throw new ExternalDataBaseException();
        }
        return BackupServiceUtils.decorateAsList(contentServerTask);
    }

    private boolean isContentServerOnInternalDatabase() {
        boolean isInternalDB = true;
        try {
            logger.info("Check if database internal");
            SASInfrastructureDataServerUtil util = new SASInfrastructureDataServerUtil(this.userSessionFactory.getLocalSession());
            DataServerInterface datserverInterface = null;
            Map connectionInfo = null;
            try {
                List sasInfraDataServerComponents = this.omrDeploymentConf.getServerComponents(SASINFRA_SERVERCOMPONENT_CLASSIDENTIFIER);
                if (sasInfraDataServerComponents == null) {
                    logger.error(RB.getStringResource("OMRPostgresSupportService.error.sasinfra.component.notfound.txt"));
                    throw new BackupException(RB.getStringResource("OMRPostgresSupportService.error.sasinfra.component.notfound.txt"), BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_DISCOVERY_FAILED.getErrorCode());
                }
                block4: for (ServerComponentInterface postgresInstance : sasInfraDataServerComponents) {
                    List dependentComponents = postgresInstance.getDependentComponents();
                    for (SoftwareComponentInterface componentdependent : dependentComponents) {
                        if (!componentdependent.getClassIdentifier().equals(WEBAPPSERV_SOFTWARECOMPONENTCLASSIDENTIFIER)) continue;
                        datserverInterface = util.getServerByName(postgresInstance.getName());
                        if (datserverInterface != null) {
                            connectionInfo = datserverInterface.getServerProperties();
                        }
                        logger.info("Got connection info for WebInfrastructure Data Server");
                        continue block4;
                    }
                }
            }
            catch (RemoteException e) {
                logger.error(e.getMessage());
                throw new BackupException("Error encountered while trying to get connection information from server component SASInfrastructureData", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_RECOVERY_FAILED.getErrorCode());
            }
            logger.info("Get Details for WIP database");
            List WebappComponents = this.omrDeploymentConf.getSoftwareComponents(WEBAPPSERV_SOFTWARECOMPONENTCLASSIDENTIFIER);
            SoftwareComponentInterface webappServComponent = null;
            if (WebappComponents.size() > 0) {
                webappServComponent = (SoftwareComponentInterface)WebappComponents.get(0);
            }
            if (webappServComponent == null) {
                logger.error("Software component for SAS Web Application Server not found");
                throw new BackupException("Software component for SAS Web Application Server not found", BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_RECOVERY_FAILED.getErrorCode());
            }
            if (connectionInfo != null) {
                String serverPort = (String)connectionInfo.get("PORT");
                logger.info("Port details from WebInfrastructure Data Server :" + serverPort);
                String dbServerPort = this.omrDeploymentConf.getSoftwareComponentProperty(webappServComponent, SCS_WEBAPPSERV_DB_PORT, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_RECOVERY_FAILED);
                logger.info("Port details from WIP textstore :" + dbServerPort);
                if (!serverPort.equals(dbServerPort)) {
                    logger.info("WebInfrastructure Data Server and WIP Data base port not equal , SCS will be excluded fr");
                    isInternalDB = false;
                }
            }
        }
        catch (Exception e) {
            throw new BackupException("Error encountered while trying to get connection information and login details from server component SASInfrastructureData", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_RECOVERY_FAILED.getErrorCode());
        }
        return isInternalDB;
    }

    @Override
    public List<BackupTask> getRestoreTasks(RuntimeSASEnvironment runtimeSASEnvironment) throws BackupException {
        ConfigurableServer wipDataServerConfig = (ConfigurableServer)BackupServiceUtils.extractAsObject(this.discoverer.getConfigurableServers(DeploymentDiscoveryDAO.ComponentType.SAS_WIP_DATA_SERVER));
        ConfigurableServer wipConfigurable = (ConfigurableServer)BackupServiceUtils.extractAsObject(this.discoverer.getConfigurableServers(DeploymentDiscoveryDAO.ComponentType.CONTENT_SERVER));
        BackupTask contentRestoreTask = null;
        if (wipDataServerConfig != null) {
            DataServerInterface wipDataServer = (DataServerInterface)this.discoverer.getServerComponent(wipDataServerConfig.getEntityId());
            try {
                String password;
                String userId;
                String serverPort;
                String serverHost;
                Map serverProperties = wipDataServer.getServerProperties();
                if (serverProperties != null) {
                    serverHost = (String)serverProperties.get("SERVER");
                    serverPort = (String)serverProperties.get("PORT");
                    String authDomain = (String)serverProperties.get("AUTHDOMAIN");
                    userId = null;
                    password = null;
                    BackupServiceUtils.Tuple<String, String> userPrincipal = BackupServiceUtils.getUserPrincipal((MetadataServerInterface)this.omrDeploymentConf.getServer(), authDomain);
                    if (userPrincipal == null) {
                        throw BackupException.getBuilder((int)BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_DISCOVERY_FAILED.getErrorCode()).addInfo("possibleCause", "User principal for content server not found.").build();
                    }
                    userId = userPrincipal.getKey();
                    password = userPrincipal.getValue();
                } else {
                    throw BackupException.getBuilder((int)BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_DISCOVERY_FAILED.getErrorCode()).addInfo("possibleCause", "Web infrastructure platform data server properties not found.").build();
                }
                contentRestoreTask = BackupTask.getBackupNodeTaskBuilder(BackupSourceConfig.BackupSource.CONTENTSERVER, wipConfigurable.getSasTier()).addParam("pghost", serverHost).addParam("pgport", serverPort).addParam("pguser", userId).addParam("pgpw", password).build();
            }
            catch (ServiceException serviceException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return contentRestoreTask != null ? BackupServiceUtils.decorateAsList(contentRestoreTask) : null;
    }
}

