/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.dao;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.OMIServerRepository;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.OMRServerContext;
import com.sas.services.information.metadata.SoftwareComponentInterface;
import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Repository;

@Repository(value="ConfigDirHelper")
public class ConfigDirHelper {
    private static final Logger logger = LogManager.getLogger(ConfigDirHelper.class);
    private ServerInterface server;

    public Map getConfiguredContexts(String hostName, ServerInterface server) throws BackupException {
        this.server = server;
        Map mpAlContexts = this.getServerContexts();
        HashMap mpValidContexts = new HashMap();
        if (!BackupServiceUtils.isEmpty(mpAlContexts)) {
            for (String reposID : mpAlContexts.keySet()) {
                List lstAlContexts = (List)mpAlContexts.get(reposID);
                if (BackupServiceUtils.isEmpty(lstAlContexts)) continue;
                ArrayList<OMRServerContext> lstValidContexts = new ArrayList<OMRServerContext>();
                for (int index = 0; index < lstAlContexts.size(); ++index) {
                    OMRServerContext context = (OMRServerContext)lstAlContexts.get(index);
                    if (!this.isConfigured(context, hostName, false)) continue;
                    lstValidContexts.add(context);
                }
                if (BackupServiceUtils.isEmpty(lstValidContexts)) continue;
                mpValidContexts.put(reposID, lstValidContexts);
            }
        }
        return BackupServiceUtils.isEmpty(mpValidContexts) ? null : mpValidContexts;
    }

    public Map getRepositories() throws BackupException {
        HashMap<String, String> repos = null;
        OMIServerRepository repository = null;
        try {
            List repositories = this.getServer().getRepositories(true);
            if (repositories != null) {
                repos = new HashMap<String, String>();
                for (int index = 0; index < repositories.size(); ++index) {
                    repository = (OMIServerRepository)repositories.get(index);
                    repos.put(repository.getIdentity().getName(), repository.getIdentity().getIdentifier());
                }
            }
        }
        catch (ServiceException e) {
            throw new BackupException("Error encountered while trying to get metadata repositories.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONFIGDIR_DISCOVERY_FAILED.getErrorCode());
        }
        catch (RemoteException e) {
            throw new BackupException("Error encountered while trying to get metadata repositories.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONFIGDIR_DISCOVERY_FAILED.getErrorCode());
        }
        return repos;
    }

    protected Map getServerContexts() throws BackupException {
        Map repositories = this.getRepositories();
        HashMap<String, List> serverContexts = null;
        List servers = null;
        String repositoryName2 = null;
        if (repositories != null) {
            serverContexts = new HashMap<String, List>();
            for (String repositoryName2 : repositories.keySet()) {
                String reposID = (String)repositories.get(repositoryName2);
                servers = this.getServerContexts(reposID);
                if (servers == null) continue;
                serverContexts.put(reposID, servers);
            }
        }
        return serverContexts;
    }

    protected boolean isConfigured(OMRServerContext context, String hostName, boolean isMdTier) throws BackupException {
        boolean isConfigured = false;
        AssociationList logicalServers = null;
        Object logicalServer = null;
        String contextName = null;
        try {
            if (context != null) {
                contextName = context.getName();
                logicalServers = ((ServerContext)context.getRepositoryEntity()).getUsingComponents();
                if (!BackupServiceUtils.isEmpty(logicalServers)) {
                    block3: for (int index = 0; index < logicalServers.size() && !isConfigured; ++index) {
                        AssociationList serverComponents;
                        logicalServer = logicalServers.get(index);
                        if (!(logicalServer instanceof LogicalServer) || BackupServiceUtils.isEmpty(serverComponents = ((LogicalServer)logicalServer).getUsingComponents())) continue;
                        for (int cnt = 0; cnt < serverComponents.size(); ++cnt) {
                            Object serverComponent = serverComponents.get(cnt);
                            if (!(serverComponent instanceof ServerComponent) || !this.isOnSpecifiedHost((ServerComponent)serverComponent, hostName, isMdTier)) continue;
                            isConfigured = true;
                            continue block3;
                        }
                    }
                }
            }
        }
        catch (MdException e) {
            throw new BackupException("Error encountered while trying to check if " + contextName + " is configured on " + hostName, (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONFIGDIR_DISCOVERY_FAILED.getErrorCode());
        }
        catch (RemoteException e) {
            throw new BackupException("Error encountered while trying to check if " + contextName + " is configured on " + hostName, (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONFIGDIR_DISCOVERY_FAILED.getErrorCode());
        }
        return isConfigured;
    }

    public boolean isOnSpecifiedHost(ServerComponent server, String hostName, boolean isMdTier) throws BackupException {
        boolean isLocalMachine;
        block1: {
            isLocalMachine = false;
            Set machines = this.getAssociatedMachines(server);
            if (BackupServiceUtils.isEmpty(machines)) break block1;
            Iterator macIt = machines.iterator();
            Machine machine = null;
            while (macIt.hasNext() && !(isLocalMachine = this.isLocalMachine(machine = (Machine)macIt.next(), hostName, isMdTier))) {
            }
        }
        return isLocalMachine;
    }

    protected Set getAssociatedMachines(ServerComponent server) throws BackupException {
        HashSet<Machine> machineList = null;
        String serverName = null;
        if (!BackupServiceUtils.isEmpty(server)) {
            try {
                List machines;
                serverName = server.getName();
                machineList = new HashSet<Machine>();
                Machine machine = server.getAssociatedMachine();
                if (!BackupServiceUtils.isEmpty(machine)) {
                    machineList.add(machine);
                }
                if (!BackupServiceUtils.isEmpty(machines = this.getMachines((List)server.getSoftwareTrees()))) {
                    machineList.addAll(machines);
                }
            }
            catch (MdException e) {
                throw new BackupException("Error encountered while trying to get associated machine of " + serverName, (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONFIGDIR_DISCOVERY_FAILED.getErrorCode());
            }
            catch (RemoteException e) {
                throw new BackupException("Error encountered while trying to get associated machine of " + serverName, (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONFIGDIR_DISCOVERY_FAILED.getErrorCode());
            }
        }
        return machineList;
    }

    private List getMachines(List softwareTrees) throws BackupException {
        if (!BackupServiceUtils.isEmpty(softwareTrees)) {
            for (int index = 0; index < softwareTrees.size(); ++index) {
                Tree tree = (Tree)softwareTrees.get(index);
                try {
                    if (!tree.getTreeType().equals("MachineGroup")) continue;
                    return tree.getAssociatedObjects("Members");
                }
                catch (RemoteException e) {
                    throw new BackupException("Error encountered while trying to get associated machine.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONFIGDIR_DISCOVERY_FAILED.getErrorCode());
                }
                catch (MdException e) {
                    throw new BackupException("Error encountered while trying to get associated machine.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONFIGDIR_DISCOVERY_FAILED.getErrorCode());
                }
            }
        }
        return null;
    }

    protected boolean isLocalMachine(Machine machine, String localHostName, boolean isMdTier) throws BackupException {
        boolean isLocalMachine = false;
        InetAddress localHost = BackupServiceUtils.convertToInetAddress("localhost");
        if (machine != null) {
            try {
                isLocalMachine = BackupServiceUtils.isHostsEqual(machine.getName(), localHostName);
                if (isMdTier) {
                    isLocalMachine = isLocalMachine || BackupServiceUtils.isHostsEqual(localHost.getHostName(), machine.getName());
                }
            }
            catch (RemoteException e) {
                throw new BackupException("Error encountered while trying to find host match for server contexts.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONFIGDIR_DISCOVERY_FAILED.getErrorCode());
            }
        }
        return isLocalMachine;
    }

    public ServerInterface getServer() {
        return this.server;
    }

    protected List getServerContexts(String repositoryId) throws BackupException {
        int searchFlags = 18561;
        SoftwareComponentInterface backupComponent = null;
        List applications = null;
        try {
            Filter filter = new Filter();
            FilterComponent fc = new FilterComponent();
            fc.setAggregation(1);
            filter.setType("ServerContext");
            filter.setOMRFlags(searchFlags);
            applications = this.getServer().search((FilterInterface)filter);
            if (applications.size() > 0) {
                backupComponent = (SoftwareComponentInterface)applications.get(0);
            }
        }
        catch (ServiceException e) {
            throw new BackupException("Error encountered while trying to fetch list server contexts configured on repository " + repositoryId, (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONFIGDIR_DISCOVERY_FAILED.getErrorCode());
        }
        catch (RemoteException e) {
            throw new BackupException("Error encountered while trying to fetch list server contexts configured on repository " + repositoryId, (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONFIGDIR_DISCOVERY_FAILED.getErrorCode());
        }
        return applications;
    }
}

