/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.dao;

import com.sas.svcs.backup.client.BackupConfiguration;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.BackupSourceNode;
import com.sas.svcs.backup.spi.BackupServiceHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BackupNodeHelper {
    @Autowired
    private BackupServiceHelper helper;
    private static final Logger logger = LogManager.getLogger(BackupNodeHelper.class);

    public Set<BackupSourceNode> getUniqueSourceNodes(BackupConfiguration config) {
        HashSet<BackupSourceNode> sourceNodes = new HashSet<BackupSourceNode>();
        List sourceConfigs = config.getSources();
        for (BackupSourceConfig sourceConfig : sourceConfigs) {
            BackupSourceNode sourceNode = sourceConfig.getBackupSourceNode();
            boolean isTierHostExcluded = this.helper.isTierHostExcluded(sourceNode.getHostName());
            if (isTierHostExcluded || sourceNodes.add(sourceNode)) continue;
            logger.debug("A source node with " + sourceNode + " is already present in unique source node list");
        }
        logger.debug("getUniqueSourceNodes() Unique source node list: " + sourceNodes);
        return sourceNodes;
    }

    public List<BackupSourceNode> getAllSourceNodes(BackupConfiguration config) {
        ArrayList<BackupSourceNode> sourceNodes = new ArrayList<BackupSourceNode>();
        List sourceConfigs = config.getSources();
        for (BackupSourceConfig sourceConfig : sourceConfigs) {
            BackupSourceNode sourceNode = sourceConfig.getBackupSourceNode();
            if (this.helper.isTierHostExcluded(sourceNode.getHostName())) continue;
            sourceNodes.add(sourceNode);
        }
        return sourceNodes;
    }

    public Set<BackupSourceNode> getUniqueElements(Collection<BackupSourceNode> collection) {
        HashSet<BackupSourceNode> uniqueElements = new HashSet<BackupSourceNode>();
        if (collection != null) {
            for (BackupSourceNode node : collection) {
                if (!this.helper.isTierHostExcluded(node.getHostName()) && uniqueElements.contains(node) && node.isPrimary()) {
                    for (BackupSourceNode alreadyAddedNode : uniqueElements) {
                        if (alreadyAddedNode.isPrimary() || !alreadyAddedNode.equals((Object)node)) continue;
                        alreadyAddedNode.setIsPrimary(true);
                        alreadyAddedNode.setMetadataTier(true);
                    }
                    continue;
                }
                uniqueElements.add(node);
            }
        }
        return uniqueElements;
    }
}

