/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.aop;

import com.sas.svcs.backup.client.BackupServiceResult;
import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupErrorDetails;
import com.sas.svcs.backup.common.definitions.BackupErrorEntry;
import com.sas.svcs.backup.common.definitions.BackupErrorLogger;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=1)
public class ErrorLoggingAspect {
    Logger logger = LogManager.getLogger(ErrorLoggingAspect.class);
    @Autowired
    @Qualifier(value="BackupErrorXmlLogger")
    BackupErrorLogger backupErrorXmlLogger;

    @Order(value=3)
    @AfterThrowing(pointcut="execution(* com.sas.svcs.backup.client.BackupService.*(..))", throwing="error")
    public void afterThrowingAdvice(JoinPoint joinPoint, Throwable error) {
        this.logger.debug("ErrorLoggingAspect.afterThrowingAdvice():" + joinPoint.getSignature().toString());
        String errorMessage = null;
        BackupException backupException = null;
        try {
            backupException = error instanceof BackupException ? (BackupException)error : new BackupException("Backup service API " + joinPoint.getSignature().toString() + " failed due to unknown reasons.", error, BackupErrorConstants.ErrorCodes.ERROR_CODE_UNKNOWN.getErrorCode());
            BackupServiceUtils.addLogDetailsToException(backupException);
            BackupErrorDetails backupError = new BackupErrorDetails();
            BackupErrorEntry errorEntry = this.backupErrorXmlLogger.getErrorEntry(backupException);
            backupError.addBackupErrorEntry(errorEntry);
            errorMessage = this.backupErrorXmlLogger.generateCompleteErrorMessage(backupError);
            if (errorMessage == null) {
                errorMessage = "Backup service API " + joinPoint.getSignature().toLongString() + " failed due to unknown reasons.";
            }
        }
        catch (BackupException e) {
            this.logger.error("Error encountered while trying to send notification.", (Throwable)e);
        }
        catch (Throwable t) {
            this.logger.error("Error encountered while trying to send notification.", t);
        }
        StringBuffer lErrorMsg = new StringBuffer("\tError Start|||  ");
        lErrorMsg.append(errorMessage);
        lErrorMsg.append("\t\t|||  Error End");
        this.logger.error((CharSequence)lErrorMsg);
    }

    @Order(value=2)
    @AfterReturning(pointcut="execution(* com.sas.svcs.backup.client.BackupService.*(..))", returning="backupServiceResult")
    public void afterReturningAdvice(JoinPoint joinPoint, BackupServiceResult<?> backupServiceResult) {
        String errorMessage = null;
        BackupErrorDetails error = null;
        boolean errorsEncountered = false;
        try {
            if (backupServiceResult != null) {
                errorsEncountered = !BackupServiceUtils.isEmpty(backupServiceResult.getExceptions());
                error = backupServiceResult.getErrorDetails();
                if (error != null) {
                    errorMessage = error.getFormattedErrorMessage();
                }
                if (errorMessage == null) {
                    Object actualResult = backupServiceResult.getActualResult();
                    Object errorLogger = null;
                    if (errorsEncountered) {
                        this.logger.debug("ErrorLoggingAspect.afterReturningAdvice()" + joinPoint.getSignature().toLongString());
                        if (errorsEncountered) {
                            error = new BackupErrorDetails();
                            LinkedList exceptions = new LinkedList();
                            LinkedHashSet setExeceptions = backupServiceResult.getExceptions();
                            if (setExeceptions != null) {
                                for (BackupException backupException : setExeceptions) {
                                    BackupServiceUtils.addLogDetailsToException(backupException);
                                }
                            }
                            exceptions.addAll(setExeceptions);
                            List errorEntries = this.backupErrorXmlLogger.getErrorEntries(exceptions);
                            error.setBackupErrorEntries(errorEntries);
                            backupServiceResult.setErrorDetails(error);
                            errorMessage = this.backupErrorXmlLogger.generateCompleteErrorMessage(error);
                        }
                    }
                }
            }
        }
        catch (BackupException e) {
            this.logger.error("Error encountered while trying to create error message.", (Throwable)e);
        }
        catch (Throwable t) {
            this.logger.error("Error encountered while trying to create error message.", t);
        }
        if (errorsEncountered) {
            if (errorMessage == null) {
                errorMessage = "Backup service API " + joinPoint.getSignature().toString() + " failed due to unknown reasons";
            }
            StringBuffer lErrorMsg = new StringBuffer("\tError Start|||  ");
            lErrorMsg.append(errorMessage);
            lErrorMsg.append("\t\t|||  Error End");
            this.logger.error((CharSequence)lErrorMsg);
        }
    }
}

