/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.analyze;

import com.sas.svcs.backup.analyze.ConfigurationMergeManager;
import com.sas.svcs.backup.analyze.RB;
import com.sas.svcs.backup.analyze.model.RuntimeSASEnvironment;
import com.sas.svcs.backup.client.SASTierProxy;
import com.sas.svcs.backup.client.SASTiers;
import com.sas.svcs.backup.client.UserConfigurationServiceInterface;
import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import com.sas.svcs.backup.dao.ConfigBeanConverter;
import com.sas.svcs.backup.dao.DeploymentAgentClient;
import com.sas.svcs.backup.dao.OMRDeploymentBackupConfiguration;
import com.sas.svcs.backup.spi.BackupConfigurationService;
import com.sas.svcs.backup.spi.BackupServiceHelper;
import com.sas.svcs.backup.spi.SessionManager;
import com.sas.svcs.deployment.DeploymentDiscoveryService;
import com.sas.svcs.deployment.dao.DeploymentDiscoveryDAO;
import com.sas.svcs.deployment.data.ConfigurableServer;
import com.sas.svcs.deployment.data.SASEnvironment;
import com.sas.svcs.deployment.data.SASTier;
import com.sas.text.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class RuntimeSASEnvironmentPreparer {
    private static final Logger logger = LogManager.getLogger(RuntimeSASEnvironmentPreparer.class);
    @Autowired
    private BackupConfigurationService backupConfigurationService;
    @Autowired
    @Qualifier(value="DeploymentBackupConfiguration")
    private OMRDeploymentBackupConfiguration backupConfiguration;
    @Autowired
    private DeploymentDiscoveryService deploymentDiscoverer;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ConfigurationMergeManager configurationMergeManager;
    @Autowired
    @Qualifier(value="UserConfigurationService")
    private UserConfigurationServiceInterface userConfigurationService;
    @Autowired
    ConfigBeanConverter configBeanConverter;
    @Autowired
    private BackupServiceHelper helper;

    public RuntimeSASEnvironment prepare(SASEnvironment sasEnvironment) {
        logger.debug("Preparing runtime environment.");
        List sasTiers = sasEnvironment.getSasTiers();
        RuntimeSASEnvironment runtimeSASEnvironment = RuntimeSASEnvironment.getInstance((SASEnvironment)sasEnvironment);
        this.backupConfiguration.getServer();
        List<SASTier> unreachableTiers = this.getUnreachableTiers(sasTiers);
        runtimeSASEnvironment.setUnreachableTiers(unreachableTiers);
        boolean isPrimaryTierAssigned = this.assignPrimaryMetadataTier(runtimeSASEnvironment);
        if (isPrimaryTierAssigned) {
            this.configurationMergeManager.merge(sasTiers);
            this.filterExcludedTiers(runtimeSASEnvironment);
        }
        this.filterTiersWithoutDeployedProducts(runtimeSASEnvironment);
        logger.debug("Prepared runtime environment.");
        return runtimeSASEnvironment;
    }

    private List<SASTier> getUnreachableTiers(List<SASTier> sasTiers) {
        ArrayList<SASTier> unreachableTiers = new ArrayList<SASTier>();
        try {
            for (SASTier sasTier : sasTiers) {
                String hostName = sasTier.getHostName();
                if (DeploymentAgentClient.isAgentRunning(hostName)) continue;
                unreachableTiers.add(sasTier);
            }
        }
        catch (BackupException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new BackupException("Fatal error encountered while trying check deployment agent communications.", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_DEPLOYMENT_AGENT_COMMUNICATION_FAILURE.getErrorCode());
        }
        return unreachableTiers;
    }

    private boolean assignPrimaryMetadataTier(RuntimeSASEnvironment runtimeSASEnvironment) {
        boolean isPrimaryMetadataTierAssigned = false;
        List unreachableTiers = runtimeSASEnvironment.getUnreachableTiers();
        List reachableTiers = runtimeSASEnvironment.getAvailableTiers();
        ArrayList<String> unreachableHost = new ArrayList<String>();
        if (!unreachableTiers.isEmpty()) {
            for (Object tiers : unreachableTiers) {
                unreachableHost.add(tiers.getHostName());
            }
            logger.debug("Get List of unreachable tiers::" + unreachableHost);
        }
        if (reachableTiers != null && !reachableTiers.isEmpty()) {
            logger.debug("#Get List of available tiers#");
            for (Object tiers : reachableTiers) {
                logger.debug("Hostname::" + tiers.getHostName());
            }
        }
        logger.debug("#Get List of actual reachable tiers#");
        ArrayList<SASTier> actualReachableTiers = new ArrayList<SASTier>();
        for (SASTier tier : reachableTiers) {
            if (unreachableHost.contains(tier.getHostName())) continue;
            actualReachableTiers.add(tier);
            logger.debug("Hostname::" + tier.getHostName());
        }
        SASTier primaryMetadataTier = null;
        SASTier userSpecifiedPrimaryTier = this.backupConfiguration.getUserSpecifiedPrimaryMetadataTier();
        if (userSpecifiedPrimaryTier != null) {
            primaryMetadataTier = BackupServiceUtils.retrieveObject(actualReachableTiers, userSpecifiedPrimaryTier);
            logger.debug("IF UserSpecifiedPrimaryTIer is not null PrimaryMetadataTier hostName::" + primaryMetadataTier.getHostName());
        } else {
            logger.debug("#If userspecifiedPrimaryTier is null#");
            List metaServers = this.deploymentDiscoverer.getConfigurableServers(DeploymentDiscoveryDAO.ComponentType.METADATA_SERVER);
            ArrayList<String> metadataTierList = new ArrayList<String>();
            for (ConfigurableServer metadataServer : metaServers) {
                metadataTierList.add(metadataServer.getSasTier().getHostName());
            }
            logger.debug("metadataTierList::" + metadataTierList);
            if (!metadataTierList.isEmpty() && !actualReachableTiers.isEmpty()) {
                for (SASTier metadataTier : actualReachableTiers) {
                    String hostName = metadataTier.getHostName();
                    if (!metadataTierList.contains(hostName)) continue;
                    primaryMetadataTier = metadataTier;
                    break;
                }
            }
        }
        if (primaryMetadataTier != null) {
            logger.debug("Primary metadata is not null");
            primaryMetadataTier.setPrimaryMetadataServer(true);
            runtimeSASEnvironment.setPrimaryMetdataTier(primaryMetadataTier);
            if (!actualReachableTiers.contains(primaryMetadataTier)) {
                String message = Message.format((String)RB.getStringResource("RuntimeSASEnvironmentPreparer.primary.metadata.not.reachable.fmt"), (Object)primaryMetadataTier.getHostName());
                throw new BackupException.BackupExceptionBuilder(BackupErrorConstants.ErrorCodes.ERROR_CODE_DEPLOYMENT_AGENT_COMMUNICATION_FAILURE.getErrorCode()).setMessage(message).build();
            }
            isPrimaryMetadataTierAssigned = true;
            logger.debug("Final PrimaryMetadataTier hostName::" + primaryMetadataTier.getHostName());
        }
        return isPrimaryMetadataTierAssigned;
    }

    private RuntimeSASEnvironment filterExcludedTiers(RuntimeSASEnvironment runtimeSASEnvironment) {
        List<SASTier> excludedTiers = this.getExcludedSASTiers();
        for (SASTier excludedTier : excludedTiers) {
            runtimeSASEnvironment.getAvailableTiers().remove(excludedTier);
            runtimeSASEnvironment.getUnreachableTiers().remove(excludedTier);
        }
        return runtimeSASEnvironment;
    }

    private List<SASTier> getExcludedSASTiers() {
        SASTiers sasTiers = this.userConfigurationService.getSASTiers();
        ArrayList<SASTier> excludedProxies = null;
        List proxyTier = sasTiers.getSasTiers();
        if (proxyTier != null && proxyTier.size() > 0) {
            excludedProxies = new ArrayList<SASTier>(proxyTier.size());
            for (SASTierProxy servicetier : proxyTier) {
                if (servicetier.isIncluded() == null || servicetier.isIncluded().booleanValue()) continue;
                SASTier tierdata = this.configBeanConverter.proxyToSASTier(servicetier);
                excludedProxies.add(tierdata);
            }
        }
        return excludedProxies == null || excludedProxies.size() <= 0 ? Collections.EMPTY_LIST : excludedProxies;
    }

    private RuntimeSASEnvironment filterTiersWithoutAgentInstalled(RuntimeSASEnvironment runtimeSASEnvironment) {
        List allTiers = runtimeSASEnvironment.getAllTiers();
        for (SASTier sasTier : allTiers) {
            boolean isAgentInstalled = this.isAgentInstalledOn(sasTier);
            if (isAgentInstalled) continue;
            runtimeSASEnvironment.getAvailableTiers().remove(sasTier);
            runtimeSASEnvironment.getUnreachableTiers().remove(sasTier);
        }
        return runtimeSASEnvironment;
    }

    private boolean isAgentInstalledOn(SASTier sasTier) {
        Properties configurableProperties = sasTier.getProperties();
        String agentPort = configurableProperties.getProperty("solstice.agent.jmx.port");
        boolean isAgentInstalled = agentPort != null;
        return isAgentInstalled;
    }

    private RuntimeSASEnvironment filterTiersWithoutDeployedProducts(RuntimeSASEnvironment runtimeSASEnvironment) {
        List allTiers = runtimeSASEnvironment.getAllTiers();
        for (SASTier sasTier : allTiers) {
            if (sasTier.isProductsDeployed()) continue;
            runtimeSASEnvironment.getAvailableTiers().remove(sasTier);
            runtimeSASEnvironment.getUnreachableTiers().remove(sasTier);
        }
        return runtimeSASEnvironment;
    }

    public RuntimeSASEnvironment filterUnrequiredTiers(List<SASTier> requiredTiers, RuntimeSASEnvironment runtimeSASEnvironment) {
        Collection unrequiredTiers = CollectionUtils.subtract((Collection)runtimeSASEnvironment.getAllTiers(), requiredTiers);
        for (SASTier unrequiredTier : unrequiredTiers) {
            runtimeSASEnvironment.getUnreachableTiers().remove(unrequiredTier);
        }
        this.updateTiersTobeConfigured(runtimeSASEnvironment, requiredTiers);
        return runtimeSASEnvironment;
    }

    private void updateTiersTobeConfigured(RuntimeSASEnvironment runtimeSASEnvironment, List<SASTier> requiredTiers) {
        List availableTiers = runtimeSASEnvironment.getAvailableTiers();
        ArrayList<SASTier> tiersTobeConfigured = new ArrayList<SASTier>(requiredTiers);
        for (SASTier sasTier : availableTiers) {
            if (!this.shouldConfigure(sasTier, tiersTobeConfigured)) continue;
            logger.debug(sasTier.getHostName() + " is added to required tiers to be configured list.");
            tiersTobeConfigured.add(sasTier);
        }
        runtimeSASEnvironment.setRequiredTiersTobeConfigured(tiersTobeConfigured);
    }

    private boolean shouldConfigure(SASTier sasTier, List<SASTier> tiersTobeConfigured) {
        return !tiersTobeConfigured.contains(sasTier) && this.isAgentInstalledOn(sasTier) && sasTier.isMidTierClusterTier() && !this.getExcludedSASTiers().contains(sasTier);
    }
}

