/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.analyze;

import com.sas.codepolicy.SASScope;
import com.sas.svcs.backup.analyze.BackupJob;
import com.sas.svcs.backup.analyze.BackupTask;
import com.sas.svcs.backup.analyze.DeploymentAnalyzer;
import com.sas.svcs.backup.analyze.OperationRequest;
import com.sas.svcs.backup.analyze.RuntimeSASEnvironmentPreparer;
import com.sas.svcs.backup.analyze.model.AnalysisResult;
import com.sas.svcs.backup.analyze.model.RuntimeSASEnvironment;
import com.sas.svcs.backup.client.BackupOptions;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import com.sas.svcs.backup.dao.OMRBackupSourceSupportService;
import com.sas.svcs.backup.spi.BackupConfigurationService;
import com.sas.svcs.backup.spi.BackupTaskExecutor;
import com.sas.svcs.backup.spi.ExternalDataBaseException;
import com.sas.svcs.deployment.DeploymentDiscoveryService;
import com.sas.svcs.deployment.data.SASEnvironment;
import com.sas.svcs.deployment.data.SASTier;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="backupRequestContext")
@Scope(value="prototype")
@SASScope
public class BackupRequestContext {
    private Logger logger = LogManager.getLogger(BackupRequestContext.class);
    @Autowired
    private DeploymentDiscoveryService deploymentDiscoverer;
    @Autowired
    private RuntimeSASEnvironmentPreparer runtimeSASEnvPreparer;
    @Autowired
    private BackupConfigurationService configService;
    @Autowired
    private DeploymentAnalyzer deploymentAnalyzer;
    @Autowired
    private BackupConfigurationService backupConfigurationService;
    private static RuntimeSASEnvironment cachedRunTimeEnvironment = null;

    public RuntimeSASEnvironment initialize() {
        RuntimeSASEnvironment runtimeSASEnvironment = null;
        SASEnvironment sasEnvironment = this.deploymentDiscoverer.discover();
        List sasTiers = sasEnvironment.getSasTiers();
        if (sasTiers != null) {
            runtimeSASEnvironment = this.runtimeSASEnvPreparer.prepare(sasEnvironment);
        }
        cachedRunTimeEnvironment = runtimeSASEnvironment;
        return runtimeSASEnvironment;
    }

    public AnalysisResult analyze(RuntimeSASEnvironment runtimeSASEnvironment) {
        OperationRequest<?> operationRequest = null;
        AnalysisResult analysisResult = this.deploymentAnalyzer.analyze(runtimeSASEnvironment, operationRequest);
        runtimeSASEnvironment.setBackupAnalysis(analysisResult);
        if (!analysisResult.isOK()) {
            // empty if block
        }
        return analysisResult;
    }

    public BackupTaskExecutor getTaskExecutor(BackupTask task) {
        return null;
    }

    public BackupJob createBackupJob(BackupOptions options, RuntimeSASEnvironment runtimeSASEnvironment) {
        List<BackupTask> tasks = null;
        BackupJob backupJob = new BackupJob("", options);
        backupJob.setBackupJobEnvironment(runtimeSASEnvironment);
        backupJob.setBaseConfiguration(this.configService.getBaseConfiguration());
        for (BackupSourceConfig.BackupSource sourceType : BackupSourceConfig.BackupSource.values()) {
            tasks = null;
            OMRBackupSourceSupportService omrSupportService = this.backupConfigurationService.getOMRSupportService(sourceType);
            this.logger.debug("checking backup tasks ..");
            try {
                tasks = omrSupportService.getBackupTasks(runtimeSASEnvironment);
            }
            catch (ExternalDataBaseException e) {
                this.logger.info("External DB present");
                options.setExternalDBPresent(true);
                backupJob.setBackupOptions(options);
            }
            if (tasks != null && tasks.size() > 0) {
                backupJob.addTasks(tasks, sourceType);
                continue;
            }
            this.logger.warn("No tasks are found for backup type " + sourceType);
        }
        this.updateRequiredTiers(runtimeSASEnvironment, backupJob);
        return backupJob;
    }

    private void updateRequiredTiers(RuntimeSASEnvironment runtimeSASEnvironment, BackupJob backupJob) {
        List<SASTier> requiredTiers = this.getRequiredTiers(backupJob);
        runtimeSASEnvironment.setRequiredTiers(requiredTiers);
        this.runtimeSASEnvPreparer.filterUnrequiredTiers(requiredTiers, runtimeSASEnvironment);
    }

    private List<SASTier> getRequiredTiers(BackupJob backupJob) {
        ArrayList<SASTier> uniqueRequiredSasTiers = new ArrayList<SASTier>();
        List<BackupTask> backupTasks = backupJob.getAllSourcesTasks();
        ArrayList<SASTier> allRequiredSasTiers = new ArrayList<SASTier>();
        for (BackupTask backupTask : backupTasks) {
            allRequiredSasTiers.add(backupTask.performOn);
        }
        uniqueRequiredSasTiers.addAll(BackupServiceUtils.getSetFormCollection(allRequiredSasTiers));
        return uniqueRequiredSasTiers;
    }

    public RuntimeSASEnvironment getCachedRuntimeSASEnvironment() {
        if (cachedRunTimeEnvironment == null) {
            this.logger.debug("Setting cachedRunTimeEnvironment");
            cachedRunTimeEnvironment = this.initialize();
        }
        return cachedRunTimeEnvironment;
    }
}

