/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.client;

import com.sas.codepolicy.SASScope;
import com.sas.svcs.metadata.mgmt.client.CustomRepository;
import com.sas.svcs.metadata.mgmt.client.FoundationRepository;
import com.sas.svcs.metadata.mgmt.client.ProjectRepository;
import java.io.Serializable;
import java.util.Date;
import java.util.EnumSet;

public abstract class Repository
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String fqid = "A0000001.A0000001";
    private String name;
    private String description;
    private String path;
    private Access access = Access.ONLINE;
    private Access effectiveAccess = Access.ONLINE;
    private int formatVersion;
    private String state;
    private String engine = "BASE";
    private String options = "";
    private Date metadataCreated;
    private Date metadataUpdated;
    private boolean createReposPath = false;
    private double size = -1.0;

    @SASScope
    public void setId(String fqid) {
        this.fqid = fqid;
    }

    public String getId() {
        return this.fqid;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setRegisteredAccess(Access access) {
        this.access = access;
    }

    public Access getRegisteredAccess() {
        return this.access;
    }

    @SASScope
    public void setEffectiveAccess(Access effectiveAccess) {
        this.effectiveAccess = effectiveAccess;
    }

    public Access getEffectiveAccess() {
        return this.effectiveAccess;
    }

    @SASScope
    public void setRepositoryFormatVersion(int formatVersion) {
        this.formatVersion = formatVersion;
    }

    public int getRepositoryFormatVersion() {
        return this.formatVersion;
    }

    @SASScope
    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public String getOptions() {
        return this.options;
    }

    @SASScope
    public void setCreatedDate(Date metadataCreated) {
        this.metadataCreated = metadataCreated;
    }

    public Date getCreatedDate() {
        return this.metadataCreated;
    }

    @SASScope
    public void setModifiedDate(Date metadataUpdated) {
        this.metadataUpdated = metadataUpdated;
    }

    public Date getModifiedDate() {
        return this.metadataUpdated;
    }

    @SASScope
    public String getShortId() {
        return this.fqid.substring(9);
    }

    public boolean isFoundation() {
        return this instanceof FoundationRepository;
    }

    public boolean isCustom() {
        return this instanceof CustomRepository;
    }

    public boolean isProject() {
        return this instanceof ProjectRepository;
    }

    public boolean isCreateRepositoryPath() {
        return this.createReposPath;
    }

    public void setCreateRepositoryPath(boolean createReposPath) {
        this.createReposPath = createReposPath;
    }

    public double getSize() {
        return this.size;
    }

    @SASScope
    public void setSize(double size) {
        this.size = size;
    }

    public static enum Access {
        ONLINE("OMS_FULL", "0"),
        READONLY("OMS_READONLY", "1"),
        ADMIN("OMS_ADMIN", "2"),
        ADMIN_RO("OMS_ADMINRO", "3"),
        OFFLINE("OMS_OFFLINE", "4");

        private String accessString;
        private String accessNumberString;

        private Access(String displayname, String accessNumber) {
            this.accessString = displayname;
            this.accessNumberString = accessNumber;
        }

        public String getAccessString() {
            return this.accessString;
        }

        public String getAccessNumberString() {
            return this.accessNumberString;
        }

        public static Access getByValue(String value) {
            for (Access access : EnumSet.allOf(Access.class)) {
                if (!access.getAccessString().equals(value)) continue;
                return access;
            }
            return null;
        }

        public static Access getByNumberValue(String number) {
            for (Access access : EnumSet.allOf(Access.class)) {
                if (!access.getAccessNumberString().equals(number)) continue;
                return access;
            }
            return null;
        }
    }
}

