/*
 * Decompiled with CFR 0.152.
 */
package com.sas.vfabrictcsvr.valves;

import com.sas.vfabrictcsvr.valves.RequestWrapper;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.MappingMatch;
import java.io.IOException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class WebSEALRequestWrappingValve
extends ValveBase {
    private static final Log log = LogFactory.getLog(WebSEALRequestWrappingValve.class);
    protected volatile String userHeader = "iv-user";
    protected volatile String host = null;
    protected volatile String scheme = null;
    protected volatile Integer port = null;
    protected volatile String junctionName = "";

    public void setUserHeader(String userHeader) {
        this.userHeader = userHeader;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(String port) {
        this.port = Integer.parseInt(port);
    }

    public void setJunctionName(String junctionName) {
        if (!junctionName.startsWith("/")) {
            junctionName = "/" + junctionName;
        }
        this.junctionName = junctionName;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        String remoteUser = request.getHeader(this.userHeader);
        if (remoteUser != null && remoteUser.length() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Request contains '" + this.userHeader + "' header, will be wrapped"));
            }
            if (request.getMappingData() != null && request.getMappingData().matchType != null && request.getMappingData().matchType == MappingMatch.PATH) {
                WebSEALJunctionRequestWrapper webSEALJunctionRequestWrapper = new WebSEALJunctionRequestWrapper(request);
                webSEALJunctionRequestWrapper.setMappingData(request.getMappingData());
                request = webSEALJunctionRequestWrapper;
            } else {
                request = new WebSEALJunctionRequestWrapper(request);
            }
        }
        this.getNext().invoke(request, response);
    }

    public class WebSEALJunctionRequestWrapper
    extends RequestWrapper {
        public WebSEALJunctionRequestWrapper(Request request) {
            super(request);
        }

        @Override
        public String getScheme() {
            if (WebSEALRequestWrappingValve.this.scheme != null) {
                return WebSEALRequestWrappingValve.this.scheme;
            }
            return super.getScheme();
        }

        @Override
        public String getServerName() {
            if (WebSEALRequestWrappingValve.this.host != null) {
                return WebSEALRequestWrappingValve.this.host;
            }
            return super.getServerName();
        }

        @Override
        public int getServerPort() {
            if (WebSEALRequestWrappingValve.this.port != null) {
                return WebSEALRequestWrappingValve.this.port;
            }
            return super.getServerPort();
        }

        @Override
        public StringBuffer getRequestURL() {
            StringBuffer url = new StringBuffer();
            String scheme = this.getScheme();
            int port = this.getServerPort();
            if (port < 0) {
                port = 80;
            }
            url.append(scheme);
            url.append("://");
            url.append(this.getServerName());
            if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
                url.append(':');
                url.append(port);
            }
            url.append(WebSEALRequestWrappingValve.this.junctionName);
            url.append(this.getRequestURI());
            if (log.isDebugEnabled()) {
                log.debug((Object)("getRequestURL: " + url));
            }
            return url;
        }
    }
}

