/*
 * Decompiled with CFR 0.152.
 */
package com.sas.vfabrictcsvr.startup;

import com.sas.vfabrictcsvr.startup.HostPortSet;
import com.sas.vfabrictcsvr.startup.MetadataServerCheck;
import com.sas.vfabrictcsvr.startup.PortUtils;
import com.sas.vfabrictcsvr.startup.Server;
import java.io.File;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StartWrapper {
    private static final Logger logger = LogManager.getLogger(StartWrapper.class);
    private static final String CATALINA_BASE = "catalina.base";
    private static final String LOGS_DIR = "logs";
    private static final String LOG_FILE = "saswrapper.log";
    private static final String CONFIG_DIR = "conf";
    private static final String CONFIG_FILE = "startup.prerequisites";
    private static final String SHARED_SERVICES_DESCRIPTION = "The database server for SharedServices";
    private static final String METADATA_SERVER_DESCRIPTION = "SAS Metadata Server";
    private static final int METADATA_SERVER_TIMEOUT = 60;
    private static final int RECHECK_INTERVAL = 10000;
    PrintWriter out;
    long initialTime;
    PortUtils portUtils = new PortUtils();
    Map<String, Set<Server>> servers;
    Map<String, Set<Server>> unavailableServers;
    Map<String, Integer> quorum;
    File configFile;
    HostPortSet msPrimary;

    StartWrapper() {
        this.openLog();
        this.configFile = this.getConfigFile();
        this.servers = Server.loadServers(this.configFile, this.out);
        this.unavailableServers = new HashMap<String, Set<Server>>();
        this.quorum = new HashMap<String, Integer>();
        this.initialTime = System.currentTimeMillis();
    }

    public static void main(String[] args) {
        StartWrapper wrapper = new StartWrapper();
        wrapper.check();
        System.exit(0);
    }

    void check() {
        if (!this.configFile.exists()) {
            System.out.println("Configuration file " + this.configFile.toString() + " not found.");
            System.out.flush();
            System.exit(-1);
        }
        Date d = new Date(this.initialTime);
        this.out.println("Begin server prerequisite checking at " + d);
        this.out.flush();
        this.checkServerStatus();
        if (this.isSharedServicesConfigured()) {
            this.waitForSharedServicesDataServer();
        }
        if (this.isSharedServicesConfigured()) {
            MetadataServerCheck msc = new MetadataServerCheck();
            msc.setOut(this.out);
            HostPortSet msCluster = msc.getConfiguredMetadataServers();
            this.msPrimary = msc.getConfiguredPrimaryMetadataServer();
            this.addMetadataServers(msCluster, this.msPrimary);
            this.checkServerStatus();
        }
        this.waitForAllServers();
        long currentTime = System.currentTimeMillis();
        Date fd = new Date(currentTime);
        this.out.println("Starting SAS Web Application Server at " + fd);
        this.out.flush();
    }

    void openLog() {
        File logDir = new File(this.getCatalinaBase(), LOGS_DIR);
        File o = new File(logDir, LOG_FILE);
        try {
            this.out = new PrintWriter(o);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    File getCatalinaBase() {
        String basepath = System.getProperty(CATALINA_BASE);
        File catalinaBase = null;
        if (basepath != null && basepath != "") {
            catalinaBase = new File(basepath);
        }
        return catalinaBase;
    }

    File getConfigFile() {
        File configDir = new File(this.getCatalinaBase(), CONFIG_DIR);
        return new File(configDir, CONFIG_FILE);
    }

    long lapsedTime() {
        long currentTime = System.currentTimeMillis();
        return (currentTime - this.initialTime) / 1000L;
    }

    void checkServerStatus() {
        if (this.servers == null) {
            return;
        }
        Iterator<Set<Server>> li = this.servers.values().iterator();
        Date date = new Date(System.currentTimeMillis());
        if (li.hasNext()) {
            this.out.println("Prerequisite server status at " + date + ":");
        }
        while (li.hasNext()) {
            Set<Server> set = li.next();
            if (this.servers.get(METADATA_SERVER_DESCRIPTION) == set) {
                this.metadataServerHasQuorum(set);
            } else {
                this.serverHasQuorum(set);
            }
            this.checkForTimeout(set);
        }
    }

    void printFailStatus(Set<Server> set) {
        this.printClusterHeader(set);
        for (Server s : set) {
            boolean isListening = !this.portUtils.isPortAvailable(s.host, s.port);
            this.printServerStatus(s, isListening, true);
        }
        logger.error("Prerequisite servers have not been started.  See saswrapper.log for details.");
    }

    int getServerTimeout(Set<Server> set) {
        int timeout = 0;
        for (Server s : set) {
            timeout = Math.max(timeout, s.timeout);
        }
        return timeout;
    }

    String getServerName(Set<Server> set) {
        Iterator<Server> iterator = set.iterator();
        if (iterator.hasNext()) {
            Server s = iterator.next();
            return s.description;
        }
        return "";
    }

    void checkServerStatus(Set<Server> set) {
        boolean atLeastOneServerRunningInClusterIsRunning = false;
        this.printClusterHeader(set);
        for (Server s : set) {
            boolean isListening;
            boolean bl = isListening = !this.portUtils.isPortAvailable(s.host, s.port);
            if (isListening) {
                atLeastOneServerRunningInClusterIsRunning = true;
                this.unavailableServers.remove(s.description);
            }
            if (!isListening && !atLeastOneServerRunningInClusterIsRunning) {
                this.unavailableServers.put(s.description, set);
            }
            this.printServerStatus(s, isListening, false);
        }
        this.checkForTimeout(set);
    }

    void checkForTimeout(Set<Server> set) {
        int timeout = this.getServerTimeout(set);
        String clusterName = this.getServerName(set);
        if (this.lapsedTime() > (long)timeout && this.unavailableServers.containsKey(clusterName)) {
            long currentTime = System.currentTimeMillis();
            Date fd = new Date(currentTime);
            this.out.println("Failing at " + fd);
            this.printFailStatus(set);
            this.out.println("SAS Web Application Server will not be started.");
            this.out.close();
            System.exit(-1);
        }
    }

    void waitForAllServers() {
        while (!this.unavailableServers.isEmpty()) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                this.out.println("Interrupted... SAS Web Application Server will not be started.");
                this.out.close();
                System.exit(-1);
            }
            this.checkServerStatus();
        }
    }

    void waitForSharedServicesDataServer() {
        Set<Server> ssds = this.unavailableServers.get(SHARED_SERVICES_DESCRIPTION);
        if (ssds == null || ssds.isEmpty()) {
            return;
        }
        this.out.println("Waiting for SharedServices data servers to start...");
        this.out.flush();
        while (ssds != null && !ssds.isEmpty()) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                this.out.println("Interrupted... SAS Web Application Server will not be started.");
                this.out.close();
                System.exit(-1);
            }
            Date date = new Date(System.currentTimeMillis());
            this.out.println("SharedServices data server status at " + date + ":");
            this.checkServerStatus(ssds);
            ssds = this.unavailableServers.get(SHARED_SERVICES_DESCRIPTION);
        }
    }

    boolean isSharedServicesConfigured() {
        if (this.servers == null) {
            return false;
        }
        Set<Server> ssds = this.servers.get(SHARED_SERVICES_DESCRIPTION);
        return ssds != null && !ssds.isEmpty();
    }

    void addMetadataServers(HostPortSet msCluster, HostPortSet msPrimary) {
        if (msCluster == null || msPrimary == null) {
            return;
        }
        String slist = msCluster.toString();
        slist = slist.replaceAll("\\{", "").replaceAll("\\}", "");
        String[] cluster = slist.split(", ");
        HashSet<Server> set = new HashSet<Server>();
        for (String server : cluster) {
            server = server.replaceAll("\\(", "").replaceAll("\\)", "");
            String[] hostPort = server.split(":");
            Server s = new Server(hostPort[0], Integer.parseInt(hostPort[1]), 60, METADATA_SERVER_DESCRIPTION);
            if (server.equals(msPrimary.toString())) {
                s.setIsPrimary(true);
            }
            set.add(s);
        }
        this.servers.put(METADATA_SERVER_DESCRIPTION, set);
        int quorumSize = Math.round(set.size() / 2);
        this.quorum.put(METADATA_SERVER_DESCRIPTION, quorumSize);
        this.out.print("Metadata server configuration added from SharedServices database.  Recheck all servers status:\n");
    }

    int getQuorumSize(String description) {
        Integer size = this.quorum.get(description);
        if (size == null) {
            return 1;
        }
        return size;
    }

    boolean metadataServerHasQuorum(Set<Server> set) {
        boolean needPrimary = set.size() % 2 == 0;
        int quorumSize = this.getQuorumSize(METADATA_SERVER_DESCRIPTION);
        int available = 0;
        boolean primaryIsAvailable = false;
        this.printClusterHeader(set);
        for (Server s : set) {
            boolean isListening;
            boolean bl = isListening = !this.portUtils.isPortAvailable(s.host, s.port);
            if (isListening) {
                ++available;
                if (s.getIsPrimary()) {
                    primaryIsAvailable = true;
                }
            }
            this.printServerStatus(s, isListening, false);
        }
        if (available > quorumSize) {
            this.unavailableServers.remove(METADATA_SERVER_DESCRIPTION);
            return true;
        }
        if (available < quorumSize) {
            this.unavailableServers.put(METADATA_SERVER_DESCRIPTION, set);
            return false;
        }
        if (available == quorumSize) {
            if (needPrimary && primaryIsAvailable) {
                this.unavailableServers.remove(METADATA_SERVER_DESCRIPTION);
                return true;
            }
            this.unavailableServers.put(METADATA_SERVER_DESCRIPTION, set);
            return false;
        }
        return false;
    }

    boolean serverHasQuorum(Set<Server> set) {
        boolean atLeastOneServerRunningInClusterIsRunning = false;
        this.printClusterHeader(set);
        for (Server s : set) {
            boolean isListening;
            boolean bl = isListening = !this.portUtils.isPortAvailable(s.host, s.port);
            if (isListening) {
                atLeastOneServerRunningInClusterIsRunning = true;
                this.unavailableServers.remove(s.description);
            }
            if (!isListening && !atLeastOneServerRunningInClusterIsRunning) {
                this.unavailableServers.put(s.description, set);
            }
            this.printServerStatus(s, isListening, false);
        }
        return atLeastOneServerRunningInClusterIsRunning;
    }

    void printClusterHeader(Set<Server> set) {
        if (set.size() > 1) {
            if (this.getServerName(set).equals(METADATA_SERVER_DESCRIPTION)) {
                boolean needPrimary = set.size() % 2 == 0;
                this.out.println("     Cluster: " + this.getServerName(set) + "    Quorum: " + this.getQuorumSize(this.getServerName(set)) + "    Minimum Quorum needs primary? " + needPrimary + " Primary: " + this.msPrimary.toString());
                this.out.flush();
            } else {
                this.out.println("     Cluster: " + this.getServerName(set) + "    Quorum: " + this.getQuorumSize(this.getServerName(set)));
                this.out.flush();
            }
        }
    }

    void printServerStatus(Server s, boolean isListening, boolean flagAsFailure) {
        Set<Server> set = this.servers.get(s.description);
        String clusterIndent = set.size() > 1 ? "    " : "";
        String failMarker = flagAsFailure ? "FAIL " : "     ";
        this.out.println((isListening ? "     " : failMarker) + clusterIndent + s.description + (isListening ? " is listening" : " is not ready") + " on port " + s.port + " on " + s.host);
        this.out.flush();
    }
}

