/*
 * Decompiled with CFR 0.152.
 */
package com.sas.vfabrictcsvr.startup;

import java.net.Socket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class PortUtils {
    private static Logger logger = LogManager.getLogger(PortUtils.class);

    PortUtils() {
    }

    public boolean isPortAvailable(String address, int port) {
        logger.info("isPortAvailable(" + address + "," + port + ") >>>");
        boolean isAvailable = false;
        try {
            Socket socket = new Socket(address, port);
            socket.close();
            isAvailable = false;
        }
        catch (Exception e) {
            isAvailable = true;
            logger.info(e.getMessage());
        }
        logger.info("isAvailable=${isAvailable}");
        logger.info("isPortAvailable() <<<");
        return isAvailable;
    }

    public void waitForPortToOpen(String address, int port, long timeOutInSeconds) {
        boolean isServerRunning = false;
        long initialTime = System.currentTimeMillis();
        long endTime = initialTime + timeOutInSeconds * 1000L;
        long currentTime = initialTime;
        while (currentTime < endTime) {
            try {
                Thread.sleep(1000L);
                boolean bl = isServerRunning = !this.isPortAvailable(address, port);
                if (isServerRunning) break;
                logger.info("Waiting for port ($port) to open on address ($address).");
            }
            catch (Exception exception) {
                // empty catch block
            }
            currentTime = System.currentTimeMillis();
        }
        if (!isServerRunning) {
            logger.info("Timeout reached before port opened. ($address:$port)");
            throw new IllegalStateException("Timeout reached before port opened. ($address:$port)");
        }
    }

    public void waitForPortToClose(String address, int port, int timeOutInSeconds) {
        boolean isServerRunning = false;
        for (int retry = 0; retry < timeOutInSeconds; ++retry) {
            try {
                Thread.sleep(1000L);
                boolean bl = isServerRunning = !this.isPortAvailable(address, port);
                if (!isServerRunning) break;
                logger.info("Waiting for port ($port) to close on address ($address).");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (isServerRunning) {
            logger.info("Timeout reached before port closed. ($address:$port)");
            throw new IllegalStateException("Timeout reached before port closed. ($address:$port)");
        }
    }
}

