/*
 * Decompiled with CFR 0.152.
 */
package com.sas.vfabrictcsvr.startup;

import com.atomikos.jdbc.AtomikosDataSourceBean;
import com.sas.vfabrictcsvr.startup.HostPortSet;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MetadataClusterUtil {
    private static final Logger logger = LogManager.getLogger(MetadataClusterUtil.class);
    private static Properties applicationProperties = null;
    public static final String OPTION_ENCRYPT = "encrypt";
    public static final String OPTION_SSPI_PACKAGE = "sspipackage";
    public static final String OPTION_SSPI_PACKAGE_LIST = "sspipackagelist";
    public static final String OPTION_SSPI_SPN = "sspispn";
    public static final String OPTION_USE_CLUSTER_PROPERTIES = "useclusterproperties";
    private static final String APP_PROPERTY_HOST = "omr_host";
    private static final String APP_PROPERTY_PORT = "omr_port";
    private static final String APP_PROPERTY_HOSTS = "omr_cluster_hosts";
    private static final String APP_PROPERTY_PORTS = "omr_cluster_ports";
    private static final String USE_CLUSTER_PROPERTIES = "sas.metadata.use.cluster.properties";
    private static final boolean useClusterProperties = Boolean.parseBoolean(System.getProperty("sas.metadata.use.cluster.properties"));
    private static final String APP_TABLE_QUERY = "select PROPERTY_NM, PROPERTY_VALUE_TXT from SAS_APPLICATION_PROPERTY where PROPERTYSET_NM= ?";
    public static PrintWriter out;
    private static AtomikosDataSourceBean ads;

    private static void refreshApplicationProperties(String connUrl, Properties connProperties, String driver) {
        Properties newApplicationProperties = new Properties();
        try {
            Class<?> jdbcDriver = Class.forName(driver);
            Connection connection = DriverManager.getConnection(connUrl, connProperties);
            PreparedStatement statement = connection.prepareStatement(APP_TABLE_QUERY);
            statement.setString(1, "Environment.Properties");
            ResultSet results = statement.executeQuery();
            while (results.next()) {
                newApplicationProperties.put(results.getString(1), results.getString(2));
            }
            results.close();
            statement.close();
            connection.close();
            applicationProperties = newApplicationProperties;
            if (logger.isDebugEnabled()) {
                logger.debug("Loaded " + Integer.toString(applicationProperties.size()) + " application properties");
            }
            System.out.println("Loaded " + Integer.toString(applicationProperties.size()) + " application properties");
        }
        catch (Exception e) {
            logger.error("Error reading SAS_APPLICATION_PROPERTY table.");
            logger.error("  " + e.getMessage());
            e.printStackTrace(out);
            out.flush();
            return;
        }
    }

    public static HostPortSet getClusterHostPortSet(String connUrl, Properties connProperties, String driver) {
        if (applicationProperties == null) {
            MetadataClusterUtil.refreshApplicationProperties(connUrl, connProperties, driver);
        }
        if (applicationProperties == null) {
            return null;
        }
        String hosts = applicationProperties.containsKey(APP_PROPERTY_HOSTS) ? applicationProperties.getProperty(APP_PROPERTY_HOSTS) : applicationProperties.getProperty(APP_PROPERTY_HOST);
        String ports = applicationProperties.containsKey(APP_PROPERTY_PORTS) ? applicationProperties.getProperty(APP_PROPERTY_PORTS) : applicationProperties.getProperty(APP_PROPERTY_PORT);
        return HostPortSet.newInstance(hosts, ports);
    }

    public static HostPortSet getPrimaryHostPortSet(String connUrl, Properties connProperties, String driver) {
        if (applicationProperties == null) {
            MetadataClusterUtil.refreshApplicationProperties(connUrl, connProperties, driver);
        }
        if (applicationProperties == null) {
            return null;
        }
        String hosts = applicationProperties.getProperty(APP_PROPERTY_HOST);
        String ports = applicationProperties.getProperty(APP_PROPERTY_PORT);
        return HostPortSet.newInstance(hosts, ports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refreshApplicationPropertiesWithXADriver(Properties connProperties, String xaDriver, String minPoolSize, String maxPoolSize) {
        Properties newApplicationProperties = new Properties();
        Connection connection = null;
        Statement statement = null;
        ResultSet results = null;
        try {
            if (ads == null) {
                ads = new AtomikosDataSourceBean();
                ads.setUniqueResourceName("MetadataClusterUtil-SharedServices");
                ads.setXaDataSourceClassName(xaDriver);
                if (minPoolSize != null) {
                    ads.setMinPoolSize(Integer.parseInt(minPoolSize));
                }
                if (maxPoolSize != null) {
                    ads.setMaxPoolSize(Integer.parseInt(maxPoolSize));
                }
            }
            ads.setXaProperties(connProperties);
            connection = ads.getConnection();
            statement = connection.prepareStatement(APP_TABLE_QUERY);
            statement.setString(1, "Environment.Properties");
            results = statement.executeQuery();
            while (results.next()) {
                newApplicationProperties.put(results.getString(1), results.getString(2));
            }
            applicationProperties = newApplicationProperties;
            if (logger.isDebugEnabled()) {
                logger.debug("Loaded " + Integer.toString(applicationProperties.size()) + " application properties");
            }
            System.out.println("Loaded " + Integer.toString(applicationProperties.size()) + " application properties");
        }
        catch (Exception e) {
            logger.error("Error reading SAS_APPLICATION_PROPERTY table.");
            logger.error("  " + e.getMessage());
            e.printStackTrace(out);
            out.flush();
            return;
        }
        finally {
            try {
                results.close();
            }
            catch (SQLException e) {
                logger.error("Failed to close the results.");
                logger.error("  " + e.getMessage());
                e.printStackTrace(out);
                out.flush();
            }
            try {
                statement.close();
            }
            catch (SQLException e) {
                logger.error("Failed to close the statement.");
                logger.error("  " + e.getMessage());
                e.printStackTrace(out);
                out.flush();
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                logger.error("Failed to close the connection.");
                logger.error("  " + e.getMessage());
                e.printStackTrace(out);
                out.flush();
            }
        }
    }

    public static HostPortSet getClusterHostPortSetWithXADriver(Properties connProperties, String xaDriver, String minPoolSize, String maxPoolSize) {
        if (applicationProperties == null) {
            MetadataClusterUtil.refreshApplicationPropertiesWithXADriver(connProperties, xaDriver, minPoolSize, maxPoolSize);
        }
        if (applicationProperties == null) {
            return null;
        }
        String hosts = applicationProperties.containsKey(APP_PROPERTY_HOSTS) ? applicationProperties.getProperty(APP_PROPERTY_HOSTS) : applicationProperties.getProperty(APP_PROPERTY_HOST);
        String ports = applicationProperties.containsKey(APP_PROPERTY_PORTS) ? applicationProperties.getProperty(APP_PROPERTY_PORTS) : applicationProperties.getProperty(APP_PROPERTY_PORT);
        return HostPortSet.newInstance(hosts, ports);
    }

    public static HostPortSet getPrimaryHostPortSetWithXADriver(Properties connProperties, String xaDriver, String minPoolSize, String maxPoolSize) {
        if (applicationProperties == null) {
            MetadataClusterUtil.refreshApplicationPropertiesWithXADriver(connProperties, xaDriver, minPoolSize, maxPoolSize);
        }
        if (applicationProperties == null) {
            return null;
        }
        String hosts = applicationProperties.getProperty(APP_PROPERTY_HOST);
        String ports = applicationProperties.getProperty(APP_PROPERTY_PORT);
        return HostPortSet.newInstance(hosts, ports);
    }

    static {
        ads = null;
    }
}

