/*
 * Decompiled with CFR 0.152.
 */
package com.sas.vfabrictcsvr.session;

import jakarta.servlet.http.HttpSession;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SessionFixationSupport {
    private static final SessionFixationSupport instance = new SessionFixationSupport();
    private Map<String, AuthenticatedSession> authenticatedSessions = new ConcurrentHashMap<String, AuthenticatedSession>();
    private static final String HASH_KEY_SEPARATOR = " ";

    public static SessionFixationSupport getInstance() {
        return instance;
    }

    public void registerAuthenticatedHttpSession(HttpSession session, String name) {
        this.authenticatedSessions.put(this.getHashKey(session), new AuthenticatedSession(session, name));
        LogManager.getLogger(SessionFixationSupport.class).debug("Registered authenticated session " + session.getId() + " for user " + name);
    }

    public void unregisterHttpSession(HttpSession session) {
        String key = this.getHashKey(session);
        AuthenticatedSession authenticatedSession = this.authenticatedSessions.remove(key);
        if (authenticatedSession != null) {
            LogManager.getLogger(SessionFixationSupport.class).debug("Session " + session.getId() + " unregistered");
        }
    }

    private String getHashKey(HttpSession session) {
        return session.getId() + HASH_KEY_SEPARATOR + session.getServletContext().getContextPath();
    }

    public String getAuthenticatedName(HttpSession session) {
        Logger logger = LogManager.getLogger(SessionFixationSupport.class);
        for (Map.Entry<String, AuthenticatedSession> entry : this.authenticatedSessions.entrySet()) {
            AuthenticatedSession authenticatedSession = entry.getValue();
            if (!session.getId().equals(authenticatedSession.getSession().getId())) continue;
            String name = authenticatedSession.getName();
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("User %s is authenticated in session %s ,context %s", name, session.getId(), authenticatedSession.getSession().getServletContext().getContextPath()));
            }
            return name;
        }
        if (logger.isDebugEnabled()) {
            LogManager.getLogger(SessionFixationSupport.class).debug("Session " + session.getId() + " is not authenticated in any web apps");
        }
        return null;
    }

    class AuthenticatedSession {
        private final HttpSession session;
        private final String name;

        public AuthenticatedSession(HttpSession session, String name) {
            this.session = session;
            this.name = name;
        }

        public HttpSession getSession() {
            return this.session;
        }

        public String getName() {
            return this.name;
        }
    }
}

